/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.arcu.dc.services.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.arcu.dc.services.utils.ARCU_DC_Packer;
import kd.ebg.aqap.banks.arcu.dc.services.utils.ARCU_DC_Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public boolean isSupportPage() {
        return true;
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        Element root = ARCU_DC_Packer.getCommonHeader("B2EACTransQry", RequestContextUtils.getRequestContext().getBankRequestSeq(), LocalDateTime.now());
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"AcNo", (String)bankDetailRequest.getAcnt().getAccNo());
        String startDate = bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String endDate = bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)startDate);
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)endDate);
        JDomUtils.addChild((Element)body, (String)"CurrentIndex", (String)this.getCurrentPage());
        JDomUtils.addChild((Element)body, (String)"QueryCount", (String)"20");
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankDetailResponse parse(BankDetailRequest rqst, String s) {
        Element list;
        this.setLastPage(true);
        int nextPage = Integer.parseInt(this.getCurrentPage()) + 20;
        this.setCurrentPage(nextPage);
        ArrayList<DetailInfo> result = new ArrayList<DetailInfo>(3);
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = ARCU_DC_Parser.parserCommonHeader((Element)root);
        if (null == bankResponse.getResponseCode() || !"000000".equals(bankResponse.getResponseCode())) {
            return new EBBankDetailResponse(result);
        }
        Element body = JDomUtils.getChildElement((Element)root, (String)"Body");
        String bankAccNo = JDomUtils.getChildText((Element)body, (String)"AcNo");
        if (null == bankAccNo || !rqst.getAcnt().getAccNo().equals(bankAccNo)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u8d26\u53f7\u4e0d\u5339\u914d\u3002", (String)"DetailImpl_0", (String)"ebg-aqap-banks-arcu-dc", (Object[])new Object[0]));
        }
        String totalNum = JDomUtils.getChildText((Element)body, (String)"TotalNum");
        int total = Integer.parseInt(totalNum);
        if (total > nextPage) {
            this.setLastPage(false);
        }
        if (null == (list = JDomUtils.getChildElement((Element)body, (String)"List"))) {
            return new EBBankDetailResponse(result);
        }
        List mapList = list.getChildren("Map");
        for (int i = 0; i < mapList.size(); ++i) {
            Element map = (Element)mapList.get(i);
            String trsDateStr = JDomUtils.getChildText((Element)map, (String)"TrsDate");
            String trsTimeStr = JDomUtils.getChildText((Element)map, (String)"TrsTime");
            String currency = JDomUtils.getChildText((Element)map, (String)"Currency");
            String dcFlag = JDomUtils.getChildText((Element)map, (String)"DCFlag");
            String amountStr = JDomUtils.getChildText((Element)map, (String)"Amount");
            String balance = JDomUtils.getChildText((Element)map, (String)"Balance");
            String remark = JDomUtils.getChildText((Element)map, (String)"Remark");
            String payerAcName = JDomUtils.getChildText((Element)map, (String)"PayerAcName");
            String payerAcNo = JDomUtils.getChildText((Element)map, (String)"PayerAcNo");
            String payerBankName = JDomUtils.getChildText((Element)map, (String)"PayerBankName");
            String payeeAcName = JDomUtils.getChildText((Element)map, (String)"PayeeAcName");
            String payeeBankName = JDomUtils.getChildText((Element)map, (String)"PayeeBankName");
            String payeeAcNo = JDomUtils.getChildText((Element)map, (String)"PayeeAcNo");
            DetailInfo detailInfo = new DetailInfo();
            LocalDate transDate = LocalDate.parse(trsDateStr, DateTimeFormatter.ofPattern("yyyyMMdd"));
            detailInfo.setTransDate(transDate);
            LocalDateTime transTime = LocalDateTime.parse(trsDateStr + trsTimeStr, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            detailInfo.setTransTime(transTime);
            detailInfo.setAccName(rqst.getAcnt().getAccName());
            detailInfo.setAccNo(rqst.getAcnt().getAccNo());
            detailInfo.setUseCn(remark);
            detailInfo.setExplanation(remark);
            detailInfo.setCurrency(currency);
            if ("D".equalsIgnoreCase(dcFlag)) {
                detailInfo.setOppAccName(payeeAcName);
                detailInfo.setOppAccNo(payeeAcNo);
                detailInfo.setOppBankName(payeeBankName);
                detailInfo.setCreditAmount(new BigDecimal("0.00"));
                detailInfo.setDebitAmount(new BigDecimal(amountStr));
            } else {
                if (!"C".equalsIgnoreCase(dcFlag)) continue;
                detailInfo.setOppAccName(payerAcName);
                detailInfo.setOppAccNo(payerAcNo);
                detailInfo.setOppBankName(payerBankName);
                detailInfo.setCreditAmount(new BigDecimal(amountStr));
                detailInfo.setDebitAmount(new BigDecimal("0.00"));
            }
            if (StringUtils.isNotEmpty((String)balance)) {
                detailInfo.setBalance(new BigDecimal(balance));
            }
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(map);
            String receiptNo = MatchRule.getInstance().getReceiptNo(detailInfo.getAccNo(), trsDateStr, jsonStr);
            detailInfo.setJsonMap(jsonStr);
            detailInfo.setBankDetailNo(JDomUtils.getChildText((Element)map, (String)"HostJnlNo"));
            detailInfo.setReceiptNo(receiptNo);
            result.add(detailInfo);
        }
        return new EBBankDetailResponse(result);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EACTransQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_1", (String)"ebg-aqap-banks-arcu-dc", (Object[])new Object[0]);
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
        factory.setUri(ARCU_DC_Packer.getURI());
        this.configFactory(factory);
        return factory;
    }
}

