/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gxnx.dc.utils;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gxnx.dc.utils.GzipUtil;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.BalanceUtil;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class GxnxParser {
    static EBGLogger logger = EBGLogger.getInstance().getLogger(GxnxParser.class);

    public static EBBankBalanceResponse parseBalance(BankBalanceRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element resp = JDomUtils.getChildElement((Element)root, (String)"RESP");
        Element head = JDomUtils.getChildElement((Element)resp, (String)"RESPHEAD");
        String returnCode = JDomUtils.getChildText((Element)head, (String)"RspCode");
        String returnMsg = JDomUtils.getChildText((Element)head, (String)"RspMsg");
        JDomUtils.getChildText((Element)head, (String)"TranCode");
        JDomUtils.getChildText((Element)head, (String)"UserID");
        JDomUtils.getChildText((Element)head, (String)"TranSeq");
        if (!StringUtils.equalsIgnoreCase((String)"000000", (String)returnCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5e7f\u897f\u519c\u4fe1\u67e5\u8be2\u4f59\u989d\u51fa\u9519\uff0c\u94f6\u884c\u8fd4\u56de\u7801:%1$s\uff0c\u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"GxnxParser_20", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), returnCode, returnMsg));
        }
        Element body = JDomUtils.getChildElement((Element)resp, (String)"RESPBODY");
        String bankAccNo = JDomUtils.getChildText((Element)body, (String)"AcctNo");
        if (bankAccNo == null || !request.getAcnt().getAccNo().equalsIgnoreCase(bankAccNo)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u8d26\u53f7\u4e0d\u5339\u914d\uff0c\u67e5\u8be2\u8d26\u53f7:%1$s\uff0c\u94f6\u884c\u8fd4\u56de\u8d26\u53f7:%2$s\u3002", (String)"GxnxParser_21", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), request.getAcnt().getAccNo(), bankAccNo));
        }
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(16);
        JDomUtils.getChildText((Element)body, (String)"CCY");
        String balance = JDomUtils.getChildText((Element)body, (String)"Bal");
        String avabBalance = JDomUtils.getChildText((Element)body, (String)"AvaBal");
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankCurrency(request.getBankCurrency());
        balanceInfo.setBankAcnt(request.getAcnt());
        BalanceUtil.setCurrentBalance((BalanceInfo)balanceInfo, (String)balance);
        BalanceUtil.setAvailableBalance((BalanceInfo)balanceInfo, (String)avabBalance);
        balanceInfos.add(balanceInfo);
        return new EBBankBalanceResponse(balanceInfos);
    }

    public static List<DetailInfo> parseDetail(BankDetailRequest request, String rspStr) {
        if (StringUtils.isEmpty((String)rspStr)) {
            logger.info("\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u94f6\u884c\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a");
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u94f6\u884c\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"GxnxParser_4", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]));
        }
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element resp = JDomUtils.getChildElement((Element)root, (String)"RESP");
        Element head = JDomUtils.getChildElement((Element)resp, (String)"RESPHEAD");
        String rspCode = head.getChildText("RspCode");
        String rspMsg = head.getChildText("RspMsg");
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(16);
        JDomUtils.getChildText((Element)head, (String)"TranCode");
        JDomUtils.getChildText((Element)head, (String)"UserID");
        JDomUtils.getChildText((Element)head, (String)"TranSeq");
        if (!"000000".equalsIgnoreCase(rspCode)) {
            logger.info("\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u8fd4\u56de\u975e\u6210\u529f\u4ea4\u6613\u7801\u3002\u94f6\u884c\u8fd4\u56de:" + rspCode + ", " + rspMsg);
            return detailInfos;
        }
        Element body = JDomUtils.getChildElement((Element)resp, (String)"RESPBODY");
        Element MAININF = JDomUtils.getChildElement((Element)body, (String)"MAININF");
        JDomUtils.getChildText((Element)MAININF, (String)"SumNo");
        JDomUtils.getChildText((Element)MAININF, (String)"RetNo");
        Element listElement = body.getChild("LIST");
        List list = listElement.getChildren("PARAM");
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
        for (int i = 0; i < list.size(); ++i) {
            try {
                DetailInfo detail = new DetailInfo();
                Element row = (Element)list.get(i);
                String tranDate = row.getChildTextTrim("TranDate");
                String RecAcctNo = row.getChildText("RecAcctNo");
                String RecAcctName = row.getChildText("RecAcctName");
                String currency = row.getChildText("TranCcy");
                String amount = row.getChildText("TranAmt");
                String balance = row.getChildText("Bal");
                String dcFlag = row.getChildText("CDFlag");
                String Useage = row.getChildText("Useage");
                String Brief = row.getChildText("Brief");
                String ctFlag = row.getChildText("CTFlag");
                String serSeqNo = row.getChildText("SerSeqNo");
                detail.setAccNo(request.getAcnt().getAccNo());
                detail.setExplanation(Useage);
                detail.setOppAccNo(RecAcctNo);
                detail.setOppAccName(RecAcctName);
                detail.setCurrency(currency);
                if (!StringUtils.isEmpty((String)balance)) {
                    detail.setBalance(new BigDecimal(balance));
                }
                detail.setCurrency(currency);
                detail.setTransDate(LocalDate.parse(tranDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
                detail.setTransTime(LocalDateTime.parse(tranDate + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                if ("C".equalsIgnoreCase(dcFlag)) {
                    detail.setDebitAmount(new BigDecimal("0.0"));
                    detail.setCreditAmount(new BigDecimal(amount));
                } else if ("D".equalsIgnoreCase(dcFlag)) {
                    detail.setCreditAmount(new BigDecimal("0.0"));
                    detail.setDebitAmount(new BigDecimal(amount));
                } else {
                    logger.error(ShowTipUtil.getDetailCDFlagErrorTips((String)dcFlag));
                    continue;
                }
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
                detail.setJsonMap(jsonStr);
                detail.setBankDetailNo(serSeqNo);
                String receiptNo = MatchRule.getInstance().getReceiptNo(request.getAcnt().getAccNo(), tranDate, jsonStr);
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                detail.setReceiptNo(receiptNo);
                detailInfos.add(detail);
                continue;
            }
            catch (Throwable t) {
                logger.error(t.toString());
            }
        }
        return detailInfos;
    }

    public static EBBankPayResponse parseSameBankPay(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element resp = JDomUtils.getChildElement((Element)root, (String)"RESP");
        Element head = JDomUtils.getChildElement((Element)resp, (String)"RESPHEAD");
        String returnCode = JDomUtils.getChildText((Element)head, (String)"RspCode");
        String retrunMsg = JDomUtils.getChildText((Element)head, (String)"RspMsg");
        String TranCode = JDomUtils.getChildText((Element)head, (String)"TranCode");
        String UserID = JDomUtils.getChildText((Element)head, (String)"UserID");
        String TranSeq = JDomUtils.getChildText((Element)head, (String)"TranSeq");
        Element body = JDomUtils.getChildElement((Element)resp, (String)"RESPBODY");
        String status = JDomUtils.getChildText((Element)body, (String)"TranDes");
        String SerSeqNo = JDomUtils.getChildText((Element)body, (String)"SerSeqNo");
        if ("000000".equalsIgnoreCase(returnCode) || "AUTHREQ".equalsIgnoreCase(returnCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"GxnxParser_5", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), (String)status, (String)retrunMsg);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u77e5", (String)"GxnxParser_6", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), (String)status, (String)retrunMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public static EBBankPayResponse parseQuerySameBankPay(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element resp = JDomUtils.getChildElement((Element)root, (String)"RESP");
        Element head = JDomUtils.getChildElement((Element)resp, (String)"RESPHEAD");
        String returnCode = JDomUtils.getChildText((Element)head, (String)"RspCode");
        String returnMsg = JDomUtils.getChildText((Element)head, (String)"RspMsg");
        JDomUtils.getChildText((Element)head, (String)"TranCode");
        JDomUtils.getChildText((Element)head, (String)"UserID");
        JDomUtils.getChildText((Element)head, (String)"TranSeq");
        if (!"000000".equalsIgnoreCase(returnCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u540c\u884c\u8f6c\u8d26\u7ed3\u679c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u4ee3\u7801:%1$s,\u8fd4\u56de\u4fe1\u606f:%2$s", (String)"GxnxParser_22", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), returnCode, returnMsg));
        }
        Element body = JDomUtils.getChildElement((Element)resp, (String)"RESPBODY");
        String status = JDomUtils.getChildText((Element)body, (String)"TranStatus");
        String msg = JDomUtils.getChildText((Element)body, (String)"TranMsg");
        if ("1".equalsIgnoreCase(status)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"GxnxParser_9", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), (String)status, (String)msg);
        } else if ("2".equalsIgnoreCase(status)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"GxnxParser_10", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), (String)status, (String)msg);
        } else if ("3".equalsIgnoreCase(status) || "4".equalsIgnoreCase(status)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"GxnxParser_11", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), (String)status, (String)msg);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u77e5", (String)"GxnxParser_6", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), (String)status, (String)msg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public static EBBankPayResponse parseDiffBankPay(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element resp = JDomUtils.getChildElement((Element)root, (String)"RESP");
        Element head = JDomUtils.getChildElement((Element)resp, (String)"RESPHEAD");
        JDomUtils.getChildText((Element)head, (String)"RspMsg");
        String TranCode = JDomUtils.getChildText((Element)head, (String)"TranCode");
        JDomUtils.getChildText((Element)head, (String)"UserID");
        JDomUtils.getChildText((Element)head, (String)"TranSeq");
        String returnCode = JDomUtils.getChildText((Element)head, (String)"RspCode");
        String returnMsg = JDomUtils.getChildText((Element)head, (String)"RspMsg");
        Element body = JDomUtils.getChildElement((Element)resp, (String)"RESPBODY");
        String tranDes = JDomUtils.getChildText((Element)body, (String)"TranDes");
        JDomUtils.getChildText((Element)body, (String)"SerSeqNo");
        JDomUtils.getChildText((Element)body, (String)"Bal");
        JDomUtils.getChildText((Element)body, (String)"AvaBal");
        if ("000000".equalsIgnoreCase(returnCode) || "AUTHREQ".equalsIgnoreCase(returnCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"GxnxParser_5", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u77e5", (String)"GxnxParser_6", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public static EBBankPayResponse parseQueryDiffBankPay(BankPayRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        List paymentInfos = request.getPaymentInfos();
        Element resp = JDomUtils.getChildElement((Element)root, (String)"RESP");
        Element head = JDomUtils.getChildElement((Element)resp, (String)"RESPHEAD");
        String rspCode = JDomUtils.getChildText((Element)head, (String)"RspCode");
        String rspMsg = JDomUtils.getChildText((Element)head, (String)"RspMsg");
        JDomUtils.getChildText((Element)head, (String)"TranCode");
        JDomUtils.getChildText((Element)head, (String)"UserID");
        JDomUtils.getChildText((Element)head, (String)"TranSeq");
        if (!"000000".equalsIgnoreCase(rspCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u540c\u884c\u8f6c\u8d26\u7ed3\u679c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u4ee3\u7801:%1$s,\u8fd4\u56de\u4fe1\u606f:%2$s", (String)"GxnxParser_22", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), rspCode, rspMsg));
        }
        Element body = JDomUtils.getChildElement((Element)resp, (String)"RESPBODY");
        String status = JDomUtils.getChildText((Element)body, (String)"TranStatus");
        String msg = JDomUtils.getChildText((Element)body, (String)"TranMsg");
        if ("1".equalsIgnoreCase(status)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"GxnxParser_9", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), (String)status, (String)msg);
        } else if ("2".equalsIgnoreCase(status)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"GxnxParser_10", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), (String)status, (String)msg);
        } else if ("3".equalsIgnoreCase(status)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"GxnxParser_5", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), (String)status, (String)msg);
        } else if ("4".equalsIgnoreCase(status)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u5df2\u51b2\u9500", (String)"GxnxParser_12", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), (String)status, (String)msg);
        } else if ("5".equalsIgnoreCase(status)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u5f85\u6388\u6743", (String)"GxnxParser_13", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), (String)status, (String)msg);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u77e5", (String)"GxnxParser_6", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), (String)status, (String)msg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public static EBBankPayResponse parseSalaryPay(BankPayRequest request, String responseStr) {
        if (StringUtils.isEmpty((String)responseStr)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u94f6\u884c\u8fd4\u56de\u7684xml\u9519\u8bef,\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a", (String)"GxnxParser_14", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]));
        }
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        List paymentInfos = request.getPaymentInfos();
        Element resp = JDomUtils.getChildElement((Element)root, (String)"RESP");
        Element head = JDomUtils.getChildElement((Element)resp, (String)"RESPHEAD");
        String returnCode = JDomUtils.getChildText((Element)head, (String)"RspCode");
        String RspMsg = JDomUtils.getChildText((Element)head, (String)"RspMsg");
        JDomUtils.getChildText((Element)head, (String)"TranCode");
        JDomUtils.getChildText((Element)head, (String)"UserID");
        JDomUtils.getChildText((Element)head, (String)"TranSeq");
        JDomUtils.getChildElement((Element)resp, (String)"RESPBODY");
        if ("000000".equalsIgnoreCase(returnCode) || "AUTHREQ".equalsIgnoreCase(returnCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"GxnxParser_5", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), (String)returnCode, (String)RspMsg);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u77e5", (String)"GxnxParser_6", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), (String)returnCode, (String)RspMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public static EBBankPayResponse parseQuerySalaryPay(BankPayRequest request, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        if (root == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u94f6\u884c\u8fd4\u56de\u7684xml\u9519\u8bef,root\u6ca1\u6709\u8fd4\u56de", (String)"GxnxParser_15", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]));
        }
        List paymentInfos = request.getPaymentInfos();
        Element resp = JDomUtils.getChildElement((Element)root, (String)"RESP");
        Element head = JDomUtils.getChildElement((Element)resp, (String)"RESPHEAD");
        String returnCode = JDomUtils.getChildText((Element)head, (String)"RspCode");
        String retrunMsg = JDomUtils.getChildText((Element)head, (String)"RspMsg");
        JDomUtils.getChildText((Element)head, (String)"UserID");
        JDomUtils.getChildText((Element)head, (String)"TranSeq");
        BankResponse bankResponse = new BankResponse();
        bankResponse.setResponseCode(returnCode);
        bankResponse.setResponseMessage(retrunMsg);
        if (!"000000".equalsIgnoreCase(returnCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6279\u91cf\u4ee3\u53d1\u4ea4\u6613\u7ed3\u679c\u51fa\u9519\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u4ee3\u7801:%1$s\u3002", (String)"GxnxParser_23", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), returnCode));
        }
        Element body = JDomUtils.getChildElement((Element)resp, (String)"RESPBODY");
        String count = JDomUtils.getChildText((Element)body, (String)"SucCount");
        String sucAmt = JDomUtils.getChildText((Element)body, (String)"SucAmt");
        String fileName = JDomUtils.getChildText((Element)body, (String)"HPFile");
        String hPCont = JDomUtils.getChildText((Element)body, (String)"HPCont");
        if (StringUtils.isEmpty((String)hPCont)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u94f6\u884c\u8fd4\u56de\u7684HPCont\u9519\u8bef,\u6ca1\u6709\u8fd4\u56de\u6587\u4ef6\u5185\u5bb9", (String)"GxnxParser_17", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]));
        }
        byte[] ret2 = GzipUtil.ungzipAndEncoder((String)hPCont);
        String fileContent = "";
        try {
            fileContent = new String(ret2, encoding);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5b57\u7b26\u4e32\u8f6c\u6362\u5f02\u5e38\uff1a", (String)"GxnxParser_18", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), (Throwable)e);
        }
        logger.info("\u89e3\u5bc6\u540e\u7684\u6587\u4ef6\u5185\u5bb9\u4e3a:{}", (Object)fileContent);
        String[] content = fileContent.split("\\n");
        for (int i = 1; i < content.length; ++i) {
            String[] result = content[i].split("\\|", -1);
            String bankDetailSeqId = result[0];
            PaymentInfo info = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)bankDetailSeqId);
            if (info == null) {
                logger.info("\u627e\u4e0d\u5230\u660e\u7ec6\u53f7\uff1a" + bankDetailSeqId);
                continue;
            }
            String code = result[6];
            String msg = result[7];
            if ("000000".equalsIgnoreCase(code)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"GxnxParser_9", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), (String)code, (String)msg);
                continue;
            }
            if ("888999".equalsIgnoreCase(code)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"GxnxParser_19", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), (String)code, (String)msg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)code, (String)msg);
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

