/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.qdb.dc.services.detail;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.qdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.qdb.dc.services.Packer;
import kd.ebg.aqap.banks.qdb.dc.services.Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CBE022
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final int PAGE_SHOW_NUM = 50;

    public String pack(BankDetailRequest bankDetailRequest) {
        String accNo = bankDetailRequest.getAcnt().getAccNo();
        Element root = Packer.ccreateCommonHead((String)"CBE022");
        Element ReqParam = root.getChild("opReq").getChild("ReqParam");
        JDomUtils.addChild((Element)ReqParam, (String)"accountNo", (String)accNo);
        JDomUtils.addChild((Element)ReqParam, (String)"accountType", (String)"D");
        JDomUtils.addChild((Element)ReqParam, (String)"currencyType", (String)bankDetailRequest.getBankCurrency());
        JDomUtils.addChild((Element)ReqParam, (String)"beginDate", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)ReqParam, (String)"endDate", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)ReqParam, (String)"beginAmount", (String)"");
        JDomUtils.addChild((Element)ReqParam, (String)"endAmount", (String)"");
        JDomUtils.addChild((Element)ReqParam, (String)"turnPageShowNum", (String)"50");
        int pagePos = Integer.parseInt(this.getCurrentPage());
        JDomUtils.addChild((Element)ReqParam, (String)"turnPageBeginPos", (String)(pagePos * 50 + 1 + ""));
        JDomUtils.addChild((Element)ReqParam, (String)"queryFlag", (String)"");
        JDomUtils.addChild((Element)ReqParam, (String)"moreRecInd", (String)"");
        JDomUtils.addChild((Element)ReqParam, (String)"searchKeys", (String)"");
        JDomUtils.addChild((Element)ReqParam, (String)"sqlInfo", (String)"");
        JDomUtils.addChild((Element)ReqParam, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)ReqParam, (String)"ReqReserved2", (String)"");
        String xmlMsg = JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.createRequestMsg((String)"CBE022", (String)xmlMsg);
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        this.setLastPage(true);
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(8);
        BankAcnt acnt = bankDetailRequest.getAcnt();
        BankResponse rsp = Parser.parseHeader((String)s);
        if (!"0000".equals(rsp.getResponseCode())) {
            if ("000305".equals(rsp.getResponseCode())) {
                return new EBBankDetailResponse(detailList);
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"", (String)"ebg-aqap-banks-qdb-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{rsp.getResponseCode(), rsp.getResponseMessage()})));
        }
        Element root = JDomUtils.string2Root((String)Parser.getRespXml((String)s), (String)RequestContextUtils.getCharset());
        Element opResult = root.getChild("opRep").getChild("opResult");
        if (null == opResult) {
            return new EBBankDetailResponse(detailList);
        }
        String turnPageTotalNum = opResult.getChildTextTrim("turnPageTotalNum");
        if (!StringUtils.isEmpty((String)turnPageTotalNum)) {
            int totalNum = Integer.parseInt(turnPageTotalNum);
            if (totalNum == 0) {
                return new EBBankDetailResponse(detailList);
            }
            int pagePos = Integer.parseInt(this.getCurrentPage()) + 1;
            this.setLastPage(totalNum <= pagePos * 50);
            this.setCurrentPage(pagePos);
        }
        String moreRecInd = opResult.getChildTextTrim("moreRecInd");
        String searchKeys = opResult.getChildTextTrim("searchKeys");
        String sqlInfo = opResult.getChildTextTrim("sqlInfo");
        Element list = opResult.getChild("list");
        List rowList = list.getChildren("row");
        for (int i = 0; i < rowList.size(); ++i) {
            Element d = (Element)rowList.get(i);
            DetailInfo detailInfo = new DetailInfo();
            String oppositeAccNo = d.getChildTextTrim("oppositeAccNo");
            String oppositeAccName = d.getChildTextTrim("oppositeAccName");
            String transferAmt = d.getChildTextTrim("transferAmt");
            String onloanFlag = d.getChildTextTrim("onloanFlag");
            String ecTran = d.getChildTextTrim("ecTran");
            String orderFlowNo = d.getChildTextTrim("orderFlowNo");
            String subseq1 = d.getChildTextTrim("SUBSEQ1");
            String tellerID = d.getChildTextTrim("tellerID");
            String transferDate = d.getChildTextTrim("transferDate");
            String transferTime = d.getChildTextTrim("transferTime");
            String currencyType = d.getChildTextTrim("currencyType");
            String othbranch = d.getChildTextTrim("othbranch");
            String balance = d.getChildTextTrim("balance");
            String remark = d.getChildTextTrim("remark");
            detailInfo.setCurrency(currencyType);
            detailInfo.setAccNo(bankDetailRequest.getAcnt().getAccNo());
            detailInfo.setAccName(bankDetailRequest.getAcnt().getAccName());
            detailInfo.setBankName(bankDetailRequest.getAcnt().getBankName());
            detailInfo.setOppAccNo(oppositeAccNo);
            detailInfo.setOppAccName(oppositeAccName);
            detailInfo.setOppBankName(othbranch);
            if ("C".equals(onloanFlag)) {
                detailInfo.setDebitAmount(Parser.ZERO);
                detailInfo.setCreditAmount(new BigDecimal(transferAmt));
            } else {
                detailInfo.setDebitAmount(new BigDecimal(transferAmt));
                detailInfo.setCreditAmount(Parser.ZERO);
            }
            if (StringUtils.isNotEmpty((String)balance)) {
                detailInfo.setBalance(new BigDecimal(balance));
            }
            detailInfo.setExplanation(remark);
            LocalDateTime transDateTime = StringUtils.isEmpty((String)transferTime) ? LocalDateTime.parse(transferDate + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) : LocalDateTime.parse(transferDate + transferTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            detailInfo.setTransTime(transDateTime);
            detailInfo.setTransDate(transDateTime.toLocalDate());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("oppositeAccNo", (Object)oppositeAccNo);
            jsonObject.put("transferAmt", (Object)transferAmt);
            jsonObject.put("onloanFlag", (Object)onloanFlag);
            jsonObject.put("ecTran", (Object)ecTran);
            jsonObject.put("orderFlowNo", (Object)orderFlowNo);
            jsonObject.put("SUBSEQ1", (Object)subseq1);
            jsonObject.put("tellerID", (Object)tellerID);
            String receiptNo = MatchRule.getInstance().getReceiptNo(acnt.getAccNo(), transferDate, jsonObject.toJSONString());
            detailInfo.setReceiptNo(receiptNo);
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(d);
            detailInfo.setJsonMap(jsonStr);
            detailList.add(detailInfo);
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return "567";
    }

    public String getBizCode() {
        return "CBE022";
    }

    public String getBizDesc() {
        return "CBE022";
    }

    public boolean match(BankDetailRequest request) {
        return !BankBusinessConfig.is002Detail();
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(Packer.getUrl());
        Packer.setContentType((ConnectionFactory)factory);
    }

    public boolean isSupportPage() {
        return true;
    }
}

