/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cdb.ccip.services.balance;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cdb.ccip.common.CDBBankResponse;
import kd.ebg.aqap.banks.cdb.ccip.common.CommonPacker;
import kd.ebg.aqap.banks.cdb.ccip.common.CommonParser;
import kd.ebg.aqap.banks.cdb.ccip.helper.LoginUtils;
import kd.ebg.aqap.banks.cdb.ccip.util.JDomExtUtils;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import org.jdom2.Content;
import org.jdom2.Element;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    EBGLogger logger = EBGLogger.getInstance().getLogger(HisBalanceImpl.class);
    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");

    public String pack(BankBalanceRequest bankBalanceRequest) {
        LoginUtils.getInstance().doBiz();
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader((String)"P1CMSER47", (String)Sequence.genSequence());
        root.addContent((Content)headr);
        Element request = CommonPacker.packComEntity((String)"O0220001", (String)Sequence.genSequence());
        JDomExtUtils.addChild((Element)body, (Element)request);
        JDomExtUtils.addChildCDData((Element)request, (String)"Rvl_Rcrd_Num", (String)"1");
        Element list1 = JDomExtUtils.addChild((Element)request, (String)"LIST1");
        JDomExtUtils.addChildCDData((Element)list1, (String)"AccNo", (String)bankBalanceRequest.getAcnt().getAccNo());
        JDomExtUtils.addChildCDData((Element)request, (String)"StDt", (String)bankBalanceRequest.getStartDate().format(this.formatter));
        JDomExtUtils.addChildCDData((Element)request, (String)"EdDt", (String)bankBalanceRequest.getEndDate().format(this.formatter));
        JDomExtUtils.addChildCDData((Element)request, (String)"CcyCd", (String)bankBalanceRequest.getBankCurrency());
        JDomExtUtils.addChildCDData((Element)request, (String)"CshEx_Cd", (String)("CNY".equalsIgnoreCase(bankBalanceRequest.getBankCurrency()) ? "0" : "1"));
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        CDBBankResponse bankResp = CommonParser.getBankPreResponse((String)(rspStr = CommonParser.preParse((String)rspStr)));
        if (!bankResp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5386\u53f2\u4f59\u989d\u94f6\u884c\u8fd4\u56de\u5931\u8d25\u3002%1$s,%2$s", (String)"HisBalanceImpl_4", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]), bankResp.getResponseCode(), bankResp.getResponseMessage()));
        }
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        List list1 = response.getChildren("LIST1");
        int balanceCount = Integer.parseInt(response.getChildText("Rvl_Rcrd_Num"));
        ArrayList<BalanceInfo> hisBalanceInfos = new ArrayList<BalanceInfo>(16);
        if (balanceCount > 0) {
            for (Element node : list1) {
                String accNo = JDomExtUtils.getChildText((Element)node, (String)"AccNo");
                String currency = JDomExtUtils.getChildText((Element)node, (String)"CcyCd");
                String AcBa = JDomExtUtils.getChildText((Element)node, (String)"AcBa");
                String AccAvlBal = JDomExtUtils.getChildText((Element)node, (String)"Acc_Avl_Bal");
                String transDateStr = JDomExtUtils.getChildText((Element)node, (String)"Txn_Dt");
                BalanceInfo info = new BalanceInfo();
                this.setBalanceDateTime(info, transDateStr + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                this.setAvailableBalance(info, AccAvlBal);
                this.setCurrentBalance(info, AcBa);
                this.setBankAcnt(info, bankBalanceRequest.getBankAcntList(), accNo);
                this.setBankCurrency(info, currency);
                hisBalanceInfos.add(info);
            }
        } else {
            BalanceInfo info = new BalanceInfo();
            this.setBankAcnt(info, bankBalanceRequest.getAcnt());
            info.setError(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u4f59\u989d\u4fe1\u606f.", (String)"HisBalanceImpl_2", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]));
            hisBalanceInfos.add(info);
        }
        EBBankBalanceResponse rsp = new EBBankBalanceResponse();
        rsp.setBalances(hisBalanceInfos);
        return rsp;
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P1CMSER47";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4f59\u989d\u67e5\u8be2", (String)"HisBalanceImpl_3", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]);
    }
}

