/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.other.service;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.other.info.BankLoginInfo;
import kd.ebg.aqap.business.other.info.BankVersionInfo;
import kd.ebg.aqap.business.other.info.PropertyConfigInfo;
import kd.ebg.aqap.business.other.info.ServiceInfo;
import kd.ebg.aqap.business.other.service.CommonToBusinessAdapter;
import kd.ebg.aqap.common.framework.info.FrameworkInfoContributor;
import kd.ebg.aqap.common.utils.BeanFactory;
import kd.ebg.aqap.mservice.boot.configuration.FrameworkInfoConfiguration;
import kd.ebg.egf.common.annotation.Service;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.FieldUtils;

@Service
public class InfoService {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(InfoService.class);
    private static AtomicReference<ServiceInfo> serviceInfoAtomicReference = new AtomicReference();
    private static Long lastUpdateTime = 1L;
    private static final Long UPDATEPEROID = 6000L;
    private static String banksInfo = "";

    private synchronized void init() {
        FrameworkInfoConfiguration infoConfiguration = (FrameworkInfoConfiguration)BeanFactory.getBean(FrameworkInfoConfiguration.class);
        if (!infoConfiguration.isFinished()) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u5e94\u7528\u542f\u52a8\u8fd8\u672a\u5b8c\u6210\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"InfoService_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        FrameworkInfoContributor frameworkInfoContributor = (FrameworkInfoContributor)BeanFactory.getBean(FrameworkInfoContributor.class);
        ServiceInfo serviceInfo = new ServiceInfo();
        serviceInfo.setBanks(CommonToBusinessAdapter.convertBankInfos(frameworkInfoContributor.getInfoBanks()));
        serviceInfo.setBankVersions(CommonToBusinessAdapter.convertBankVersionInfos(frameworkInfoContributor.getInfoBankVersions()));
        serviceInfoAtomicReference.set(serviceInfo);
    }

    private void ensureInit() {
        if (Objects.isNull(serviceInfoAtomicReference.get())) {
            this.init();
        }
    }

    public PropertyConfigInfo getBankConfig(String bankVersionID) {
        BankVersionInfo versionInfo = this.getBankVersionInfo(bankVersionID);
        if (versionInfo == null) {
            return null;
        }
        return versionInfo.getPropertyConfigInfo();
    }

    public PropertyConfigInfo getBankBusinessConfig(String bankVersionID) {
        PropertyConfigInfo propertyConfigInfo = this.getBankConfig(bankVersionID);
        if (propertyConfigInfo == null) {
            return null;
        }
        PropertyConfigInfo propertyConfigInfoCopy = new PropertyConfigInfo();
        FieldUtils.fieldsCopy((Object)propertyConfigInfo, (Object)propertyConfigInfoCopy);
        propertyConfigInfoCopy.setConfigItems(propertyConfigInfo.getConfigItems());
        List configItemInfos = propertyConfigInfoCopy.getConfigItems().stream().filter(configItemInfo -> !configItemInfo.isAccNo()).collect(Collectors.toList());
        propertyConfigInfoCopy.setConfigItems(configItemInfos);
        return propertyConfigInfoCopy;
    }

    public PropertyConfigInfo getBankAcntConfig(String bankVersionID) {
        PropertyConfigInfo propertyConfigInfo = this.getBankConfig(bankVersionID);
        if (propertyConfigInfo == null) {
            return null;
        }
        PropertyConfigInfo propertyConfigInfoCopy = new PropertyConfigInfo();
        FieldUtils.fieldsCopy((Object)propertyConfigInfo, (Object)propertyConfigInfoCopy);
        propertyConfigInfoCopy.setConfigItems(propertyConfigInfo.getConfigItems());
        List configItemInfos = propertyConfigInfoCopy.getConfigItems().stream().filter(configItemInfo -> configItemInfo.isAccNo()).collect(Collectors.toList());
        propertyConfigInfoCopy.setConfigItems(configItemInfos);
        return propertyConfigInfoCopy;
    }

    private BankVersionInfo getBankVersionInfo(String bankVersionID) {
        this.ensureInit();
        ServiceInfo serviceInfo = serviceInfoAtomicReference.get();
        return serviceInfo.getBankVersions().stream().filter(v -> v.getBankVersionID().equalsIgnoreCase(bankVersionID)).findFirst().orElse(null);
    }

    public List<BankLoginInfo> getBankLoginInfoList(String bankVersionID) {
        BankVersionInfo bankVersionInfo = this.getBankVersionInfo(bankVersionID);
        if (bankVersionInfo != null) {
            return bankVersionInfo.getLogins();
        }
        return null;
    }
}

