/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.aqap.business.detail.item.TransTypeEnum;
import kd.ebg.aqap.business.payment.utils.CheckUtil;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.pay.PayBody;
import kd.ebg.aqap.common.entity.biz.pay.PayDetail;
import kd.ebg.aqap.common.entity.biz.pay.PayRequest;
import kd.ebg.aqap.common.entity.biz.pay.PayResponse;
import kd.ebg.aqap.common.entity.biz.querypay.QueryPayRequest;
import kd.ebg.aqap.common.entity.biz.querypay.QueryPayResponse;
import kd.ebg.aqap.common.entity.biz.status.EbStatus;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.services.ObjectPropertyOpService;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.service.keywords.BankKeyWordsService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.file.FieldUtils;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PaymentConvert {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(PaymentConvert.class);

    public static List<PaymentInfo> convertPay(PayRequest payRequest) {
        ObjectPropertyOpService objectPropertyService;
        String openPayForSalary;
        JSONObject jsonObject;
        logger.info("\u4ed8\u6b3e\u8bf7\u6c42\u8f6c\u6362\u4e3a\u4ed8\u6b3e\u5bf9\u8c61");
        PayBody body = payRequest.getBody();
        String bizType = payRequest.getHeader().getBizType();
        String subBizType = payRequest.getHeader().getSubBizType();
        String customID = payRequest.getHeader().getCustomId();
        String currency = payRequest.getHeader().getCurrency();
        int totalCount = body.getTotalCount();
        BigDecimal totalAmount = CheckUtil.checkBigDecimal((String)body.getTotalAmount(), (String)ResManager.loadKDString((String)"\u8bf7\u6c42\u91cc\u7684\u4ed8\u6b3e\u603b\u91d1\u989d\u3002", (String)"PaymentConvert_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
        String batchSeqID = body.getBatchSeqID();
        List payDetails = body.getDetails();
        EBContext context = EBContext.getContext();
        BankAcnt bankAcnt = context.getBankAcnt();
        long requestTimeStamp = payRequest.getHeader().getRequestTime();
        LocalDateTime requestTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(requestTimeStamp), ZoneId.systemDefault());
        Preconditions.checkArgument((totalCount == payDetails.size() ? 1 : 0) != 0, (Object)String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u7684\u4ed8\u6b3e\u5355\u603b\u6570(%1$s)\u548c\u8be5\u6279\u6b21\u6307\u793a\u7684\u603b\u7b14\u6570(%2$s)\u4e0d\u7b26", (String)"PaymentConvert_20", (String)"ebg-aqap-business", (Object[])new Object[0]), payDetails.size(), totalCount));
        BigDecimal actualTotalAmount = new BigDecimal("0.00");
        ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>(payDetails.size());
        int bankSerialNo = 1;
        BankAcnt acnt = EBContext.getContext().getBankAcnt();
        boolean idempotency = false;
        if (StringUtils.isNotEmpty((String)payRequest.getExtData())) {
            jsonObject = JSONObject.parseObject((String)payRequest.getExtData());
            if (jsonObject.containsKey((Object)"idempotency")) {
                idempotency = jsonObject.getBoolean("idempotency");
            }
        } else if (StringUtils.isNotEmpty((String)payRequest.getBody().getExtData()) && (jsonObject = JSONObject.parseObject((String)payRequest.getBody().getExtData())).containsKey((Object)"idempotency")) {
            idempotency = jsonObject.getBoolean("idempotency");
        }
        HashMap<String, String> currencyMap = new HashMap<String, String>(16);
        for (PayDetail detail : payDetails) {
            PaymentInfo info = new PaymentInfo();
            paymentInfos.add(info);
            String extData = detail.getExtData();
            if (StringUtils.isNotEmpty((String)extData)) {
                JSONObject jsonObject2 = JSONObject.parseObject((String)extData);
                if (jsonObject2 != null && jsonObject2.containsKey((Object)"paybillcreator")) {
                    String paybillcreator = jsonObject2.getString("paybillcreator");
                    info.setPaybillCreator(paybillcreator);
                }
                if (jsonObject2 != null && jsonObject2.containsKey((Object)"paybillauditor")) {
                    String paybillauditor = jsonObject2.getString("paybillauditor");
                    info.setPaybillAuditor(paybillauditor);
                }
                if (jsonObject2 != null && jsonObject2.containsKey((Object)"applyname")) {
                    String applyname = jsonObject2.getString("applyname");
                    info.setApplyName(applyname);
                }
                if (jsonObject2 != null && jsonObject2.containsKey((Object)"applyphone")) {
                    String applyphone = jsonObject2.getString("applyphone");
                    info.setApplyPhone(applyphone);
                }
            }
            info.setIdempotency(idempotency);
            info.setAccCity(acnt.getCity());
            info.setAccProvince(acnt.getProvince());
            if (CheckUtil.isChineseStr((String)acnt.getCountry())) {
                info.setAccCountry(acnt.getCountry());
            } else {
                QFilter filter = QFilter.of((String)"name=?", (Object[])new Object[]{acnt.getCountry()});
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_country", (String)"simplespell", (QFilter[])filter.toArray());
                String country = "";
                country = dynamicObject != null ? dynamicObject.getString("simplespell") : acnt.getCountry();
                info.setAccCountry(country);
            }
            info.setBankSerialNo(String.valueOf(bankSerialNo++));
            FieldUtils.fieldsCopy((Object)detail, (Object)info);
            LocalDateTime bookingTime = info.getBookingTime();
            if (bookingTime != null && bookingTime.isBefore(LocalDateTime.now())) {
                info.setBookingTime(LocalDateTime.now());
            }
            if (StringUtils.isNotEmpty((String)detail.getAgentAccNo())) {
                PaymentInfoSysFiled.set((PaymentInfo)info, (String)"agentAccNo", (String)detail.getAgentAccNo());
            }
            info.setBatchSeqID(batchSeqID);
            info.setBizType(bizType);
            info.setSubBizType(subBizType);
            info.setTotalAmount(totalAmount);
            info.setTotalCount(Integer.valueOf(totalCount));
            if ("individual".equalsIgnoreCase(detail.getIncomeType())) {
                info.setIndividual(Boolean.TRUE);
            } else {
                info.setIndividual(Boolean.FALSE);
            }
            info.setEmails(detail.getEmail());
            info.setRequestTime(requestTime);
            info.setRequestSeq(Sequence.genSequence());
            info.setInsertBatchSeq(payRequest.getBody().getBatchSeqID());
            info.setDetailBizNo(detail.getDetailBizNo());
            info.setId(String.valueOf(ID.genLongId()));
            info.setTransUp(detail.getTransUp());
            FieldUtils.fieldsCopy((Object)bankAcnt, (Object)info);
            info.setCustomID(customID);
            String bankCurrency = "";
            if (!currencyMap.containsKey(currency)) {
                bankCurrency = CurrencyUtils.convert2Bank((String)currency);
                currencyMap.put(currency, bankCurrency);
            } else {
                bankCurrency = (String)currencyMap.get(currency);
            }
            info.setCurrency(bankCurrency);
            info.setPayCurrency(bankCurrency);
            info.setIsoCurrencyCode(currency);
            String detailSeqID = detail.getDetailSeqID();
            info.setDetailSeqID(detailSeqID);
            String incomeAccNo = info.getIncomeAccNo();
            incomeAccNo = incomeAccNo.replaceAll("\u200b", "");
            if ("overseaPay".equalsIgnoreCase(subBizType) && context.getBankVersionID().equalsIgnoreCase("BOCHK_DC") && StringUtils.isNotEmpty((String)info.getUseCN()) && ResManager.loadKDString((String)"\u8f6c\u6570\u5feb", (String)"PaymentConvert_8", (String)"ebg-aqap-business", (Object[])new Object[0]).equalsIgnoreCase(info.getUseCN().trim())) {
                info.setIncomeAccNo(incomeAccNo);
                info.setIncomeBankName(detail.getIncomeBankName());
            }
            info.setAmount(CheckUtil.checkBigDecimal((String)info.getAmount().toString(), (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d", (String)"PaymentConvert_13", (String)"ebg-aqap-business", (Object[])new Object[0])));
            info.setSameBank(Boolean.valueOf(PaymentConvert.isSameBank(bankAcnt, info)));
            info.setSameCity(Boolean.valueOf(PaymentConvert.isSameCity(bankAcnt, info)));
            info.setMobiles(detail.getMobile());
            info.setEmails(detail.getEmail());
            info.setIncomeCnaps(detail.getIncomeCnapsCode());
            info.setIncomeBranchNo(detail.getIncomeBranchNo());
            info.setIncomeBranchName(detail.getIncomeBranchName());
            info.setAbstractMsg(detail.getAbstractMsg());
            actualTotalAmount = actualTotalAmount.add(info.getAmount());
            info.setMerge(Boolean.valueOf(detail.isMergeFlag()));
            info.setForce(Boolean.valueOf(detail.isForce()));
            info.setUrgent(Boolean.valueOf(detail.isUrgent()));
            if (StringUtils.isEmpty((String)detail.getIncomeAreaCode())) {
                info.setIncomeAreaCode("");
            }
            info.setExplanation(StringUtils.isNotEmpty((String)info.getExplanation()) ? info.getExplanation().trim() : "");
            info.setCertType(detail.getCertType());
            info.setCertNum(detail.getCertNum());
        }
        if (UseConvertor.isSalary((PaymentInfo)((PaymentInfo)paymentInfos.get(0))) && !StringUtils.equalsIgnoreCase((String)"true", (String)(openPayForSalary = (objectPropertyService = (ObjectPropertyOpService)SpringContextUtil.getBean(ObjectPropertyOpService.class)).isOpenPayForSalary(context.getBankVersionID())))) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\u4e1a\u52a1\u672a\u542f\u7528\u6216\u6682\u4e0d\u652f\u6301\u4ee3\u53d1\u5de5\u8d44\uff0c\u8bf7\u5728\u67e5\u8be2\u4e0e\u652f\u4ed8-\u94f6\u884c\u53c2\u6570\u914d\u7f6e\u5185\u786e\u8ba4\u662f\u5426\u6709\u4ee3\u53d1\u5de5\u8d44\u4e1a\u52a1\u53c2\u6570\uff0c\u786e\u8ba4\u5b8c\u6210\u53ef\u4ee5\u5f00\u542f\u4ee3\u53d1\u5de5\u8d44\u4e1a\u52a1\u5f00\u5173\u540e\u91cd\u8bd5\u3002", (String)"PaymentConvert_15", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        if (actualTotalAmount.compareTo(totalAmount) != 0) {
            throw EBExceiptionUtil.preCheckException((String)(String.format(ResManager.loadKDString((String)"\u63a5\u5165\u65b9\u4f20\u7684\u603b\u91d1\u989d \uff1a%s\u3002", (String)"PaymentConvert_27", (String)"ebg-aqap-business", (Object[])new Object[0]), totalAmount) + String.format(ResManager.loadKDString((String)" \u4e0e\u8ba1\u7b97\u540e\u7684\u603b\u91d1\u989d\u4e0d\u7b26 \uff1a%s\u3002", (String)"PaymentConvert_28", (String)"ebg-aqap-business", (Object[])new Object[0]), actualTotalAmount)));
        }
        return paymentInfos;
    }

    public static boolean isSameBank(BankAcnt acnt, PaymentInfo info) {
        String bankVersionID = acnt.getBankVersionId();
        String bankName = acnt.getBankName();
        String incomeBankName = info.getIncomeBankName();
        if (StringUtils.isNotEmpty((String)incomeBankName) && StringUtils.isNotEmpty((String)bankName) && (bankName.equalsIgnoreCase(incomeBankName) || incomeBankName.contains(bankName))) {
            return true;
        }
        List keyWords = BankBundleManager.getInstance().getKeyWords(bankVersionID);
        if ((keyWords == null || keyWords.isEmpty()) && (keyWords = BankKeyWordsService.getInstance().getKeyWords(bankVersionID)) != null && !keyWords.isEmpty()) {
            BankBundleManager.getInstance().setKeyWords(bankVersionID, keyWords);
        }
        if (keyWords == null || keyWords.isEmpty()) {
            keyWords = BankBundleManager.getInstance().getBankKeyWords(bankVersionID);
            BankBundleManager.getInstance().setKeyWords(bankVersionID, keyWords);
        }
        for (String keyWord : keyWords) {
            if (!incomeBankName.contains(keyWord) && !keyWord.contains(incomeBankName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSameCity(BankAcnt acnt, PaymentInfo info) {
        String payCity = acnt.getCity();
        String incomeCity = info.getIncomeCity();
        if (StrUtil.isBlank((CharSequence)payCity) || StrUtil.isBlank((CharSequence)incomeCity)) {
            return false;
        }
        return payCity.equalsIgnoreCase(incomeCity) || payCity.contains(incomeCity) || incomeCity.contains(payCity);
    }

    public static PayResponse convertToResponse(List<PaymentInfo> paymentInfos, PayRequest payRequest) {
        PayResponse response = new PayResponse();
        response.setHeader(payRequest.getHeader());
        PayBody body = PaymentConvert.convert2Body(paymentInfos);
        body.setBatchSeqID(payRequest.getBody().getBatchSeqID());
        body.setTotalAmount(payRequest.getBody().getTotalAmount());
        body.setTotalCount(payRequest.getBody().getTotalCount());
        body.setFeeType(payRequest.getBody().getFeeType());
        body.setBatchRollBack(payRequest.getBody().getBatchRollBack());
        response.setBody(body);
        return response;
    }

    public static QueryPayResponse convertToResponse(List<PaymentInfo> paymentInfos, QueryPayRequest queryPayRequest) {
        QueryPayResponse response = new QueryPayResponse();
        response.setHeader(queryPayRequest.getHeader());
        PayBody body = PaymentConvert.convert2Body(paymentInfos);
        body.setBatchSeqID(queryPayRequest.getBody().getBatchSeqId());
        response.setBody(body);
        return response;
    }

    public static PayBody convert2Body(List<PaymentInfo> paymentInfos) {
        PayBody body = new PayBody();
        ArrayList<PayDetail> details = new ArrayList<PayDetail>(paymentInfos.size());
        for (PaymentInfo info : paymentInfos) {
            PayDetail detail = new PayDetail();
            FieldUtils.fieldsCopy((Object)info, (Object)detail);
            detail.setMergeFlag(info.getMerge().booleanValue());
            detail.setKdFlagID(info.getKdFlagID());
            detail.setBookPayFlag(info.isBookPayFlag());
            details.add(detail);
            detail.setBankMsg(info.bankMsgDetails());
            detail.setEbSeqId(info.getId());
            detail.setEbStatus(EbStatus.convertBankState2EBG((PaymentState)PaymentState.getEnumById((int)info.getStatus())).getName());
            detail.setTransUp(info.getTransUp());
            detail.setEbStatusMsg(PaymentConvert.getEbStatusMsg(info));
            detail.setReversed1(info.getReversed1());
            String refundNo = info.getBiz(TransTypeEnum.REFUND.getName());
            if (!StringUtils.isNotEmpty((String)refundNo)) continue;
            HashMap<String, String> jsonMap = new HashMap<String, String>(1);
            jsonMap.put(TransTypeEnum.REFUND.getName(), refundNo);
            detail.setExtData(JsonUtil.toJsonLine(jsonMap));
        }
        body.setDetails(details);
        return body;
    }

    public static String getEbStatusMsg(PaymentInfo info) {
        String tip = info.getStatusMsg();
        if (info.isBookPayFlag() && info.getBookingTime() != null) {
            String payDate = info.getBookingTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            tip = String.format(ResManager.loadKDString((String)"\u672c\u7b14\u4ed8\u6b3e\u4e3a\u9884\u7ea6\u4ed8\u6b3e\uff0c\u9884\u7ea6\u65e5\u671f\u4e3a%1$s\uff1b%2$s", (String)"PaymentConvert_3", (String)"ebg-aqap-business", (Object[])new Object[0]), payDate, tip);
        }
        String ebStatusMsg = PaymentState.FAIL.getId() == info.getStatus().intValue() && !StringUtils.isEmpty((String)info.getBankMsg()) ? String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\uff1a%s\u3002", (String)"PaymentConvert_24", (String)"ebg-aqap-business", (Object[])new Object[0]), tip) + String.format(ResManager.loadKDString((String)"\u539f\u56e0\uff1a%s", (String)"PaymentConvert_25", (String)"ebg-aqap-business", (Object[])new Object[0]), info.getBankMsg()) : (StringUtils.isEmpty((String)info.getErrorMsg()) || info.getErrorMsg().startsWith(info.getStatusMsg()) ? String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\uff1a%s\u3002", (String)"PaymentConvert_24", (String)"ebg-aqap-business", (Object[])new Object[0]), tip) : String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\uff1a%1$s,%2$s", (String)"PaymentConvert_26", (String)"ebg-aqap-business", (Object[])new Object[0]), tip, info.getErrorMsg()));
        return StringUtils.norm((String)ebStatusMsg);
    }
}

