/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.detail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Parser;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.framework.match.DetailFieldUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailFieldConf;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailParser {
    public static final String AUTO_PAY_FLAG = "STFS";

    public static List<DetailInfo> parseHisDetail(BankDetailRequest rqst, String rspStr) {
        return DetailParser.parseDetail(rqst, rspStr);
    }

    public static List<DetailInfo> parseTodayDetail(BankDetailRequest rqst, String rspStr) {
        return DetailParser.parseDetail(rqst, rspStr);
    }

    private static List<DetailInfo> parseDetail(BankDetailRequest rqst, String rspStr) {
        EBGLogger logger = EBGLogger.getInstance().getLogger(DetailParser.class);
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot((Element)root);
        if (!"0000".equalsIgnoreCase(rsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4ea4\u884c\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 ,\u94f6\u884c\u8fd4\u56de :%1$s", (String)"DetailParser_4", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{rsp.getResponseCode(), rsp.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element body = root.getChild("body");
        String field_num = ParserUtils.checkUnNullableElement((Element)body, (String)"field_num");
        String record_num = ParserUtils.checkUnNullableElement((Element)body, (String)"record_num");
        String serial_record = ParserUtils.checkUnNullableElement((Element)body, (String)"serial_record");
        int recordNum = Integer.parseInt(record_num);
        if (0 == recordNum) {
            return detailList;
        }
        int fieldNum = Integer.parseInt(field_num);
        String[] splits = DetailParser.split(serial_record);
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        DetailFieldConf detailField = DetailFieldUtil.getInstance().getDetailField(EBContext.getContext().getBankVersionID(), RequestContextUtils.getRunningParam((String)"interface_name"));
        for (int i = 1; i <= recordNum; ++i) {
            String dateStr = splits[fieldNum * i + 1];
            String timeStr = splits[fieldNum * i + 2];
            String useCnStr = splits[fieldNum * i + 3];
            String detailSequence = splits[fieldNum * i + 4];
            String flowSequence = splits[fieldNum * i + 5];
            String accNo = splits[fieldNum * i + 6];
            String drcrf = splits[fieldNum * i + 8];
            String currency = splits[fieldNum * i + 9];
            String amountStr = splits[fieldNum * i + 10];
            String balanceStr = splits[fieldNum * i + 11];
            String oppAccNo = splits[fieldNum * i + 13];
            String oppAccName = splits[fieldNum * i + 14];
            String oppAccBank = splits[fieldNum * i + 17];
            String explanation1 = splits[fieldNum * i + 22];
            String explanation2 = splits[fieldNum * i + 23];
            if (!rqst.getBankCurrency().equals(currency)) {
                logger.info("\u4e0a\u6e38\u8bf7\u6c42\u7684\u5e01\u522b{}\u548c\u94f6\u884c\u8fd4\u56de\u7684\u5e01\u522b\u4e0d\u4e00\u81f4{},\u672c\u6b21\u660e\u7ec6\u4e0d\u4fdd\u5b58", new Object[]{rqst.getBankCurrency(), currency});
                continue;
            }
            String json = null;
            if (detailField != null) {
                StringBuilder sb = new StringBuilder();
                for (int j = fieldNum * i; j < fieldNum * i + fieldNum; ++j) {
                    sb.append(splits[j]).append(detailField.getSplit());
                }
                json = MatchRule.getInstance().getDetailJsonWithNonStructuredData(detailField.getDetailFields(), sb.toString(), detailField.getSplit());
            }
            String KDDetailNo = null;
            int index = explanation2.indexOf("#");
            String explanationPrefix = "";
            if (-1 != index) {
                explanationPrefix = explanation2.substring(0, index + 1);
                explanation2 = explanation2.substring(index + 1);
            }
            DetailInfo detail = new DetailInfo();
            detail.setCurrency(currency);
            BigDecimal amout = null;
            if (StringUtils.isEmpty((String)amountStr)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u884c\u62a5\u6587\u683c\u5f0f\u9519\u8bef\uff0c\u4ea4\u6613\u91d1\u989d\u4e3a\u7a7a\u3002", (String)"DetailParser_1", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]));
            }
            amout = new BigDecimal(amountStr.trim());
            boolean debitFlag = false;
            if ("D".equalsIgnoreCase(drcrf)) {
                debitFlag = true;
                detail.setDebitAmount(amout);
                detail.setCreditAmount(ParserUtils.ZERO);
            } else if ("C".equalsIgnoreCase(drcrf)) {
                detail.setDebitAmount(ParserUtils.ZERO);
                detail.setCreditAmount(amout);
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u884c\u8fd4\u56de\u4e86\u672a\u77e5\u7684\u501f\u8d37\u6807\u5fd7Drcrf=%1$s\u3002", (String)"DetailParser_5", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]), drcrf));
            }
            detail.setOppAccNo(oppAccNo);
            detail.setOppAccName(oppAccName);
            detail.setOppBankName(oppAccBank);
            if ("D".equalsIgnoreCase(drcrf) && !StringUtils.isEmpty((String)BizNoUtil.getId((String)explanation2))) {
                KDDetailNo = BizNoUtil.getId((String)explanation2);
            }
            explanation1 = BizNoUtil.getMsg((String)explanation1);
            detail.setExplanation(explanation2);
            if (!StringUtils.isEmpty((String)BizNoUtil.getMsg((String)explanation2))) {
                String exp = BizNoUtil.getMsg((String)explanation2);
                detail.setExplanation(exp);
            }
            if (!BankBusinessConfig.isSubExplanation()) {
                detail.setExplanation(explanationPrefix + detail.getExplanation());
            }
            if (!StringUtils.isEmpty((String)KDDetailNo)) {
                if (KDDetailNo.startsWith(ResManager.loadKDString((String)"\u4ee3\u53d1\u5176\u4ed6\u6b3e\u9879-", (String)"DetailParser_3", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]))) {
                    KDDetailNo = KDDetailNo.replaceFirst(ResManager.loadKDString((String)"\u4ee3\u53d1\u5176\u4ed6\u6b3e\u9879-", (String)"DetailParser_3", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]), "");
                }
                if (KDDetailNo.contains("-")) {
                    KDDetailNo = KDDetailNo.substring(KDDetailNo.indexOf("-") + 1);
                }
                DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)KDDetailNo);
                detail.setKdFlag(KDDetailNo);
                detail.setPayBankDetailSeqID(KDDetailNo);
            }
            JSONObject receiptJson = new JSONObject();
            if (StringUtils.isNotEmpty((String)json)) {
                receiptJson = JSON.parseObject((String)json);
            }
            receiptJson.put("accNo", (Object)accNo);
            receiptJson.put("transDate", (Object)dateStr);
            receiptJson.put("serialNo", (Object)(detailSequence + "@" + flowSequence));
            receiptJson.put("logNo", (Object)flowSequence);
            receiptJson.put("detailSequence", (Object)detailSequence);
            receiptJson.put("Amount", (Object)amountStr);
            receiptJson.put("remark", (Object)detail.getExplanation());
            receiptJson.put("cdFlag", (Object)drcrf);
            detail.setJsonMap(receiptJson.toJSONString());
            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, dateStr, receiptJson.toJSONString());
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setReceiptNo(receiptNo);
            detail.setBankDetailNo(detailSequence);
            detail.setUseCn(useCnStr);
            detail.setTransDate(LocalDate.parse(dateStr, DateTimeFormatter.ofPattern("yyyyMMdd")));
            detail.setTransTime(LocalDateTime.parse(dateStr + timeStr, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            if (!StringUtils.isEmpty((String)balanceStr)) {
                detail.setBalance(new BigDecimal(balanceStr.trim()));
            }
            if (!StringUtils.isEmpty((String)detailSequence)) {
                String autoPayFlag = detailSequence.substring(0, 4);
                if (AUTO_PAY_FLAG.equalsIgnoreCase(autoPayFlag)) {
                    if ("C".equalsIgnoreCase(drcrf)) {
                        detail.setTransType("autotransup");
                    } else if ("D".equalsIgnoreCase(drcrf)) {
                        detail.setTransType("autotransdown");
                    }
                } else {
                    String oldFlag = detailSequence.substring(0, 1);
                    if (oldFlag.equalsIgnoreCase("G") && "C".equalsIgnoreCase(drcrf)) {
                        detail.setTransType("autotransup");
                    }
                }
            }
            detailList.add(detail);
        }
        return detailList;
    }

    private static String[] split(String serial_record) {
        return StringUtils.split((String)serial_record, (String)"|");
    }
}

