/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbc.cmp.services.handler;

import java.io.File;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsbc.cmp.services.utils.HsbcUtil;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.repository.PaymentInfoRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.proxy.oversea.AbstractMT940Handler;
import kd.ebg.aqap.proxy.oversea.entity.OverseaBalance;
import kd.ebg.aqap.proxy.oversea.entity.OverseaDetail;
import kd.ebg.aqap.proxy.swift.model.SwiftTextBlock;
import kd.ebg.aqap.proxy.swift.model.Tag;
import kd.ebg.aqap.proxy.swift.model.field.Field20;
import kd.ebg.aqap.proxy.swift.model.field.Field25;
import kd.ebg.aqap.proxy.swift.model.field.Field28C;
import kd.ebg.aqap.proxy.swift.model.field.Field60F;
import kd.ebg.aqap.proxy.swift.model.field.Field60M;
import kd.ebg.aqap.proxy.swift.model.field.Field61;
import kd.ebg.aqap.proxy.swift.model.field.Field62F;
import kd.ebg.aqap.proxy.swift.model.field.Field64;
import kd.ebg.aqap.proxy.swift.model.field.Field86;
import kd.ebg.aqap.proxy.swift.utils.SwiftTagsUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class HSBC_CMP_MT940_Handler
extends AbstractMT940Handler {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(HSBC_CMP_MT940_Handler.class);

    public boolean isNeedToProcessFile(String fileName) {
        if (fileName.startsWith("STMT")) {
            return true;
        }
        return fileName.contains("SHK") || fileName.contains("SCN") || fileName.contains("MT940");
    }

    public void initContext(EBContext ebContext) {
        this.context = ebContext;
    }

    protected void processFile(File file, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) {
        String name = file.getName();
        if (!this.isNeedToProcessFile(name)) {
            return;
        }
        try {
            List list = super.readFileContentAsString(file);
            for (SwiftTextBlock aList : list) {
                this.parseHistoryDetails(aList, name, detailInfoList, payInfoList, balanceInfoList);
            }
        }
        catch (Exception e) {
            logger.error(String.format(ResManager.loadKDString((String)"\u5904\u7406\u524d\u65e5\u4ea4\u6613\u660e\u7ec6\u62a5\u544a[%1$s]\u51fa\u9519:%2$s\u3002", (String)"HSBC_CMP_MT940_Handler_2", (String)"ebg-aqap-banks-hsbc-cmp", (Object[])new Object[0]), new Object[0]), new Object[]{name, e});
        }
    }

    private void parseHistoryDetails(SwiftTextBlock swiftTextBlock, String fileName, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) throws Exception {
        BigDecimal openingBalance;
        Field20 field20 = new Field20(swiftTextBlock.getTagValue("20"));
        Field25 field25 = new Field25(swiftTextBlock.getTagValue("25"));
        Field28C field28C = new Field28C(swiftTextBlock.getTagValue("28C"));
        Field60F field60F = new Field60F(swiftTextBlock.getTagValue("60F"));
        Field60M field60M = new Field60M(swiftTextBlock.getTagValue("60M"));
        Field62F field62F = new Field62F(swiftTextBlock.getTagValue("62F"));
        logger.info("Field62F:" + field62F.toString());
        logger.info("Field20:" + field20.toString());
        logger.info("Field25:" + field25.toString());
        logger.info("Field28C:" + field28C.toString());
        logger.info("Field60F:" + field60F.toString());
        logger.info("Field60M:" + field60M.toString());
        String acntNumber = field25.getComponent1();
        String currency = field60F.getComponent3();
        if (StringUtils.isEmpty((String)currency)) {
            currency = field60M.getComponent3();
        }
        LocalDate date = field62F.getComponent2AsCalendar().getTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<List<PaymentInfo>, String> gatherMap = new HashMap<List<PaymentInfo>, String>();
        this.parse61To86Tags(swiftTextBlock, acntNumber, currency, fileName, detailInfoList, payInfoList, map, gatherMap, date);
        if (map.size() > 0) {
            this.dealCharge(detailInfoList, map);
        }
        if (gatherMap.size() > 0) {
            this.dealChargeGather(detailInfoList, gatherMap);
        }
        Field64 field64 = new Field64(swiftTextBlock.getTagValue("64"));
        logger.info("Field64:" + field64.toString());
        try {
            openingBalance = field60F.getComponent4AsBigDecimal();
            String balSign = field60F.getComponent1AsString();
            if (null == openingBalance) {
                openingBalance = field60M.getComponent4AsBigDecimal();
                balSign = field60M.getComponent1AsString();
            }
            if ("D".equalsIgnoreCase(balSign)) {
                openingBalance = openingBalance.multiply(new BigDecimal("-1"));
            }
        }
        catch (Exception ex) {
            Exception e = new Exception(ResManager.loadKDString((String)"\u83b7\u53d6\u5386\u53f2\u660e\u7ec6Opening Balance \u4f59\u989d\u5931\u8d25\u3002", (String)"HSBC_CMP_MT940_Handler_0", (String)"ebg-aqap-banks-hsbc-cmp", (Object[])new Object[0]), ex);
            logger.info("", (Object)e);
            throw e;
        }
        this.calcBalance(detailInfoList, openingBalance, acntNumber);
        Calendar balanceDate = field62F.getComponent2AsCalendar();
        LocalDateTime localDateTime = balanceDate.getTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        BigDecimal closingBalance = field62F.getComponent4AsBigDecimal();
        BigDecimal closingAvailableBalance = field64.getComponent4AsBigDecimal();
        OverseaBalance balanceInfo = new OverseaBalance();
        balanceInfo.setNumber(acntNumber);
        balanceInfo.setCurrency(currency);
        balanceInfo.setCurrentBalance(closingBalance);
        balanceInfo.setAvailableBalance(closingAvailableBalance);
        balanceInfo.setLastDayBalance(openingBalance);
        balanceInfo.setBalanceDate(localDateTime);
        balanceInfo.setUpdateSource(fileName);
        balanceInfo.setBankVersion(this.context.getBankVersionID());
        balanceInfoList.add(balanceInfo);
    }

    private void parse61To86Tags(SwiftTextBlock swiftTextBlock, String acntNumber, String currency, String fileName, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, Map<String, String> map, Map<List<PaymentInfo>, String> gatherMap, LocalDate transTime) {
        List tags = swiftTextBlock.getTags();
        int[] tag61Index = SwiftTagsUtils.getTagsIndex((List)tags, (String)"61");
        if (0 == tag61Index.length) {
            return;
        }
        for (int aTag61Index : tag61Index) {
            Field61 field61 = new Field61(((Tag)tags.get(aTag61Index)).getTagValue());
            OverseaDetail detail = new OverseaDetail();
            detail.setNumber(acntNumber);
            detail.setBenefitAccNo("");
            detail.setPayBankName("HSBC");
            detail.setPayBankVersion("HSBC_CMP");
            detail.setDetailFileName(fileName);
            detail.setCustomId(EBContext.getContext().getCustomID());
            detail.setCreatetime(LocalDateTime.now());
            String oppInfo = field61.getComponent9();
            detail.setTxDate(transTime);
            detail.setCurrency(currency);
            BigDecimal amount = field61.getComponent5AsBigDecimal();
            String creditOrDebit = field61.getComponent3();
            if ("C".equalsIgnoreCase(creditOrDebit) || "EC".equalsIgnoreCase(creditOrDebit)) {
                detail.setCordFlag("CREDIT");
                detail.setTxAmt(amount);
            } else if ("D".equalsIgnoreCase(creditOrDebit) || "ED".equalsIgnoreCase(creditOrDebit)) {
                detail.setCordFlag("DEBIT");
                detail.setTxAmt(amount);
            } else if ("RC".equalsIgnoreCase(creditOrDebit)) {
                detail.setCordFlag("CREDIT");
                detail.setTxAmt(amount.multiply(new BigDecimal("-1")));
            } else if ("RD".equalsIgnoreCase(creditOrDebit)) {
                detail.setCordFlag("CREDIT");
                detail.setTxAmt(amount);
            } else {
                logger.info(String.format(ResManager.loadKDString((String)"\u672a\u80fd\u786e\u5b9a\u501f\u8d37\u6807\u5fd7[%1$s]\u6240\u5c5e\u7684\u7c7b\u578b,\u65e0\u6cd5\u8bbe\u7f6e\u91d1\u989d\u501f\u8d37\u65b9\u5411", (String)"HSBC_CMP_MT940_Handler_3", (String)"ebg-aqap-banks-hsbc-cmp", (Object[])new Object[0]), new Object[0]), (Object)creditOrDebit);
            }
            String custRef = field61.getComponent7() == null ? "" : field61.getComponent7().trim().toLowerCase();
            detail.setExtField1(custRef);
            String bankRef = field61.getComponent8AsString();
            logger.info("Field61:" + field61.toString());
            PaymentInfoRepository paymentInfoRepository = (PaymentInfoRepository)SpringContextUtil.getBean(PaymentInfoRepository.class);
            String batchId = "";
            try {
                List lists;
                PaymentInfo paymentInfo = paymentInfoRepository.findByBankDetailSeqID(custRef);
                if (paymentInfo != null) {
                    batchId = paymentInfo.getBankBatchSeqID();
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"HSBC_CMP_MT940_Handler_1", (String)"ebg-aqap-banks-hsbc-cmp", (Object[])new Object[0]), (String)"PAY_SUCCESS", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"HSBC_CMP_MT940_Handler_1", (String)"ebg-aqap-banks-hsbc-cmp", (Object[])new Object[0]));
                    payInfoList.add(paymentInfo);
                }
                String transType = field61.getComponent6();
                detail.setTransType(transType);
                if ("NCHK".equals(transType)) {
                    detail.setPayid(oppInfo);
                } else if ("NTRF".equals(transType)) {
                    if (custRef.toLowerCase(Locale.ENGLISH).startsWith("akd") && custRef.length() == 11) {
                        detail.setPayid(batchId);
                    } else if (custRef.toLowerCase(Locale.ENGLISH).startsWith("pkd") && custRef.length() == 11) {
                        String id = field61.getComponent8();
                        if (StringUtils.isEmpty((String)id)) {
                            detail.setPayid(batchId);
                        } else {
                            id = id.replace("//", "");
                            detail.setPayid(id);
                        }
                    } else if (custRef.length() == 8 && !CollectionUtil.isNotEmpty((Collection)(lists = paymentInfoRepository.findByBankBatchSeqID(custRef)))) {
                        EBGBusinessUtils.setPaymentState((List)lists, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"HSBC_CMP_MT940_Handler_1", (String)"ebg-aqap-banks-hsbc-cmp", (Object[])new Object[0]), (String)"PAY_SUCCESS", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"HSBC_CMP_MT940_Handler_1", (String)"ebg-aqap-banks-hsbc-cmp", (Object[])new Object[0]));
                        payInfoList.addAll(lists);
                        detail.setPayid(custRef);
                    }
                } else if ("NCHG".equals(transType)) {
                    if (custRef.length() == 8) {
                        lists = paymentInfoRepository.findByBankBatchSeqID(custRef);
                        if (!CollectionUtil.isEmpty((Collection)lists)) {
                            gatherMap.put(lists, field61.getComponent5());
                        }
                    } else {
                        map.put(custRef, field61.getComponent5());
                    }
                }
            }
            catch (Exception e) {
                logger.info(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u5e93\u4e2d\u7684\u4ed8\u6b3e\u6570\u636e\u5931\u8d25\uff0c\u65e0\u6cd5\u66f4\u65b0\u4ed8\u6b3e\u72b6\u6001%1$s\u3002", (String)"HSBC_CMP_MT940_Handler_4", (String)"ebg-aqap-banks-hsbc-cmp", (Object[])new Object[0]), new Object[0]), (Object)e);
            }
            Tag tag86 = SwiftTagsUtils.getTagBetween((List)tags, (String)"86", (int)aTag61Index, (int)(aTag61Index + 1));
            if (null != tag86) {
                this.deal86Tags(tag86, detail, fileName, currency, custRef);
            }
            detailInfoList.add(detail);
        }
    }

    private void deal86Tags(Tag tag86, OverseaDetail detail, String fileName, String currency, String custRef) {
        Field86 field86 = new Field86(tag86.getTagValue());
        logger.info("Field86:" + field86.toString());
        List field86List = field86.getComponents();
        String line1 = (String)field86List.get(0);
        if (line1 != null && line1.startsWith("/BENM/")) {
            this.parseField86Rjct(field86List, detail, fileName);
        } else {
            String line2 = (String)field86List.get(1);
            String line3 = (String)field86List.get(2);
            if (line2 != null && line2.startsWith("/BENM/")) {
                this.parseField86CHKPayment(field86List, detail);
            } else if (line2 != null && line2.startsWith("/ORDP/")) {
                this.parseField86Get(field86List, detail);
            } else if (line3 != null && "PAYMENT CHARGES".equalsIgnoreCase(line3)) {
                this.parseField86PaymentCharge(field86List, detail);
            } else if (line3 != null && line3.startsWith("/BENM/")) {
                this.parseField86Payment(field86List, detail);
            } else {
                this.parseField86Other(field86List, detail, currency);
            }
        }
        if (detail.getCordFlag().equals("CREDIT") && !fileName.contains("CN") && !"CNY".equalsIgnoreCase(currency)) {
            String name = null;
            for (String line : field86List) {
                if (StringUtils.isEmpty((String)line) || !line.contains("/ORDP/") || !(name = line.substring(line.indexOf("/ORDP/") + 6, line.length())).contains("/")) continue;
                name = name.substring(0, name.indexOf("/"));
            }
            if (name == null) {
                if (fileName.contains("SG") || fileName.contains("HK")) {
                    detail.setBenefitAccName(this.cut86((String)field86List.get(0)));
                } else if (fileName.contains("AU")) {
                    if ("NTRF".equals(detail.getTransType()) && "NONREF".equalsIgnoreCase(custRef)) {
                        detail.setBenefitAccName(this.cut86((String)field86List.get(1)));
                    } else {
                        detail.setBenefitAccName(((String)field86List.get(0)).replaceAll("\\d+", ""));
                    }
                }
            } else {
                detail.setBenefitAccName(name);
            }
        }
        if ("NONREF".equalsIgnoreCase(detail.getBenefitAccName())) {
            detail.setBenefitAccName("");
        }
    }

    private void dealCharge(List<OverseaDetail> list, Map<String, String> map) {
        for (Map.Entry<String, String> key : map.entrySet()) {
            for (OverseaDetail info : list) {
                if (!info.getExtField1().equals(key.getKey())) continue;
                info.setExtField3(key.getValue());
            }
        }
    }

    private void dealChargeGather(List<OverseaDetail> delist, Map<List<PaymentInfo>, String> map) {
        for (Map.Entry<List<PaymentInfo>, String> list : map.entrySet()) {
            for (OverseaDetail info : delist) {
                for (PaymentInfo gen : list.getKey()) {
                    if (!info.getExtField1().equals(gen.getBankDetailSeqID())) continue;
                    info.setExtField3(list.getValue());
                    return;
                }
            }
        }
    }

    private void parseField86Rjct(List<String> field86List, OverseaDetail detail, String fileName) {
        if (fileName.contains(".HK.")) {
            StringBuilder sb = new StringBuilder();
            for (String line : field86List) {
                if (StringUtils.isEmpty((String)line)) continue;
                sb.append(line).append("\n");
            }
            String exp = sb.toString();
            detail.setBenefitAccName(HsbcUtil.safelySubstring((String)field86List.get(0), (int)"/BENM/".length()));
            detail.setExplanation(exp);
            detail.setUseDesc(exp);
        } else {
            String curLine;
            int index = 0;
            String BENM = curLine = field86List.get(index);
            if ((curLine = field86List.get(++index)) != null && !curLine.startsWith("/RJCT/")) {
                BENM = BENM + curLine;
                ++index;
            }
            curLine = field86List.get(index);
            String RJCT = curLine.trim();
            if (!StringUtils.isEmpty((String)(curLine = field86List.get(++index)))) {
                RJCT = curLine.startsWith("/REMI/") ? curLine.trim() + "\uff0c" + RJCT : RJCT + curLine.trim();
            }
            if (!StringUtils.isEmpty((String)(curLine = field86List.get(++index))) && curLine.startsWith("/REMI/")) {
                RJCT = curLine.trim() + "\uff0c" + RJCT;
            }
            RJCT = RJCT.replace("/RJCT/", "").replace("/REMI/", "");
            detail.setCordFlag("CREDIT");
            detail.setBenefitAccName(HsbcUtil.safelySubstring((String)BENM, (int)"/BENM/".length()));
            detail.setExplanation(RJCT);
            detail.setUseDesc(RJCT);
        }
    }

    private void parseField86Other(List<String> field86List, OverseaDetail detail, String currency) {
        StringBuilder exp = new StringBuilder();
        for (int j = 0; j < field86List.size(); ++j) {
            String line = field86List.get(j);
            if (StringUtils.isEmpty((String)line)) continue;
            exp.append(line).append("\n");
            if (!line.startsWith("/BBK/")) continue;
            detail.setBenefitBankName(HsbcUtil.safelySubstring((String)line, (int)"/BBK/".length()));
        }
        detail.setExplanation(exp.toString().trim());
        detail.setUseDesc(exp.toString().trim());
        if (currency.equalsIgnoreCase("CNY")) {
            String line1 = field86List.get(0);
            if (!StringUtils.isEmpty((String)line1)) {
                detail.setBenefitAccName(line1);
            } else {
                detail.setBenefitAccName("");
            }
        }
    }

    private String cut86(String str) {
        int i;
        int start = 0;
        int end = str.length();
        for (i = 0; i < str.length(); ++i) {
            if (str.charAt(i) >= '0' && str.charAt(i) <= '9') continue;
            start = i;
            break;
        }
        for (i = start; i < str.length(); ++i) {
            if (str.charAt(i) < '0' || str.charAt(i) > '9') continue;
            end = i - 1;
            break;
        }
        if (end < 0) {
            return "";
        }
        return str.substring(start, end).trim();
    }

    private void parseField86CHKPayment(List<String> field86List, OverseaDetail detail) {
        String curLine;
        int index = 0;
        String REMI = curLine = field86List.get(index);
        String BENM = curLine = field86List.get(++index);
        if (!((curLine = field86List.get(++index)) == null || curLine.startsWith("/REMI/") || "NCHG".equals(detail.getTransType()) && curLine.startsWith("LOCAL"))) {
            BENM = BENM + curLine;
        }
        detail.setBenefitAccName(HsbcUtil.safelySubstring((String)BENM, (int)"/BENM/".length()));
        detail.setExplanation(REMI);
        detail.setUseDesc(REMI);
    }

    private void parseField86PaymentCharge(List<String> field86List, OverseaDetail detail) {
        String curLine;
        int index = 1;
        String AC = curLine = field86List.get(index);
        String REMI = curLine = field86List.get(++index);
        String BENM = curLine = field86List.get(++index);
        if (++index < field86List.size()) {
            curLine = field86List.get(index);
            BENM = BENM + curLine;
        }
        detail.setBenefitAccNo(HsbcUtil.safelySubstring((String)AC, (int)"/AC/".length()).trim());
        detail.setBenefitAccName(HsbcUtil.safelySubstring((String)BENM, (int)"/BENM/".length()));
        detail.setExplanation(REMI);
        detail.setUseDesc(REMI);
    }

    private void parseField86Get(List<String> field86List, OverseaDetail detail) {
        int index = 1;
        String curLine = field86List.get(index);
        String ORDP = curLine.trim();
        if (!((curLine = field86List.get(++index)) == null || curLine.startsWith("/REMI/") || "NCHG".equals(detail.getTransType()) && curLine.startsWith("LOCAL"))) {
            ORDP = ORDP + curLine.trim();
            ++index;
        }
        String REMI = curLine = field86List.get(index);
        if (++index < field86List.size() && !StringUtils.isEmpty((String)(curLine = field86List.get(index)))) {
            REMI = REMI + curLine;
        }
        detail.setBenefitAccName(HsbcUtil.safelySubstring((String)ORDP, (int)"/ORDP/".length()));
        if (!StringUtils.isEmpty((String)REMI) && REMI.startsWith("/REMI/")) {
            REMI = HsbcUtil.safelySubstring((String)REMI, (int)"/REMI/".length());
        }
        detail.setExplanation(REMI);
        detail.setUseDesc(REMI);
    }

    private void parseField86Payment(List<String> field86List, OverseaDetail detail) {
        String curLine;
        int index = 1;
        String AC = curLine = field86List.get(index);
        String BENM = curLine = field86List.get(++index);
        if (!((curLine = field86List.get(++index)) == null || curLine.startsWith("/REMI/") || "NCHG".equals(detail.getTransType()) && curLine.startsWith("LOCAL"))) {
            BENM = BENM + curLine;
            ++index;
        }
        String REMI = curLine = field86List.get(index);
        if (++index < field86List.size() && !StringUtils.isEmpty((String)(curLine = field86List.get(index)))) {
            REMI = REMI + curLine;
        }
        detail.setBenefitAccNo(HsbcUtil.safelySubstring((String)AC, (int)"/AC/".length()).trim());
        detail.setBenefitAccName(HsbcUtil.safelySubstring((String)BENM, (int)"/BENM/".length()));
        if (!StringUtils.isEmpty((String)REMI) && REMI.startsWith("/REMI/")) {
            REMI = HsbcUtil.safelySubstring((String)REMI, (int)"/REMI/".length());
        }
        detail.setExplanation(REMI);
        detail.setUseDesc(REMI);
    }

    private void calcBalance(List<OverseaDetail> detailList, BigDecimal currentValue, String accNo) {
        for (OverseaDetail info : detailList) {
            if (!info.getNumber().equals(accNo)) continue;
            BigDecimal txAmt = info.getTxAmt();
            currentValue = "CREDIT".equals(info.getCordFlag()) ? currentValue.add(txAmt) : currentValue.subtract(txAmt);
            info.setBalance(currentValue);
        }
    }
}

