/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.info;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.ebg.aqap.common.framework.frame.AtomicBizMeta;
import kd.ebg.aqap.common.framework.frame.Bank;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.frame.BankVersion;
import kd.ebg.aqap.common.framework.info.BankImplInfo;
import kd.ebg.aqap.common.framework.info.BankInfo;
import kd.ebg.aqap.common.framework.info.BankLoginInfo;
import kd.ebg.aqap.common.framework.info.BankVersionInfo;
import kd.ebg.aqap.common.framework.info.BizInfo;
import kd.ebg.aqap.common.framework.info.Info;
import kd.ebg.aqap.common.framework.info.InfoContributor;
import kd.ebg.aqap.common.framework.info.PropertyConfigInfo;
import kd.ebg.aqap.common.framework.info.PropertyConfigItemInfo;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfigType;
import kd.ebg.aqap.common.framework.properties.GlobalPropertyConfig;
import kd.ebg.aqap.common.framework.properties.PropertyConfig;
import kd.ebg.aqap.common.framework.properties.PropertyConfigItem;
import kd.ebg.egf.common.annotation.Autowired;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.bank.api.IBankServiceDesc;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;
import kd.ebg.egf.common.utils.collect.CollectionUtil;

@Component
public class FrameworkInfoContributor
implements InfoContributor {
    @Autowired
    private BankBundleManager bankBundleManager;
    @Autowired
    private GlobalPropertyConfig globalPropertyConfig;
    private List<BankInfo> infoBanks = new ArrayList<BankInfo>(16);
    private List<BankVersionInfo> infoBankVersions = new ArrayList<BankVersionInfo>(16);
    private List<BizInfo> infoBizs = new ArrayList<BizInfo>(16);
    private List<PropertyConfigInfo> infoPropertyConfigs = new ArrayList<PropertyConfigInfo>(16);
    private Map<String, List<BankLoginInfo>> infoBankLogins = Maps.newHashMapWithExpectedSize((int)16);
    private volatile boolean inited = false;

    @Override
    public void contribute(Info.Builder builder) {
        if (!this.inited) {
            this.initInfos();
        }
        builder.withDetail("banks", this.infoBanks);
        builder.withDetail("bankVersions", this.infoBankVersions);
        builder.withDetail("bizMetas", this.infoBizs);
        builder.withDetail("propertyConfigs", this.infoPropertyConfigs);
        builder.withDetail("bankLogins", this.infoBankLogins);
    }

    @Override
    public void contribute() {
        if (!this.inited) {
            this.initInfos();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initInfos() {
        EBContext context = new EBContext();
        try {
            EBContext.setContext((EBContext)context);
            if (!this.inited) {
                Collection banks = this.bankBundleManager.getBanks();
                Collection bankVersions = this.bankBundleManager.getBankVersions();
                List bizMetas = this.bankBundleManager.getBizMetas();
                List propertyConfigs = this.globalPropertyConfig.getPropertyConfigList();
                this.infoBanks = new ArrayList<BankInfo>(banks.size());
                this.infoBankVersions = new ArrayList<BankVersionInfo>(bankVersions.size());
                this.infoBizs = new ArrayList<BizInfo>(bizMetas.size());
                this.infoPropertyConfigs = new ArrayList<PropertyConfigInfo>(1);
                this.infoBankLogins = Maps.newHashMap();
                for (Bank bank : banks) {
                    BankInfo bankInfo = new BankInfo();
                    this.infoBanks.add(bankInfo);
                    bankInfo.setBankName(bank.getBankName());
                    bankInfo.setBankShortName(bank.getBankShortName());
                    bankInfo.setBankDescription(bank.getBankDescription());
                    bankInfo.setBankNameKeyWords(bank.getBankNameKeyWords());
                    List bankVersionList = bank.getBankVersions();
                    ArrayList<BankVersionInfo> tempBankVersionInfos = new ArrayList<BankVersionInfo>(bankVersionList.size());
                    bankInfo.setVersionInfos(tempBankVersionInfos);
                    for (BankVersion version : bankVersionList) {
                        BankLoginInfo loginInfo;
                        context.setBankVersionID(version.getBankVersionID());
                        BankVersionInfo info = new BankVersionInfo();
                        tempBankVersionInfos.add(info);
                        info.setBankVersionID(version.getBankVersionID());
                        info.setBankVersionName(version.getBankVersionName());
                        info.setBankName(version.getBankName());
                        info.setAvailable(version.isAvailable());
                        info.setVersion(version.getVersion());
                        info.setSortNum(version.getSortNum());
                        info.setConcurrentCount(version.getConcurrentCount());
                        List configs = version.getBankLoginConfigs();
                        List bankConfigs = version.getBankConfigs();
                        ArrayList<BankLoginInfo> loginInfos = new ArrayList<BankLoginInfo>(configs.size());
                        for (BankLoginConfig config : configs) {
                            loginInfo = new BankLoginInfo();
                            loginInfos.add(loginInfo);
                            loginInfo.setShowByFieldAndVal(config.getShowByFieldAndVal());
                            loginInfo.setBankConfigId(config.getKey().getBankConfigId());
                            loginInfo.setBankConfigName(config.getBankConfigName());
                            loginInfo.setMlBankConfigName(config.getMlBankConfigName());
                            loginInfo.setBankConfigValue(config.getBankConfigValue());
                            loginInfo.setNullable(config.getNullable().booleanValue());
                            loginInfo.setReadOnly(config.getReadOnly().booleanValue());
                            loginInfo.setInputType(config.getInputType());
                            loginInfo.setBankConfig(false);
                            loginInfo.setDesc(config.getDesc());
                            loginInfo.setMlDesc(config.getMlDesc());
                            loginInfo.setMlDescs(config.getMlDescs());
                            loginInfo.setType(config.getType());
                            loginInfo.setSourceValues(config.getSourceValues());
                            loginInfo.setSourceNames(config.getSourceNames());
                            loginInfo.setMlSourceNames(config.getMlSourceNames());
                            loginInfo.setMaxLength(Integer.valueOf(config.getMaxLength()));
                            loginInfo.setMinValueNum(config.getMinValueNum());
                            loginInfo.setMaxValueNum(config.getMaxValueNum());
                            if (config.getHidden() == null) {
                                loginInfo.setHidden(false);
                                continue;
                            }
                            loginInfo.setHidden(config.getHidden().booleanValue());
                        }
                        for (BankLoginConfig config : bankConfigs) {
                            loginInfo = new BankLoginInfo();
                            loginInfos.add(loginInfo);
                            loginInfo.setBankConfigId(config.getKey().getBankConfigId());
                            loginInfo.setBankConfigName(config.getBankConfigName());
                            loginInfo.setBankConfigValue(config.getBankConfigValue());
                            loginInfo.setNullable(true);
                            loginInfo.setReadOnly(false);
                            loginInfo.setInputType(config.getInputType());
                            loginInfo.setBankConfig(true);
                        }
                        info.setLogins(loginInfos);
                        this.infoBankLogins.put(info.getBankVersionID(), loginInfos);
                        PropertyConfig propertyConfig = version.getPropertyConfig();
                        PropertyConfigInfo infoPropertyConfig = new PropertyConfigInfo();
                        info.setPropertyConfigInfo(infoPropertyConfig);
                        infoPropertyConfig.setPropertyConfigID(propertyConfig.getPropertyConfigID());
                        infoPropertyConfig.setConfigName(propertyConfig.getConfigName());
                        infoPropertyConfig.setPropertyName(propertyConfig.getPropertyName().name());
                        infoPropertyConfig.setConfigDesc(propertyConfig.getConfigDesc());
                        List configItems = propertyConfig.getAllPropertyConfigItems();
                        ArrayList<PropertyConfigItemInfo> itemInfos = new ArrayList<PropertyConfigItemInfo>(configItems.size());
                        infoPropertyConfig.setConfigItems(itemInfos);
                        for (PropertyConfigItem item : configItems) {
                            PropertyConfigItemInfo itemInfo = new PropertyConfigItemInfo();
                            itemInfos.add(itemInfo);
                            itemInfo.setKey(item.getKey());
                            itemInfo.setName(item.getName());
                            itemInfo.setMlName(item.getMlName());
                            itemInfo.setDesc(item.getDesc());
                            itemInfo.setMlDesc(item.getMlDesc());
                            itemInfo.setMinValueNum(item.getMinValueNum());
                            itemInfo.setMaxValueNum(item.getMaxValueNum());
                            itemInfo.setSourceNames(item.getSourceNames());
                            itemInfo.setMlSourceNames(item.getMlSourceNames());
                            itemInfo.setSourceValues(item.getSourceValues());
                            itemInfo.setDefaultValues(item.getDefaultValues());
                            itemInfo.setReadonly(item.isReadonly());
                            itemInfo.setAccNo(item.isAccNo());
                            itemInfo.setHide(item.isHide());
                            itemInfo.setType(item.getType());
                            itemInfo.setMustInput(item.isMustInput());
                            itemInfo.setInputType(item.getInputType());
                            itemInfo.setShowByFieldAndVal(item.getShowByFieldAndVal());
                        }
                        this.infoPropertyConfigs.add(infoPropertyConfig);
                        ArrayList<BizInfo> infoBizs = new ArrayList<BizInfo>(1);
                        info.setInfoBizs(infoBizs);
                        boolean isSupportPay = false;
                        Map implMaps = version.getImplMap();
                        for (Map.Entry entry : implMaps.entrySet()) {
                            AtomicBizMeta atomicBizMeta;
                            Class bizInterfaceClass = (Class)entry.getKey();
                            String interFaceClassName = bizInterfaceClass.getName();
                            List implClasses = (List)entry.getValue();
                            if ("kd.ebg.aqap.business.payment.atomic.IPay".equals(interFaceClassName) && CollectionUtil.isNotEmpty((Collection)implClasses)) {
                                isSupportPay = true;
                            }
                            if (!Objects.nonNull(atomicBizMeta = this.getBizMeta(bizMetas, bizInterfaceClass))) continue;
                            BizInfo bizInfo = new BizInfo();
                            infoBizs.add(bizInfo);
                            bizInfo.setBizInterfaceClassName(atomicBizMeta.getBizInterface().getName());
                            bizInfo.setBizName(atomicBizMeta.getBizName());
                            bizInfo.setSubBizName(atomicBizMeta.getSubBizName());
                            bizInfo.setBizDesc(atomicBizMeta.getBizDesc());
                            ArrayList<BankImplInfo> infoBankImpls = new ArrayList<BankImplInfo>(implClasses.size());
                            bizInfo.setBankImpls(infoBankImpls);
                            for (Class implClass : implClasses) {
                                BankImplInfo bankImplInfo = new BankImplInfo();
                                infoBankImpls.add(bankImplInfo);
                                IBankService bankService = this.bankBundleManager.getImpl(implClass);
                                bankImplInfo.setClassName(implClass.getName());
                                bankImplInfo.setBizCode(bankService.getBizCode());
                                bankImplInfo.setBizDesc(bankService.getBizDesc());
                                bankImplInfo.setDeveloper(bankService.getDeveloper());
                            }
                        }
                        if (isSupportPay) continue;
                        List filterResult = infoPropertyConfig.getConfigItems().stream().filter(p -> !BankPropertyConfigType.PAY_BIZ_PARAM.getName().equals(p.getType()) && !BankPropertyConfigType.PAY_FOR_SALARY_PARAM.getName().equals(p.getType())).collect(Collectors.toList());
                        infoPropertyConfig.setConfigItems(filterResult);
                    }
                    this.infoBankVersions.addAll(tempBankVersionInfos);
                }
                for (AtomicBizMeta meta : bizMetas) {
                    BizInfo bizInfo = new BizInfo();
                    this.infoBizs.add(bizInfo);
                    bizInfo.setBizInterfaceClassName(meta.getBizInterface().getName());
                    bizInfo.setBizName(meta.getBizName());
                    bizInfo.setSubBizName(meta.getSubBizName());
                    bizInfo.setBizDesc(meta.getBizDesc());
                }
                for (PropertyConfig propertyConfig : propertyConfigs) {
                    PropertyConfigInfo infoPropertyConfig = new PropertyConfigInfo();
                    infoPropertyConfig.setPropertyConfigID(propertyConfig.getPropertyConfigID());
                    infoPropertyConfig.setConfigName(propertyConfig.getConfigName());
                    infoPropertyConfig.setPropertyName(propertyConfig.getPropertyName().name());
                    infoPropertyConfig.setConfigDesc(propertyConfig.getConfigDesc());
                    List configItems = propertyConfig.getAllPropertyConfigItems();
                    ArrayList<PropertyConfigItemInfo> itemInfos = new ArrayList<PropertyConfigItemInfo>(configItems.size());
                    infoPropertyConfig.setConfigItems(itemInfos);
                    for (PropertyConfigItem item : configItems) {
                        PropertyConfigItemInfo itemInfo = new PropertyConfigItemInfo();
                        itemInfos.add(itemInfo);
                        itemInfo.setKey(item.getKey());
                        itemInfo.setName(item.getName());
                        itemInfo.setMlName(item.getMlName());
                        itemInfo.setDesc(item.getDesc());
                        itemInfo.setMlDesc(item.getMlDesc());
                        itemInfo.setMinValueNum(item.getMinValueNum());
                        itemInfo.setMaxValueNum(item.getMaxValueNum());
                        itemInfo.setSourceNames(item.getSourceNames());
                        itemInfo.setMlSourceNames(item.getMlSourceNames());
                        itemInfo.setSourceValues(item.getSourceValues());
                        itemInfo.setDefaultValues(item.getDefaultValues());
                        itemInfo.setReadonly(item.isReadonly());
                        itemInfo.setAccNo(item.isAccNo());
                        itemInfo.setHide(item.isHide());
                        itemInfo.setType(item.getType());
                        itemInfo.setMustInput(item.isMustInput());
                        itemInfo.setInputType(item.getInputType());
                        itemInfo.setShowByFieldAndVal(item.getShowByFieldAndVal());
                    }
                    this.infoPropertyConfigs.add(infoPropertyConfig);
                }
                this.inited = true;
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            EBContext.destroy();
        }
    }

    private AtomicBizMeta getBizMeta(Collection<AtomicBizMeta> metas, Class<? extends IBankServiceDesc> bizInterfaceClass) {
        for (AtomicBizMeta meta : metas) {
            if (!meta.getBizInterface().equals(bizInterfaceClass)) continue;
            return meta;
        }
        return null;
    }

    public List<BankInfo> getInfoBanks() {
        return this.infoBanks;
    }

    public List<BankVersionInfo> getInfoBankVersions() {
        return this.infoBankVersions;
    }

    public List<BizInfo> getInfoBizs() {
        return this.infoBizs;
    }

    public List<PropertyConfigInfo> getInfoPropertyConfigs() {
        return this.infoPropertyConfigs;
    }

    public Map<String, List<BankLoginInfo>> getInfoBankLogins() {
        return this.infoBankLogins;
    }
}

