/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.utils.DTFactoryUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;

@Component
public class SecondDetailInfoRepository {
    private String DETAILINFO_ENTITY = "aqap_second_detailinfo";

    public void saveAll(List<DetailInfo> detailInfos) {
        if (detailInfos != null && detailInfos.size() > 0) {
            DynamicObject[] dynamicObjects = new DynamicObject[detailInfos.size()];
            for (int i = 0; i < detailInfos.size(); ++i) {
                DetailInfo detailInfo = detailInfos.get(i);
                dynamicObjects[i] = this.packDetailInfo(null, detailInfo);
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
    }

    public boolean exitsByBankLoginIdAndCreateDateAndTransDateBetween(String bankLoginID, Integer createDate, LocalDate startDate, LocalDate endDate) {
        return QueryServiceHelper.exists((String)this.DETAILINFO_ENTITY, (QFilter[])QFilter.of((String)"bank_login_id = ? and create_date = ? and trans_date>=? and trans_date<=?", (Object[])new Object[]{bankLoginID, createDate, startDate, endDate}).toArray());
    }

    public void deleteByBankLoginIdAndCreateDateAndAccNoNotIn(String bankLoginID, Integer createDate, LocalDate startDate, LocalDate endDate, List<String> accNos) {
        QFilter[] qFilters = new QFilter[]{QFilter.of((String)"bank_login_id = ? and create_date = ? and trans_date>=? and trans_date<=?", (Object[])new Object[]{bankLoginID, createDate, startDate, endDate}), new QFilter("acc_no", "not in", accNos)};
        DeleteServiceHelper.delete((String)this.DETAILINFO_ENTITY, (QFilter[])qFilters);
    }

    private DynamicObject packDetailInfo(DynamicObject dynamicObject, DetailInfo info) {
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.DETAILINFO_ENTITY);
        }
        dynamicObject.set("acc_name", (Object)info.getAccName());
        dynamicObject.set("acc_no", (Object)info.getAccNo());
        dynamicObject.set("acc_type", (Object)info.getAccType());
        dynamicObject.set("agent_acc_bank_name", (Object)info.getAgentAccBankName());
        dynamicObject.set("agent_acc_name", (Object)info.getAgentAccName());
        dynamicObject.set("agent_acc_no", (Object)info.getAccNo());
        dynamicObject.set("available_balance", (Object)info.getAvailableBalance());
        dynamicObject.set("balance", (Object)info.getBalance());
        dynamicObject.set("bank_login_id", (Object)info.getBankLoginID());
        dynamicObject.set("bank_name", (Object)info.getBankName());
        dynamicObject.set("bank_version_id", (Object)info.getBankVersionID());
        dynamicObject.set("biz_ref_no", (Object)info.getBizRefNo());
        dynamicObject.set("bus_type", (Object)info.getBusType());
        dynamicObject.set("credit_amount", (Object)info.getCreditAmount());
        dynamicObject.set("currency", (Object)info.getCurrency());
        dynamicObject.set("custom_id", (Object)info.getCustomID());
        dynamicObject.set("debit_amount", (Object)info.getDebitAmount());
        dynamicObject.set("explanation", (Object)info.getExplanation());
        dynamicObject.set("impl_class_name", (Object)info.getImplClassName());
        Date insertTime = Date.from(info.getInsertTime().atZone(ZoneId.systemDefault()).toInstant());
        dynamicObject.set("insert_time", (Object)insertTime);
        dynamicObject.set("kd_flag", (Object)info.getKdFlag());
        dynamicObject.set("opp_acc_name", (Object)info.getOppAccName());
        dynamicObject.set("opp_acc_no", (Object)info.getOppAccNo());
        dynamicObject.set("opp_bank_name", (Object)info.getOppBankName());
        dynamicObject.set("pay_detail_seq_id", (Object)info.getPayBankDetailSeqID());
        dynamicObject.set("receipt_no", (Object)info.getReceiptNo());
        dynamicObject.set("serial_no", (Object)info.getSerialNo());
        dynamicObject.set("sort_id", (Object)info.getSortID());
        dynamicObject.set("detail_id", (Object)info.getId());
        Date transDate = Date.from(info.getTransDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        dynamicObject.set("trans_date", (Object)transDate);
        Date transTime = Date.from(info.getTransTime().atZone(ZoneId.systemDefault()).toInstant());
        dynamicObject.set("trans_time", (Object)transTime);
        dynamicObject.set("trans_type", (Object)info.getTransType());
        dynamicObject.set("unique_seq", (Object)(StringUtils.isEmpty((String)info.getUniqueSeq()) ? info.getId() : info.getUniqueSeq()));
        dynamicObject.set("unique_version", (Object)info.getUniqueVersion());
        dynamicObject.set("bank_detail_no", (Object)info.getBankDetailNo());
        dynamicObject.set("enable", (Object)"1");
        Date updateTime = Date.from(info.getUpdateTime().atZone(ZoneId.systemDefault()).toInstant());
        dynamicObject.set("update_time", (Object)updateTime);
        dynamicObject.set("use_cn", (Object)info.getUseCN());
        dynamicObject.set("vouh_no", (Object)info.getVouhNo());
        dynamicObject.set("transfer_charge", (Object)info.getTransferCharge());
        Date date = new Date();
        long days = DateUtil.getDayDiff((Date)transDate, (Date)date);
        dynamicObject.set("reversed1", (Object)String.valueOf(days));
        dynamicObject.set("reversed2", (Object)info.getReversed2());
        dynamicObject.set("reversed3", (Object)info.getReversed3());
        dynamicObject.set("reversed4", (Object)info.getReversed4());
        dynamicObject.set("reversed_biz_field", (Object)info.getReversedBizField());
        dynamicObject.set("reversed_sys_field", (Object)info.getReversedSysField());
        dynamicObject.set("create_date", (Object)Long.parseLong(DateUtil.formatDate((Date)date, (String)"yyyyMMdd")));
        dynamicObject.set("sort_field", (Object)(StringUtils.isEmpty((String)info.getSortField()) ? info.getId() : info.getSortField()));
        dynamicObject.set("status", (Object)"A");
        return dynamicObject;
    }

    private DetailInfo transDetailInfo(DynamicObject dynamicObject) {
        String transTime;
        String customID = dynamicObject.getString("custom_id");
        String bankVersionID = dynamicObject.getString("bank_version_id");
        String currency = dynamicObject.getString("currency");
        DetailInfo detailInfo = new DetailInfo();
        detailInfo.setId(dynamicObject.getString("id"));
        detailInfo.setAccNo(dynamicObject.getString("acc_no"));
        detailInfo.setAccName(dynamicObject.getString("acc_name"));
        detailInfo.setAccType(dynamicObject.getString("acc_type"));
        detailInfo.setAgentAccBankName(dynamicObject.getString("agent_acc_bank_name"));
        detailInfo.setAgentAccName(dynamicObject.getString("agent_acc_name"));
        detailInfo.setAgentAccNo(dynamicObject.getString("agent_acc_no"));
        detailInfo.setAvailableBalance(dynamicObject.getBigDecimal("available_balance").setScale(2));
        detailInfo.setBalance(dynamicObject.getBigDecimal("balance").setScale(2));
        detailInfo.setBankLoginID(dynamicObject.getString("bank_login_id"));
        detailInfo.setBankName(dynamicObject.getString("bank_name"));
        detailInfo.setBankVersionID(dynamicObject.getString("bank_version_id"));
        detailInfo.setBizRefNo(dynamicObject.getString("biz_ref_no"));
        detailInfo.setBusType(dynamicObject.getString("bus_type"));
        detailInfo.setCreditAmount(dynamicObject.getBigDecimal("credit_amount").setScale(2));
        detailInfo.setISOCurrency(CurrencyUtils.checkAndGetISOCurrency((String)currency, (String)customID, (String)bankVersionID));
        detailInfo.setCustomID(dynamicObject.getString("custom_id"));
        detailInfo.setDebitAmount(dynamicObject.getBigDecimal("debit_amount").setScale(2));
        detailInfo.setExplanation(dynamicObject.getString("explanation"));
        detailInfo.setImplClassName(dynamicObject.getString("impl_class_name"));
        String insertTime = dynamicObject.getString("insert_time");
        if (StringUtils.isNotEmpty((String)insertTime)) {
            detailInfo.setInsertTime(DTFactoryUtil.parseDateTime((String)insertTime));
        }
        detailInfo.setHistory(Boolean.valueOf(false));
        detailInfo.setKdFlag(dynamicObject.getString("kd_flag"));
        detailInfo.setOppAccName(dynamicObject.getString("opp_acc_name"));
        detailInfo.setOppAccNo(dynamicObject.getString("opp_acc_no"));
        detailInfo.setOppBankName(dynamicObject.getString("opp_bank_name"));
        detailInfo.setPayBankDetailSeqID(dynamicObject.getString("pay_detail_seq_id"));
        detailInfo.setReceiptNo(dynamicObject.getString("receipt_no"));
        detailInfo.setSerialNo(Integer.valueOf(Integer.parseInt(dynamicObject.getString("serial_no"))));
        detailInfo.setSortID(dynamicObject.getString("sort_id"));
        String transDate = dynamicObject.getString("trans_date");
        if (StringUtils.isNotEmpty((String)transDate)) {
            detailInfo.setTransDate(DTFactoryUtil.parseDate((String)transDate));
        }
        if (StringUtils.isNotEmpty((String)(transTime = dynamicObject.getString("trans_time")))) {
            detailInfo.setTransTime(DTFactoryUtil.parseDateTime((String)transTime));
        }
        detailInfo.setTransType(dynamicObject.getString("trans_type"));
        detailInfo.setUniqueSeq(dynamicObject.getString("unique_seq"));
        detailInfo.setUniqueVersion(dynamicObject.getString("unique_version"));
        detailInfo.setBankDetailNo(dynamicObject.getString("bank_detail_no"));
        detailInfo.setIsKeyRepeat(Integer.valueOf(dynamicObject.getInt("is_key_repeat")));
        detailInfo.setIsConfirm(dynamicObject.getString("is_confirm"));
        detailInfo.setMatchNode(Integer.valueOf(dynamicObject.getInt("match_node")));
        String updateTime = dynamicObject.getString("update_time");
        if (StringUtils.isNotEmpty((String)updateTime)) {
            detailInfo.setUpdateTime(DTFactoryUtil.parseDateTime((String)updateTime));
        }
        detailInfo.setUseCN(dynamicObject.getString("use_cn"));
        detailInfo.setTransferCharge(dynamicObject.getBigDecimal("transfer_charge").setScale(2));
        detailInfo.setVouhNo(dynamicObject.getString("vouh_no"));
        detailInfo.setReversed1(dynamicObject.getString("reversed1"));
        detailInfo.setReversed2(dynamicObject.getString("reversed2"));
        detailInfo.setReversed3(dynamicObject.getString("reversed3"));
        detailInfo.setReversed4(dynamicObject.getString("reversed4"));
        detailInfo.setReversedBizField(dynamicObject.getString("reversed_biz_field"));
        detailInfo.setReversedSysField(dynamicObject.getString("reversed_sys_field"));
        detailInfo.setSortField(dynamicObject.getString("sort_field"));
        return detailInfo;
    }
}

