/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xmb.dc.service.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xmb.dc.Packer;
import kd.ebg.aqap.banks.xmb.dc.Parser;
import kd.ebg.aqap.banks.xmb.dc.service.detail.DetailPage;
import kd.ebg.aqap.banks.xmb.dc.service.loginout.LoginAndOut;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.commons.collections.CollectionUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String pack(BankDetailRequest rqst) {
        return this.packDetail(rqst);
    }

    private String packDetail(BankDetailRequest rqst) throws EBServiceException {
        Element XCCBEBankData = new Element("XCCBEBankData");
        Element opReq = JDomUtils.addChild((Element)XCCBEBankData, (String)"opReq");
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)EBContext.getContext().getBankRequestSeq());
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)DateUtil.formatDateTime((Date)new Date()));
        Element ReqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        JDomUtils.addChild((Element)ReqParam, (String)"accountNo", (String)rqst.getAcnt().getAccNo());
        JDomUtils.addChild((Element)ReqParam, (String)"beginDate", (String)rqst.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)ReqParam, (String)"endDate", (String)rqst.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)ReqParam, (String)"turnPageBeginPos", (String)this.getCurrentPage());
        JDomUtils.addChild((Element)ReqParam, (String)"turnPageShowNum", (String)"15");
        JDomUtils.addChild((Element)ReqParam, (String)"sortType", (String)"0");
        String xmlMessage = Packer.packFormatXmlMsg((Element)XCCBEBankData, (String)"GBK");
        String sessionId = LoginAndOut.getLoginAndOut().getLoginSessionId();
        return Packer.packAll((String)sessionId, (String)"CBE018", (String)xmlMessage);
    }

    public EBBankDetailResponse parse(BankDetailRequest rqs, String rspStr) {
        EBBankDetailResponse detailResponse = new EBBankDetailResponse();
        ArrayList<DetailInfo> totalList = new ArrayList<DetailInfo>(16);
        String pageTag = this.getCurrentPage();
        String pageTagNext = DetailPage.getNextPageTag(pageTag);
        this.setCurrentPage(pageTagNext);
        boolean lastPage = DetailPage.isLastPage(rspStr, pageTagNext);
        this.setLastPage(lastPage);
        String[] code = rspStr.split("\\|");
        if (code.length > 2) {
            if ("EBLN5001".equalsIgnoreCase(code[1]) || "EBLN9999".equalsIgnoreCase(code[1])) {
                detailResponse.setDetails(totalList);
                return detailResponse;
            }
        } else {
            detailResponse.setDetails(totalList);
            return detailResponse;
        }
        BankResponse response = Parser.parserHead((String)rspStr);
        if (!"0000".equalsIgnoreCase(response.getResponseCode())) {
            if ("EBCBE005".equalsIgnoreCase(response.getResponseCode())) {
                return detailResponse;
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25,\u54cd\u5e94\u4ee3\u7801\uff1a%1$s\u54cd\u5e94\u4fe1\u606f\uff1a%2$s", (String)"DetailImpl_4", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        Element root = Parser.getXmlRoot((String)rspStr);
        Element opRep = root.getChild("opRep");
        Element opResult = opRep.getChild("opResult");
        Element list = opResult.getChild("list");
        List rows = list.getChildren("row");
        if (CollectionUtils.isEmpty((Collection)rows)) {
            detailResponse.setDetails(totalList);
            return detailResponse;
        }
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        for (int i = 0; i < rows.size(); ++i) {
            Element row = (Element)rows.get(i);
            String BIZH = row.getChildTextTrim("ccy");
            String JDBZ = row.getChildTextTrim("flag");
            String PATI = row.getChildTextTrim("smyDsc");
            String JYJE = row.getChildTextTrim("txnAmt");
            String YUER = row.getChildTextTrim("acctBal");
            String JYRQ = row.getChildTextTrim("txnDt");
            String JYSJ = row.getChildTextTrim("txnTm");
            String DFZH = row.getChildTextTrim("oppCstAcctNo");
            String DFHM = row.getChildTextTrim("oppCstNm");
            String hostFlowNo = row.getChildTextTrim("hostFlowNo");
            DetailInfo detail = new DetailInfo();
            detail.setAccNo(rqs.getAcnt().getAccNo());
            detail.setAccName(rqs.getAcnt().getAccName());
            detail.setThirdBankName(hostFlowNo);
            detail.setOppAccNo(DFZH);
            detail.setOppAccName(DFHM);
            detail.setCurrency(BIZH);
            if ("0".equalsIgnoreCase(JDBZ)) {
                detail.setCreditAmount(new BigDecimal("0.00"));
                detail.setDebitAmount(BigDecimalHelper.add((String)"0.00", (String)JYJE));
            } else if ("1".equalsIgnoreCase(JDBZ)) {
                detail.setCreditAmount(BigDecimalHelper.add((String)"0.00", (String)JYJE));
                detail.setDebitAmount(new BigDecimal("0.00"));
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u4e86\u672a\u77e5\u7684\u501f\u8d37\u6807\u5fd7:%s\u3002", (String)"DetailImpl_5", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]), JDBZ));
            }
            detail.setBalance(BigDecimalHelper.add((String)"0.00", (String)YUER));
            detail.setExplanation(PATI);
            if (StringUtils.isEmpty((String)JYSJ)) {
                Date date = DateUtil.String2Date((String)(JYRQ + "000000"));
                detail.setTransTime(date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
            } else {
                int dastestr = JYSJ.length();
                int zeroLength = 9 - dastestr;
                for (int j = 0; j < zeroLength; ++j) {
                    JYSJ = "0" + JYSJ;
                }
                Date date = DateUtil.String2Date((String)(JYRQ + JYSJ));
                detail.setTransTime(date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
            }
            detail.setTransDate(LocalDate.parse(JYRQ, DateTimeFormatter.ofPattern("yyyyMMdd")));
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
            detail.setJsonMap(jsonStr);
            String accNo = rqs.getAcnt().getAccNo();
            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, JYRQ, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setReceiptNo(receiptNo);
            detail.setBankDetailNo(hostFlowNo);
            totalList.add(detail);
        }
        detailResponse.setDetails(totalList);
        return detailResponse;
    }

    public EBBankDetailResponse detail(BankDetailRequest request) {
        ArrayList detailInfos = new ArrayList(16);
        String pageTag = DetailPage.getFirstPageTag();
        this.setCurrentPage(pageTag);
        this.setLastPage(false);
        while (!this.isLastPage()) {
            EBBankDetailResponse ebBankDetailResponse = this.doBiz(request);
            if (ebBankDetailResponse == null || kd.bos.orm.util.CollectionUtils.isEmpty((Collection)ebBankDetailResponse.getDetails())) continue;
            detailInfos.addAll(ebBankDetailResponse.getDetails());
        }
        this.logger.info("detailInfos\u7684\u6570\u91cf{}", (Object)detailInfos.size());
        return new EBBankDetailResponse(detailInfos);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        return this.detail(request);
    }

    public String getBizCode() {
        return "XCCBEBankData";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_3", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]);
    }

    public String getDeveloper() {
        return "mukan_huang";
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/xml;charset=GBK");
    }
}

