/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.pab.dc.services.balance;

import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.pab.dc.services.PackerHelper;
import kd.ebg.aqap.banks.pab.dc.services.PageUtil;
import kd.ebg.aqap.banks.pab.dc.services.ParserHelper;
import kd.ebg.aqap.business.balancereconciliation.atomic.AbstractBalanceStatementImpl;
import kd.ebg.aqap.business.balancereconciliation.atomic.IBalanceStatement;
import kd.ebg.aqap.business.balancereconciliation.bank.BankBalanceStatementRequest;
import kd.ebg.aqap.business.balancereconciliation.bank.EBBankBalanceStatementResponse;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceStatementImpl
extends AbstractBalanceStatementImpl
implements IBalanceStatement {
    public int getMonthSpan() {
        return 1;
    }

    public String pack(BankBalanceStatementRequest bankBalanceStatementRequest) {
        Element Result = new Element("Result");
        JDomUtils.addChild((Element)Result, (String)"AcctNo", (String)bankBalanceStatementRequest.getAccNo());
        String startMonth = bankBalanceStatementRequest.getStartMonth();
        LocalDate localDate = LocalDateUtil.parserDate((String)(startMonth + "01"));
        LocalDate endDate = localDate.with(TemporalAdjusters.lastDayOfMonth());
        JDomUtils.addChild((Element)Result, (String)"QueryDate", (String)LocalDateUtil.formatDate((LocalDate)endDate));
        JDomUtils.addChild((Element)Result, (String)"PageNo", (String)"1");
        JDomUtils.addChild((Element)Result, (String)"PageSize", (String)"100");
        JDomUtils.addChild((Element)Result, (String)"CheckFlag", (String)"N");
        String xmlStr = JDomUtils.root2StringNoIndentLineNoSeparator((Element)Result, (String)RequestContextUtils.getCharset());
        return PackerHelper.createReqMsgWithHead((String)EBContext.getContext().getBankRequestSeq(), (String)"EDZ001", (String)xmlStr);
    }

    public EBBankBalanceStatementResponse parse(BankBalanceStatementRequest bankBalanceStatementRequest, String responseStr) {
        BankResponse bankRsp = new BankResponse();
        PageUtil pageUtil = ParserHelper.parseResponse((String)responseStr, (BankResponse)bankRsp);
        if (!"000000".equalsIgnoreCase(bankRsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"TodayBalanceImpl_6", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{bankRsp.getResponseCode(), bankRsp.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        ArrayList<BalanceReconciliationDetail> detailList = new ArrayList<BalanceReconciliationDetail>(5);
        Element root = JDomUtils.string2Root((String)pageUtil.getXmlStr(), (String)RequestContextUtils.getCharset());
        String endFlag = root.getChildText("EndFlag");
        List list = root.getChildren("list");
        for (Element element : list) {
            BalanceReconciliationDetail detail = new BalanceReconciliationDetail();
            String acctNo = element.getChildText("acctNo");
            String balanceDate = element.getChildText("balanceDate");
            String currency = element.getChildText("ccy");
            String balance = element.getChildText("balance");
            detail.setBalance(balance);
            detail.setAccNo(acctNo);
            detail.setCurrency(currency);
            detail.setMonth(balanceDate.substring(0, 6));
            detailList.add(detail);
        }
        return new EBBankBalanceStatementResponse(detailList);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "EDZ001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u5bf9\u8d26\u67e5\u8be2", (String)"BalanceStatementImpl_0", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceStatementRequest bankBalanceStatementRequest) {
        return true;
    }
}

