/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.payment.company;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.opa.service.payment.BusModUtil;
import kd.ebg.aqap.banks.cmb.opa.service.payment.PaymentUtil;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.entity.settleBankAccNo.SettleBankAccNoEntity;
import kd.ebg.aqap.common.model.repository.SettBankKeyWordsRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.service.properties.ObjectPropertyService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

class PayPacker {
    PayPacker() {
    }

    public String packPay(PaymentInfo[] paymentInfos) throws EBServiceException {
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u62db\u884c\u4f01\u94f6\u652f\u4ed8\u5355\u7b14\u7ecf\u529eBB1PAYOP\u4ec5\u652f\u6301\u5355\u7b14\u4ea4\u6613", (String)"PayPacker_0", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        }
        EBGLogger logger = EBGLogger.getInstance().getLogger(PayPacker.class);
        String busMod = BankBusinessConfig.getN02030Busmod(paymentInfos[0].getAccNo());
        if (StringUtils.isEmpty((String)busMod)) {
            logger.info("\u94f6\u4f01\u672a\u7ef4\u62a4\u4e1a\u52a1\u6a21\u5f0f\u7f16\u53f7\uff0c\u4ece\u94f6\u884c\u83b7\u53d6");
            busMod = BusModUtil.getBusMod((String)"N02030");
            String busModName = ResManager.loadKDString((String)"\u5355\u7b14\u652f\u4ed8\u4e1a\u52a1\u6a21\u5f0f\u7f16\u53f7", (String)"PayPacker_1", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]);
            if (StringUtils.isEmpty((String)busMod)) {
                throw EBExceiptionUtil.payFailException((String)String.format(ResManager.loadKDString((String)"%s\u4e3a\u7a7a\uff0c\u8bf7\u767b\u9646\u7f51\u94f6\u6216\u8005\u8054\u7cfb\u94f6\u884c\u5904\u7406\u3002", (String)"PayPacker_14", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), busModName));
            }
            if (busMod.contains(",")) {
                throw EBExceiptionUtil.payFailException((String)String.format(ResManager.loadKDString((String)"%1$s\u6709\u591a\u4e2a%2$s\uff0c\u8bf7\u4e8e\u8d26\u53f7\u9644\u52a0\u5c5e\u6027\u4e2d\u624b\u52a8\u914d\u7f6e\u552f\u4e00\u7684\u2018%3$s\u2019\u3002", (String)"PayPacker_15", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), busModName, busMod, busModName));
            }
            ObjectPropertyService objectPropertyService = (ObjectPropertyService)SpringContextUtil.getBean(ObjectPropertyService.class);
            objectPropertyService.saveAcntProperties("cmb_cmp_NTOPRLKP_busmod", busMod, paymentInfos[0].getAccNo());
        }
        JSONObject body = new JSONObject();
        JSONObject bb1paybmx1 = new JSONObject();
        bb1paybmx1.put("busMod", (Object)busMod);
        bb1paybmx1.put("busCod", (Object)"N02030");
        JSONArray array = new JSONArray();
        array.add((Object)bb1paybmx1);
        body.put("bb1paybmx1", (Object)array);
        JSONObject bb1payopx1 = new JSONObject();
        bb1payopx1.put("dbtAcc", (Object)paymentInfos[0].getAccNo());
        bb1payopx1.put("dmaNbr", (Object)(StringUtils.isEmpty((String)paymentInfos[0].getAgentAccNo()) ? "" : paymentInfos[0].getAgentAccNo()));
        bb1payopx1.put("crtAcc", (Object)paymentInfos[0].getIncomeAccNo());
        bb1payopx1.put("crtNam", (Object)paymentInfos[0].getIncomeAccName());
        SettleBankAccNoEntity settleBankAccNoEntity = this.getSettleBankEntityByBankName(paymentInfos[0].getIncomeBankName());
        if (settleBankAccNoEntity != null) {
            bb1payopx1.put("crtBnk", (Object)settleBankAccNoEntity.getBankKey());
        } else {
            bb1payopx1.put("crtBnk", (Object)paymentInfos[0].getIncomeBankName());
        }
        if (!paymentInfos[0].is2SameBank()) {
            bb1payopx1.put("crtAdr", (Object)paymentInfos[0].getIncomeBankAddress());
            bb1payopx1.put("brdNbr", (Object)(settleBankAccNoEntity == null ? paymentInfos[0].getIncomeCnaps() : settleBankAccNoEntity.getSettleAccno()));
        }
        bb1payopx1.put("ccyNbr", (Object)paymentInfos[0].getCurrency());
        bb1payopx1.put("trsAmt", (Object)paymentInfos[0].getAmount().toString());
        if (null != paymentInfos[0].getBookingTime() && paymentInfos[0].getBookingTime().isAfter(LocalDateTime.now())) {
            bb1payopx1.put("eptDat", (Object)paymentInfos[0].getBookingTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            kd.ebg.aqap.business.payment.utils.PaymentUtil.setBookPayFlag((PaymentInfo[])paymentInfos);
        }
        if (!paymentInfos[0].is2SameBank()) {
            bb1payopx1.put("bnkFlg", (Object)"N");
        } else {
            bb1payopx1.put("bnkFlg", (Object)"Y");
        }
        String routeChoose = BankBusinessConfig.getSingleRouteChoose();
        if ("GQ".equals(routeChoose)) {
            if (paymentInfos[0].is2Urgent()) {
                bb1payopx1.put("stlChn", (Object)"Q");
            } else {
                bb1payopx1.put("stlChn", (Object)"G");
            }
        } else {
            bb1payopx1.put("stlChn", (Object)routeChoose);
        }
        if (StringUtils.isEmpty((String)paymentInfos[0].getExplanation())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6458\u8981\u4e0d\u80fd\u4e3a\u7a7a", (String)"PayPacker_5", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        }
        bb1payopx1.put("nusAge", (Object)paymentInfos[0].getExplanation());
        if (StringUtils.isNotEmpty((String)paymentInfos[0].getAbstractMsg()) && "abstract".equalsIgnoreCase(BankBusinessConfig.getAbstractRule())) {
            bb1payopx1.put("busNar", (Object)paymentInfos[0].getAbstractMsg());
        }
        bb1payopx1.put("yurRef", (Object)PaymentUtil.getBankDetailSeqId((PaymentInfo)paymentInfos[0]));
        JSONArray array2 = new JSONArray();
        array2.add((Object)bb1payopx1);
        body.put("bb1payopx1", (Object)array2);
        String bizCode = "BB1PAYOP";
        JSONObject head = JsonUtil.getHead((String)bizCode, (String)Sequence.genSequence());
        JSONObject request = JsonUtil.getrequest((JSONObject)head, (JSONObject)body);
        return MsgPacker.getSendMsg((JSONObject)request, (EBGLogger)logger, (String)bizCode);
    }

    private SettleBankAccNoEntity getSettleBankEntityByBankName(String bankName) {
        SettleBankAccNoEntity entity;
        String routeChoose = BankBusinessConfig.getSingleRouteChoose();
        if (!"GQ".equals(routeChoose) && StringUtils.isNotEmpty((String)bankName) && (entity = this.getSettleBankEntity(bankName)) != null) {
            return entity;
        }
        return null;
    }

    private SettleBankAccNoEntity getSettleBankEntity(String bankName) {
        SettBankKeyWordsRepository settBankKeyWordsRepository = (SettBankKeyWordsRepository)SpringContextUtil.getBean(SettBankKeyWordsRepository.class);
        return settBankKeyWordsRepository.matchByKey(bankName);
    }
}

