/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsurb.dc.services.balance;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsurb.dc.services.utils.SignUtils;
import kd.ebg.aqap.banks.hsurb.dc.services.utils.TPacker;
import kd.ebg.aqap.banks.hsurb.dc.services.utils.TParser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"HttpUri"));
        factory.setHttpHeader("content-type", "text/xml; charset=" + RequestContextUtils.getCharset());
    }

    public String pack(BankBalanceRequest req) {
        BankAcnt acnt = req.getAcnt();
        String acntNo = acnt.getAccNo();
        String req_no = RequestContextUtils.getRequestContext().getBankRequestSeq();
        String cid = RequestContextUtils.getBankParameterValue((String)"CustomerId");
        String branchId = RequestContextUtils.getBankParameterValue((String)"BranchId");
        String d = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        String tr_code = "CBE002";
        Element QLBankData = TPacker.createCommonHead((String)tr_code, (String)cid, (String)req_no, (String)d);
        Element opReq = QLBankData.getChild("opReq");
        Element ReqParam = opReq.getChild("ReqParam");
        JDomUtils.addChild((Element)ReqParam, (String)"accountNo", (String)acntNo);
        JDomUtils.addChild((Element)ReqParam, (String)"currencyType", (String)req.getBankCurrency());
        JDomUtils.addChild((Element)ReqParam, (String)"branchId", (String)branchId);
        String str = cid + "|" + acntNo + "|" + branchId;
        JDomUtils.addChild((Element)ReqParam, (String)"signDataStr", (String)str);
        if (!"1000".equals(RequestContextUtils.getBankParameterValue((String)"signPort"))) {
            String signData = SignUtils.sign((String)str);
            JDomUtils.addChild((Element)ReqParam, (String)"signData", (String)signData);
        }
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringNoIndentLineNoSeparator((Element)QLBankData, (String)encoding);
        String msg = tr_code + "|#" + xmlMsg;
        return msg;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest req, String s) {
        String encoding = RequestContextUtils.getCharset();
        String xml = TParser.parseRsp((String)s, (String)encoding);
        Element QLBankData = JDomUtils.string2Root((String)xml, (String)encoding);
        Element opResult = QLBankData.getChild("opRep").getChild("opResult");
        if (opResult == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\uff1aopResult\u4e3a\u7a7a\u3002", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]));
        }
        String errorCode = opResult.getChildTextTrim("errorCode");
        String errorMessage = opResult.getChildTextTrim("errorMessage");
        String acno = opResult.getChildTextTrim("accountNo");
        if (StringUtils.isNotEmpty((String)errorCode) && !"000000".equals(errorCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\uff1aerrorCode = %1$s , errorMessage = %2$s", (String)"BalanceImpl_5", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]), errorCode, errorMessage));
        }
        if (!acno.equalsIgnoreCase(req.getAcnt().getAccNo())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff0c\u8d26\u6237\u4e0d\u4e00\u81f4\uff0c\u67e5\u8be2\u8d26\u53f7\uff1a %1$s, \u8fd4\u56de\u8d26\u53f7\uff1a %2$s", (String)"BalanceImpl_6", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]), req.getAcnt().getAccNo(), acno));
        }
        String cur_code = opResult.getChildTextTrim("currencyTyp");
        String balance = opResult.getChildTextTrim("balance");
        String use_balance = opResult.getChildTextTrim("balanceAvailable");
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(req.getAcnt());
        balanceInfo.setBankCurrency(cur_code);
        if (StringUtils.isEmpty((String)balance)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u5f53\u65e5\u4f59\u989d\u4e3a\u7a7a\uff0c\u67e5\u8be2\u5931\u8d25", (String)"BalanceImpl_7", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]));
        }
        balanceInfo.setCurrentBalance(new BigDecimal(balance));
        if (!StringUtils.isEmpty((String)use_balance)) {
            balanceInfo.setAvailableBalance(new BigDecimal(use_balance));
        }
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CBE002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u4f59\u989d (CBE002)", (String)"BalanceImpl_4", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]);
    }
}

