/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsurb.dc.services.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsurb.dc.services.utils.SignUtils;
import kd.ebg.aqap.banks.hsurb.dc.services.utils.TPacker;
import kd.ebg.aqap.banks.hsurb.dc.services.utils.TParser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"HttpUri"));
        factory.setHttpHeader("content-type", "text/xml; charset=" + RequestContextUtils.getCharset());
    }

    public String pack(BankDetailRequest req) {
        BankAcnt acnt = req.getAcnt();
        String acntNo = acnt.getAccNo();
        String req_no = RequestContextUtils.getRequestContext().getBankRequestSeq();
        String tr_code = "CBE006";
        String cid = RequestContextUtils.getBankParameterValue((String)"CustomerId");
        String branchId = RequestContextUtils.getBankParameterValue((String)"BranchId");
        String d = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        Element QLBankData = TPacker.createCommonHead((String)tr_code, (String)cid, (String)req_no, (String)d);
        Element opReq = QLBankData.getChild("opReq");
        Element ReqParam = opReq.getChild("ReqParam");
        String currency = req.getBankCurrency();
        String beginDate = req.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String endDate = req.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)ReqParam, (String)"accountNo", (String)acntNo);
        JDomUtils.addChild((Element)ReqParam, (String)"currencyType", (String)req.getBankCurrency());
        JDomUtils.addChild((Element)ReqParam, (String)"beginDate", (String)beginDate);
        JDomUtils.addChild((Element)ReqParam, (String)"endDate", (String)endDate);
        int pageTag = Integer.parseInt(this.getCurrentPage());
        JDomUtils.addChild((Element)ReqParam, (String)"turnPageBgnPos", (String)(1 + pageTag * 20 + ""));
        JDomUtils.addChild((Element)ReqParam, (String)"turnPageShowQnt", (String)"20");
        JDomUtils.addChild((Element)ReqParam, (String)"branchId", (String)branchId);
        String str = acntNo + "|" + currency + "|" + beginDate + "|" + endDate;
        JDomUtils.addChild((Element)ReqParam, (String)"signDataStr", (String)str);
        String signData = SignUtils.sign((String)str);
        JDomUtils.addChild((Element)ReqParam, (String)"signData", (String)signData);
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringNoIndentLineNoSeparator((Element)QLBankData, (String)encoding);
        return tr_code + "|#" + xmlMsg;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        this.setLastPage(true);
        EBBankDetailResponse ebBankDetailResponse = new EBBankDetailResponse();
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(3);
        String encoding = RequestContextUtils.getCharset();
        String xml = TParser.parseRsp((String)s, (String)encoding);
        Element QLBankData = JDomUtils.string2Root((String)xml, (String)encoding);
        Element opRep = QLBankData.getChild("opRep");
        Element opResult = opRep.getChild("opResult");
        if (opResult == null) {
            ebBankDetailResponse.setDetails(details);
            return ebBankDetailResponse;
        }
        Element list = opResult.getChild("list");
        if (list == null) {
            ebBankDetailResponse.setDetails(details);
            return ebBankDetailResponse;
        }
        List rows = list.getChildren("row");
        if (rows == null || rows.size() == 0) {
            ebBankDetailResponse.setDetails(details);
            return ebBankDetailResponse;
        }
        String turnPageTotalQnt = opRep.getChildTextTrim("turnPageTotalQnt");
        if (!StringUtils.isEmpty((String)turnPageTotalQnt)) {
            int currentPage;
            int total = Integer.parseInt(turnPageTotalQnt);
            this.setLastPage(total <= ((currentPage = Integer.parseInt(this.getCurrentPage())) + 1) * 20);
            this.setCurrentPage(currentPage + 1);
        }
        for (int i = 0; i < rows.size(); ++i) {
            DetailInfo detailInfo = new DetailInfo();
            Element row = (Element)rows.get(i);
            detailInfo.setCurrency(row.getChildTextTrim("currencyType"));
            detailInfo.setAccNo(bankDetailRequest.getAcnt().getAccNo());
            String loanFlag = row.getChildTextTrim("loanFlag");
            if ("D".equalsIgnoreCase(loanFlag)) {
                detailInfo.setCreditAmount(new BigDecimal("0.00"));
                detailInfo.setDebitAmount(new BigDecimal(row.getChildTextTrim("cadDebit")));
            }
            if ("C".equalsIgnoreCase(loanFlag)) {
                detailInfo.setCreditAmount(new BigDecimal(row.getChildTextTrim("cadCredit")));
                detailInfo.setDebitAmount(new BigDecimal("0.00"));
            }
            detailInfo.setBalance(new BigDecimal(row.getChildTextTrim("balance")));
            detailInfo.setExplanation(row.getChildTextTrim("remark"));
            String transferDate = row.getChildTextTrim("transferDate");
            LocalDate transDate = LocalDate.parse(transferDate, DateTimeFormatter.ofPattern("yyyyMMdd"));
            detailInfo.setTransDate(transDate);
            detailInfo.setTransTime(transDate.atTime(0, 0, 0));
            detailInfo.setOppAccNo(row.getChildTextTrim("oppositeAccount"));
            detailInfo.setOppAccName(row.getChildTextTrim("oppositeAccountName"));
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
            detailInfo.setJsonMap(jsonStr);
            detailInfo.setBankDetailNo(row.getChildTextTrim("hostSeqNb"));
            details.add(detailInfo);
        }
        ebBankDetailResponse.setDetails(details);
        return ebBankDetailResponse;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CBE006";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u660e\u7ec6(CBE006)", (String)"DetailImpl_1", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]);
    }

    public boolean isSupportPage() {
        return true;
    }
}

