/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.codeless.ParserUtil;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class XMLParseUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(XMLParseUtil.class);

    public static String getXmlAttrValue(String xml, String attrName) {
        if (null == xml || xml.equals("") || null == attrName || attrName.equals("")) {
            logger.error("parser error :" + xml + attrName);
            throw EBExceiptionUtil.serviceException((String)("parser error :" + xml + attrName));
        }
        String[] attrs = attrName.split("\\.");
        int length = attrs.length;
        String result = null;
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)xml);
        }
        catch (Exception e2) {
            logger.error("xml parser error ", new Object[]{e2.getMessage()});
            throw EBExceiptionUtil.serviceException((Throwable)e2);
        }
        Element element = document.getRootElement();
        List elements = Arrays.asList(element);
        for (int i = 0; i < length; ++i) {
            Map<String, Element> elementMap = elements.stream().collect(Collectors.toMap(e -> e.getName(), e -> e));
            if (elementMap.containsKey(attrs[i])) {
                if (i == length - 1) {
                    result = elementMap.get(attrs[i]).getText();
                    break;
                }
                elements = elementMap.get(attrs[i]).elements();
                continue;
            }
            logger.error("Node does not exist:" + attrName);
            result = "";
        }
        return result;
    }
}

