/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.bank.connect;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLHandshakeException;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.entity.base.EBHeader;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.connect.BankConnectResponse;
import kd.ebg.egf.common.framework.bank.connect.bean.BankLoginBean;
import kd.ebg.egf.common.framework.bank.connect.ping.PingConnectImpl;
import kd.ebg.egf.common.framework.bank.connect.ping.PingRequest;
import kd.ebg.egf.common.framework.bank.connect.ping.PingRequestBody;
import kd.ebg.egf.common.framework.bank.connect.ping.PingResponse;
import kd.ebg.egf.common.framework.biz.BizTypeEnum;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.framework.service.BankLoginConfigService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.model.bank.login.BankLoginConfigKVN;
import kd.ebg.egf.common.model.bank.login.BankLoginKey;
import kd.ebg.egf.common.model.proxy.BankLoginProxyConfig;
import kd.ebg.egf.common.repository.bank.config.BankLoginProxyConfigRepository;
import kd.ebg.egf.common.repository.bank.login.BankLoginRepository;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.net.NetUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class TestBankConnection {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(TestBankConnection.class);
    private static TestBankConnection instance = new TestBankConnection();
    private BankLoginConfigService bankLoginConfigService = BankLoginConfigService.getInstance();
    public static final int CONNECT_TIMEOUT_MS = 2000;

    public static TestBankConnection getInstance() {
        return instance;
    }

    public boolean isNeedPing(String bizType) {
        BizTypeEnum bizTypeEnum = BizTypeEnum.getBizTypeEnumByName((String)bizType);
        return bizTypeEnum.isPing();
    }

    private Map<String, String> parseUrl(String address) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        try {
            URL url = new URL(address);
            int port = url.getPort();
            if (port == -1) {
                port = url.getDefaultPort();
            }
            String ip = url.getHost();
            map.put("ip", ip);
            map.put("exchangePort", String.valueOf(port));
        }
        catch (MalformedURLException e) {
            logger.error(address + " is MalformedURL", (Throwable)e);
        }
        return map;
    }

    public BankConnectResponse test(String customID, String bankLoginID) {
        BankConnectResponse response;
        if (bankLoginID.startsWith("EBG_SIM")) {
            return BankConnectResponse.success();
        }
        Map<String, String> configMap = this.getBankLoginConfig(customID, bankLoginID);
        String ip = configMap.getOrDefault("ip", "");
        int port = -1;
        if (configMap.containsKey("exchangePort")) {
            try {
                port = Integer.parseInt(configMap.getOrDefault("exchangePort", "0"));
            }
            catch (NumberFormatException e) {
                port = 0;
                logger.error("BankLogin exchange port is not NumberFormat");
            }
        }
        if (StringUtils.isEmpty((String)ip)) {
            BankConnectResponse response2 = BankConnectResponse.fail();
            response2.setErrMsg(ResManager.loadKDString((String)"\u94f6\u884c\u8fde\u63a5\u901a\u9053IP\u5730\u5740\u914d\u7f6e\u4e3a\u7a7a\u3002", (String)"TestBankConnection_8", (String)"ebg-egf-common", (Object[])new Object[0]));
            return response2;
        }
        if (ip.startsWith("http")) {
            Map<String, String> domainUrlMap = this.parseUrl(ip);
            ip = domainUrlMap.get("ip");
            port = Integer.parseInt(domainUrlMap.get("exchangePort"));
        }
        if (port == 0) {
            response = BankConnectResponse.fail();
            response.setErrMsg(ResManager.loadKDString((String)"\u94f6\u884c\u8fde\u63a5\u901a\u9053\u7aef\u53e3\u53f7\u914d\u7f6e\u4e3a\u7a7a\u3002", (String)"TestBankConnection_9", (String)"ebg-egf-common", (Object[])new Object[0]));
            return response;
        }
        response = this.bankLoginConfigService.isProxy(customID, bankLoginID) ? this.tryProxyConnect(customID, bankLoginID, configMap) : this.tryConnect(ip, port);
        return response;
    }

    public Map<String, String> getBankLoginConfig(String customID, String bankLoginID) {
        HashMap<String, String> configMap = new HashMap<String, String>(16);
        List configKVNS = this.bankLoginConfigService.getBankLoginConfigKVNList(bankLoginID, customID);
        for (BankLoginConfigKVN configKVN : configKVNS) {
            configMap.put(configKVN.getBankConfigID(), configKVN.getBankConfigValue());
        }
        return configMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BankConnectResponse tryConnect(String ip, int port) {
        Socket aSocket = new Socket();
        String errMsg = "";
        String address = "";
        try {
            address = NetUtil.getLocalhostStr();
            if (port == -1) {
                errMsg = String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u94f6\u884c\u670d\u52a1 %2$s \u57df\u540d\u89e3\u6790\u7aef\u53e3\u53f7\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5IP\u5730\u5740\u662f\u5426\u4ee5http\u6216https\u5f00\u5934\u3002", (String)"TestBankConnection_11", (String)"ebg-egf-common", (Object[])new Object[0]), address, ip);
            } else {
                int connectionTimeout = IOUtils.getConnectionTimeout();
                InetSocketAddress inetSocketAddress = new InetSocketAddress(ip, port);
                aSocket.connect(inetSocketAddress, connectionTimeout);
            }
        }
        catch (UnknownHostException e) {
            errMsg = String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u94f6\u884c\u670d\u52a1 %2$s %3$s \u57df\u540d\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4e0a\u8ff0\u670d\u52a1\u53ca\u94f6\u884c\u670d\u52a1\u7f51\u7edc\u8bbf\u95ee\u6743\u9650\u3002", (String)"TestBankConnection_1", (String)"ebg-egf-common", (Object[])new Object[0]), address, ip, port);
        }
        catch (SocketTimeoutException e) {
            errMsg = String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u94f6\u884c\u670d\u52a1 %2$s %3$s \u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u4e0a\u8ff0\u670d\u52a1\u53ca\u94f6\u884c\u670d\u52a1\u7f51\u7edc\u8bbf\u95ee\u6743\u9650\u3002", (String)"TestBankConnection_2", (String)"ebg-egf-common", (Object[])new Object[0]), address, ip, port);
        }
        catch (ConnectException e) {
            errMsg = String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u94f6\u884c\u670d\u52a1 %2$s %3$s \u88ab\u62d2\u7edd\uff0c\u8bf7\u68c0\u67e5\u94f6\u884c\u670d\u52a1\u5730\u5740\u3001\u7aef\u53e3\u662f\u5426\u6b63\u786e\u53ca\u7f51\u7edc\u8bbf\u95ee\u6743\u9650\u3002", (String)"TestBankConnection_10", (String)"ebg-egf-common", (Object[])new Object[0]), address, ip, port);
        }
        catch (Exception e) {
            errMsg = String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u94f6\u884c\u670d\u52a1 %2$s %3$s \u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6392\u67e5\u3002", (String)"TestBankConnection_3", (String)"ebg-egf-common", (Object[])new Object[0]), address, ip, port);
        }
        finally {
            try {
                if (aSocket != null) {
                    aSocket.close();
                }
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
        }
        if (!StringUtils.isEmpty((String)errMsg)) {
            BankConnectResponse failResponse = BankConnectResponse.fail();
            failResponse.setState("cosmic_bank_error");
            failResponse.setErrMsg(errMsg);
            return failResponse;
        }
        return BankConnectResponse.success();
    }

    public BankConnectResponse tryProxyConnect(String customID, String bankLoginID, Map<String, String> configMap) {
        String pPort;
        BankLoginProxyConfig proxyConfig = BankLoginProxyConfigRepository.getInstance().findById(customID);
        String pIp = proxyConfig.getProxyHost();
        BankConnectResponse proxyResponse = this.tryConnect(pIp, Integer.parseInt(pPort = proxyConfig.getProxyPort()));
        if (!proxyResponse.isSuccess()) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u7f51\u7edc\u4ee3\u7406\u670d\u52a1\u7aef\u53e3\uff1a%1$s %2$s \u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u4ee3\u7406\u7aef\u53e3\u662f\u5426\u4e3a\u516c\u7f51\u53ef\u8bbf\u95ee\u7aef\u53e3\u3002", (String)"TestBankConnection_4", (String)"ebg-egf-common", (Object[])new Object[0]), pIp, pPort);
            BankConnectResponse failResponse = BankConnectResponse.fail();
            failResponse.setState("cosmic_proxy_error");
            failResponse.setErrMsg(errMsg);
            return failResponse;
        }
        PingRequest request = this.createRequest(customID, bankLoginID, configMap);
        PingResponse response = PingConnectImpl.getInstance().doBiz(request, "ping");
        String errorClass = "";
        String pingErrMsg = "";
        if (response.getException() == null) {
            return BankConnectResponse.success();
        }
        if (response.getException().getErrorClass() != null) {
            errorClass = response.getException().getErrorClass();
        }
        if (response.getException().getMessage() != null) {
            pingErrMsg = response.getException().getMessage();
        }
        BankConnectResponse failResponse = BankConnectResponse.fail();
        failResponse.setState("cosmic_proxy_error");
        String errMsg = IllegalStateException.class.getName().equalsIgnoreCase(errorClass) ? String.format(ResManager.loadKDString((String)"\u7f51\u7edc\u4ee3\u7406\u670d\u52a1\u7aef\u53e3\uff1a%1$s %2$s \u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u4ee3\u7406\u7aef\u53e3\u662f\u5426\u4e3a\u516c\u7f51\u53ef\u8bbf\u95ee\u7aef\u53e3\u3002", (String)"TestBankConnection_4", (String)"ebg-egf-common", (Object[])new Object[0]), pIp, pPort) : (SSLHandshakeException.class.getName().equalsIgnoreCase(errorClass) || IOException.class.getName().equalsIgnoreCase(errorClass) ? ResManager.loadKDString((String)"\u7f51\u7edc\u4ee3\u7406\u8bc1\u4e66\u4ea4\u4e92\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u4ee3\u7406\u914d\u7f6e\u7684\u79c1\u94a5/\u516c\u94a5\u8bc1\u4e66\u6587\u4ef6\u3001\u522b\u540d\u53ca\u5bc6\u7801\u4fe1\u606f\u662f\u5426\u6b63\u786e\u3002", (String)"TestBankConnection_5", (String)"ebg-egf-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8fde\u63a5\u7f51\u7edc\u4ee3\u7406\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6392\u67e5\u3002", (String)"TestBankConnection_7", (String)"ebg-egf-common", (Object[])new Object[0]));
        failResponse.setErrMsg(errMsg + pingErrMsg);
        return failResponse;
    }

    private PingRequest createRequest(String customID, String bankLoginID, Map<String, String> configMap) {
        PingRequest monitorRequest = new PingRequest();
        PingRequestBody body = new PingRequestBody();
        body.setBizType("ping");
        body.setSubType("ping");
        BankLoginKey key = new BankLoginKey();
        key.setCustomId(customID);
        key.setBankLoginId(bankLoginID);
        BankLogin bankLogin = BankLoginRepository.getInstance().findById(key);
        String bankVersion = bankLogin.getBankVersionId();
        String bankName = bankLogin.getBankName();
        String ip = configMap.getOrDefault("ip", "");
        String port = configMap.getOrDefault("exchangePort", "0");
        String data = JSONObject.toJSONString(this.getMonitorData(bankVersion, bankLoginID, bankName, ip, port));
        if (StringUtils.isEmpty((String)data)) {
            throw EBExceiptionUtil.serviceException((String)"");
        }
        body.setData(data);
        monitorRequest.setBody(body);
        EBHeader header = new EBHeader();
        header.setAccNo(null);
        header.setCustomId(customID);
        header.setBizType("ping");
        header.setSubBizType("ping");
        header.setClientName("EBG AQAP");
        header.setClientVersion("1.0");
        header.setCurrency("CNY");
        header.setRequestTime(System.currentTimeMillis());
        String bizSeqID = Sequence.gen18Sequence();
        JSONObject object = new JSONObject();
        object.put("loggerBatchNo", (Object)bizSeqID);
        object.put("loggerDetailNo", (Object)bizSeqID);
        object.put("loggerBankNo", (Object)bizSeqID);
        object.put("bankVersionID", (Object)bankVersion);
        object.put("bankLoginID", (Object)bankLoginID);
        header.setExtData(object.toString());
        monitorRequest.setHeader(header);
        return monitorRequest;
    }

    private List<BankLoginBean> getMonitorData(String bankVersionID, String bankLoginID, String bankName, String bankLoginIP, String bankLoginPort) {
        ArrayList<BankLoginBean> bankLoginList = new ArrayList<BankLoginBean>(1);
        if (StringUtils.isNotEmpty((String)bankLoginIP) && StringUtils.isNotEmpty((String)bankLoginPort)) {
            BankLoginBean bankLoginBean = new BankLoginBean();
            bankLoginBean.setIp(bankLoginIP);
            bankLoginBean.setPort(Integer.parseInt(bankLoginPort));
            bankLoginBean.setBankVersionId(bankVersionID);
            bankLoginBean.setBankLoginId(bankLoginID);
            bankLoginBean.setBankLoginName(bankName);
            bankLoginBean.setEmail("");
            bankLoginBean.setPhoneNum("");
            bankLoginList.add(bankLoginBean);
        }
        return bankLoginList;
    }
}

