/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.communication.protocol;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class HttpClient {
    private EBGLogger log = EBGLogger.getInstance().getLogger(HttpClient.class);
    private HttpURLConnection connection;
    private URL url;

    public HttpClient(String host, int port, String uri, Map<String, String> header, int timeout, String method) throws IOException {
        if (Strings.isNullOrEmpty((String)uri)) {
            uri = "";
        }
        int connectionTimeout = IOUtils.getConnectionTimeout();
        if ("GET".equals(method)) {
            this.url = new URL(host);
            this.connection = (HttpURLConnection)this.url.openConnection();
            this.connection.setDoInput(true);
            this.connection.setConnectTimeout(connectionTimeout);
            this.connection.setReadTimeout(timeout * 60 * 1000);
            if (Objects.nonNull(header)) {
                this.log.info("\u521b\u5efaGET\u8bf7\u6c42\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0cheader\u53c2\u6570\uff1a{}", new Object[]{host, header.toString()});
                header.forEach((key, value) -> this.connection.setRequestProperty((String)key, (String)value));
            }
            this.connection.setRequestMethod("GET");
            try {
                this.connection.connect();
            }
            catch (IOException e) {
                this.log.error("\u4e0e\u524d\u7f6e\u673a\u5efa\u7acbhttp\u8fde\u63a5\u5f02\u5e38\uff0c", (Throwable)e);
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0e\u524d\u7f6e\u673a\u5efa\u7acbhttp\u8fde\u63a5\u5f02\u5e38\uff0c%s", (String)"HttpClient_0", (String)"ebg-egf-common", (Object[])new Object[0]), host), (Throwable)e);
            }
            return;
        }
        this.url = new URL("http", host, port, uri);
        this.connection = (HttpURLConnection)this.url.openConnection();
        this.connection.setDoInput(true);
        if ("POST".equalsIgnoreCase(method)) {
            this.connection.setDoOutput(true);
        }
        this.connection.setConnectTimeout(connectionTimeout);
        this.connection.setReadTimeout(timeout * 60 * 1000);
        try {
            String reTimeOut = RequestContextUtils.getRunningParam((String)"timeout");
            if (StringUtils.isNotEmpty((String)reTimeOut)) {
                this.connection.setReadTimeout(Integer.parseInt(reTimeOut));
            }
        }
        catch (Exception e) {
            this.log.error("\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u8d85\u65f6\u65f6\u95f4\u5f02\u5e38", (Throwable)e);
        }
        if (Objects.nonNull(header)) {
            header.forEach((key, value) -> {
                this.connection.setRequestProperty((String)key, (String)value);
                this.log.info("http header: " + key + "=" + value);
            });
        }
        this.connection.setRequestMethod(method);
        try {
            this.connection.connect();
        }
        catch (IOException e) {
            throw new ConnectException(String.format(ResManager.loadKDString((String)"\u4e0e\u524d\u7f6e\u673a\u5efa\u7acbhttp\u8fde\u63a5\u5f02\u5e38\uff0c%s\u3002", (String)"HttpClient_0", (String)"ebg-egf-common", (Object[])new Object[0]), host + ":" + port));
        }
    }

    public HttpClient(String host, int port, String uri, Map<String, String> header, int timeout, String proxyHost, int proxyPort, String proxyUserName, String proxyCipherPd) throws IOException {
        if (Strings.isNullOrEmpty((String)uri)) {
            uri = "";
        }
        int connectionTimeout = IOUtils.getConnectionTimeout();
        this.url = new URL("http", host, port, uri);
        InetSocketAddress address = new InetSocketAddress(proxyHost, proxyPort);
        Proxy proxy = new Proxy(Proxy.Type.HTTP, address);
        String authentication = proxyUserName + ":" + proxyCipherPd;
        String encodedLogin = Base64.getEncoder().encodeToString(authentication.getBytes()).replaceAll("\n", "");
        this.connection = (HttpURLConnection)this.url.openConnection(proxy);
        this.connection.setDoOutput(true);
        this.connection.setDoInput(true);
        this.connection.setConnectTimeout(connectionTimeout);
        this.connection.setReadTimeout(timeout * 60 * 1000);
        if (Objects.nonNull(header)) {
            header.forEach((key, value) -> {
                this.connection.setRequestProperty((String)key, (String)value);
                this.log.info("http header: " + key + "=" + value);
            });
        }
        this.connection.setRequestMethod("POST");
        this.connection.setRequestProperty("Proxy-Authorization", "Basic " + encodedLogin);
        this.connection.connect();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.connection.getOutputStream();
    }

    public int getResponseCode() throws IOException {
        return this.connection.getResponseCode();
    }

    public InputStream getInputStream() throws IOException {
        return this.connection.getInputStream();
    }

    public void closeConnection() {
        this.connection.disconnect();
    }
}

