/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.lock;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import kd.bos.config.client.ConfigUrlType;
import kd.bos.config.client.util.ConfigUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.lock.DistributedAccessManager;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.redis.RedisAccessManager;
import kd.ebg.egf.common.framework.lock.redis.RedisFepAccess;
import kd.ebg.egf.common.utils.file.PropertiesUtils;
import kd.ebg.egf.common.utils.string.StrUtil;
import org.slf4j.MDC;

public class FEPAccessUtil {
    private static final String BASE_TIME = "2099-01-01 00:00:00.000";

    public static FEPAccess access(String bankVersionId, String bankLoginId) {
        if (EBContext.getContext().isUnitTest()) {
            return new RedisFepAccess("mock", 1);
        }
        MDC.put((String)"bussiness_type", (String)"bussiness_bank");
        String customId = EBContext.getContext().getCustomID();
        Object accessManager = ConfigUtils.getConfigUrlTypeEnum() == ConfigUrlType.zookeeper ? DistributedAccessManager.getInstance() : RedisAccessManager.getInstance();
        FEPAccess access = accessManager.getAccess(customId, bankVersionId, bankLoginId);
        access.lock();
        return access;
    }

    private static boolean isRemoveZookeeper() {
        String value = PropertiesUtils.getValue((String)"isRomveZK");
        return Boolean.parseBoolean(value);
    }

    public static void release(FEPAccess access) {
        try {
            MDC.put((String)"bussiness_type", (String)"bussiness_bank");
            if (Objects.nonNull(access)) {
                access.release();
            }
        }
        finally {
            MDC.put((String)"bussiness_type", (String)"bussiness_process");
        }
    }

    public static double getPriority(int integer) {
        LocalDateTime end = LocalDateTime.parse(BASE_TIME, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
        long difference = ChronoUnit.MILLIS.between(LocalDateTime.now(), end);
        return Double.parseDouble(integer + "." + difference);
    }

    public static boolean isPayRequest(String bizType) {
        return StrUtil.equals((String)"pay", (String)bizType) || StrUtil.equals((String)"overseaPay", (String)bizType);
    }

    private static double extractDecimal(double n) {
        String num = String.valueOf(n);
        String part = "0" + num.substring(num.indexOf("."));
        return Double.parseDouble(part);
    }
}

