/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.log;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.file.WriteFileUtil;
import kd.ebg.egf.common.framework.biz.BizTypeEnum;
import kd.ebg.egf.common.framework.frame.BusinessTypeUtil;
import kd.ebg.egf.common.log.BizLogType;
import kd.ebg.egf.common.log.LogFilterUtil;
import kd.ebg.egf.common.log.LogInfo;
import kd.ebg.egf.common.log.LogPrivacyUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.zip.StringCompressor;
import org.slf4j.MDC;

public class BaseLog {
    private Log logger;
    private String className;
    public static final String DEBUG = "DEBUG";
    public static final String INFO = "INFO";
    public static final String WARN = "WARN";
    public static final String ERROR = "ERROR";

    public String getCloudAppName() {
        return "";
    }

    public String getAppName() {
        return "";
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    private void init() {
        MDC.put((String)this.getCloudAppName(), (String)this.getAppName());
    }

    private boolean isAppStarting() {
        RequestContext context = RequestContext.get();
        if (context != null) {
            String accountId = context.getAccountId();
            return StringUtils.isEmpty((String)accountId);
        }
        return true;
    }

    public void monitorInfo(String msg) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(msg);
        }
    }

    public void monitorInfo(String msg, Object ... obj) {
        String logStr = this.format(msg, obj);
        if (this.logger.isInfoEnabled()) {
            this.init();
            this.logger.info(logStr);
        }
    }

    public void monitorError(String msg, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(msg, t);
            this.logger.error(EBExceiptionUtil.stackTraceString((StackTraceElement[])t.getStackTrace()));
        }
    }

    public void info(String msg) {
        if (this.logger.isInfoEnabled() && this.isAppStarting()) {
            this.logger.info(msg);
        }
        this.sendLogToMQ(msg, INFO);
    }

    public void info(String msg, Object obj) {
        String logStr = this.format(msg, obj);
        if (this.logger.isInfoEnabled() && this.isAppStarting()) {
            this.logger.info(logStr);
        }
        this.sendLogToMQ(logStr, INFO);
    }

    public void info(String msg, Object ... obj) {
        String logStr = this.format(msg, obj);
        if (this.logger.isInfoEnabled() && this.isAppStarting()) {
            this.init();
            this.logger.info(logStr);
        }
        this.sendLogToMQ(logStr, INFO);
    }

    public void debug(String msg) {
        if (this.logger.isInfoEnabled() && this.isAppStarting()) {
            this.logger.info(msg);
        }
        this.sendLogToMQ(msg, DEBUG);
    }

    public void debug(String msg, Object obj) {
        String logStr = this.format(msg, obj);
        if (this.logger.isInfoEnabled() && this.isAppStarting()) {
            this.logger.info(logStr);
        }
        this.sendLogToMQ(logStr, DEBUG);
    }

    public void debug(String msg, Object ... obj) {
        String logStr = this.format(msg, obj);
        if (this.logger.isInfoEnabled() && this.isAppStarting()) {
            this.init();
            this.logger.info(logStr);
        }
        this.sendLogToMQ(logStr, DEBUG);
    }

    public void warn(String msg) {
        if (this.logger.isWarnEnabled() && this.isAppStarting()) {
            this.logger.warn(msg);
        }
        this.sendLogToMQ(msg, WARN);
    }

    public void warn(String msg, Object ... obj) {
        String logStr = this.format(msg, obj);
        if (this.logger.isWarnEnabled() && this.isAppStarting()) {
            this.logger.warn(logStr);
        }
        this.sendLogToMQ(logStr, WARN);
    }

    public void error(String msg) {
        if (this.logger.isErrorEnabled() && this.isAppStarting()) {
            this.logger.error(msg);
        }
        this.sendLogToMQ(msg, ERROR);
    }

    public void error(String msg, Object ... obj) {
        String logStr = this.format(msg, obj);
        if (this.logger.isErrorEnabled() && this.isAppStarting()) {
            this.logger.error(logStr);
        }
        this.sendLogToMQ(logStr, ERROR);
    }

    public void error(String errorMsg, Throwable t) {
        int length;
        if (this.logger.isErrorEnabled() && this.isAppStarting()) {
            this.logger.error(errorMsg, t);
            this.logger.error(EBExceiptionUtil.stackTraceString((StackTraceElement[])t.getStackTrace()));
        }
        if (errorMsg == null) {
            errorMsg = "null";
        }
        if ((length = errorMsg.length()) > 100) {
            errorMsg = errorMsg.substring(0, 100) + "...";
        }
        EBContext context = EBContext.getContext();
        boolean isLog = false;
        if (context != null) {
            isLog = context.isLogErrorStack();
        }
        if (!isLog) {
            if (StringUtils.isNotEmpty((String)errorMsg)) {
                StringBuilder sb = new StringBuilder();
                sb.append("ERROR MSG\uff1a");
                sb.append(errorMsg);
                this.sendLogToMQ(sb.toString(), ERROR);
            }
            this.sendLogToMQ(this.getStackTraceString(t), ERROR);
            if (context != null) {
                context.setLogErrorStack(true);
            }
        }
    }

    private String getStackTraceString(Throwable t) {
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n").append(t.toString());
        sb.append("\r\n").append(EBExceiptionUtil.stackTraceString((StackTraceElement[])t.getStackTrace()));
        return sb.toString();
    }

    private Throwable getInnerCause(Throwable t) {
        Throwable innerCause = t.getCause();
        Throwable cause = null;
        if (innerCause != null) {
            while ((innerCause = (cause = innerCause).getCause()) != null) {
            }
        }
        if (cause == null) {
            return t;
        }
        return cause;
    }

    private String format(String msg, Object ... objs) {
        String result = String.copyValueOf(msg.toCharArray());
        try {
            for (Object obj : objs) {
                int index = result.indexOf("{}");
                if (index != -1) {
                    String tempStr1 = result.substring(0, index);
                    String tempStr2 = result.substring(index + 2);
                    result = tempStr1 + obj + tempStr2;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            return msg;
        }
        return result;
    }

    public void info(int logType, String msg, Object obj) {
        if (1 == logType) {
            this.infoRequest(msg, obj);
        } else if (2 == logType) {
            this.infoResponse(msg, obj);
        } else {
            this.info(msg, obj);
        }
    }

    public void infoRequest(String msg, Object obj) {
        MDC.put((String)"bussiness_type", (String)"bussiness_request");
        String logStr = this.format(msg, obj);
        if (this.logger.isInfoEnabled() && this.isAppStarting()) {
            this.logger.info(logStr);
        }
        this.sendLogToMQ(logStr, "bussiness_request");
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
    }

    public void infoRequest(String msg) {
        MDC.put((String)"bussiness_type", (String)"bussiness_request");
        if (this.logger.isInfoEnabled() && this.isAppStarting()) {
            this.logger.info(msg);
        }
        this.sendLogToMQ(msg, "bussiness_request");
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
    }

    public void infoResponse(String msg, Object obj) {
        MDC.put((String)"bussiness_type", (String)"bussiness_response");
        String logStr = this.format(msg, obj);
        if (this.logger.isInfoEnabled() && this.isAppStarting()) {
            this.logger.info(logStr);
        }
        this.sendLogToMQ(logStr, "bussiness_response");
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
    }

    public void infoResponse(String msg) {
        MDC.put((String)"bussiness_type", (String)"bussiness_response");
        if (this.logger.isInfoEnabled() && this.isAppStarting()) {
            this.logger.info(msg);
        }
        this.sendLogToMQ(msg, "bussiness_response");
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
    }

    public void infoProcess(String msg, Object ... obj) {
        String logStr = this.format(msg, obj);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        if (this.logger.isInfoEnabled() && this.isAppStarting()) {
            this.logger.info(logStr);
        }
        this.sendLogToMQ(logStr, INFO);
    }

    public void infoProcess(String msg) {
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        if (this.logger.isInfoEnabled() && this.isAppStarting()) {
            this.logger.info(msg);
        }
        this.sendLogToMQ(msg, INFO);
    }

    public void infoIndex(String msg) {
        MDC.put((String)"bussiness_type", (String)"bussiness_index");
        if (this.logger.isInfoEnabled() && this.isAppStarting()) {
            this.logger.info(msg);
        }
        this.sendLogToMQ(msg, "bussiness_index");
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
    }

    public void infoIndex(String msg, Object obj) {
        MDC.put((String)"bussiness_type", (String)"bussiness_index");
        String logStr = this.format(msg, obj);
        if (this.logger.isInfoEnabled() && this.isAppStarting()) {
            this.logger.info(logStr);
        }
        this.sendLogToMQ(logStr, "bussiness_index");
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
    }

    private void sendLogToMQ(String msg, String logLevel) {
        try {
            LogInfo logInfo = new LogInfo();
            logInfo.setBussiness_type(this.transFormat(MDC.get((String)"bussiness_type")));
            logInfo.setAccount(this.transFormat(MDC.get((String)"account")));
            logInfo.setBizName(this.transFormat(MDC.get((String)"bizName")));
            logInfo.setBankVersionID(this.transFormat(MDC.get((String)"bankVersionID")));
            logInfo.setBankLoginID(this.transFormat(MDC.get((String)"bankLoginID")));
            logInfo.setCustomerID(this.transFormat(MDC.get((String)"customerID")));
            logInfo.setCloudAppName(this.transFormat(MDC.get((String)"cloudAppName")));
            logInfo.setSubBizName(this.transFormat(MDC.get((String)"subBizName")));
            logInfo.setLogger_bank_no(this.transFormat(MDC.get((String)"logger_bank_no")));
            logInfo.setLogger_batch_no(this.transFormat(MDC.get((String)"logger_batch_no")));
            logInfo.setLogger_detail_no(this.transFormat(MDC.get((String)"logger_detail_no")));
            if (StringUtils.isNotEmpty((String)msg) && StringUtils.isNotEmpty((String)logInfo.getLogger_bank_no()) && StringUtils.isNotEmpty((String)logInfo.getLogger_batch_no()) && StringUtils.isNotEmpty((String)logInfo.getLogger_detail_no())) {
                logInfo.setMsg(this.getMsg(msg, this.className, logLevel));
                logInfo.setTime(System.currentTimeMillis());
                logInfo.setTraceID(RequestContext.get().getTraceId());
                String subBizName = MDC.get((String)"subBizName");
                String bizName = MDC.get((String)"bizName");
                this.recordLog(logInfo, bizName, logLevel);
            }
        }
        catch (Throwable t) {
            this.logger.error("Invoke sendLogToMQ() error", t);
        }
    }

    private void recordLog(LogInfo logInfo, String bizName, String logLevel) {
        if (DEBUG.equalsIgnoreCase(logLevel)) {
            boolean isDebugMode = Boolean.parseBoolean(System.getProperty("ebg.log.debug", "false"));
            if (isDebugMode) {
                this.recordLog(logInfo, bizName);
            }
        } else {
            this.recordLog(logInfo, bizName);
        }
    }

    private void recordLog(LogInfo logInfo, String bizName) {
        BizTypeEnum bizTypeEnum = BizTypeEnum.getBizTypeEnumByName((String)bizName);
        if (!bizTypeEnum.isNeedBizLog()) {
            if ("COSMIC-EBG".equalsIgnoreCase(MDC.get((String)"clientName"))) {
                this.recordLogInfo(logInfo);
            } else if (!"bussiness_bank".equalsIgnoreCase(logInfo.getBussiness_type()) && !"bussiness_response".equalsIgnoreCase(logInfo.getBussiness_type()) && bizTypeEnum != BizTypeEnum.DETAIL) {
                this.recordLogInfo(logInfo);
            }
        } else if (bizTypeEnum == BizTypeEnum.QUERY_PAY || bizTypeEnum == BizTypeEnum.QUERY_LINK_PAY) {
            if (this.isOpenQueryPayLog()) {
                this.recordLogInfo(logInfo);
            }
        } else if (!this.isAppStarting() && "receipt".equalsIgnoreCase(bizTypeEnum.getAppId())) {
            if (this.isPrintReceiptLogger()) {
                this.recordLogInfo(logInfo);
            }
        } else if (bizTypeEnum == BizTypeEnum.QUERY_NOTE_DETAIL) {
            if ("reply".equals(logInfo.getSubBizName())) {
                if (this.isOpenQueryReplyNoteDetailLog()) {
                    this.recordLogInfo(logInfo);
                }
            } else if ("hold".equals(logInfo.getSubBizName())) {
                if (this.isOpenHoldNoteDetailLog()) {
                    this.recordLogInfo(logInfo);
                }
            } else {
                this.recordLogInfo(logInfo);
            }
        } else {
            this.recordLogInfo(logInfo);
        }
    }

    private boolean getValueAsBoolean(String attrKey, boolean defaultValue) {
        boolean result = defaultValue;
        String selectFields = "attr_value";
        String objectId = "common_business";
        QFilter filter = QFilter.of((String)"object_id=?  and attr_key=?", (Object[])new Object[]{objectId, attrKey});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"aqap_object_properties", (String)selectFields, (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            result = "on".equalsIgnoreCase(dynamicObject.getString("attr_value")) || "true".equalsIgnoreCase(dynamicObject.getString("attr_value"));
        }
        return result;
    }

    private boolean isOpenQueryPayLog() {
        return this.getValueAsBoolean("OPEN_QUERY_PAY_LOG", true);
    }

    private boolean isOpenQueryReplyNoteDetailLog() {
        return this.getValueAsBoolean("OPEN_QUERY_PNOTE_DETAIL_LOG", true);
    }

    private boolean isOpenHoldNoteDetailLog() {
        return this.getValueAsBoolean("OPEN_QUERY_PNOTE_DETAIL_HOLD_LOG", true);
    }

    private boolean isPrintReceiptLogger() {
        return this.getValueAsBoolean("isPrintReceiptLogger", false);
    }

    private void recordLogInfo(LogInfo log) {
        ArrayList<DynamicObject> logList = new ArrayList<DynamicObject>(1);
        BizLogType bizLogType = BizLogType.getEnumByID((String)MDC.get((String)"bizName"));
        if (bizLogType != BizLogType.DEFAULT) {
            String fileName = bizLogType.getName();
            WriteFileUtil.writeLog((String)fileName, (String)log.getMsg().replace("\u0000", "").replace("\\u0000", ""));
        } else if ("bussiness_index".equals(log.getBussiness_type())) {
            DynamicObject repeatLog = BusinessDataServiceHelper.newDynamicObject((String)"aqap_new_log");
            repeatLog.set("biz_name", (Object)log.getBizName());
            repeatLog.set("bd_biz_name", (Object)this.getBusinessTypeID(log.getBizName()));
            repeatLog.set("bank_login", (Object)log.getBankLoginID());
            repeatLog.set("logger_bank_no", (Object)log.getLogger_bank_no());
            repeatLog.set("bank_version", (Object)log.getBankVersionID());
            repeatLog.set("bd_bank_version", (Object)this.getBankVersionID(log.getBankVersionID()));
            repeatLog.set("account", (Object)log.getAccount());
            repeatLog.set("dt_query", (Object)log.getTime());
            repeatLog.set("logger_batch_no", (Object)log.getLogger_batch_no());
            repeatLog.set("logger_detail_no", (Object)log.getLogger_detail_no());
            repeatLog.set("logger_type", (Object)this.getBusinessType(log));
            repeatLog.set("biz_seq", (Object)log.getTraceID());
            logList.add(repeatLog);
            SaveServiceHelper.save((DynamicObject[])logList.toArray(new DynamicObject[0]));
        } else {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"aqap_biz_log");
            DynamicObject repeatLog = new DynamicObject((DynamicObjectType)entityType);
            repeatLog.getDataEntityType().getPrimaryKey().setValueFast((Object)repeatLog, (Object)ID.genLongId());
            repeatLog.set("biz_name", (Object)log.getBizName());
            repeatLog.set("bank_login", (Object)log.getBankLoginID());
            repeatLog.set("logger_bank_no", (Object)log.getLogger_bank_no());
            repeatLog.set("bank_version", (Object)log.getBankVersionID());
            repeatLog.set("account", (Object)log.getAccount());
            repeatLog.set("dt_query", (Object)log.getTime());
            repeatLog.set("logger_batch_no", (Object)log.getLogger_batch_no());
            repeatLog.set("logger_detail_no", (Object)log.getLogger_detail_no());
            repeatLog.set("logger_type", (Object)log.getBussiness_type());
            repeatLog.set("biz_seq", (Object)(ID.genLongId() + ""));
            String msg = log.getMsg().replace("\u0000", "").replace("\\u0000", "");
            if (StringUtils.isNotEmpty((String)msg) && msg.length() > 1000) {
                try {
                    msg = StringCompressor.compressString(msg);
                    repeatLog.set("opname", (Object)"1");
                }
                catch (Throwable t) {
                    repeatLog.set("opname", (Object)"");
                }
            }
            repeatLog.set("log_content_tag", (Object)msg);
            ArrayList<DynamicObject> objects = new ArrayList<DynamicObject>(16);
            objects.add(repeatLog);
            LogORM logORM = LogORM.create();
            logORM.insert(objects);
        }
    }

    private long getBusinessTypeID(String bizName) {
        long id = 0L;
        QFilter filter = QFilter.of((String)"number=?", (Object[])new Object[]{bizName});
        Map map = BusinessDataServiceHelper.loadFromCache((String)"aqap_business_type", (QFilter[])filter.toArray());
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                id = (Long)entry.getKey();
            }
        }
        return id;
    }

    private long getBankVersionID(String bankVersion) {
        long id = 0L;
        QFilter filter = QFilter.of((String)"number=?", (Object[])new Object[]{bankVersion});
        Map map = BusinessDataServiceHelper.loadFromCache((String)"aqap_bank", (QFilter[])filter.toArray());
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                id = (Long)entry.getKey();
            }
        }
        return id;
    }

    private String getBusinessType(LogInfo info) {
        String businessType = "";
        businessType = StringUtils.equals((String)info.getLogger_batch_no(), (String)info.getLogger_detail_no()) ? (BusinessTypeUtil.INSTANCE.isOnlyBusiness(info.getBizName()) || BusinessTypeUtil.INSTANCE.isSynBusiness(info.getBizName()) ? new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u5fd7", (String)"BaseLog_0", (String)"ebg-egf-common", (Object[])new Object[0])).getLocaleValue() : new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u5fd7+\u94f6\u884c\u65e5\u5fd7", (String)"BaseLog_1", (String)"ebg-egf-common", (Object[])new Object[0])).getLocaleValue()) : new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u5fd7+\u94f6\u884c\u65e5\u5fd7", (String)"BaseLog_1", (String)"ebg-egf-common", (Object[])new Object[0])).getLocaleValue();
        return businessType;
    }

    private String transFormat(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return "";
        }
        return value;
    }

    private String getMsg(String msg, String className, String logLevel) {
        StringBuilder sb = new StringBuilder();
        String time = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
        sb.append('[').append(time).append(' ');
        if (StringUtils.isNotEmpty((String)className)) {
            sb.append(this.getSimpleClassName(className)).append(' ');
        }
        if (StringUtils.isNotEmpty((String)logLevel)) {
            if (WARN.equalsIgnoreCase(logLevel) || ERROR.equalsIgnoreCase(logLevel)) {
                sb.append(logLevel);
            } else {
                sb.append(INFO);
            }
        }
        sb.append(']').append(": ");
        sb.append(msg);
        return sb.toString();
    }

    private String getSimpleClassName(String className) {
        StringBuilder sb = new StringBuilder();
        String[] classNameCollection = className.split("\\.");
        for (int i = 0; i < classNameCollection.length; ++i) {
            if (i < classNameCollection.length - 1) {
                sb.append(classNameCollection[i].substring(0, 1)).append('.');
                continue;
            }
            sb.append(classNameCollection[i]);
        }
        return sb.toString();
    }

    public void infoPrivacy(String msg) {
        msg = LogPrivacyUtil.getSendResult((String)msg);
        msg = LogFilterUtil.getSendResult((String)msg);
        this.sendLogToMQ(msg, INFO);
    }

    public void infoFilerLog(String msg) {
        msg = LogFilterUtil.getSendResult((String)msg);
        this.sendLogToMQ(msg, INFO);
    }

    public void monitorFeature(String featureNumber, String formid, String action, String method) {
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)"POA-FEATURE-MONITOR");
        object.put("featureNumber", (Object)featureNumber);
        object.put("count", (Object)"1");
        object.put("time", (Object)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        object.put("formid", (Object)formid);
        JSONObject var = new JSONObject();
        object.put("var", (Object)var);
        var.put("action", (Object)action);
        var.put("method", (Object)method);
        this.logger.info(object.toString());
    }
}

