/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.spdb.dc.services.codeless.receivable;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.note.banks.spdb.dc.services.util.Check;
import kd.ebg.note.banks.spdb.dc.services.util.Packer;
import kd.ebg.note.banks.spdb.dc.services.util.Parser;
import kd.ebg.note.banks.spdb.dc.services.util.Signature;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class SplideUtil
extends AbstractNoteReceivableImpl {
    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "PJ23";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u62c6\u5206\u7968\u636e\u4ea4\u6613\u6570\u636e", (String)"SplideUtil_0", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public String pack(BankNoteReceivableRequest request, String s) {
        NoteReceivableInfo[] infos = request.getNotePayableInfosAsArray();
        String startNo = infos[0].getStartNo();
        String endNo = infos[0].getEndNo();
        Element root = new Element("body");
        JDomUtils.addChild((Element)root, (String)"transMasterID", (String)BankBusinessConfig.getPayMasterID((String)request.getAcnt().getAccNo()));
        JDomUtils.addChild((Element)root, (String)"eBillBusessType", (String)"06");
        JDomUtils.addChild((Element)root, (String)"eBillType", (String)infos[0].getDraftType());
        JDomUtils.addChild((Element)root, (String)"billPackageNo", (String)infos[0].getBillNo());
        JDomUtils.addChild((Element)root, (String)"sonBillRngLow", (String)startNo);
        JDomUtils.addChild((Element)root, (String)"sonBillRngHight", (String)endNo);
        if ("1".equals(infos[0].getAutoAccept())) {
            JDomUtils.addChild((Element)root, (String)"queryType", (String)"03");
        } else if ("AC01".equals(infos[0].getDraftType())) {
            JDomUtils.addChild((Element)root, (String)"queryType", (String)"02");
        } else {
            JDomUtils.addChild((Element)root, (String)"queryType", (String)"01");
        }
        JDomUtils.addChild((Element)root, (String)"beginNumber", (String)"1");
        JDomUtils.addChild((Element)root, (String)"queryNumber", (String)"20");
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg((String)"PJ23", (String)signedMsg);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String respStr) {
        Element root = JDomUtils.string2Root((String)respStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = Parser.parseResponse(root);
        String code = rsp.getResponseCode();
        if (!"AAAAAAA".equals(code)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u53ef\u64cd\u4f5c\u7968\u636e\u67e5\u8be2\u5f02\u5e38\uff1a%s", (String)"SplideUtil_1", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]), rsp.getResponseMessage()));
        }
        String rspData = Signature.getInstance().validateSignedData(respStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
        String totalNumber = body.getChildTextTrim("totalNumber");
        if (StringUtils.isEmpty((String)totalNumber) || "0".equals(totalNumber)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u53ef\u64cd\u4f5c\u7968\u636e\u67e5\u8be2\u8be5\u7968\u4e0d\u53ef\u505a\u6b64\u4e1a\u52a1\uff0c\u8bf7\u786e\u8ba4\uff1a", (String)"SplideUtil_2", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
        }
        Element lists = Check.checkNoNullChildElement((Element)body, (String)"lists");
        List localList = lists.getChildren("list");
        List infos = request.getNoteReceivableInfos();
        if (localList != null && localList.size() >= 1) {
            Element element = (Element)localList.get(0);
            String adjustDays = element.getChildText("adjustDays");
            ((NoteReceivableInfo)infos.get(0)).setReserved2(adjustDays);
        }
        return infos;
    }
}

