/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.spdb.dc.services.codeless.receivable.discount;

import java.time.LocalDate;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.note.banks.spdb.dc.services.codeless.receivable.QueryReceivableImpl;
import kd.ebg.note.banks.spdb.dc.services.codeless.receivable.QueryResultUtil;
import kd.ebg.note.banks.spdb.dc.services.codeless.receivable.SplideUtil;
import kd.ebg.note.banks.spdb.dc.services.util.Packer;
import kd.ebg.note.banks.spdb.dc.services.util.Signature;
import kd.ebg.note.business.SameBankUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.bank.EBBankNoteReceivableResponse;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class CodelessDiscountImpl
extends AbstractNoteReceivableImpl {
    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryReceivableImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "PJ07";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public String pack(BankNoteReceivableRequest request, String s) {
        EBBankNoteReceivableResponse res = new SplideUtil().doBiz(request);
        List infos = res.getNoteReceivableInfos();
        BankAcnt acnt = request.getAcnt();
        Element root = new Element("body");
        JDomUtils.addChild((Element)root, (String)"totalNumber", (String)(infos.size() + ""));
        JDomUtils.addChild((Element)root, (String)"totalAmount", (String)((NoteReceivableInfo)infos.get(0)).getAmount().toPlainString());
        JDomUtils.addChild((Element)root, (String)"transMasterID", (String)BankBusinessConfig.getPayMasterID((String)acnt.getAccNo()));
        String bankName = ((NoteReceivableInfo)infos.get(0)).getPayeeBankName();
        if (StringUtils.isEmpty((String)bankName)) {
            JDomUtils.addChild((Element)root, (String)"acceptanceType", (String)"01");
        } else if ("1".equals(SameBankUtil.isSameBank((String)EBContext.getContext().getBankVersionID(), (String)bankName))) {
            JDomUtils.addChild((Element)root, (String)"acceptanceType", (String)"00");
        } else {
            JDomUtils.addChild((Element)root, (String)"acceptanceType", (String)"01");
        }
        JDomUtils.addChild((Element)root, (String)"discountType", (String)"RM00");
        JDomUtils.addChild((Element)root, (String)"eBillType", (String)((NoteReceivableInfo)infos.get(0)).getDraftType());
        JDomUtils.addChild((Element)root, (String)"recordedAcctNo", (String)((NoteReceivableInfo)infos.get(0)).getAcceptorAccNo());
        JDomUtils.addChild((Element)root, (String)"recordedBankNo", (String)((NoteReceivableInfo)infos.get(0)).getAcceptorBankCnaps());
        JDomUtils.addChild((Element)root, (String)"discounterName", (String)acnt.getAccName());
        JDomUtils.addChild((Element)root, (String)"acctNo", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)root, (String)"discounteeName", (String)((NoteReceivableInfo)infos.get(0)).getPayeeAccName());
        JDomUtils.addChild((Element)root, (String)"discounteeAcctNo", (String)((NoteReceivableInfo)infos.get(0)).getPayeeAccNo());
        JDomUtils.addChild((Element)root, (String)"discounteeBankNo", (String)((NoteReceivableInfo)infos.get(0)).getPayeeBankCnaps());
        if (StringUtils.isEmpty((String)((NoteReceivableInfo)infos.get(0)).getSettleWay())) {
            JDomUtils.addChild((Element)root, (String)"settleType", (String)"ST02");
        } else {
            JDomUtils.addChild((Element)root, (String)"settleType", (String)((NoteReceivableInfo)infos.get(0)).getSettleWay());
        }
        JDomUtils.addChild((Element)root, (String)"remark", (String)((NoteReceivableInfo)infos.get(0)).getExplanation());
        JDomUtils.addChild((Element)root, (String)"bargainNo", (String)((NoteReceivableInfo)infos.get(0)).getContractNo());
        Element lists = new Element("lists");
        lists.setAttribute("name", "edraftList");
        JDomUtils.addChild((Element)root, (Element)lists);
        for (int i = 0; i < infos.size(); ++i) {
            Element list = new Element("list");
            JDomUtils.addChild((Element)lists, (Element)list);
            JDomUtils.addChild((Element)list, (String)"sequenceNo", (String)"0001");
            JDomUtils.addChild((Element)list, (String)"billPackageNo", (String)((NoteReceivableInfo)infos.get(i)).getBillNo());
            JDomUtils.addChild((Element)list, (String)"eBillAmount", (String)((NoteReceivableInfo)infos.get(i)).getDraftAmount().toPlainString());
            String startNo = ((NoteReceivableInfo)infos.get(i)).getStartNo();
            String endNo = ((NoteReceivableInfo)infos.get(i)).getEndNo();
            if ("0".equals(((NoteReceivableInfo)infos.get(i)).getGrdBag())) {
                JDomUtils.addChild((Element)list, (String)"sonBillRngLow", (String)"0");
                JDomUtils.addChild((Element)list, (String)"sonBillRngHight", (String)"0");
            } else {
                JDomUtils.addChild((Element)list, (String)"sonBillRngLow", (String)startNo);
                JDomUtils.addChild((Element)list, (String)"sonBillRngHight", (String)endNo);
            }
            JDomUtils.addChild((Element)list, (String)"applyAmount", (String)((NoteReceivableInfo)infos.get(i)).getAmount().toPlainString());
            JDomUtils.addChild((Element)list, (String)"voteDate", (String)LocalDateUtil.formatDate((LocalDate)((NoteReceivableInfo)infos.get(0)).getIssueDate()));
            JDomUtils.addChild((Element)list, (String)"expiryDate", (String)LocalDateUtil.formatDate((LocalDate)((NoteReceivableInfo)infos.get(0)).getDueDate()));
            JDomUtils.addChild((Element)list, (String)"discountAmount", (String)((NoteReceivableInfo)infos.get(i)).getDisCountAmount());
            JDomUtils.addChild((Element)list, (String)"canTransferFlag", (String)((NoteReceivableInfo)infos.get(i)).getTransferFlag());
            JDomUtils.addChild((Element)list, (String)"discountYearRate", (String)((NoteReceivableInfo)infos.get(i)).getDisCountRatePer());
            JDomUtils.addChild((Element)list, (String)"adjustingDays", (String)((NoteReceivableInfo)infos.get(i)).getReserved2());
            JDomUtils.addChild((Element)list, (String)"canTransferFlag", (String)((NoteReceivableInfo)infos.get(i)).getTransferFlag());
            String discountType = ((NoteReceivableInfo)infos.get(i)).getDiscountType();
            JDomUtils.addChild((Element)list, (String)"interestWay", (String)discountType);
            if ("0".equals(((NoteReceivableInfo)infos.get(i)).getIsPayeeSameBank())) {
                JDomUtils.addChild((Element)list, (String)"discountInterest", (String)((NoteReceivableInfo)infos.get(i)).getInterest());
            }
            if ("3".equals(discountType)) {
                String disRedRate = ((NoteReceivableInfo)infos.get(i)).getIncreaseRate();
                if (StringUtils.isEmpty((String)disRedRate)) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u534f\u8bae\u4ed8\u606f\u4e2d\uff0c\u672a\u4e0a\u9001\u4e70\u65b9\u4ed8\u606f\u6bd4\u4f8b", (String)"CodelessDiscountImpl_0", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                }
                JDomUtils.addChild((Element)list, (String)"interestRatio", (String)disRedRate);
            }
            JDomUtils.addChild((Element)list, (String)"ensureIdentification", (String)"0");
        }
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg((String)"PJ07", (String)signedMsg);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String rspStr) {
        List infos = request.getNoteReceivableInfos();
        QueryResultUtil.parserCommon(infos, rspStr);
        return infos;
    }
}

