/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.newnote.detail;

import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.ext.ResponseFileUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.note.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.banks.abc.dc.service.newnote.detail.NoteDetailUtil;
import kd.ebg.note.banks.abc.dc.service.newnote.util.NewNoteUtil;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.EBBankDetailResponse;
import kd.ebg.note.business.util.NoteRngNoUtils;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import kd.ebg.note.common.framework.utils.ParserUtils;
import org.jdom2.Element;

public class NoteHoldImpl
extends AbstractNoteDetailImpl {
    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5ba2\u6237\u6301\u6709\u7968\u636e\u67e5\u8be2", (String)"NoteHoldImpl_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return "0".equals(noteDetailRequest.getBody().getIsNewECDS());
    }

    public String pack(BankNoteDetailRequest request, String pageTag) {
        BankAcnt acnt = request.getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New((String)"CQRD36");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19((String)acnt.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt((BankAcnt)acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)acnt.getCurrency());
        Element hermes = CommNotePacker.packHermes((Element)root, (String)"CH1003", (String)"SPIN1033", (String)"");
        JDomUtils.addChild((Element)hermes, (String)"DistTp", (String)"DT02");
        JDomUtils.addChild((Element)hermes, (String)"CdType", (String)request.getBody().getDraftType());
        if ("info".equals(request.getHeader().getSubBizType())) {
            JDomUtils.addChild((Element)hermes, (String)"CdNo", (String)request.getBody().getNoteNo());
            JDomUtils.addChild((Element)hermes, (String)"CdNo", (String)NewNoteUtil.getBankNoteSubrange((String)request.getBody().getStartNo()));
            JDomUtils.addChild((Element)hermes, (String)"CdNo", (String)NewNoteUtil.getBankNoteSubrange((String)request.getBody().getEndNo()));
        }
        return ABC_DC_Packer.covert2ABCMessage((Element)root);
    }

    public List<Detail> parse(BankNoteDetailRequest rqst, String rspStr) {
        BankAcnt bankAcnt = rqst.getAcnt();
        return this.parseReplyDetail(rqst, rspStr, bankAcnt);
    }

    public List<Detail> parseReplyDetail(BankNoteDetailRequest rqst, String rspStr, BankAcnt ancAcnt) {
        LinkedList<Detail> result = new LinkedList<Detail>();
        Element root = ABC_DC_Parser.parseString2Root((String)rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader((Element)root);
        String RespInfo = root.getChildTextTrim("RespInfo");
        if (ResManager.loadKDString((String)"\u65e0\u6ee1\u8db3\u6761\u4ef6\u7684\u8bb0\u5f55", (String)"NoteDetailParser_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]).equals(RespInfo) || ResManager.loadKDString((String)"\u67e5\u8be2\u65e0\u6570\u636e", (String)"NoteDetailParser_1", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]).equals(RespInfo)) {
            return result;
        }
        if (!"0000".equals(rsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u519c\u884c\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 ,\u94f6\u884c\u8fd4\u56de :%s", (String)"NoteDetailParser_4", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{rsp.getResponseCode(), rsp.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element cme = root.getChild("Cme");
        String fieldNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"FieldNum");
        String recordNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"RecordNum");
        int recordNum = Integer.parseInt(recordNumStr);
        if (0 == recordNum) {
            return result;
        }
        String[] splits = new String[]{};
        Element cmp = root.getChild("Cmp");
        String fileName = ParserUtils.checkUnNullableElement((Element)cmp, (String)"BatchFileName");
        splits = ResponseFileUtils.getDetailRspRecordsNew((String)fileName, (String)"");
        int fieldNum = Integer.parseInt(fieldNumStr);
        for (int i = recordNum - 1; i >= 0; --i) {
            String billNo = splits[fieldNum * i];
            String startNo = splits[fieldNum * i + 1];
            String endNo = splits[fieldNum * i + 2];
            String billAmount = splits[fieldNum * i + 3];
            String billType = splits[fieldNum * i + 4];
            String transferFlag = splits[fieldNum * i + 5];
            String issueDate = splits[fieldNum * i + 6];
            String dueDate = splits[fieldNum * i + 7];
            String isGrad = splits[fieldNum * i + 8];
            String accNo = splits[fieldNum * i + 12];
            String accName = splits[fieldNum * i + 13];
            String accBankScnaps = splits[fieldNum * i + 15];
            String accBankScnapsName = splits[fieldNum * i + 16];
            String acceptName = splits[fieldNum * i + 20];
            String acceptNo = splits[fieldNum * i + 19];
            String acceptScnaps = splits[fieldNum * i + 22];
            String acceptScnapsName = splits[fieldNum * i + 23];
            String payeeName = splits[fieldNum * i + 27];
            String payeeNo = splits[fieldNum * i + 26];
            String payeeScnaps = splits[fieldNum * i + 29];
            String payeeScnapsName = splits[fieldNum * i + 30];
            String notestaus = splits[fieldNum * i + 45];
            String circus = splits[fieldNum * i + 46];
            Detail info = new Detail();
            info.setNoteStatus(notestaus);
            if ("CS06".equals(notestaus) || "CS05".equals(notestaus)) continue;
            info.setCirStatus(circus);
            info.setNoteNo(billNo);
            if (!StringUtils.isEmpty((String)billAmount)) {
                info.setAmount(billAmount);
            }
            info.setDraftType(billType);
            if (StringUtils.isNotEmpty((String)startNo) && StringUtils.isNotEmpty((String)endNo) && !"0".equals(startNo)) {
                startNo = NoteRngNoUtils.getForMatBillNoRng((String)startNo);
                endNo = NoteRngNoUtils.getForMatBillNoRng((String)endNo);
            }
            info.setSubRange(startNo + "," + endNo);
            info.setStartNo(startNo);
            info.setEndNo(endNo);
            info.setIsNewECDS("0");
            info.setGrdBag(isGrad);
            info.setDrawerAccName(accName);
            info.setDrawerAccNo(accNo);
            info.setDrawerCnapsCode(accBankScnaps);
            info.setDrawerBankName(accBankScnapsName);
            info.setAcceptorAccName(acceptName);
            info.setAcceptorAccNo(acceptNo);
            info.setAcceptorCnapsCode(acceptScnaps);
            info.setAcceptorBankName(acceptScnapsName);
            info.setPayeeAccName(payeeName);
            info.setPayeeAccNo(payeeNo);
            info.setPayeeCnapsCode(payeeScnaps);
            info.setPayeeBankName(payeeScnapsName);
            info.setTransferFlag(transferFlag);
            info.setIssueDate(issueDate.replaceAll("-", ""));
            info.setDueDate(dueDate.replaceAll("-", ""));
            new NoteDetailUtil().queryNoteDetails(info, ancAcnt);
            result.add(info);
        }
        return result;
    }

    public EBBankDetailResponse doBiz(BankNoteDetailRequest request) {
        EBBankDetailResponse response = super.doBiz(request);
        response.setKeepFlag("1");
        return response;
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        return true;
    }
}

