/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.newnote.payable.cancel;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.banks.abc.dc.service.newnote.DetailNoteImpl;
import kd.ebg.note.banks.abc.dc.service.newnote.NewNoteParser;
import kd.ebg.note.banks.abc.dc.service.newnote.payable.QueryPayableNoteImpl;
import kd.ebg.note.banks.abc.dc.service.newnote.util.NewNoteUtil;
import kd.ebg.note.banks.abc.dc.service.newnote.util.TypeConvertUtils;
import kd.ebg.note.banks.abc.dc.utils.TypeInfo;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class CancelNoteImpl
extends AbstractNotePayableImpl {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryPayableNoteImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CFRC51";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u901a\u7528\u64a4\u9500", (String)"CancelNoteImpl_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return false;
    }

    public String pack(BankNotePayableRequest bankNotePayableRequest, String s) {
        NotePayableInfo info = (NotePayableInfo)bankNotePayableRequest.getNotePayableInfoList().get(0);
        String subBizType = info.getSubBizType();
        String code = info.getOperationCode();
        String typeCode = subBizType + code;
        TypeInfo typeInfo = TypeConvertUtils.getReplayPackerTypeInfo((String)typeCode);
        if (null == typeInfo || StringUtils.isEmpty((String)typeInfo.getTransCode())) {
            EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b:%1$s\u7684\u4e1a\u52a1\u79cd\u7c7b\uff1a%2$s\u65e0\u6cd5\u64a4\u9500\u3002\u4e0d\u652f\u6301\u8be5\u64a4\u9500\u7c7b\u578b\u4e1a\u52a1\u3002", (String)"CancelNoteImpl_1", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), subBizType, code));
        }
        BankAcnt acnt = bankNotePayableRequest.getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New((String)"CFRC51", (String)info.getBankBatchSeqId());
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19((String)acnt.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt((BankAcnt)acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)info.getCurrency());
        Element hermes = CommNotePacker.packHermes((Element)root, (String)"CH1003", (String)"SPIN1017", (String)"");
        JDomUtils.addChild((Element)hermes, (String)"BusiType", (String)typeInfo.getABCNoteType());
        RequestContextUtils.setRunningParam((String)"BusiType", (String)typeInfo.getABCNoteType());
        String busCode = new DetailNoteImpl().getDetail(info, acnt);
        if (StringUtils.isEmpty((String)busCode)) {
            EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u7f16\u53f7\u4e3a\u7a7a", (String)"CancelNoteImpl_2", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)hermes, (String)"BusiNo", (String)busCode);
        JDomUtils.addChild((Element)hermes, (String)"Note", (String)info.getExplanation());
        Element CancelResPsnInf = JDomUtils.addChild((Element)hermes, (String)"CancelResPsnInf");
        JDomUtils.addChild((Element)CancelResPsnInf, (String)"DistTp", (String)"DT02");
        JDomUtils.addChild((Element)CancelResPsnInf, (String)"Acct", (String)NewNoteUtil.getPayeeAccNo((NotePayableInfo)info));
        JDomUtils.addChild((Element)CancelResPsnInf, (String)"Name", (String)info.getPayeeAccName());
        JDomUtils.addChild((Element)CancelResPsnInf, (String)"AcctSvcr", (String)info.getPayeeBankCnaps());
        Element CustInf = JDomUtils.addChild((Element)hermes, (String)"CustInf");
        JDomUtils.addChild((Element)CustInf, (String)"DistTp", (String)"DT02");
        JDomUtils.addChild((Element)CustInf, (String)"AcctSvcr", (String)acnt.getCnaps());
        JDomUtils.addChild((Element)CustInf, (String)"ConAcctSvcr", (String)acnt.getCnaps());
        JDomUtils.addChild((Element)hermes, (String)"CdNo", (String)info.getBillNo());
        JDomUtils.addChild((Element)hermes, (String)"CdRangeStart", (String)NewNoteUtil.getBankNoteSubrange((String)info.getStartNo()));
        JDomUtils.addChild((Element)hermes, (String)"CdRangeEnd", (String)NewNoteUtil.getBankNoteSubrange((String)info.getEndNo()));
        return ABC_DC_Packer.covert2ABCMessage((Element)root);
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest bankNotePayableRequest, String rspStr) {
        return NewNoteParser.parse(bankNotePayableRequest, rspStr);
    }
}

