/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.newnote.receivable;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.note.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.banks.abc.dc.service.newnote.receivable.QueryReceivableStatusNoteImpl;
import kd.ebg.note.business.noteReceivable.atomic.AbstractQueryNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class QueryReceivableNoteImpl
extends AbstractQueryNoteReceivableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryReceivableNoteImpl.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CQRD39";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u901a\u7528\u67e5\u8be2\u5e94\u6536\u7968\u636e", (String)"QueryReceivableNoteImpl_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public String pack(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        List notePayableinfos = bankNoteReceivableRequest.getNoteReceivableInfos();
        BankAcnt acnt = bankNoteReceivableRequest.getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New((String)"CQRD39");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19((String)acnt.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)acnt.getAreaCode());
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)((NoteReceivableInfo)notePayableinfos.get(0)).getCurrency());
        Element hermes = CommNotePacker.packHermes((Element)root, (String)"CH1003", (String)"SPIN1036", (String)"");
        if (StringUtils.isNotEmpty((String)((NoteReceivableInfo)notePayableinfos.get(0)).getReserved1()) && StringUtils.isNotEmpty((String)((NoteReceivableInfo)notePayableinfos.get(0)).getReserved2())) {
            JDomUtils.addChild((Element)hermes, (String)"BusiNo", (String)((NoteReceivableInfo)notePayableinfos.get(0)).getReserved1());
            JDomUtils.addChild((Element)hermes, (String)"BusiType", (String)((NoteReceivableInfo)notePayableinfos.get(0)).getReserved2());
        } else {
            JDomUtils.addChild((Element)hermes, (String)"CodReqSeq", (String)((NoteReceivableInfo)notePayableinfos.get(0)).getBankBatchSeqId());
        }
        JDomUtils.addChild((Element)hermes, (String)"DistTp", (String)"DT02");
        String direction = "ST00";
        if ("note_signin".equals(bankNoteReceivableRequest.getHeader().getSubBizType())) {
            direction = "ST01";
        }
        JDomUtils.addChild((Element)hermes, (String)"Direction", (String)direction);
        return ABC_DC_Packer.covert2ABCMessage((Element)root);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest bankNoteReceivableRequest, String rspStr) {
        List infos = bankNoteReceivableRequest.getNoteReceivableInfos();
        Element root = ABC_DC_Parser.parseString2Root((String)rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader((Element)root);
        String rspCode = rsp.getResponseCode();
        this.logger.info("respCode:" + rspCode);
        NoteReceivableInfo info = (NoteReceivableInfo)infos.get(0);
        if (StringUtils.isNotEmpty((String)info.getReserved1()) && StringUtils.isNotEmpty((String)info.getReserved2())) {
            if (!"0000".equals(rspCode)) {
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
                return infos;
            }
        } else {
            if ("ETCTCSC0042".equals(rspCode)) {
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
                return infos;
            }
            if (!"0000".equals(rspCode)) {
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
                return infos;
            }
        }
        Element Hermes = root.getChild("Hermes");
        String CdNo = Hermes.getChildTextTrim("CdNo");
        String CdRangeStart = Hermes.getChildTextTrim("CdRangeStart");
        String CdRangeEnd = Hermes.getChildTextTrim("CdRangeEnd");
        String DealDtTm = Hermes.getChildTextTrim("DealDtTm");
        String DealResult = Hermes.getChildTextTrim("DealResult");
        String BusiStatus = Hermes.getChildTextTrim("BusiStatus");
        String SgnUpMk = Hermes.getChildTextTrim("SgnUpMk");
        String AppvStatus = Hermes.getChildTextTrim("AppvStatus");
        if (!StringUtils.isEmpty((String)CdNo)) {
            ((NoteReceivableInfo)infos.get(0)).setBillNo(CdNo);
        }
        if (!StringUtils.isEmpty((String)CdRangeStart)) {
            ((NoteReceivableInfo)infos.get(0)).setStartNo(CdRangeStart);
        }
        if (!StringUtils.isEmpty((String)CdRangeEnd)) {
            ((NoteReceivableInfo)infos.get(0)).setEndNo(CdRangeEnd);
        }
        String BusiNo = ((NoteReceivableInfo)infos.get(0)).getReserved1();
        String reqCode = "DT02";
        String BusiType = ((NoteReceivableInfo)infos.get(0)).getReserved2();
        if ("SPBS05".equals(BusiStatus) || "SPBS14".equals(BusiStatus) || "SPBS15".equals(BusiStatus)) {
            if ("note_signin".equals(((NoteReceivableInfo)infos.get(0)).getSubBizType()) && "SU01".equals(((NoteReceivableInfo)infos.get(0)).getOtherInfo())) {
                ((NoteReceivableInfo)infos.get(0)).setNoteStatus("CS03");
                ((NoteReceivableInfo)infos.get(0)).setCirStatus("TF0301");
            } else {
                new QueryReceivableStatusNoteImpl().getStatus(bankNoteReceivableRequest, reqCode);
            }
            if ("TAED01".equals(BusiType) || "TAPG01".equals(BusiType) || "TAPR01".equals(BusiType) || "TADC01".equals(BusiType) || "TAPP01".equals(BusiType)) {
                if ("SPBS14".equals(BusiStatus)) {
                    EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUCCESS, (String)BusiStatus, (String)DealResult);
                } else if ("SPBS15".equals(BusiStatus)) {
                    EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)BusiStatus, (String)DealResult);
                } else {
                    EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)BusiStatus, (String)DealResult);
                }
            } else if ("TRPP01".equals(BusiType)) {
                if ("SPBS14".equals(BusiStatus)) {
                    String cirStatus = ((NoteReceivableInfo)infos.get(0)).getCirStatus();
                    if ("CS06".equals(((NoteReceivableInfo)infos.get(0)).getNoteStatus()) && "TF0501".equals(cirStatus)) {
                        EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUCCESS, (String)BusiStatus, (String)"");
                    } else {
                        EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)BusiStatus, (String)DealResult);
                    }
                } else if ("SPBS15".equals(BusiStatus)) {
                    String cirStatus = ((NoteReceivableInfo)infos.get(0)).getCirStatus();
                    if ("CS03".equals(((NoteReceivableInfo)infos.get(0)).getNoteStatus()) && ("TF0301".equals(cirStatus) || "TF0303".equals(cirStatus))) {
                        EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUCCESS, (String)BusiStatus, (String)"");
                    } else {
                        EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)BusiStatus, (String)DealResult);
                    }
                } else {
                    EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)BusiStatus, (String)DealResult);
                }
            } else if ("TRAT01".equals(BusiType) || "TRRB01".equals(BusiType) || "TRED01".equals(BusiType) || "TRGT01".equals(BusiType) || "TRPG01".equals(BusiType) || "TRPR01".equals(BusiType)) {
                if ("SPBS14".equals(BusiStatus) || "SPBS15".equals(BusiStatus)) {
                    EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUCCESS, (String)BusiStatus, (String)"");
                } else {
                    EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)BusiStatus, (String)DealResult);
                }
            } else if ("SPBS05".equals(BusiStatus)) {
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUCCESS, (String)BusiStatus, (String)"");
            } else {
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)BusiStatus, (String)DealResult);
            }
        } else if ("SPBS00".equals(BusiStatus) || "SPBS03".equals(BusiStatus) || "SPBS07".equals(BusiStatus) || "SPBS10".equals(BusiStatus) || "SPBS30".equals(BusiStatus) || "SPBS31".equals(BusiStatus)) {
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)BusiStatus, (String)DealResult);
        } else if ("SPBS04".equals(BusiStatus) || "SPBS06".equals(BusiStatus) || "SPBS11".equals(BusiStatus) || "SPBS13".equals(BusiStatus) || "SPBS16".equals(BusiStatus) || "SPBS17".equals(BusiStatus) || "SPBS18".equals(BusiStatus) || "SPBS19".equals(BusiStatus) || "SPBS32".equals(BusiStatus)) {
            new QueryReceivableStatusNoteImpl().getStatus(bankNoteReceivableRequest, reqCode);
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)BusiStatus, (String)DealResult);
        } else if ("SPBS15".equals(BusiStatus)) {
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)BusiStatus, (String)DealResult);
        }
        if ("note_endorse".equals(((NoteReceivableInfo)infos.get(0)).getSubBizType()) || "note_discount".equals(((NoteReceivableInfo)infos.get(0)).getSubBizType()) || "pledge_note".equals(((NoteReceivableInfo)infos.get(0)).getSubBizType())) {
            if ("SPBS05".equals(BusiStatus) || "SPBS07".equals(BusiStatus) || "SPBS10".equals(BusiStatus) || "SPBS11".equals(BusiStatus) || "SPBS13".equals(BusiStatus) || "SPBS14".equals(BusiStatus) || "SPBS15".equals(BusiStatus) || "SPBS16".equals(BusiStatus) || "SPBS17".equals(BusiStatus) || "SPBS18".equals(BusiStatus) || "SPBS19".equals(BusiStatus) || "SPBS30".equals(BusiStatus) || "SPBS31".equals(BusiStatus) || "SPBS32".equals(BusiStatus) || "SPBS33".equals(BusiStatus) || "SPBS34".equals(BusiStatus)) {
                ((NoteReceivableInfo)infos.get(0)).setIsRefuse("1");
            } else {
                ((NoteReceivableInfo)infos.get(0)).setIsRefuse("0");
            }
        }
        return infos;
    }

    public int getBatchSize() {
        return 0;
    }
}

