/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.newnote.receivable.pledge;

import java.time.LocalDate;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.proxy.ABC_DCFileUtil;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.banks.abc.dc.service.newnote.NewNoteParser;
import kd.ebg.note.banks.abc.dc.service.newnote.receivable.discount.QueryDiscountReceivableNoteImpl;
import kd.ebg.note.banks.abc.dc.service.newnote.util.NewNoteUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class ReceivablePledgeNoteImpl
extends AbstractNoteReceivableImpl {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryDiscountReceivableNoteImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CFRC63";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u8d28\u62bc", (String)"ReceivablePledgeNoteImpl_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public String pack(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        NoteReceivableInfo[] receivableInfos = bankNoteReceivableRequest.getNotePayableInfosAsArray();
        String fileName = receivableInfos[0].getBankBatchSeqId();
        String content = this.getFileContent(receivableInfos[0]);
        new ABC_DCFileUtil().uploadFile(fileName, content, fileName);
        BankAcnt acnt = bankNoteReceivableRequest.getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New((String)"CFRC63", (String)receivableInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)root, (String)"FileFlag", (String)"1");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19((String)acnt.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt((BankAcnt)acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)acnt.getCurrency());
        JDomUtils.addChild((Element)cmp, (String)"BatchFileName", (String)fileName);
        Element hermes = CommNotePacker.packHermes((Element)root, (String)"CH1003", (String)"SPIN1049", (String)"");
        Element CustInf = JDomUtils.addChild((Element)hermes, (String)"CustInf");
        JDomUtils.addChild((Element)CustInf, (String)"DistTp", (String)"DT02");
        JDomUtils.addChild((Element)CustInf, (String)"AcctSvcr", (String)acnt.getCnaps());
        JDomUtils.addChild((Element)CustInf, (String)"ConAcctSvcr", (String)"");
        Element ComBusiInf = JDomUtils.addChild((Element)hermes, (String)"ComBusiInf");
        JDomUtils.addChild((Element)ComBusiInf, (String)"AppDt", (String)LocalDateUtil.formatDate((LocalDate)LocalDate.now()));
        JDomUtils.addChild((Element)ComBusiInf, (String)"BtNo", (String)receivableInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)ComBusiInf, (String)"Note", (String)receivableInfos[0].getExplanation());
        Element PlgePsnInf = JDomUtils.addChild((Element)hermes, (String)"PlgePsnInf");
        JDomUtils.addChild((Element)PlgePsnInf, (String)"IsDependRoster", (String)"1");
        if ("0".equals(receivableInfos[0].getPayeeAccNo())) {
            JDomUtils.addChild((Element)PlgePsnInf, (String)"DistTp", (String)"");
        } else {
            JDomUtils.addChild((Element)PlgePsnInf, (String)"DistTp", (String)"DT01");
        }
        JDomUtils.addChild((Element)PlgePsnInf, (String)"Acct", (String)receivableInfos[0].getPayeeAccNo());
        JDomUtils.addChild((Element)PlgePsnInf, (String)"AcctSvcr", (String)receivableInfos[0].getPayeeBankCnaps());
        JDomUtils.addChild((Element)cmp, (String)"BusiType", (String)"TAPG01");
        JDomUtils.addChild((Element)cmp, (String)"BtNo", (String)receivableInfos[0].getBankBatchSeqId());
        return ABC_DC_Packer.covert2ABCMessage((Element)root);
    }

    private String getFileContent(NoteReceivableInfo receivableInfo) {
        String separate = "|_|";
        StringBuilder content = new StringBuilder();
        content.append(receivableInfo.getBillNo());
        content.append("|_|");
        content.append(NewNoteUtil.getBankNoteSubrange((String)receivableInfo.getStartNo()));
        content.append("|_|");
        content.append(NewNoteUtil.getBankNoteSubrange((String)receivableInfo.getEndNo()));
        content.append("|_|");
        content.append(receivableInfo.getAmount().toString());
        content.append("|_|");
        content.append("1");
        content.append("|_|");
        content.append('\n');
        return content.toString();
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        NewNoteParser.parse(bankNoteReceivableRequest, s);
        return bankNoteReceivableRequest.getNoteReceivableInfos();
    }
}

