/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.bocom.dc.service.news.detail;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.bocom.dc.service.news.detail.endorsInfo.EndorseInfoImpl;
import kd.ebg.note.banks.bocom.dc.service.news.util.BOCOM_DC_NotePacker;
import kd.ebg.note.banks.bocom.dc.service.news.util.BOCOM_DC_Parser;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequestBody;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import org.jdom2.Element;

public class CodelessNoteDetailImpl
extends AbstractNoteDetailImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(CodelessNoteDetailImpl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "ZL421107";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u636e\u4fe1\u606f\u67e5\u8be2", (String)"CodelessNoteDetailImpl_1", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return noteDetailRequest.getBody().getIsNewECDS().equals("0");
    }

    public boolean isNeedPage() {
        return true;
    }

    public String getFirstPageTag() {
        return "000001";
    }

    public long getBankInterval() {
        return 0L;
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element body = ap.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String totalPage = body.getChildTextTrim("totalPage");
        if (StringUtils.isEmpty((String)totalPage)) {
            return true;
        }
        int total = Integer.parseInt(totalPage);
        int cur_page = Integer.parseInt(pageTag);
        return cur_page - 1 >= total;
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        int cur = Integer.parseInt(pageTag);
        return String.format("%06d", ++cur);
    }

    public String pack(BankNoteDetailRequest request, String pageTag) {
        String subBizType = request.getHeader().getSubBizType();
        BankNoteDetailRequestBody requestBody = request.getBody();
        BankAcnt acnt = request.getAcnt();
        String tranType = requestBody.getTranType();
        Element root = BOCOM_DC_NotePacker.packRootForNote((String)"ZL421107", (String)"");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"NoteFlag", (String)"1");
        JDomUtils.addChild((Element)body, (String)"QryAcct", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"Tp", (String)(StringUtils.isEmpty((String)requestBody.getDraftType()) ? "0000" : requestBody.getDraftType()));
        if ("hold".equals(subBizType)) {
            JDomUtils.addChild((Element)body, (String)"Role", (String)"3");
        } else if ("10".equals(tranType)) {
            JDomUtils.addChild((Element)body, (String)"QryOptType", (String)"SR04");
            JDomUtils.addChild((Element)body, (String)"OrderTp", (String)"6");
        } else if ("02".equals(tranType)) {
            JDomUtils.addChild((Element)body, (String)"QryOptType", (String)"SR02");
        } else if ("03".equals(tranType)) {
            JDomUtils.addChild((Element)body, (String)"QryOptType", (String)"SR01");
        } else if ("20".equals(tranType)) {
            JDomUtils.addChild((Element)body, (String)"QryOptType", (String)"SR05");
        } else if ("18".equals(tranType)) {
            JDomUtils.addChild((Element)body, (String)"QryOptType", (String)"SR08");
        } else if ("19".equals(tranType)) {
            JDomUtils.addChild((Element)body, (String)"QryOptType", (String)"SR12");
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u4e1a\u52a1\u7c7b\u578b%1$s", (String)"CodelessNoteDetailImpl_4", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), tranType));
        }
        JDomUtils.addChild((Element)body, (String)"Ccy", (String)"CNY");
        JDomUtils.addChild((Element)body, (String)"IsseAmtMin");
        JDomUtils.addChild((Element)body, (String)"IsseAmtMax");
        String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
        boolean isProduct = StringUtils.isEmpty((String)signDate4Test);
        if (isProduct) {
            JDomUtils.addChild((Element)body, (String)"IsseDtMin", (String)request.getBody().getStartIssueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)body, (String)"IsseDtMax", (String)request.getBody().getEndIssueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        } else {
            JDomUtils.addChild((Element)body, (String)"IsseDtMin", (String)DateUtil.formatDate((Date)DateUtil.preDay((Date)DateUtil.String2Date((String)signDate4Test), (int)60)));
            JDomUtils.addChild((Element)body, (String)"IsseDtMax", (String)signDate4Test);
        }
        JDomUtils.addChild((Element)body, (String)"PagIdx", (String)pageTag);
        JDomUtils.addChild((Element)body, (String)"DueDtMin", (String)"");
        JDomUtils.addChild((Element)body, (String)"DueDtMax", (String)"");
        JDomUtils.addChild((Element)body, (String)"IfRoam", (String)request.getBody().getGrdBag());
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
    }

    public List<Detail> parse(BankNoteDetailRequest request, String responseStr) {
        BankAcnt acnt = request.getAcnt();
        BankNoteDetailRequestBody requestbody = request.getBody();
        String tranType = requestbody.getTranType();
        ArrayList<Detail> detailList = new ArrayList<Detail>(16);
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot((Element)ap);
        if (rsp.getResponseCode().equals("E014")) {
            return detailList;
        }
        if (!"0000".equals(rsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4ea4\u884c\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de :%s\u3002", (String)"CodelessNoteDetailImpl_3", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), rsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element body = ap.getChild("body");
        Element tran = body.getChild("list");
        if (tran == null) {
            return detailList;
        }
        List rcdList = tran.getChildren("rcd");
        if (null == rcdList || rcdList.size() == 0) {
            return detailList;
        }
        for (int i = 0; i < rcdList.size(); ++i) {
            Element rcd = (Element)rcdList.get(i);
            String rmrkByReq = rcd.getChildTextTrim("RmrkByReq");
            String noteFlag = rcd.getChildTextTrim("IfRoam");
            String IdNb = rcd.getChildText("IdNb");
            String Tp = rcd.getChildText("Tp");
            String IsseAmt = rcd.getChildText("IsseAmt");
            String Ccy = rcd.getChildText("Ccy");
            String IsseDt = rcd.getChildText("IsseDt");
            String DueDt = rcd.getChildText("DueDt");
            String startNo = rcd.getChildText("NoteStart");
            String endNo = rcd.getChildText("NoteEnd");
            String Sts = rcd.getChildText("Sts");
            String FlowFlag = rcd.getChildText("FlowFlag");
            String DrwrAcctId = rcd.getChildText("DrwrAcctId");
            String DrwrAcctNm = rcd.getChildText("DrwrAcctNm");
            String PyeeAcctId = rcd.getChildText("PyeeAcctId");
            String PyeeAcctNm = rcd.getChildText("PyeeAcctNm");
            String AccptrAcctId = rcd.getChildText("AccptrAcctId");
            String AccptrNm = rcd.getChildText("AccptrNm");
            String HldrAcctId = rcd.getChildText("HldrAcctId");
            String HldrNm = rcd.getChildText("HldrNm");
            String HldrAcctSvcrNm = rcd.getChildText("HldrAcctSvcrNm");
            String DrwrAcctSvcrNm = rcd.getChildText("DrwrAcctSvcrNm");
            String PyeeAcctSvcrNm = rcd.getChildText("PyeeAcctSvcrNm");
            String AccptrAcctSvcrNm = rcd.getChildText("AccptrAcctSvcrNm");
            String DrwrAcctSvcr = rcd.getChildText("DrwrAcctSvcr");
            String PyeeAcctSvcr = rcd.getChildText("PyeeAcctSvcr");
            String AccptrAcctSvcr = rcd.getChildText("AccptrAcctSvcr");
            String HldrAcctSvcr = rcd.getChildText("HldrAcctSvcr");
            String banEndrsmtMk = rcd.getChildTextTrim("BanEndrsmtMk");
            Detail info = new Detail();
            info.setGrdBag(noteFlag);
            info.setNoteNo(IdNb);
            info.setStartNo(startNo);
            info.setEndNo(endNo);
            info.setRemark(rmrkByReq);
            if (!StringUtils.isEmpty((String)IsseAmt)) {
                info.setAmount(IsseAmt);
            } else {
                info.setAmount("0");
            }
            info.setDraftType(Tp);
            info.setBusinessCode(tranType);
            info.setNoteStatus(Sts);
            info.setCirStatus(FlowFlag);
            if (!StringUtils.isEmpty((String)IsseDt)) {
                info.setIssueDate(IsseDt);
                info.setApplicationDate(IsseDt);
            }
            if (!StringUtils.isEmpty((String)DueDt)) {
                info.setDueDate(DueDt);
            }
            info.setTransferFlag(banEndrsmtMk);
            info.setDrawerAccName(DrwrAcctNm);
            info.setDrawerAccNo(DrwrAcctId);
            info.setDrawerBankName(DrwrAcctSvcrNm);
            info.setDrawerCnapsCode(DrwrAcctSvcr);
            info.setApplicantAcNo(HldrAcctId);
            info.setApplicantAcName(HldrNm);
            info.setApplicantBankCnaps(HldrAcctSvcr);
            info.setApplicantBankName(HldrAcctSvcrNm);
            info.setHolderAccNo(HldrAcctId);
            info.setPreHolderName(HldrNm);
            info.setHolderCnapsCode(HldrAcctSvcr);
            info.setHolderBankName(HldrAcctSvcrNm);
            info.setAcceptorAccName(AccptrNm);
            info.setAcceptorAccNo(AccptrAcctId);
            info.setAcceptorBankName(AccptrAcctSvcrNm);
            info.setAcceptorCnapsCode(AccptrAcctSvcr);
            info.setPayeeAccName(PyeeAcctNm);
            info.setPayeeAccNo(PyeeAcctId);
            info.setPayeeBankName(PyeeAcctSvcrNm);
            info.setPayeeCnapsCode(PyeeAcctSvcr);
            info.setCurrency("CNY");
            if ("10".equals(tranType)) {
                try {
                    this.logger.info("\u80cc\u9762\u4fe1\u606f\u67e5\u8be2\u5f00\u59cb");
                    EndorseInfoImpl impl = new EndorseInfoImpl();
                    List noteSidesInfo = impl.getMessage(IdNb, acnt.getAccNo(), startNo, endNo);
                    Collections.reverse(noteSidesInfo);
                    this.logger.info("\u80cc\u9762\u4fe1\u606f\u6570\u91cf\uff1a" + noteSidesInfo.size());
                    info.setNoteSidesInfo(noteSidesInfo);
                }
                catch (Exception e) {
                    this.logger.info("\u7968\u53f7\u4e3a{}\u67e5\u8be2\u80cc\u9762\u4fe1\u606f\u5f02\u5e38", (Object)IdNb);
                    info.setIsNoteSidesError("Y");
                }
            }
            detailList.add(info);
        }
        return detailList;
    }
}

