/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.icbc.opa.service.receipt.utils;

import com.icbc.api.DefaultIcbcClient;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.model.CertInfo;
import kd.ebg.receipt.common.model.repository.UserCertRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import org.apache.commons.codec.binary.Base64;

public class GetStore {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(GetStore.class);
    private static UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);

    public static String getPRI() {
        return GetStore.getUserKey("private_key", ResManager.loadKDString((String)"\u5e94\u7528\u79c1\u94a5", (String)"GetStore_0", (String)"ebg-receipt-banks-icbc-opa", (Object[])new Object[0]));
    }

    public static String getPUB() {
        return GetStore.getUserKey("public_key", ResManager.loadKDString((String)"\u7f51\u5173\u516c\u94a5", (String)"GetStore_1", (String)"ebg-receipt-banks-icbc-opa", (Object[])new Object[0]));
    }

    public static String getPUBSM() {
        return GetStore.getUserKeySM("public_key", ResManager.loadKDString((String)"\u7f51\u5173\u516c\u94a5", (String)"GetStore_1", (String)"ebg-receipt-banks-icbc-opa", (Object[])new Object[0]));
    }

    public static String getCAPUBSM() {
        return GetStore.getUserKeySM("ca_pub_sm_name", ResManager.loadKDString((String)"CA\u8bc1\u4e66\u516c\u94a5", (String)"GetStore_2", (String)"ebg-receipt-banks-icbc-opa", (Object[])new Object[0]));
    }

    public static String getCAPRISM() {
        return GetStore.getUserKeySM("ca_pri_sm_name", ResManager.loadKDString((String)"CA\u8bc1\u4e66\u79c1\u94a5", (String)"GetStore_3", (String)"ebg-receipt-banks-icbc-opa", (Object[])new Object[0]));
    }

    public static String getCAPUB() {
        return GetStore.getCAUserKey("ca_pub_name", ResManager.loadKDString((String)"CA\u8bc1\u4e66\u516c\u94a5", (String)"GetStore_2", (String)"ebg-receipt-banks-icbc-opa", (Object[])new Object[0]));
    }

    public static String getCAPRI() {
        return GetStore.getCAUserKey("ca_pri_name", ResManager.loadKDString((String)"CA\u8bc1\u4e66\u79c1\u94a5", (String)"GetStore_3", (String)"ebg-receipt-banks-icbc-opa", (Object[])new Object[0]));
    }

    public static Map<String, String> getCAPRIMap() {
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID("ca_pri_name", RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getCustomId());
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6CA\u8bc1\u4e66\u79c1\u94a5\u5931\u8d25\uff0c\u8bf7\u5148\u914d\u7f6e\u5e94\u7528\u79c1\u94a5\u6587\u4ef6", (String)"GetStore_4", (String)"ebg-receipt-banks-icbc-opa", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = GetStore.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        String key = GetStore.getKey(com.icbc.api.internal.util.codec.Base64.encodeBase64((byte[])fileContent));
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("key", key);
        result.put("pwd", certInfo.getCertPassword());
        return result;
    }

    public static String getCAUserKey(String key, String name) {
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID(key, RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getCustomId());
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6CA\u8bc1\u4e66\u79c1\u94a5\u5931\u8d25\uff0c\u8bf7\u5148\u914d\u7f6e\u5e94\u7528\u79c1\u94a5\u6587\u4ef6", (String)"GetStore_4", (String)"ebg-receipt-banks-icbc-opa", (Object[])new Object[0]), name));
        }
        CipherInfo cipherInfo = GetStore.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return GetStore.getKey(com.icbc.api.internal.util.codec.Base64.encodeBase64((byte[])fileContent));
    }

    public static String getUserKeySM(String key, String name) {
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID(key, RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getCustomId());
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6%s\u5931\u8d25\uff0c\u8bf7\u5148\u914d\u7f6e\u5e94\u7528\u79c1\u94a5\u6587\u4ef6\u3002", (String)"GetStore_10", (String)"ebg-receipt-banks-icbc-opa", (Object[])new Object[0]), name));
        }
        CipherInfo cipherInfo = GetStore.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        String result = "";
        result = EBGStringUtils.isNotEmpty((String)certInfo.getFileName()) && (certInfo.getFileName().endsWith(".cer") || certInfo.getFileName().endsWith(".key")) ? new String(com.icbc.bcprov.org.bouncycastle.util.encoders.Base64.encode((byte[])fileContent)) : GetStore.getKey(fileContent);
        return result;
    }

    public static String getUserKey(String key, String name) {
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID(key, RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getCustomId());
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6%s\u5931\u8d25\uff0c\u8bf7\u5148\u914d\u7f6e\u5e94\u7528\u79c1\u94a5\u6587\u4ef6", (String)"GetStore_10", (String)"ebg-receipt-banks-icbc-opa", (Object[])new Object[0]), name));
        }
        CipherInfo cipherInfo = GetStore.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return GetStore.getKey(fileContent);
    }

    private static String getKey(byte[] fileContent) {
        return StringUtils.byteToString((byte[])fileContent);
    }

    public static String getBaseUrl() {
        String ip = RequestContextUtils.getBankParameterValue((String)"ip");
        String port = RequestContextUtils.getBankParameterValue((String)"exchangePort");
        if (StringUtils.isNotEmpty((String)port)) {
            String protocol = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
            port = "HTTPS".equals(protocol) && "443".equals(port) ? "" : ("HTTP".equals(protocol) && "80".equals(port) ? "" : ":" + port);
            return protocol + "://" + ip + port + RequestContextUtils.getBankParameterValue((String)"exchangeUri") + "/";
        }
        return ip;
    }

    public static DefaultIcbcClient getClient() {
        String signType = RequestContextUtils.getBankParameterValue((String)"signType");
        String APP_ID = RequestContextUtils.getBankParameterValue((String)"appId");
        String APIGW_PUBLIC_KEY = GetStore.getPUB();
        if (StringUtils.isEmpty((String)APIGW_PUBLIC_KEY)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7f51\u5173\u516c\u94a5\u6587\u4ef6\u4e3a\u7a7a", (String)"GetStore_7", (String)"ebg-receipt-banks-icbc-opa", (Object[])new Object[0]));
        }
        Pattern p = Pattern.compile("\\s*|\t");
        Matcher m4 = p.matcher(APIGW_PUBLIC_KEY);
        APIGW_PUBLIC_KEY = m4.replaceAll("");
        if (!"CA".equals(signType) && !"SM".equals(signType)) {
            String PRI_KEY = GetStore.getPRI();
            if (StringUtils.isEmpty((String)PRI_KEY)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5e94\u7528\u79c1\u94a5\u6587\u4ef6\u4e3a\u7a7a", (String)"GetStore_8", (String)"ebg-receipt-banks-icbc-opa", (Object[])new Object[0]));
            }
            DefaultIcbcClient client = new DefaultIcbcClient(APP_ID, signType, PRI_KEY, APIGW_PUBLIC_KEY);
            return client;
        }
        if ("SM".equals(signType)) {
            String publicKey = GetStore.getCAPUBSM();
            APIGW_PUBLIC_KEY = GetStore.getPUBSM();
            String privateKey = GetStore.getCAPRISM();
            DefaultIcbcClient client = new DefaultIcbcClient(APP_ID, "CA-SM-ICBC", privateKey, "UTF-8", "json", null, null, null, publicKey, null);
            client.setIcbc_ca(APIGW_PUBLIC_KEY);
            return client;
        }
        String publicKey = GetStore.getCAPUB();
        Map<String, String> privateKeyMap = GetStore.getCAPRIMap();
        String ca_password = privateKeyMap.get("pwd");
        if (StringUtils.isEmpty((String)ca_password)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8bc1\u4e66\u5bc6\u7801\u4e3a\u7a7a", (String)"GetStore_9", (String)"ebg-receipt-banks-icbc-opa", (Object[])new Object[0]));
        }
        DefaultIcbcClient client = new DefaultIcbcClient(APP_ID, privateKeyMap.get("key"), APIGW_PUBLIC_KEY, publicKey, ca_password);
        return client;
    }

    private static CipherInfo getCipherInfo(String data) {
        AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
        CipherInfo cipherInfo = security.getCipherInfo(data);
        if (cipherInfo.getCipherVersion() == 0) {
            cipherInfo.setFileBytes(java.util.Base64.getDecoder().decode(cipherInfo.getCipherData()));
        } else {
            cipherInfo.setFileBytes(Base64.decodeBase64((String)cipherInfo.getCipherData()));
        }
        return cipherInfo;
    }
}

