/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.impl.handler;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.framework.service.bank.BankLoginService;
import kd.ebg.egf.common.framework.service.bank.BankVersionService;
import kd.ebg.egf.common.model.bank.BankListEntity;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.entity.HandlerType;
import kd.ebg.receipt.business.receipt.entity.ReceiptHandlerRequest;
import kd.ebg.receipt.business.receipt.framework.EBThreadPools;
import kd.ebg.receipt.business.receipt.framework.ScheduleHanlder;
import kd.ebg.receipt.business.receipt.framework.TaskActuator;
import kd.ebg.receipt.business.receipt.framework.TaskFactory;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.BankBundleManager;
import kd.ebg.receipt.common.framework.frame.BankVersion;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.ReceiptSystemProperties;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoService;
import kd.ebg.receipt.common.framework.utils.ReceiptCommonAipUtil;
import kd.ebg.receipt.common.model.receipt.EBCReceiptInfo;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class CreateTaskHandler
extends ScheduleHanlder {
    EBGLogger logger = EBGLogger.getInstance().getLogger(CreateTaskHandler.class);
    private EBCReceiptInfoService ebcReceiptInfoService;

    public CreateTaskHandler(String name) {
        super(name);
    }

    @Override
    public boolean preJob() {
        String customId = RequestContext.get().getTenantId();
        EBContext.setContext((EBContext)EBContext.builder().customID(customId).logBizSeqID(Sequence.genSequence()).logRequestSeqID(Sequence.genSequence()).bizName("receipt").build());
        this.ebcReceiptInfoService = (EBCReceiptInfoService)SpringContextUtil.getBean(EBCReceiptInfoService.class);
        return true;
    }

    @Override
    public void subProcess() {
        this.MDC_Schedule();
        BankLoginService bankLoginService = BankLoginService.getInstance();
        BankVersionService bankVersionService = BankVersionService.getInstance();
        DownloadTaskService receiptDownloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
        BankAcntService bankAcntService = BankAcntService.getInstance();
        BankBundleManager bankBundleManager = BankBundleManager.getInstance();
        String customId = RequestContext.get().getTenantId();
        List bankListEntities = bankVersionService.findByCustomId(customId);
        if (bankListEntities.size() == 0) {
            this.logger.info("\u8be5\u79df\u6237-{}-\u542f\u7528\u7684\u94f6\u884c\u5217\u8868\u4e3a\u7a7a", (Object)customId);
            return;
        }
        List bankLoginList = bankLoginService.getNotDeleteByCustomId(customId);
        if (bankLoginList.size() == 0) {
            this.logger.info("\u8be5\u79df\u6237-{}-\u672a\u914d\u7f6e\u524d\u7f6e\u673a", (Object)customId);
            return;
        }
        HashMap allBankLoginMap = Maps.newHashMapWithExpectedSize((int)8);
        for (BankLogin bankLogin : bankLoginList) {
            Set<String> bankLoginSet = new HashSet<String>();
            if (allBankLoginMap.containsKey(bankLogin.getBankVersionId())) {
                bankLoginSet = (Set)allBankLoginMap.get(bankLogin.getBankVersionId());
            }
            bankLoginSet.add(bankLogin.getKey().getBankLoginId());
            allBankLoginMap.put(bankLogin.getBankVersionId(), bankLoginSet);
        }
        LocalDate startDate = LocalDate.now().minusDays(1L);
        String startDateStr = LocalDateUtil.formatDate((LocalDate)startDate);
        ReceiptSystemProperties systemProperties = (ReceiptSystemProperties)EBConfigBuilder.getInstance().buildConfig(ReceiptSystemProperties.class);
        int createTaskPeriod = systemProperties.getCreateTaskPeriod();
        ArrayList<String> createTaskDateList = new ArrayList<String>(16);
        if (createTaskPeriod > 1) {
            for (int i = 1; i <= createTaskPeriod; ++i) {
                LocalDate transDate = LocalDate.now().minusDays(i);
                String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
                createTaskDateList.add(transDateStr);
            }
        } else {
            createTaskDateList.add(startDateStr);
        }
        for (BankListEntity bankListEntity : bankListEntities) {
            String bankVersionId = bankListEntity.getNumber();
            String enable = bankListEntity.getEnable();
            BankVersion versionInfo = bankBundleManager.getBankVersionInfo(bankVersionId);
            if (Objects.isNull(versionInfo)) {
                this.logger.info("\u8be5\u79df\u6237{}-\u8be5\u94f6\u884c-{}-\u8fd8\u672a\u5f00\u53d1\u56de\u5355\u6a21\u5757", new Object[]{customId, bankVersionId});
                continue;
            }
            if (Objects.equals(enable, "0")) {
                this.logger.info("\u8be5\u79df\u6237-{}-\u672a\u542f\u7528\u8be5\u94f6\u884c-{}", new Object[]{customId, bankVersionId});
                continue;
            }
            if (!allBankLoginMap.containsKey(bankVersionId)) {
                this.logger.info("\u8be5\u79df\u6237-{}-\u8be5\u94f6\u884c-{}-\u672a\u914d\u7f6e\u524d\u7f6e\u673a", new Object[]{customId, bankVersionId});
                continue;
            }
            Set bankLoginSet = (Set)allBankLoginMap.get(bankVersionId);
            this.logger.info("\u8be5\u79df\u6237{}-\u8be5\u94f6\u884c-{}-\u4e00\u5171\u914d\u7f6e\u4e86{}\u4e2a\u524d\u7f6e\u673a", new Object[]{customId, bankVersionId, bankLoginSet.size()});
            List bankAcntList = bankAcntService.selectReconciliationByCustomIdAndBankVersion(customId, bankVersionId);
            if (bankAcntList.size() == 0) {
                this.logger.info("\u8be5\u79df\u6237{}-\u8be5\u94f6\u884c-{}-\u8fd8\u672a\u914d\u7f6e\u56de\u5355\u8d26\u53f7", new Object[]{customId, bankVersionId});
                continue;
            }
            HashMap requestSeqIDMap = Maps.newHashMapWithExpectedSize((int)16);
            for (String transDateStr : createTaskDateList) {
                String requestSeqID;
                LocalDate transDate = LocalDateUtil.parserDate((String)transDateStr);
                EBCReceiptInfo ebcReceiptInfo = this.ebcReceiptInfoService.findByCustomIdAndTransDateAndBankVersionId(customId, transDate, bankVersionId);
                if (ebcReceiptInfo == null) {
                    requestSeqID = receiptDownloadTaskService.getUniqueBatchNoByBankAndDateAndCustomId(bankVersionId, transDate, customId);
                    ReceiptCommonAipUtil.handleReceiptInfo((String)customId, (String)bankVersionId, (String)requestSeqID, (LocalDate)transDate);
                } else {
                    requestSeqID = ebcReceiptInfo.getBatchNo();
                }
                String mapKey = bankVersionId + transDateStr;
                requestSeqIDMap.put(mapKey, requestSeqID);
            }
            EBContext.getContext().setBankVersionID(bankVersionId);
            boolean isSupportTodayReceipt = false;
            String todayRequestSeqID = "";
            boolean isBreak = false;
            for (String bankLoginId : bankLoginSet) {
                EBContext.getContext().setBankLoginID(bankLoginId);
                isSupportTodayReceipt = RequestContextUtils.isSupportTodayByBankLogin((String)bankVersionId, (String)bankLoginId) && Objects.equals(this.name, HandlerType.TODAY_CREATE.getName());
                if (!isBreak && isSupportTodayReceipt) {
                    EBCReceiptInfo ebcReceiptInfo = this.ebcReceiptInfoService.findByCustomIdAndTransDateAndBankVersionId(customId, LocalDate.now(), bankVersionId);
                    if (ebcReceiptInfo == null) {
                        todayRequestSeqID = receiptDownloadTaskService.getUniqueBatchNoByBankAndDateAndCustomId(bankVersionId, LocalDate.now(), customId);
                        ReceiptCommonAipUtil.handleReceiptInfo((String)customId, (String)bankVersionId, (String)todayRequestSeqID, (LocalDate)LocalDate.now());
                    } else {
                        todayRequestSeqID = ebcReceiptInfo.getBatchNo();
                    }
                    isBreak = true;
                }
                if (isSupportTodayReceipt) {
                    this.logger.info("\u8be5\u79df\u6237{}-\u8be5\u94f6\u884c-{} \u652f\u6301\u521b\u5efa\u5f53\u65e5\u56de\u5355", new Object[]{customId, bankVersionId});
                    ReceiptHandlerRequest receiptHandlerRequest = new ReceiptHandlerRequest();
                    receiptHandlerRequest.setBankVersion(bankVersionId);
                    receiptHandlerRequest.setBatchSeqId(todayRequestSeqID);
                    receiptHandlerRequest.setTransDate(LocalDateUtil.formatDate((LocalDate)LocalDate.now()));
                    receiptHandlerRequest.setType(this.name);
                    receiptHandlerRequest.setBankLoginId(bankLoginId);
                    receiptHandlerRequest.setCustomId(customId);
                    TaskActuator task = TaskFactory.getTask((ReceiptHandlerRequest)receiptHandlerRequest);
                    EBThreadPools.getThreadPool((String)this.name, (String)bankLoginId, (String)customId).submit((Callable)task);
                }
                if (!Objects.equals(this.name, HandlerType.CREATE.getName())) continue;
                for (String transDateStr : createTaskDateList) {
                    String mapKey = bankVersionId + transDateStr;
                    String requestSeqID = (String)requestSeqIDMap.get(mapKey);
                    ReceiptHandlerRequest receiptHandlerRequest = new ReceiptHandlerRequest();
                    receiptHandlerRequest.setBankVersion(bankVersionId);
                    receiptHandlerRequest.setBatchSeqId(requestSeqID);
                    receiptHandlerRequest.setTransDate(transDateStr);
                    receiptHandlerRequest.setType(this.name);
                    receiptHandlerRequest.setBankLoginId(bankLoginId);
                    receiptHandlerRequest.setCustomId(customId);
                    TaskActuator task = TaskFactory.getTask((ReceiptHandlerRequest)receiptHandlerRequest);
                    EBThreadPools.getThreadPool((String)this.name, (String)bankLoginId, (String)customId).submit((Callable)task);
                }
            }
        }
        this.logger.info("\u521b\u5efa\u4efb\u52a1\u5904\u7406\u5b8c\u6210-{}", (Object)customId);
    }

    @Override
    public boolean afterJob() {
        EBContext.destroy();
        return true;
    }
}

