/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.impl.task;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.ID;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.business.receipt.entity.HandlerType;
import kd.ebg.receipt.business.receipt.entity.ReceiptHandlerRequest;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.framework.TaskActuator;
import kd.ebg.receipt.common.constant.MatchStatusEnum;
import kd.ebg.receipt.common.constant.TaskStatusEnum;
import kd.ebg.receipt.common.constant.UploadRetryByBankEnum;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.constant.UploadTaskStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.log.MDCUtil;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.AttachServiceUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.MDC;

public class ReceiptUploadTask
extends TaskActuator {
    EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptUploadTask.class);
    private DownloadListDetailService downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    private DownloadTaskService downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    private EBCReceiptInfoJsonService ebcReceiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    private List<DownloadListDetail> jobList;
    private int redoMaxNum = 2;
    private boolean isNeedRetryDownload = false;

    public ReceiptUploadTask(ReceiptHandlerRequest request) {
        super(request);
    }

    public boolean preTask() {
        String redoNum = System.getProperty("receipt.upload.redo");
        try {
            if (!EBGStringUtils.isEmpty((String)redoNum)) {
                this.redoMaxNum = Integer.parseInt(redoNum);
                if (this.redoMaxNum < 1) {
                    this.redoMaxNum = 1;
                }
            }
        }
        catch (Exception e) {
            this.redoMaxNum = 2;
        }
        String bankVersionId = this.receiptHandlerRequest.getBankVersion();
        String bankLoginId = this.receiptHandlerRequest.getBankLoginId();
        String customId = this.receiptHandlerRequest.getCustomId();
        String transDate = this.receiptHandlerRequest.getTransDate();
        String accNo = this.receiptHandlerRequest.getAccNo();
        Long taskId = this.receiptHandlerRequest.getTaskId();
        String loggerBatchNo = Sequence.gen16Sequence();
        EBContext.setContext((EBContext)EBContext.builder().customID(customId).bankLoginID(bankLoginId).bankVersionID(bankVersionId).logBizSeqID(taskId + "").logRequestSeqID(taskId + "").bizName("receipt").loggerBatchNo(taskId + "").loggerDetailNo(loggerBatchNo).loggerBankNo(ID.genLongId() + "").build());
        MDC.put((String)"bankVersion", (String)bankVersionId);
        MDC.put((String)"transDate", (String)transDate);
        EBContext.getContext().setType("upload");
        MDCUtil.initMDC((EBContext)EBContext.getContext());
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setAccNo(accNo);
        EBContext.getContext().setBankAcnt(bankAcnt);
        ArrayList<Integer> uploadStatus = new ArrayList<Integer>(1);
        uploadStatus.add(UploadStatusEnum.UN_UPLOAD.getId());
        this.jobList = this.downloadListDetailService.selectByRefidAndUploadFlag(taskId.toString(), uploadStatus);
        this.logger.info("\u6587\u4ef6\u4e0a\u4f20-\u8d26\u53f7\uff1a{} \u56de\u5355\u65e5\u671f\uff1a{} \u4e0a\u4f20\u603b\u6761\u6570\uff1a{}", new Object[]{accNo, transDate, this.jobList.size()});
        ArrayList<Integer> successUploadStatus = new ArrayList<Integer>(1);
        successUploadStatus.add(UploadStatusEnum.UPLOAD_SUCCESS.getId());
        List successList = this.downloadListDetailService.selectByRefidAndUploadFlag(taskId.toString(), successUploadStatus);
        for (DownloadListDetail downloadListDetail : successList) {
            File successFile = FileCommonUtils.getFileByPath((String)downloadListDetail.getBankFilePath());
            if (!successFile.exists()) continue;
            boolean isDelete = successFile.delete();
            this.logger.info("\u6587\u4ef6\u4e0a\u4f20-\u6587\u4ef6\uff1a{} \u5220\u9664\u662f\u5426\u6210\u529f\uff1a{}", new Object[]{successFile.getName(), isDelete});
        }
        String cacheKey = String.format("upload_key_%s_%s", RequestContext.get().getAccountId(), Long.toString(this.receiptHandlerRequest.getTaskId()));
        CosmicCache.putIfAbsentWithExpire((String)cacheKey, (String)"uploading", (int)6, (TimeUnit)TimeUnit.HOURS);
        return true;
    }

    public boolean afterTask() {
        ArrayList<Integer> uploadStatus = new ArrayList<Integer>(1);
        uploadStatus.add(UploadStatusEnum.UPLOAD_SUCCESS.getId());
        Long taskId = this.receiptHandlerRequest.getTaskId();
        int successCount = this.downloadListDetailService.selectByRefidAndUploadFlag(taskId.toString(), uploadStatus).size();
        int total = 0;
        List detailList = this.downloadListDetailService.selectByRefId(taskId);
        total = detailList.size();
        DownloadListTask downloadListTask = this.downloadTaskService.findById(taskId.longValue());
        int uploadFlag = UploadTaskStatusEnum.UPLOAD_SUCCESS.getId();
        if (total == 0) {
            uploadFlag = UploadTaskStatusEnum.UPLOAD_FAIL.getId();
        } else {
            this.logger.info("\u56de\u5355\u4e0a\u4f20\u7ed3\u679c\uff1a\u603b\u7b14\u6570\uff1a{}-\u6210\u529f\u7b14\u6570\uff1a{}-taskId:{}", new Object[]{total, successCount, taskId});
            int uploadRedo = ((DownloadListDetail)detailList.get(0)).getUploadRedo();
            if (successCount == 0) {
                uploadFlag = uploadRedo <= this.redoMaxNum ? UploadTaskStatusEnum.UN_UPLOAD.getId() : UploadTaskStatusEnum.UPLOAD_FAIL.getId();
            } else {
                if (successCount < total) {
                    uploadFlag = UploadTaskStatusEnum.UPLOAD_PROCESSING.getId();
                }
                if (successCount == total) {
                    uploadFlag = UploadTaskStatusEnum.UPLOAD_SUCCESS.getId();
                }
            }
        }
        if (this.isNeedRetryDownload) {
            uploadFlag = UploadTaskStatusEnum.UN_UPLOAD.getId();
            int taskStatus = UploadRetryByBankEnum.getTaskStatusByBank((String)downloadListTask.getBankVersionId());
            if (taskStatus == TaskStatusEnum.CREATE.getId()) {
                downloadListTask.setStatus(Integer.valueOf(TaskStatus.CREATE.getId()));
                successCount = 0;
                ArrayList<Long> ids = new ArrayList<Long>(16);
                for (DownloadListDetail detail : detailList) {
                    if (!this.isNeedSkip(detail)) {
                        ids.add(detail.getId());
                        continue;
                    }
                    ++successCount;
                }
                this.downloadListDetailService.deleteAll(ids);
                this.ebcReceiptInfoJsonService.deleteByDetailIdList(ids);
            } else {
                ArrayList<DownloadListDetail> updateDetailList = new ArrayList<DownloadListDetail>(detailList.size());
                for (DownloadListDetail detail : detailList) {
                    if (this.isNeedSkip(detail)) continue;
                    detail.setStatus(Integer.valueOf(TaskStatusEnum.COMPLETED.getId()));
                    detail.setUploadFlag(Integer.valueOf(UploadTaskStatusEnum.UN_UPLOAD.getId()));
                    detail.setUploadRedo(0);
                    updateDetailList.add(detail);
                }
                this.downloadListDetailService.updateAll(updateDetailList);
                downloadListTask.setStatus(Integer.valueOf(TaskStatusEnum.COMPLETED.getId()));
            }
        }
        downloadListTask.setUploadFlag(Integer.valueOf(uploadFlag));
        downloadListTask.setUploadNum(Integer.valueOf(successCount));
        this.downloadTaskService.update(downloadListTask);
        MDC.remove((String)"bankVersion");
        MDC.remove((String)"type");
        EBContext.destroy();
        String cacheKey = String.format("upload_key_%s_%s", RequestContext.get().getAccountId(), Long.toString(this.receiptHandlerRequest.getTaskId()));
        CosmicCache.delete((String)cacheKey);
        return true;
    }

    public void updateTaskDetailUploadStatus(DownloadListDetail detail, Integer status) {
        detail.setUploadFlag(status);
        detail.setCompleteTime(LocalDateTime.now());
        this.downloadListDetailService.update(detail);
    }

    public void subProcess() {
        this.logger.info("\u4efb\u52a1\u6267\u884c\u5668\uff1a\u6587\u4ef6\u4e0a\u4f20");
        String parentPath = "";
        int successCount = 0;
        for (DownloadListDetail detail : this.jobList) {
            try {
                String bakFile = detail.getBankFilePath();
                File file = FileCommonUtils.getFileByPath((String)bakFile);
                if (!file.exists()) {
                    this.logger.info("bakFile:{} \u56de\u5355\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u9700\u8981\u91cd\u7f6e\u56de\u5355\u4efb\u52a1\u91cd\u65b0\u4e0b\u8f7d\u56de\u5355\u6587\u4ef6", (Object)bakFile);
                    this.isNeedRetryDownload = true;
                    continue;
                }
                this.updateTaskDetailUploadStatus(detail, UploadStatusEnum.UPLOAD_PROCESSING.getId());
                this.doTask(detail);
                File receiptFile = FileCommonUtils.getFileByPath((String)detail.getBankFilePath());
                if (receiptFile.exists() || !receiptFile.isDirectory()) {
                    boolean isDelete = receiptFile.delete();
                    this.logger.info("\u6587\u4ef6\u662f\u5426\u5220\u9664\uff1a{}-{}", new Object[]{file.getName(), isDelete});
                    parentPath = receiptFile.getParent();
                }
                ++successCount;
            }
            catch (Exception e) {
                int uploadRedo = detail.getUploadRedo();
                if (uploadRedo < this.redoMaxNum) {
                    String message = String.format(ResManager.loadKDString((String)"\u4e0a\u6b21\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"ReceiptUploadTask_7", (String)"ebg-receipt-business", (Object[])new Object[0]), e.getMessage());
                    if (message.length() > 190) {
                        message = message.substring(0, 190);
                    }
                    detail.setUploadExpMsg(message);
                    detail.setUploadRedo(uploadRedo + 1);
                    detail.setModifytime(LocalDateTime.now());
                    this.updateTaskDetailUploadStatus(detail, UploadStatusEnum.UN_UPLOAD.getId());
                    continue;
                }
                if (uploadRedo == this.redoMaxNum) {
                    this.updateTaskDetailUploadStatus(detail, UploadStatusEnum.UPLOAD_FAIL.getId());
                    continue;
                }
                this.logger.error("ID:{}-\u8d26\u53f7\uff1a{}-\u6587\u4ef6\u8def\u5f84\uff1a{}-\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38\uff1a{}", new Object[]{detail.getId(), detail.getAccNo(), detail.getBankFilePath(), e.getMessage()});
            }
        }
        if (this.jobList.size() > 0 && StringUtils.isNotEmpty((String)parentPath)) {
            File parentFile = FileCommonUtils.getFileByPath((String)parentPath);
            if (successCount == this.jobList.size() && parentFile.exists() && parentFile.isDirectory()) {
                boolean isDelete = parentFile.delete();
                this.logger.info("\u6587\u4ef6\u662f\u5426\u5220\u9664\uff1a{}-{}", new Object[]{parentFile.getName(), isDelete});
            }
        }
    }

    public void doTask(DownloadListDetail detail) {
        String uploadedPath = "";
        String customNo = detail.getCustomNo();
        String localRealFilePath = detail.getBankFilePath();
        String fileName = detail.getFileName();
        String accNo = detail.getAccNo();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)detail.getTransDate());
        if (!detail.getCustomNo().startsWith("JDY")) {
            try {
                if (AttachServiceUtil.isUseOpenApi()) {
                    uploadedPath = AttachServiceUtil.uploadFile((String)detail.getBankFilePath(), (String)fileName, (String)detail.getAccNo(), (LocalDate)detail.getTransDate());
                } else {
                    String accessToken = this.getAccessToken(customNo, this.getAppToken(customNo));
                    StringBuilder requestUrlBuilder = new StringBuilder();
                    requestUrlBuilder.append(AttachServiceUtil.getAttachUrlCangqiong());
                    requestUrlBuilder.append("?access_token=");
                    requestUrlBuilder.append(accessToken);
                    requestUrlBuilder.append("&&appId=").append(AttachServiceUtil.getAppIdCangqiong());
                    requestUrlBuilder.append("&&fId=").append("receipt_detail");
                    String path = AttachServiceUtil.getUploadUrl((String)fileName, (String)detail.getAccNo(), (LocalDate)detail.getTransDate());
                    uploadedPath = this.upload(requestUrlBuilder.toString(), path, localRealFilePath, fileName);
                }
            }
            catch (Exception e) {
                this.logger.error("\u4e0a\u4f20\u5931\u8d25-{}-{}", new Object[]{fileName, e.getMessage()});
                throw new ReceiptException((Throwable)e);
            }
            this.logger.info("\u6587\u4ef6{}\u5df2\u7ecf\u4e0a\u4f20,\u8fd4\u56de\u6587\u4ef6\u540d\uff1a{}", new Object[]{localRealFilePath, uploadedPath});
        }
        detail.setUploadFileName(uploadedPath);
        detail.setUploadExpMsg("");
        this.updateTaskDetailUploadStatus(detail, UploadStatusEnum.UPLOAD_SUCCESS.getId());
    }

    public boolean match() {
        return HandlerType.UPLOAD.getName().equals(this.receiptHandlerRequest.getType());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String upload(String requestUrl, String path, String localFilePath, String fileName) {
        this.logger.info("\u6587\u4ef6\u4e0a\u4f20\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)requestUrl);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String uploadedPath = null;
            HttpPost httpPost = new HttpPost(requestUrl);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addBinaryBody("file", FileCommonUtils.getFileByPath((String)localFilePath), ContentType.MULTIPART_FORM_DATA, fileName);
            ContentType contentType = ContentType.create((String)"multipart/form-data", (Charset)Charset.forName("UTF-8"));
            builder.addTextBody("url", path, contentType);
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            String responseStr = EntityUtils.toString((HttpEntity)responseEntity);
            if (!EBGStringUtils.isEmpty((String)responseStr)) {
                this.logger.info("\u4e0a\u4f20\u6587\u4ef6\u54cd\u5e94\u62a5\u6587\uff1a" + responseStr);
                JSONObject jsonObject = JSONObject.parseObject((String)responseStr);
                if ("success".equals(jsonObject.get((Object)"status").toString())) {
                    uploadedPath = jsonObject.get((Object)"url").toString();
                    String string = uploadedPath;
                    return string;
                }
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6:%1$s\u4e0a\u4f20\u5931\u8d25\uff0c\u82cd\u7a79\u8fd4\u56de\u62a5\u6587:%2$s\u3002", (String)"ReceiptUploadTask_8", (String)"ebg-receipt-business", (Object[])new Object[0]), path, jsonObject.toJSONString()));
            }
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6:%s \u4e0a\u4f20\u5931\u8d25\uff0c\u82cd\u7a79\u672a\u8fd4\u56de\u6570\u636e\u3002", (String)"ReceiptUploadTask_9", (String)"ebg-receipt-business", (Object[])new Object[0]), path));
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff1a{}", new Object[]{e.getMessage()});
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff1a%s\u3002", (String)"ReceiptUploadTask_10", (String)"ebg-receipt-business", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    private String getAccessToken(String customNo, String appToken) {
        String accessToken;
        block21: {
            if (EBGStringUtils.isEmpty((String)appToken)) {
                this.getAppToken(customNo);
            }
            String accessTokenKey = customNo + AttachServiceUtil.getAppIdCangqiong() + "access_token";
            try {
                accessToken = CosmicCache.get((String)accessTokenKey);
                if (!EBGStringUtils.isEmpty((String)accessToken)) break block21;
                try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                    HttpPost httpPost = new HttpPost(AttachServiceUtil.getAccessTokenUrlCangqiong());
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("user", (Object)AttachServiceUtil.getUserCangqiong());
                    jsonObject.put("apptoken", (Object)appToken);
                    String accountId = AttachServiceUtil.getCosmicAccountId();
                    if (Objects.nonNull(accountId)) {
                        jsonObject.put("accountId", (Object)accountId);
                    } else {
                        jsonObject.put("accountId", (Object)RequestContext.get().getAccountId());
                    }
                    StringEntity entity = new StringEntity(jsonObject.toString());
                    entity.setContentEncoding("utf-8");
                    entity.setContentType("application/json");
                    httpPost.setEntity((HttpEntity)entity);
                    this.logger.info("\u53d1\u9001\u8bf7\u6c42\u83b7\u53d6AccessToken-\u8bf7\u6c42\u62a5\u6587\uff1a" + jsonObject.toJSONString());
                    this.logger.info("\u53d1\u9001\u8bf7\u6c42\u83b7\u53d6AccessToken\uff1a" + httpPost.getURI());
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                    String result = EntityUtils.toString((HttpEntity)response.getEntity());
                    JSONObject responseJson = JSONObject.parseObject((String)result);
                    JSONObject data = (JSONObject)responseJson.get((Object)"data");
                    if (data != null) {
                        accessToken = data.get((Object)"access_token").toString();
                        CosmicCache.putIfAbsentWithExpire((String)accessTokenKey, (String)accessToken, (int)1800, (TimeUnit)TimeUnit.SECONDS);
                        if (EBGStringUtils.isEmpty((String)accessToken)) {
                            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u82cd\u7a79\u8fd4\u56de\u9519\u8bef\uff1a%s\u3002", (String)"ReceiptUploadTask_11", (String)"ebg-receipt-business", (Object[])new Object[0]), result));
                        }
                        break block21;
                    }
                    throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u82cd\u7a79\u8fd4\u56de\u62a5\u6587\u6ca1data\u6570\u636e %s\u3002", (String)"ReceiptUploadTask_12", (String)"ebg-receipt-business", (Object[])new Object[0]), result));
                }
                catch (Exception e) {
                    this.logger.error("getAccessToken-\u82cd\u7a79\u8fd4\u56de\u9519\u8bef\uff1a{}", new Object[]{e.getMessage()});
                    throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u82cd\u7a79\u8fd4\u56de\u9519\u8bef\uff1a%s\u3002", (String)"ReceiptUploadTask_11", (String)"ebg-receipt-business", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
                }
            }
            catch (Exception e) {
                this.logger.error("\u83b7\u53d6accesstoken\u5f02\u5e38\uff1a{}", new Object[]{e.getMessage()});
                throw new ReceiptException((Throwable)e);
            }
        }
        return accessToken;
    }

    private String getAppToken(String customNo) {
        String appToken;
        block20: {
            String appTokenKey = customNo + AttachServiceUtil.getAppIdCangqiong() + "app_token";
            try {
                appToken = CosmicCache.get((String)appTokenKey);
                if (!EBGStringUtils.isEmpty((String)appToken)) break block20;
                try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                    HttpPost httpPost = new HttpPost(AttachServiceUtil.getAppTokenUrlCangqiong());
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("appId", (Object)AttachServiceUtil.getAppIdCangqiong());
                    jsonObject.put("appSecuret", (Object)AttachServiceUtil.getAppSecuretCangqiong());
                    String accountId = AttachServiceUtil.getCosmicAccountId();
                    if (Objects.nonNull(accountId)) {
                        jsonObject.put("accountId", (Object)accountId);
                    } else {
                        jsonObject.put("accountId", (Object)RequestContext.get().getAccountId());
                    }
                    StringEntity entity = new StringEntity(jsonObject.toString());
                    entity.setContentEncoding("utf-8");
                    entity.setContentType("application/json");
                    httpPost.setEntity((HttpEntity)entity);
                    this.logger.info("\u53d1\u9001\u8bf7\u6c42\u83b7\u53d6AppToken-\u8bf7\u6c42\u62a5\u6587\uff1a" + jsonObject.toJSONString());
                    this.logger.info("\u53d1\u9001\u8bf7\u6c42\u83b7\u53d6AppToken\uff1a" + httpPost.getURI());
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                    String result = EntityUtils.toString((HttpEntity)response.getEntity());
                    JSONObject responseJson = JSONObject.parseObject((String)result);
                    JSONObject data = (JSONObject)responseJson.get((Object)"data");
                    if (data != null) {
                        appToken = data.get((Object)"app_token").toString();
                        CosmicCache.putIfAbsentWithExpire((String)appTokenKey, (String)appToken, (int)60, (TimeUnit)TimeUnit.MINUTES);
                        if (EBGStringUtils.isEmpty((String)appToken)) {
                            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u82cd\u7a79\u8fd4\u56de\u9519\u8bef\uff1a%s\u3002", (String)"ReceiptUploadTask_11", (String)"ebg-receipt-business", (Object[])new Object[0]), result));
                        }
                        break block20;
                    }
                    throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u82cd\u7a79\u8fd4\u56de\u62a5\u6587\u6ca1data\u6570\u636e %s\u3002", (String)"ReceiptUploadTask_12", (String)"ebg-receipt-business", (Object[])new Object[0]), responseJson));
                }
                catch (Exception e) {
                    this.logger.error("\u83b7\u53d6apptoken-\u82cd\u7a79\u8fd4\u56de\u9519\u8bef\uff1a{}", new Object[]{e.getMessage()});
                    throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u82cd\u7a79\u8fd4\u56de\u9519\u8bef\uff1a%s\u3002", (String)"ReceiptUploadTask_11", (String)"ebg-receipt-business", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
                }
            }
            catch (Exception e) {
                this.logger.error("\u83b7\u53d6apptoken\u5f02\u5e38\uff1a{}", new Object[]{e.getMessage()});
                throw new ReceiptException((Throwable)e);
            }
        }
        return appToken;
    }

    private boolean isNeedSkip(DownloadListDetail downloadListDetail) {
        return downloadListDetail.getMatchFlag().intValue() == MatchStatusEnum.SUCCESS.getId() && downloadListDetail.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId();
    }
}

