/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.query;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.model.data.Sort;
import kd.ebg.receipt.business.receipt.atom.IReceipt;
import kd.ebg.receipt.business.receipt.bank.ReceiptInfo;
import kd.ebg.receipt.business.receipt.bank.ReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.ReceiptResponseEB;
import kd.ebg.receipt.business.receipt.query.FileReceiptPage;
import kd.ebg.receipt.business.receipt.query.ReceiptResult;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.model.repository.receipt.DownloadListDetailRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class FileReceiptImpl
implements IReceipt {
    private DownloadListDetailRepository downloadListDetailRepository;
    private DownloadTaskService downloadTaskService;

    public boolean needLock() {
        return false;
    }

    public String getDeveloper() {
        return "Jimmy";
    }

    public String getBizCode() {
        return "EBGFileReceipt";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u901a\u8fc7\u94f6\u4f01\u5e73\u53f0\u56de\u5355\u7a0b\u5e8f\u83b7\u53d6\u6587\u4ef6\u56de\u5355\u7d22\u5f15\u3002", (String)"FileReceiptImpl_0", (String)"ebg-receipt-business", (Object[])new Object[0]);
    }

    public ReceiptResponseEB doBiz(ReceiptRequest request) {
        if ("receiptPage".equals(request.getHeader().getSubBizType())) {
            return new FileReceiptPage().doBiz(request);
        }
        ReceiptResponseEB responseEB = new ReceiptResponseEB();
        this.downloadListDetailRepository = (DownloadListDetailRepository)SpringContextUtil.getBean(DownloadListDetailRepository.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
        String accNo = request.getAccNo();
        String bankVersionID = request.getHeader().getBankVersionID();
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        String customID = EBContext.getContext().getCustomID();
        String fixedAccNo = accNo;
        List downloadListTasks = this.downloadTaskService.findBybankVersionAndCustomNoAndQueryDateBetweenOrderByFileNumDesc(bankVersionID, customID, startDate, endDate);
        ArrayList<DownloadListDetail> detailList = new ArrayList<DownloadListDetail>(16);
        HashMap transDateMap = Maps.newHashMapWithExpectedSize((int)8);
        ArrayList<Long> refIDs = new ArrayList<Long>(16);
        for (DownloadListTask info : downloadListTasks) {
            ReceiptResult result = new ReceiptResult();
            result.setCompleteFlas(Integer.valueOf(1));
            result.setTransDate(info.getTransDate());
            result.setRefID(Long.valueOf(info.getId()));
            refIDs.add(info.getId());
            transDateMap.put(info.getId(), info.getTransDate());
        }
        Sort sort = Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "id")});
        List downloadListDetails = this.downloadListDetailRepository.findByRefidInAndAccNo(refIDs, fixedAccNo);
        for (DownloadListDetail detail : downloadListDetails) {
            detailList.add(detail);
        }
        ArrayList<DownloadListDetail> newDetailList = new ArrayList<DownloadListDetail>(16);
        newDetailList.addAll(detailList);
        detailList.clear();
        detailList.addAll(this.removeRepeat(newDetailList));
        ArrayList<ReceiptInfo> bankReceiptInfos = new ArrayList<ReceiptInfo>(16);
        boolean isFileReceipt = RequestContextUtils.receiptFormatIsFile();
        if (newDetailList.size() > 0) {
            for (DownloadListDetail detail : downloadListDetails) {
                if (detail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId()) continue;
                ReceiptInfo info = new ReceiptInfo();
                if (isFileReceipt) {
                    info.setReceiptNo(detail.getDetailNo());
                    info.setFilePath(detail.getBankFilePath());
                    info.setTransDate(((LocalDate)transDateMap.get(detail.getRefid())).format(DateTimeFormatter.BASIC_ISO_DATE));
                    info.setAccNo(request.getAccNo());
                    info.setAccName(EBContext.getContext().getBankAcnt().getAccName());
                    info.setBankName(EBContext.getContext().getBankAcnt().getBankName());
                    info.setExplanation(ResManager.loadKDString((String)"\u6587\u4ef6\u7c7b\u7684\u56de\u5355\uff0c\u8bf7\u67e5\u9605\u56de\u5355\u6587\u4ef6\u5185\u5bb9\u3002", (String)"FileReceiptImpl_1", (String)"ebg-receipt-business", (Object[])new Object[0]));
                    info.setBankName(detail.getBankName());
                    info.setOppAccNo(detail.getOppAccNo());
                    info.setOppAccName(detail.getOppAccName());
                    info.setDebitAmount(detail.getDebitAmount());
                    info.setCreditAmount(detail.getCreditAmount());
                    info.setCurrency(detail.getCurrency());
                    info.setUseCn(detail.getUseCN());
                    String uploadFileName = detail.getUploadFileName();
                    if (!EBGStringUtils.isEmpty((String)uploadFileName)) {
                        info.setUploadFileName(uploadFileName);
                    }
                    info.setUploadFlag(detail.getUploadFlag().intValue());
                } else {
                    info = (ReceiptInfo)JSONObject.parseObject((String)detail.getOfdJson(), ReceiptInfo.class);
                }
                bankReceiptInfos.add(info);
            }
        }
        responseEB.setReceiptInfos(bankReceiptInfos);
        responseEB.setTcpUrl("");
        responseEB.setFileServerUrl("");
        responseEB.setUserName("");
        if (isFileReceipt) {
            responseEB.setFileFlag(1);
        } else {
            responseEB.setFileFlag(0);
            responseEB.setCompleteFlag(0);
        }
        responseEB.setCompleteFlag(1);
        responseEB.setUserName("");
        responseEB.setTotalCount((long)bankReceiptInfos.size());
        return responseEB;
    }

    public boolean match(ReceiptRequest receiptRequest) {
        boolean result = "receipt".equalsIgnoreCase(receiptRequest.getHeader().getBizType()) || "receiptPage".equalsIgnoreCase(receiptRequest.getHeader().getBizType()) || "receipt".equalsIgnoreCase(receiptRequest.getHeader().getSubBizType()) || "receiptPage".equalsIgnoreCase(receiptRequest.getHeader().getSubBizType());
        return result;
    }

    public List<DownloadListDetail> removeRepeat(List<DownloadListDetail> receiptDetails) {
        ArrayList<DownloadListDetail> newReceiptDatails = new ArrayList<DownloadListDetail>(16);
        newReceiptDatails.addAll(receiptDetails);
        ArrayList<String> detailNoList = new ArrayList<String>(16);
        for (DownloadListDetail receiptDetail : receiptDetails) {
            if (detailNoList.contains(receiptDetail.getDetailNo())) {
                newReceiptDatails.remove(receiptDetail);
                continue;
            }
            detailNoList.add(receiptDetail.getDetailNo());
        }
        return newReceiptDatails;
    }
}

