/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.citicb.dc.service.receipt;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.citicb.dc.service.receipt.CITICBDCCommConfig;
import kd.ebg.receipt.banks.citicb.dc.service.receipt.CITICBDCFileParser;
import kd.ebg.receipt.banks.citicb.dc.service.receipt.api.BankReceiptInfoRequestImpl;
import kd.ebg.receipt.banks.citicb.dc.service.receipt.util.CiticbFileInfo;
import kd.ebg.receipt.banks.citicb.dc.service.receipt.util.ReceiptDetailUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankLoginProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import org.jdom2.Document;
import org.jdom2.Element;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;
    private static final String TRANSCODE = "DLEDDRSQ";
    private static final String SUCCESS = "AAAAAAA";
    private int pageSize = 9;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest bankReceiptHandleRequest) {
        List<CiticbFileInfo> fileInfos;
        String response;
        this.init(bankReceiptHandleRequest);
        long taskId = bankReceiptHandleRequest.getTaskId();
        DownloadListTask task = this.downloadTaskService.findById(taskId);
        ArrayList<Object> result = new ArrayList<Object>(16);
        String accNo = task.getAccNo();
        String bankLogin = EBContext.getContext().getBankLoginID();
        int startNo = 1;
        boolean hasNext = false;
        int count = 0;
        BankLoginProperties loginProperties = (BankLoginProperties)EBConfigBuilder.getInstance().buildConfig(BankLoginProperties.class, bankLogin);
        String host = loginProperties.getIp();
        int port = loginProperties.getPort();
        String requestURL = "http://" + host + ":" + port;
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        HashMap existList = Maps.newHashMapWithExpectedSize((int)16);
        for (DownloadListDetail detail : downloadListDetails) {
            String fileName = detail.getFileName();
            CITICBDCFileParser citicbdcFileParser = new CITICBDCFileParser();
            citicbdcFileParser.setFileName(fileName);
            String transNo = citicbdcFileParser.getReceiptNo();
            String cdFlag = citicbdcFileParser.getCdFlag();
            existList.put(String.format("%s-%s", transNo, cdFlag), detail);
        }
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        String receiptType = "pdf";
        CITICBDCCommConfig config = (CITICBDCCommConfig)EBConfigBuilder.getInstance().buildConfig(CITICBDCCommConfig.class, bankLogin);
        if (Objects.equals("OFD", config.getReceiptFileType())) {
            receiptType = "ofd";
        }
        do {
            String request = this.getRequestXml(accNo, task.getTransDate(), startNo, config);
            BankReceiptRequest receiptRequest = BankReceiptRequest.builder().requestStr(request).build();
            BankReceiptInfoRequestImpl iBankReceipt = new BankReceiptInfoRequestImpl();
            response = (String)((BankReceiptResponseEB)iBankReceipt.doBiz((BankRequest)receiptRequest)).getData();
            fileInfos = this.parseFileInfo(response, accNo, task.getTransDate());
            for (CiticbFileInfo info : fileInfos) {
                StringBuilder newFileBuilder;
                String receiptNo;
                ++startNo;
                StringBuilder builder = new StringBuilder();
                builder.append(task.getAccNo()).append("-").append(task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE)).append("-").append(info.getReceiptNo()).append("-").append(info.getCreditDebitFlag()).append(".").append(receiptType);
                String fileName = builder.toString();
                if (Objects.equals(info.getBizType(), "400000")) {
                    receiptNo = "e";
                    newFileBuilder = new StringBuilder();
                    newFileBuilder.append(task.getAccNo()).append("-").append(task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE)).append("-").append(receiptNo).append("-").append(info.getCreditDebitFlag()).append("-");
                    newFileBuilder.append(info.getAmount()).append(".").append(receiptType);
                    fileName = newFileBuilder.toString();
                }
                if (countMap.containsKey(fileName)) {
                    Integer recount = (Integer)countMap.get(fileName);
                    recount = recount + 1;
                    newFileBuilder = new StringBuilder();
                    fileName = fileName.replace("." + receiptType, "");
                    newFileBuilder.append(fileName).append("-");
                    newFileBuilder.append(recount).append(".").append(receiptType);
                    countMap.put(fileName, recount);
                    fileName = newFileBuilder.toString();
                } else {
                    countMap.put(fileName, 0);
                }
                receiptNo = info.getReceiptNo();
                String cdFlag = info.getCreditDebitFlag();
                String transNo = String.format("%s-%s", receiptNo, cdFlag);
                if (!existList.containsKey(transNo)) {
                    DownloadListDetail detail = new DownloadListDetail();
                    detail.setFileLink(ReceiptDetailUtil.getMixReceiptInfo((String)task.getAccNo(), (String)info.getFileName(), (String)info.getReceiptNo()));
                    detail.setFileName(fileName);
                    detail.setTransDate(task.getTransDate());
                    result.add(detail);
                    continue;
                }
                result.add(existList.get(transNo));
            }
        } while (hasNext = this.parseNext(response, count += fileInfos.size()));
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-citicb-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    private String getRequestXml(String accNo, LocalDate transDate, int startNo, CITICBDCCommConfig config) {
        String userId = config.getReceipFitchList_userId();
        Element root = JDomExtUtils.createRoot((String)"stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)TRANSCODE);
        JDomUtils.addChild((Element)root, (String)"userName", (String)userId);
        String now = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String tDate = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)root, (String)"qryType", (String)(now.equals(tDate) ? "1" : "2"));
        JDomUtils.addChild((Element)root, (String)"accNo", (String)accNo);
        JDomUtils.addChild((Element)root, (String)"billType", (String)"0");
        JDomUtils.addChild((Element)root, (String)"minAmt", (String)"-99999999999.99");
        JDomUtils.addChild((Element)root, (String)"maxAmt", (String)"9999999999999.99");
        JDomUtils.addChild((Element)root, (String)"startDate", (String)transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)root, (String)"endDate", (String)transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)root, (String)"pageSize", (String)String.valueOf(this.pageSize));
        JDomUtils.addChild((Element)root, (String)"startNo", (String)String.valueOf(startNo));
        return JDomExtUtils.doc2StrGBK((Document)new Document(root));
    }

    private List<CiticbFileInfo> parseFileInfo(String bankRsp, String accNo, LocalDate transDate) {
        ArrayList<CiticbFileInfo> result = new ArrayList<CiticbFileInfo>(16);
        Element root = JDomExtUtils.str2DocGBK((String)bankRsp).getRootElement();
        String status = JDomExtUtils.getChildText((Element)root, (String)"status");
        String statusText = JDomExtUtils.getChildText((Element)root, (String)"statusText");
        if (SUCCESS.equalsIgnoreCase(status)) {
            Element list = JDomExtUtils.getChildElement((Element)root, (String)"list");
            List elements = list.getChildren("row");
            for (Element e : elements) {
                String bresqNo = JDomExtUtils.getChildText((Element)e, (String)"brseqNo");
                String billType = JDomExtUtils.getChildText((Element)e, (String)"billType");
                String payerAccNo = JDomExtUtils.getChildText((Element)e, (String)"payerAccNo");
                String payeeAccNo = JDomExtUtils.getChildText((Element)e, (String)"payeeAccNo");
                String tranAmt = JDomExtUtils.getChildText((Element)e, (String)"tranAmt");
                boolean isTodayReceipt = transDate.isEqual(LocalDate.now());
                if (EBGStringUtils.isEmpty((String)bresqNo)) continue;
                CiticbFileInfo info = new CiticbFileInfo();
                info.setReceiptNo(bresqNo);
                info.setFileName(billType);
                info.setBizType(billType);
                info.setAmount(tranAmt);
                if (accNo.equals(payeeAccNo)) {
                    info.setCreditDebitFlag("C");
                    info.setOppAccNo(payerAccNo);
                } else if (accNo.equals(payerAccNo)) {
                    info.setCreditDebitFlag("D");
                    info.setOppAccNo(payeeAccNo);
                }
                if (isTodayReceipt) {
                    String cdFg = JDomExtUtils.getChildText((Element)e, (String)"cdfg");
                    info.setCreditDebitFlag(cdFg);
                }
                result.add(info);
            }
        } else {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u8c03\u7528DLEDDRSQ\u63a5\u53e3\u83b7\u53d6\u5230\u94f6\u884c\u8fd4\u56de\u7684\u9519\u8bef\u62a5\u6587\uff0c\u94f6\u884c\u8fd4\u56de\u7801[%1$s]\uff1a%2$s\u3002", (String)"BankReceiptFetchListImpl_3", (String)"ebg-receipt-banks-citicb-dc", (Object[])new Object[0]), status, statusText));
        }
        return result;
    }

    private boolean parseNext(String bankRsp, int count) {
        boolean flag = false;
        Element root = JDomExtUtils.str2DocGBK((String)bankRsp).getRootElement();
        String status = JDomExtUtils.getChildText((Element)root, (String)"status");
        if (SUCCESS.equalsIgnoreCase(status)) {
            String totalCountStr = JDomExtUtils.getChildText((Element)root, (String)"totalCount");
            int totalCount = Integer.parseInt(totalCountStr);
            flag = count < totalCount;
        }
        return flag;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CITICB_DC_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u4e2d\u4fe1\u94f6\u884c\u76f4\u8054\u7248\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_2", (String)"ebg-receipt-banks-citicb-dc", (Object[])new Object[0]);
    }
}

