/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.zsb.opa.service.detail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.czb.sap.sdk.ServiceBean;
import com.czb.sap.sdk.inf.ApiHeader;
import com.czb.sap.sdk.inf.ApiRspData;
import com.czb.sap.sdk.inf.DownloadFileIn;
import com.czb.sap.sdk.inf.DownloadFileOut;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.FetchTokenUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.banks.zsb.opa.ZsbOpaMetaDataImpl;
import kd.ebg.receipt.banks.zsb.opa.utils.SdkInit;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.utils.FileCommonUtils;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public EBBankDetailResponse detail(BankDetailRequest request) {
        return this.processDetail(request);
    }

    private EBBankDetailResponse processDetail(BankDetailRequest request) {
        SdkInit.init();
        ApiHeader header = new ApiHeader();
        header.setMsgtype("yqwfw_qryAccountingDetails");
        header.setTraceno(Sequence.genSequence());
        String token = FetchTokenUtils.getToken();
        header.setToken(token);
        HashMap<String, String> body = new HashMap<String, String>(5);
        body.put("startDate", request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        body.put("endDate", request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        body.put("accNo", request.getAcnt().getAccNo());
        this.logger.info("\u6d59\u5546sdk\u660e\u7ec6\u8bf7\u6c42\u6d41\u6c34\u53f7:{}", (Object)header.getTraceno());
        this.logger.info("\u6d59\u5546sdk\u660e\u7ec6\u8bf7\u6c42\u53c2\u6570:{}", body);
        String rsp = "";
        try {
            ApiRspData data = ServiceBean.getService((String)SdkInit.getTenantKey()).invoke(header, body);
            rsp = JSON.toJSONString((Object)data);
            if (!"000000".equalsIgnoreCase(data.getResultcode())) {
                SdkInit.checkToken(token);
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u94f6\u884cSDK\u5931\u8d25" + e.getMessage(), (Throwable)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8c03\u7528\u94f6\u884cSDK\u5931\u8d25", (String)"DetailImpl_0", (String)"ebg-receipt-banks-zsb-opa", (Object[])new Object[0]), (Throwable)e);
        }
        this.logger.info("\u6d59\u5546\u660e\u7ec6\u8bf7\u6c42\u8fd4\u56de\u62a5\u6587\uff1a" + rsp);
        return this.parse(request, rsp);
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        return null;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String rspStr) {
        JSONObject root = JSONObject.parseObject((String)rspStr);
        String statusCode = root.getString("resultcode");
        String statusDesc = root.getString("resultdesc");
        if ("10011".equalsIgnoreCase(statusCode)) {
            return new EBBankDetailResponse((List)Lists.newArrayList());
        }
        if (!"000000".equalsIgnoreCase(statusCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801:%1$s \u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"DetailImpl_4", (String)"ebg-receipt-banks-zsb-opa", (Object[])new Object[0]), statusCode, statusDesc));
        }
        JSONObject jsonBody = root.getJSONObject("body");
        String field = jsonBody.getString("detailFileName");
        int totalNum = jsonBody.getIntValue("totalNum");
        if (totalNum == 0) {
            this.logger.info("\u5f53\u5929\u6ca1\u6709\u4ea4\u6613\u660e\u7ec6\u3002");
            return new EBBankDetailResponse((List)Lists.newArrayList());
        }
        if (StringUtils.isEmpty((String)field)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u8d26\u52a1\u660e\u7ec6\u6587\u4ef6\u6807\u8bc6\u4e3a\u7a7a\u3002", (String)"DetailImpl_2", (String)"ebg-receipt-banks-zsb-opa", (Object[])new Object[0]));
        }
        ArrayList<DetailInfo> list = new ArrayList<DetailInfo>(10);
        try {
            File file;
            String tempBakFilePath;
            Thread.sleep(DetailImpl.getWaiting4DataTime(totalNum));
            DownloadFileIn downFile = new DownloadFileIn();
            downFile.setTraceno(Sequence.genSequence());
            downFile.setFileid(field);
            DownloadFileOut downOut = ServiceBean.getService((String)SdkInit.getTenantKey()).downloadFile(downFile);
            this.logger.info("\u6587\u4ef6\u5185\u5bb9\uff1a" + JSONObject.toJSONString((Object)downOut));
            String savePath = tempBakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"ZSB_OPA", (String)bankDetailRequest.getAcnt().getAccNo(), (String)"Temp");
            File filePath = FileCommonUtils.getFileByPath((String)savePath);
            if (!filePath.exists()) {
                filePath.mkdirs();
            }
            if (!(file = FileCommonUtils.getFileByPath((String)(tempBakFilePath + File.separator + Sequence.gen16NumSequence() + ".txt"))).exists()) {
                boolean newFile = file.createNewFile();
                this.logger.info("\u4fdd\u5b58\u6587\u4ef6\uff1a{}", (Object)newFile);
            }
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(downOut.getBody(), 0, downOut.getBody().length);
                BankAcnt acnt = bankDetailRequest.getAcnt();
                try (InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                     BufferedReader bufr = new BufferedReader(in);){
                    String str;
                    while ((str = bufr.readLine()) != null) {
                        String[] strs = str.split(",");
                        if (strs.length <= 10) continue;
                        DetailInfo info = new DetailInfo();
                        info.setAccNo(acnt.getAccNo());
                        info.setAccName(acnt.getAccName());
                        info.setBankName(acnt.getBankName());
                        info.setCurrency(strs[8].replaceAll("\"", ""));
                        info.setBalance(new BigDecimal(strs[2].replaceAll("\"", "")));
                        info.setOppAccNo(strs[3].replaceAll("\"", ""));
                        info.setOppAccName(strs[4].replaceAll("\"", ""));
                        info.setOppBankName(strs[6].replaceAll("\"", ""));
                        String flag = strs[7].replaceAll("\"", "");
                        info.setPayBankDetailSeqID(strs[10].replaceAll("\"", ""));
                        info.setReversed1(strs[9].replaceAll("\"", ""));
                        info.setKdFlag(flag);
                        list.add(info);
                    }
                }
            }
        }
        catch (Throwable e) {
            this.logger.error("\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5f02\u5e38" + e.getMessage(), e);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6d59\u5546\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5f02\u5e38%s\u3002", (String)"DetailImpl_5", (String)"ebg-receipt-banks-zsb-opa", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        return new EBBankDetailResponse(list);
    }

    private static long getWaiting4DataTime(int total) {
        String value = RequestContextUtils.getBankParameterValue((String)ZsbOpaMetaDataImpl.waiting4Data);
        if (total >= 1500) {
            value = String.valueOf(300000);
        }
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            return 500L;
        }
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "yqwfw_qryAccountingDetails";
    }

    public String getBizDesc() {
        return null;
    }
}

