/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.zsb.opa.service.receipt;

import com.google.common.collect.Maps;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.zsb.opa.service.receipt.api.DownloadBankReceiptFile;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"ZSB_OPA", (String)accNo, (String)transDateStr);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        for (DownloadListDetail detail : downloadListDetails) {
            String receiptFileName = detail.getFileLink();
            String fileName = detail.getFileName();
            File receiptFile = FileCommonUtils.getFileByPath((String)bakFilePath, (String)fileName);
            if (receiptFile.exists() || detail.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId()) {
                result.add(detail);
                continue;
            }
            try {
                DownloadBankReceiptFile downloadBankReceiptFile = new DownloadBankReceiptFile();
                HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
                paramMap.put("receiptFileName", receiptFileName);
                paramMap.put("fileName", fileName);
                BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).paramsMap((Map)paramMap).build();
                BankReceiptResponseEB bankReceiptResponseEB = downloadBankReceiptFile.doBiz(bankReceiptRequest);
                if (!Objects.equals(bankReceiptResponseEB.getCode(), BankReceiptResponseEB.ResultEnum.SUCCESS.getCode())) continue;
                result.add(detail);
            }
            catch (Throwable e) {
                logger.error("\u56de\u5355\u6587\u4ef6\u540d\uff1a{}-\u4e0b\u8f7d\u5931\u8d25\uff1a{}", new Object[]{fileName, e.getMessage()});
            }
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-zsb-opa", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "ZSB_OPA_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d", (String)"BankReceiptDownloadImpl_1", (String)"ebg-receipt-banks-zsb-opa", (Object[])new Object[0]);
    }
}

