/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.zsb.opa.service.receipt.api;

import com.czb.sap.sdk.ServiceBean;
import com.czb.sap.sdk.inf.DownloadFileIn;
import com.czb.sap.sdk.inf.DownloadFileOut;
import java.io.File;
import java.time.LocalDate;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.FetchTokenUtils;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.zsb.opa.utils.SdkInit;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.utils.FileCommonUtils;

public class DownloadBankReceiptFile
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DownloadBankReceiptFile.class);

    public BankReceiptResponseEB doBiz(BankReceiptRequest request) {
        String accNo = request.getAccNo();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)request.getTransDate());
        Map paramMap = request.getParamsMap();
        String receiptFileName = (String)paramMap.get("receiptFileName");
        String fileName = (String)paramMap.get("fileName");
        return this.process(accNo, transDateStr, receiptFileName, fileName);
    }

    private BankReceiptResponseEB process(String accNo, String transDateStr, String receiptFileName, String fileName) {
        SdkInit.init();
        String traceNo = Sequence.genSequence();
        DownloadFileIn fileIn = new DownloadFileIn();
        fileIn.setTraceno(traceNo);
        fileIn.setFileid(receiptFileName);
        String token = FetchTokenUtils.getToken();
        fileIn.setToken(token);
        DownloadFileOut fdout = ServiceBean.getService((String)SdkInit.getTenantKey()).downloadFile(fileIn);
        String orgmsgid = fdout.getOrgmsgid();
        String fdcode = fdout.getResultcode();
        String fddesc = fdout.getResultdesc();
        if (!fdcode.equals("000000")) {
            SdkInit.checkToken(token);
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u6d59\u5546\u65e0\u524d\u7f6e\u673a\u7248\u4e0b\u8f7d\u56de\u5355\u6587\u4ef6\u8fd4\u56de\u7801 = %1$s\uff0c\u8bf7\u6c42\u5931\u8d25\uff0c\u8fd4\u56de\u94f6\u884c\u63cf\u8ff0 = %2$s\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u3002", (String)"DownloadBankReceiptFile_2", (String)"ebg-receipt-banks-zsb-opa", (Object[])new Object[0]), fdcode, fddesc));
        }
        byte[] file = fdout.getBody();
        this.logger.info("\u6d59\u5546\u65e0\u524d\u7f6e\u673a\u7248\u65b0\u6587\u4ef6\u540d = " + fileName);
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"ZSB_OPA", (String)accNo, (String)transDateStr);
        String filePath = bakFilePath + File.separator + fileName;
        boolean flag = FileCommonUtils.write2File((byte[])file, (String)filePath);
        if (flag) {
            return BankReceiptResponseEB.success();
        }
        return BankReceiptResponseEB.fail();
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        return null;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "yqwfw_qryReceiptInfo";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d", (String)"DownloadBankReceiptFile_1", (String)"ebg-receipt-banks-zsb-opa", (Object[])new Object[0]);
    }
}

