/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.njb.dc.service.receipt.api;

import java.time.LocalDate;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.njb.dc.service.receipt.GLBPacker;
import kd.ebg.receipt.banks.njb.dc.service.receipt.NJBDCCommConfig;
import kd.ebg.receipt.banks.njb.dc.service.receipt.TCommon;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import org.jdom2.Element;

public class DownloadBankReceiptImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DownloadBankReceiptImpl.class);

    public String pack(BankReceiptRequest bankReceiptRequest) {
        String bankLoginID = bankReceiptRequest.getHeader().getBankLoginID();
        Element root = GLBPacker.getHeadPackerData((String)"800191", (String)"0", (String)bankLoginID);
        Element body = new Element("body");
        Map params = bankReceiptRequest.getParamsMap();
        String transName = (String)params.get("trans_name");
        String trans_amt = (String)params.get("trans_amt");
        String host_serial_no = (String)params.get("host_serial_no");
        String trans_no = (String)params.get("trans_no");
        String cust_acno = (String)params.get("cust_acno");
        String accname = (String)params.get("accname");
        String open_org = (String)params.get("open_org");
        JDomUtils.addChild((Element)body, (String)"trans_date", (String)((String)params.get("trans_date")));
        JDomUtils.addChild((Element)body, (String)"trans_time", (String)((String)params.get("trans_time")));
        JDomUtils.addChild((Element)body, (String)"AccType", (String)"1");
        JDomUtils.addChild((Element)body, (String)"trans_name", (String)transName);
        JDomUtils.addChild((Element)body, (String)"trans_amt", (String)trans_amt);
        JDomUtils.addChild((Element)body, (String)"crdr_flag", (String)((String)params.get("crdr_flag")));
        JDomUtils.addChild((Element)body, (String)"host_serial_no", (String)host_serial_no);
        JDomUtils.addChild((Element)body, (String)"trans_no", (String)trans_no);
        JDomUtils.addChild((Element)body, (String)"cust_acno", (String)cust_acno);
        JDomUtils.addChild((Element)body, (String)"accname", (String)accname);
        JDomUtils.addChild((Element)body, (String)"open_org", (String)open_org);
        LocalDate date = bankReceiptRequest.getTransDate();
        if (date != null && date.isBefore(LocalDate.now())) {
            NJBDCCommConfig njbDCCommConfig = (NJBDCCommConfig)EBConfigBuilder.getInstance().buildConfig(NJBDCCommConfig.class, EBContext.getContext().getBankLoginID());
            if (Objects.equals(njbDCCommConfig.getIsForcePrint(), "true")) {
                JDomUtils.addChild((Element)body, (String)"flag", (String)"1");
            } else {
                JDomUtils.addChild((Element)body, (String)"flag", (String)"0");
            }
        } else {
            JDomUtils.addChild((Element)body, (String)"flag", (String)"0");
        }
        JDomUtils.addChild((Element)root, (Element)body);
        String ret = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return TCommon.createCommonMsg((String)ret);
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        Element root = JDomUtils.string2Root((String)TCommon.parseRecvMsg((String)s), (String)RequestContextUtils.getCharset());
        Element head = root.getChild("head");
        String retCode = head.getChildText("ret_code");
        String succFlag = head.getChildText("succ_flag");
        if ("0000".equalsIgnoreCase(retCode) && "0".equalsIgnoreCase(succFlag)) {
            Element body = root.getChild("body");
            String stat = body.getChildTextTrim("stat");
            if ("9".equalsIgnoreCase(stat)) {
                String fileName = body.getChildTextTrim("file_name");
                return BankReceiptResponseEB.success((Object)fileName);
            }
        } else {
            String ret_info = head.getChildText("ret_info");
            String ext_info = head.getChildText("ext_info");
            String resMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u5f02\u5e38\uff0c\u5f02\u5e38\u8fd4\u56de\u7801\uff1a%1$s\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%2$s\uff0c\u9644\u52a0\u5f02\u5e38\u4fe1\u606f%3$s\u3002", (String)"DownloadBankReceiptImpl_4", (String)"ebg-receipt-banks-njb-dc", (Object[])new Object[0]), retCode, ret_info, ext_info);
            throw EBExceiptionUtil.serviceException((String)resMsg);
        }
        return BankReceiptResponseEB.success();
    }

    public String getDeveloper() {
        return "cqc";
    }

    public String getBizCode() {
        return "800191";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u94f6\u4f01\u4e0b\u8f7d\u56de\u5355\u6587\u4ef6\u3002", (String)"DownloadBankReceiptImpl_3", (String)"ebg-receipt-banks-njb-dc", (Object[])new Object[0]);
    }
}

