/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bjb.opa.service.receipt.fetch;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.bjb.opa.service.receipt.api.ReceiptDetailImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "RECEIPT_FETCHLIST";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)request.getBankVersionId(), (String)accNo, (String)transDateStr);
        ReceiptDetailImpl receiptDetail = new ReceiptDetailImpl();
        List detailInfoList = receiptDetail.queryTransDetail(accNo, transDate, transDate);
        if (detailInfoList.isEmpty()) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u6ca1\u6709\u56de\u5355\u8bb0\u5f55", (String)"ReceiptFetchListImpl_0", (String)"ebg-receipt-banks-bjb-opa", (Object[])new Object[0]));
        }
        for (DetailInfo detailInfo : detailInfoList) {
            String receiptNo = detailInfo.getReceiptNo();
            String serialNo = detailInfo.getBankSerialNo();
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            StringBuilder receiptName = new StringBuilder();
            receiptName.append(accNo).append("_");
            receiptName.append(transDateStr).append("_");
            receiptName.append(serialNo).append("_");
            receiptName.append(receiptNo).append(".pdf");
            String oldReceiptName = receiptNo + ".pdf";
            downloadListDetail.setFileLink(oldReceiptName);
            downloadListDetail.setFileName(receiptName.toString());
            downloadListDetail.setFileLink(oldReceiptName);
            downloadListDetail.setReceiptJson(detailInfo.getJson());
            result.add(downloadListDetail);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public boolean isBreak() {
        return true;
    }
}

