/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.jxb.dc.service.receipt.fetch;

import com.google.common.collect.Maps;
import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.jxb.dc.service.receipt.api.BankReceiptPrintImpl;
import kd.ebg.receipt.banks.jxb.dc.service.receipt.api.DetailImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.MatchStatusEnum;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String date = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String bankVersionId = request.getBankVersionId();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)date);
        DetailImpl detail = new DetailImpl();
        List<DetailInfo> detailInfoList = detail.queryDetailList(accNo, transDate);
        long taskId = request.getTaskId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        HashMap existMap = Maps.newHashMapWithExpectedSize((int)1);
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            if (downloadListDetail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId() || downloadListDetail.getMatchFlag().intValue() != MatchStatusEnum.SUCCESS.getId()) continue;
            existMap.put(downloadListDetail.getFileName(), downloadListDetail);
        }
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DetailInfo detailInfo : detailInfoList) {
            String oppAccNo = detailInfo.getOppAccNo();
            String amount = detailInfo.getReversed1();
            String cdFlag = detailInfo.getReversed2();
            String serialNo = detailInfo.getReceiptNo();
            StringBuilder fileName = new StringBuilder();
            fileName.append(transDateStr).append("_");
            fileName.append(serialNo).append("_");
            fileName.append(cdFlag).append("_");
            fileName.append(amount).append("_");
            fileName.append(oppAccNo);
            if (countMap.containsKey(fileName.toString())) {
                Integer recount = (Integer)countMap.get(fileName.toString());
                recount = recount + 1;
                countMap.put(fileName.toString(), recount);
                fileName.append("_").append(recount).append(".pdf").toString();
            } else {
                countMap.put(fileName.toString(), 0);
                fileName.append(".pdf");
            }
            String fileNameStr = fileName.toString();
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            downloadListDetail.setFileLink(fileName.toString());
            downloadListDetail.setFileName(fileName.toString());
            result.add(downloadListDetail);
            if (existMap.containsKey(fileNameStr)) continue;
            BankReceiptPrintImpl bankReceiptPrint = new BankReceiptPrintImpl();
            BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).requestStr(serialNo).build();
            BankReceiptResponseEB responseEB = bankReceiptPrint.doBiz(bankReceiptRequest);
            String base64Str = (String)responseEB.getData();
            boolean isSuccess = FileCommonUtils.base64ToFile((String)base64Str, (String)(bakFilePath + File.separator + fileNameStr));
            logger.info("\u56de\u5355\u6587\u4ef6\uff1a{}-\u662f\u5426\u751f\u6210-{}", new Object[]{fileName.toString(), isSuccess});
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public BankReceiptRequest buildReq(String accNo, LocalDate localDate) {
        return BankReceiptRequest.builder().accNo(accNo).transDate(localDate).paramsMap(new HashMap()).build();
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "QLB_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-jxb-dc", (Object[])new Object[0]);
    }
}

