/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.paramsconfig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import kd.ebg.receipt.formplugin.plugin.common.EbgAddBankListPlugin;
import kd.ebg.receipt.formplugin.pojo.bizinfo.BankVersionInfo;
import kd.ebg.receipt.formplugin.repository.EbcBankAcntRepository;
import kd.ebg.receipt.formplugin.service.info.InfoService;

public class ReceiptBankLoginListPlugin
extends EbgAddBankListPlugin
implements BeforeF7SelectListener {
    private static final String ENTITY_KEY = "receipt_bank_login";
    private EbcBankAcntRepository ebcBankAcntRepository = (EbcBankAcntRepository)SpringContextUtil.getBean(EbcBankAcntRepository.class);
    private InfoService infoService = (InfoService)SpringContextUtil.getBean(InfoService.class);

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List bankVersionList = this.infoService.getBankVersionInfoList();
        ArrayList<String> bankVersionIDList = new ArrayList<String>(16);
        for (BankVersionInfo bankVersionInfo : bankVersionList) {
            bankVersionIDList.add(bankVersionInfo.getBankVersionID());
        }
        e.getQFilters().add(new QFilter("config_type", "=", (Object)"0"));
        e.getQFilters().add(new QFilter("group.number", "in", bankVersionIDList));
        e.getQFilters().add(new QFilter("custom_id", "=", (Object)RequestContext.get().getTenantId()));
        e.getQFilters().add(new QFilter("enable", "=", (Object)"1"));
        e.getQFilters().add(new QFilter("config_type", "=", (Object)"0"));
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedRowCollection;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"new", (CharSequence)formOperate.getOperateKey())) {
            TreeView treeView = (TreeView)this.getView().getControl("treeview");
            Map focusNode = treeView.getTreeState().getFocusNode();
            String text = (String)focusNode.get("text");
            if (ResManager.loadKDString((String)"\u5168\u90e8", (String)"ReceiptBankLoginListPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]).equals(text)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u5de6\u4fa7\u9009\u62e9\u5bf9\u5e94\u7684\u94f6\u884c\u8282\u70b9\u3002", (String)"ReceiptBankLoginListPlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((CharSequence)"delete", (CharSequence)formOperate.getOperateKey()) && (listSelectedRowCollection = args.getListSelectedData()) != null && listSelectedRowCollection.size() > 0) {
            listSelectedRowCollection.forEach(selectedRow -> {
                String bankLogin = selectedRow.getNumber();
                if (this.ebcBankAcntRepository.exitsAcntByBankLogin(bankLogin)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5220\u9664\u524d\u7f6e\u673a%s\u5931\u8d25\uff0c\u8bf7\u5148\u5220\u9664\u5173\u8054\u7684\u94f6\u884c\u8d26\u53f7\u3002", (String)"ReceiptBankLoginListPlugin_4", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), bankLogin));
                    args.setCancel(true);
                    return;
                }
                DeleteServiceHelper.delete((String)ENTITY_KEY, (QFilter[])new QFilter("number", "=", (Object)bankLogin).toArray());
            });
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection selectCollections = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            Map<String, DynamicObject> map = this.getAvailableBankVersionMap();
            for (ListSelectedRow row : selectCollections) {
                String number = row.getNumber();
                DynamicObject bankVersionData = map.get(number);
                if (bankVersionData == null || "1".equals(bankVersionData.get("enable")) && "C".equals(bankVersionData.get("status"))) continue;
                this.update(bankVersionData, number);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"EbcAddBankListPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            this.refreshTreeView();
            this.getView().invokeOperation("refresh");
        }
    }

    DynamicObject[] getBankVersionDatas() {
        QFilter filter = QFilter.of((String)"id > ?", (Object[])new Object[]{0});
        return BusinessDataServiceHelper.load((String)"aqap_bank", (String)"id, number, name, bank_name, status, enable", (QFilter[])filter.toArray());
    }

    Map<String, DynamicObject> getAvailableBankVersionMap() {
        DynamicObject[] bankVersionDatas = this.getBankVersionDatas();
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
        if (bankVersionDatas != null && bankVersionDatas.length > 0) {
            for (DynamicObject bankVersionData : bankVersionDatas) {
                map.put((String)bankVersionData.get("number"), bankVersionData);
            }
        }
        return map;
    }

    void update(DynamicObject bankVersionData, String number) {
        bankVersionData.set("number", (Object)number);
        bankVersionData.set("status", (Object)"C");
        bankVersionData.set("enable", (Object)"1");
        SaveServiceHelper.save((IDataEntityType)bankVersionData.getDataEntityType(), (Object[])new DynamicObject[]{bankVersionData});
    }

    private void refreshTreeView() {
        TreeView tree = (TreeView)this.getView().getControl("treeview");
        if (tree != null) {
            ListView listView = (ListView)tree.getView();
            listView.refresh();
        }
    }
}

