/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.abc.dc.service.receipt.api;

import java.time.LocalDate;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.abc.dc.service.receipt.AbcDcCommonConfig;
import kd.ebg.receipt.banks.abc.dc.service.receipt.util.ReceiptPacker;
import kd.ebg.receipt.banks.abc.dc.service.receipt.util.ReceiptParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.utils.PropertiesConstantsUtils;
import org.jdom2.Element;

public class GetBankReceiptFileNameImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(GetBankReceiptFileNameImpl.class);

    public String pack(BankReceiptRequest request) {
        String transDateStr = LocalDateUtil.formatDate((LocalDate)request.getTransDate());
        String bankLogin = EBContext.getContext().getBankLoginID();
        AbcDcCommonConfig config = (AbcDcCommonConfig)EBConfigBuilder.getInstance().buildConfig(AbcDcCommonConfig.class, bankLogin);
        String corpNo = config.getCorpNo();
        String opNo = config.getOpNo();
        String charset = config.getCharset();
        String requestStr = ReceiptPacker.pack((String)"CMRA25", (String)transDateStr, (String)corpNo, (String)opNo, (String)charset);
        return requestStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        String bankLogin = EBContext.getContext().getBankLoginID();
        AbcDcCommonConfig config = (AbcDcCommonConfig)EBConfigBuilder.getInstance().buildConfig(AbcDcCommonConfig.class, bankLogin);
        String charset = config.getCharset();
        Element root = ReceiptParser.parseString2Root((String)responseStr, (String)charset);
        String respCode = root.getChildTextTrim("RespCode");
        String respInfo = root.getChildTextTrim("RespInfo");
        String rxtInfo = root.getChildTextTrim("RxtInfo");
        String batchFileName = "";
        if ("ETCEPDF0005".equalsIgnoreCase(respCode) || respInfo.contains(PropertiesConstantsUtils.getValue((String)"FILE_OVER_MAX"))) {
            return BankReceiptResponseEB.fail((String)"ETCEPDF0005");
        }
        if (PropertiesConstantsUtils.getValue((String)"TRANS_SUCCESS").equals(respInfo)) {
            String FileFlag = JDomUtils.getUnNullChildTextTrim((Element)root, (String)"FileFlag");
            if ("0".equals(FileFlag)) {
                throw new ReceiptException(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\uff1a\u65e0\u6587\u4ef6\uff0c\u65e0\u8bb0\u5f55\u3002", (String)"GetBankReceiptFileNameImpl_1", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]));
            }
        } else {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef\uff1aRespInfo %1$s,RespCode:%2$s, RxtInfo:%3$s", (String)"GetBankReceiptFileNameImpl_4", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]), respInfo, respCode, rxtInfo));
        }
        Element cmp = root.getChild("Cmp");
        batchFileName = JDomUtils.getUnNullChildTextTrim((Element)cmp, (String)"BatchFileName");
        return BankReceiptResponseEB.success((Object)batchFileName);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "ABC_DC_RECEIPT_FILE_NAME_REQUEST";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e2d\u56fd\u519c\u4e1a\u94f6\u884c\u516c\u7f51\u7248-\u83b7\u53d6\u94f6\u884c\u56de\u5355\u6587\u4ef6\u540d\u8bf7\u6c42\u3002", (String)"GetBankReceiptFileNameImpl_3", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
    }
}

