/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bosh.dc.service.api.receipt;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.bosh.dc.service.api.login.LoginAndOut;
import kd.ebg.receipt.banks.bosh.dc.service.api.utils.Packer;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import org.jdom2.Element;

public class NewBankReceiptImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(NewBankReceiptImpl.class);
    private static int qryTP = 50;

    public List<Map<String, String>> process(BankReceiptRequest bankReceiptRequest) {
        this.setCurrentPage("1");
        this.setLastPage(false);
        ArrayList<Map<String, String>> response = new ArrayList<Map<String, String>>();
        HashMap<String, String> paramsMap = new HashMap<String, String>(4);
        paramsMap.put("TotLineNum", "");
        paramsMap.put("LclTotLineNum", "");
        paramsMap.put("QrySrlNo", "");
        bankReceiptRequest.setParamsMap(paramsMap);
        do {
            BankReceiptResponseEB doResponse = this.doBiz(bankReceiptRequest);
            List result = (List)doResponse.getData();
            response.addAll(result);
        } while (!this.isLastPage());
        return response;
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        String squence = Sequence.genSequence();
        LocalDate transDate = bankReceiptRequest.getTransDate();
        String curDate = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        Element root = JDomExtUtils.createRoot((String)"BOSEBankData");
        Element opReq = JDomExtUtils.addChild((Element)root, (String)"opReq");
        JDomExtUtils.addChild((Element)opReq, (String)"serialNo", (String)squence);
        JDomExtUtils.addChild((Element)opReq, (String)"reqTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        Element ReqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        JDomExtUtils.addChild((Element)ReqParam, (String)"AcctNo", (String)bankReceiptRequest.getAccNo());
        JDomExtUtils.addChild((Element)ReqParam, (String)"BeginDate", (String)curDate);
        JDomExtUtils.addChild((Element)ReqParam, (String)"EndDate", (String)curDate);
        JDomExtUtils.addChild((Element)ReqParam, (String)"QryTp", (String)String.format("P(%s)", qryTP));
        JDomExtUtils.addChild((Element)ReqParam, (String)"CrnPgNo", (String)this.getCurrentPage());
        Map paramsMap = bankReceiptRequest.getParamsMap();
        String totLineNum = (String)paramsMap.get("TotLineNum");
        String lclTotLineNum = (String)paramsMap.get("LclTotLineNum");
        String qrySrlNo = (String)paramsMap.get("QrySrlNo");
        JDomExtUtils.addChild((Element)ReqParam, (String)"TotLineNum", (String)totLineNum);
        JDomExtUtils.addChild((Element)ReqParam, (String)"LclTotLineNum", (String)lclTotLineNum);
        JDomExtUtils.addChild((Element)ReqParam, (String)"QrySrlNo", (String)qrySrlNo);
        String reqStr = JDomUtils.root2String((Element)root, (String)"GBK");
        String session = "";
        try {
            session = LoginAndOut.login4GetSession();
            RequestContextUtils.setRunningParam((String)"dse_sessionId", (String)session);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return Packer.getCommonBizReqData((String)session, (String)"MCAcctTxnRcrdPageQry1_1Op", (String)reqStr);
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        this.setLastPage(true);
        ArrayList result = new ArrayList(8);
        Element BOSEBankData = JDomUtils.string2Root((String)s, (String)"GBK");
        Element opRep = JDomUtils.getUnNullChildElement((Element)BOSEBankData, (String)"opRep");
        String retCode = JDomUtils.getUnNullChildText((Element)opRep, (String)"retCode");
        String errMsg = JDomUtils.getUnNullChildText((Element)opRep, (String)"errMsg");
        if ("0".equalsIgnoreCase(retCode)) {
            Element opResult = JDomUtils.getUnNullChildElement((Element)opRep, (String)"opResult");
            String totLineNum = JDomUtils.getUnNullChildText((Element)opResult, (String)"TotLineNum");
            if ("".equals(totLineNum) || "0".equals(totLineNum) || totLineNum == null) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8d26\u6237\u4ea4\u6613\u8bb0\u5f55\u67e5\u8be2\u201cMCAcctTxnRcrdPageQry1_1Op\u201d\u8fd4\u56de\u8bb0\u5f55\u6570\u4e3a0", (String)"NewBankReceiptImpl_0", (String)"ebg-receipt-banks-bosh-dc", (Object[])new Object[0]));
            }
            String lclTotLineNum = JDomUtils.getUnNullChildText((Element)opResult, (String)"LclTotLineNum");
            String qrySrlNo = JDomUtils.getUnNullChildText((Element)opResult, (String)"QrySrlNo");
            bankReceiptRequest.getParamsMap().put("TotLineNum", totLineNum);
            bankReceiptRequest.getParamsMap().put("LclTotLineNum", lclTotLineNum);
            bankReceiptRequest.getParamsMap().put("QrySrlNo", qrySrlNo);
            Element opResultSet = JDomUtils.getUnNullChildElement((Element)opRep, (String)"opResultSet");
            List opResults = opResultSet.getChildren("opResult");
            if (StringUtils.isEmpty((String)totLineNum)) {
                totLineNum = "0";
            }
            this.setLastPage(Integer.parseInt(this.getCurrentPage()) * qryTP >= Integer.parseInt(totLineNum));
            this.setCurrentPage(Integer.parseInt(this.getCurrentPage()) + 1);
            opResults.forEach(e -> {
                HashMap<String, String> map = new HashMap<String, String>();
                String OppAcctNo = JDomUtils.getUnNullChildText((Element)e, (String)"OppAcctNo");
                String Amount = JDomUtils.getUnNullChildText((Element)e, (String)"Amount");
                double amount = Double.parseDouble(Amount);
                Amount = String.format("%.2f", amount);
                String ApsNo = JDomUtils.getUnNullChildText((Element)e, (String)"ApsNo");
                if (StringUtils.isEmpty((String)ApsNo)) {
                    logger.info("\u4e0a\u6d77\u94f6\u884c \u8d26\u6237\u4ea4\u6613\u8bb0\u5f55\u67e5\u8be2\u201cMCAcctTxnRcrdPageQry1_1Op\u201d \u54cd\u5e94\u4e2d\uff1a" + e.getText() + "\u6b64\u7b14\u4ea4\u6613\u56de\u5355\u7f16\u53f7\u8fd4\u56de\u4e3a\u7a7a\uff01");
                    return;
                }
                String Balance = JDomUtils.getUnNullChildText((Element)e, (String)"Balance");
                if (!StringUtils.isEmpty((String)Balance)) {
                    try {
                        double bal = Double.parseDouble(Balance);
                        Balance = String.format("%.2f", bal);
                    }
                    catch (NumberFormatException | IllegalFormatException ex) {
                        logger.error("\u4f59\u989d\u683c\u5f0f\u6709\u8bef", (Throwable)ex);
                    }
                }
                String DbCrdtFlg = JDomUtils.getUnNullChildText((Element)e, (String)"DbCrdtFlg");
                map.put("ApsNo", ApsNo);
                map.put("OppAcctNo", OppAcctNo);
                map.put("Amount", Amount);
                map.put("Balance", Balance);
                map.put("DbCrdtFlg", DbCrdtFlg);
                result.add(map);
            });
            return BankReceiptResponseEB.success(result);
        }
        throw EBExceiptionUtil.serviceException((String)(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef\uff0c\u8fd4\u56de\u7801\uff1a%s\u3002", (String)"BankReceiptImpl_4", (String)"ebg-receipt-banks-bosh-dc", (Object[])new Object[0]), retCode) + String.format(ResManager.loadKDString((String)"\u9519\u8bef\u63cf\u8ff0\uff1a%s", (String)"BankReceiptImpl_5", (String)"ebg-receipt-banks-bosh-dc", (Object[])new Object[0]), errMsg)));
    }

    public String getDeveloper() {
        return "cqc";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u6587\u4ef6\u6d41", (String)"BankReceiptImpl_3", (String)"ebg-receipt-banks-bosh-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/CM/APIReqServlet");
        factory.setHttpHeader("User-Agent", "MSIE");
    }
}

