/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cib.dc.services.receipt;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.cib.dc.services.receipt.api.GetBankReceiptNameApiImpl;
import kd.ebg.receipt.banks.cib.dc.services.receipt.api.SubmitBankReceiptBatchNoApiImpl;
import kd.ebg.receipt.banks.cib.dc.services.receipt.api.TodaySubmitBankReceiptBatchNoApiImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.PropertiesConstantsUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import org.jdom2.Document;
import org.jdom2.Element;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        if (status.intValue() != TaskStatus.PROCESSING.getId()) {
            return false;
        }
        return RequestContextUtils.receiptFormatIsFile() || FileCommonUtils.isTestEnv();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String bankLoginId = request.getBankLoginId();
        String customId = EBContext.getContext().getCustomID();
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        try {
            logger.info("\u8c03\u5ea6\u8d26\u53f7:{} \u8c03\u5ea6\u65e5\u671f\uff1a{}", new Object[]{accNo, LocalDateUtil.formatDate((LocalDate)transDate)});
            int waitHour = 3;
            boolean isToday = transDate.isEqual(LocalDate.now());
            String key = accNo + ":" + LocalDateUtil.formatDate((LocalDate)transDate);
            String batchNo = CosmicCache.get((String)key);
            if (EBGStringUtils.isEmpty((String)batchNo) || FileCommonUtils.isTestEnv()) {
                BankReceiptRequest receiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
                Object iBankReceipt = new SubmitBankReceiptBatchNoApiImpl();
                if (isToday) {
                    iBankReceipt = new TodaySubmitBankReceiptBatchNoApiImpl();
                    waitHour = 1;
                }
                try {
                    BankReceiptResponseEB receiptResponseEB = (BankReceiptResponseEB)iBankReceipt.doBiz((BankRequest)receiptRequest);
                    batchNo = (String)receiptResponseEB.getData();
                    CosmicCache.putIfAbsentWithExpire((String)key, (String)batchNo, (int)waitHour, (TimeUnit)TimeUnit.HOURS);
                    if (FileCommonUtils.isTestEnv()) {
                        CosmicCache.delete((String)key);
                    }
                }
                catch (Exception e) {
                    logger.error("\u5174\u4e1a\u94f6\u884c\u63d0\u4ea4\u56de\u5355\u6279\u6b21\u53f7\u5f02\u5e38\uff1a", new Object[]{e.getMessage()});
                    String message = e.getMessage();
                    String mark = PropertiesConstantsUtils.getValue((String)"IS_EXIST_BATCH_NO");
                    if (!message.contains(mark)) {
                        CosmicCache.delete((String)key);
                    }
                    throw new ReceiptException((Throwable)e);
                }
            }
            List<String> fileInfos = this.sendAsynReceiptReq(batchNo, 1, accNo, transDate);
            for (String fileInfo : fileInfos) {
                String[] s = fileInfo.split("@@@@@");
                DownloadListDetail detail = new DownloadListDetail();
                String fileId = s[0];
                String fileName = s[1];
                detail.setFileLink(fileId);
                detail.setFileName(fileName);
                RequestContextUtils.setZipName((String)fileName);
                result.add(detail);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u56de\u5355\u4e0b\u8f7d\u5217\u8868\u53d1\u751f\u5f02\u5e38.", new Object[]{e.getMessage()});
            String msg = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u4e0b\u8f7d\u5217\u8868\u53d1\u751f\u5f02\u5e38\uff1a%s\u3002", (String)"BankReceiptFetchListImpl_7", (String)"ebg-receipt-banks-cib-dc", (Object[])new Object[0]), e.getMessage());
            throw new ReceiptException(msg, (Throwable)e);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_2", (String)"ebg-receipt-banks-cib-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    private List<String> sendAsynReceiptReq(String batchNo, int page, String accNo, LocalDate transDate) {
        ArrayList<String> result = new ArrayList<String>(16);
        GetBankReceiptNameApiImpl getBankReceiptNameApi = new GetBankReceiptNameApiImpl();
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)8);
        paramMap.put("cltRefNo", batchNo);
        paramMap.put("page", page);
        BankReceiptRequest receiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).paramsMap((Map)paramMap).build();
        BankReceiptResponseEB receiptResponseEB = (BankReceiptResponseEB)getBankReceiptNameApi.doBiz((BankRequest)receiptRequest);
        String response = (String)receiptResponseEB.getData();
        Element fox = this.parseRoot(response);
        Element sec = JDomExtUtils.getChildElement((Element)fox, (String)"SECURITIES_MSGSRSV1");
        Element asy = JDomExtUtils.getChildElement((Element)sec, (String)"ASYNRECEIPTINFOTRNRS");
        Element sta = JDomExtUtils.getChildElement((Element)asy, (String)"STATUS");
        String code = JDomExtUtils.getChildElement((Element)sta, (String)"CODE").getTextTrim();
        if ("0".equals(code)) {
            Element rsb = JDomExtUtils.getChildElement((Element)asy, (String)"RSBODY");
            List contents = rsb.getChildren("CONTENT");
            for (Element content : contents) {
                Element fileName = JDomExtUtils.getChildElement((Element)content, (String)"FILE_NAME");
                Element fileId = JDomExtUtils.getChildElement((Element)content, (String)"FILE_ID");
                String fileInfo = fileId.getTextTrim() + "@@@@@" + fileName.getTextTrim();
                result.add(fileInfo);
            }
            String more = rsb.getAttribute("MORE").getValue();
            if ("Y".equals(more)) {
                result.addAll(this.sendAsynReceiptReq(batchNo, page + 1, accNo, transDate));
            }
            return result;
        }
        Element mes = JDomExtUtils.getChildElement((Element)sta, (String)"MESSAGE");
        if (mes.getText().startsWith(PropertiesConstantsUtils.getValue((String)"CIB_DC_THIS_TASK_PROCESS"))) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BankReceiptFetchListImpl_4", (String)"ebg-receipt-banks-cib-dc", (Object[])new Object[0]));
        }
        throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u8c03\u7528ASYNRECEIPTINFOTRNRQ\u63a5\u53e3\u83b7\u53d6\u5230\u94f6\u884c\u9519\u8bef\u62a5\u6587\uff0c\u94f6\u884c\u8fd4\u56de\u7801[%1$s]:%2$s\u3002", (String)"BankReceiptFetchListImpl_8", (String)"ebg-receipt-banks-cib-dc", (Object[])new Object[0]), code, mes.getText()));
    }

    private Element parseRoot(String response) {
        Document doc = JDomUtils.string2Document((String)response, (String)"GBK");
        return doc.getRootElement();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CIB_DC_RECEIPT_FETCH";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u5174\u4e1a\u94f6\u884c\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_6", (String)"ebg-receipt-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean isBreak() {
        return true;
    }
}

