/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bocom.dc.service.receipt.api;

import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.receipt.banks.bocom.dc.service.receipt.BocomDcCommonConfig;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadOnApiImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadOnApiImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        if (status.intValue() != TaskStatus.DOWNLOADING.getId()) {
            return false;
        }
        BocomDcCommonConfig bocomDcCommonConfig = (BocomDcCommonConfig)EBConfigBuilder.getInstance().buildConfig(BocomDcCommonConfig.class, request.getBankLoginId());
        return !Objects.equals(bocomDcCommonConfig.getReceiptWayChoose(), "bank_proxy");
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        if (downloadListDetails.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptDownloadOnApiImpl_0", (String)"ebg-receipt-banks-bocom-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success((Object)downloadListDetails);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "BOCOM_DC_BankReceiptDownload";
    }

    public String getBizDesc() {
        return null;
    }
}

