/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.framework.receipt.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.ReceiptSystemProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;

public class AttachServiceUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(AttachServiceUtil.class);

    public static String getAttachWay() {
        ReceiptSystemProperties properties = (ReceiptSystemProperties)EBConfigBuilder.getInstance().buildConfig(ReceiptSystemProperties.class);
        return properties.getUseFileUpload();
    }

    public static String getAttachUrlCangqiong() {
        ReceiptSystemProperties properties = (ReceiptSystemProperties)EBConfigBuilder.getInstance().buildConfig(ReceiptSystemProperties.class);
        return AttachServiceUtil.handleUrl(properties.getCosmicApiUrl()) + properties.getAttachUrlCangqiong();
    }

    public static String getAppTokenUrlCangqiong() {
        ReceiptSystemProperties properties = (ReceiptSystemProperties)EBConfigBuilder.getInstance().buildConfig(ReceiptSystemProperties.class);
        return AttachServiceUtil.handleUrl(properties.getCosmicApiUrl()) + properties.getAppTokenUrlCangqiong();
    }

    public static String getAccessTokenUrlCangqiong() {
        ReceiptSystemProperties properties = (ReceiptSystemProperties)EBConfigBuilder.getInstance().buildConfig(ReceiptSystemProperties.class);
        return AttachServiceUtil.handleUrl(properties.getCosmicApiUrl()) + properties.getAccessTokenUrlCangqiong();
    }

    public static String getUserCangqiong() {
        ReceiptSystemProperties properties = (ReceiptSystemProperties)EBConfigBuilder.getInstance().buildConfig(ReceiptSystemProperties.class);
        return properties.getUserCangqiong();
    }

    public static String getAppIdCangqiong() {
        ReceiptSystemProperties properties = (ReceiptSystemProperties)EBConfigBuilder.getInstance().buildConfig(ReceiptSystemProperties.class);
        return properties.getAppIdCangqiong();
    }

    public static String getAppSecuretCangqiong() {
        ReceiptSystemProperties properties = (ReceiptSystemProperties)EBConfigBuilder.getInstance().buildConfig(ReceiptSystemProperties.class);
        return properties.getAppSecuretCangqiong();
    }

    public static String getCosmicAccountId() {
        ReceiptSystemProperties properties = (ReceiptSystemProperties)EBConfigBuilder.getInstance().buildConfig(ReceiptSystemProperties.class);
        return properties.getCosmic_account_id();
    }

    public static boolean isSupportFutureDate() {
        ReceiptSystemProperties properties = (ReceiptSystemProperties)EBConfigBuilder.getInstance().buildConfig(ReceiptSystemProperties.class);
        return Objects.equals(properties.getSearch_from_future_date(), "true");
    }

    public static boolean isUseOpenApi() {
        ReceiptSystemProperties properties = (ReceiptSystemProperties)EBConfigBuilder.getInstance().buildConfig(ReceiptSystemProperties.class);
        return Objects.equals("true", properties.getIsUseOpenApi());
    }

    public static String handleUrl(String url) {
        if (!Objects.nonNull(url)) {
            return "";
        }
        String[] array = url.split("//");
        if (array.length < 1) {
            return url;
        }
        String second = array[array.length - 1];
        if (!second.contains("/")) {
            return url + "/ierp";
        }
        return url;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String uploadFile(String filePath, String fileName, String accNo, LocalDate transDate) {
        if (!AttachServiceUtil.isUseOpenApi()) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u4e0d\u4f7f\u7528\u5fae\u670d\u52a1\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"AttachServiceUtil_0", (String)"ebg-receipt-common", (Object[])new Object[0]));
        }
        FileService fs = FileServiceFactory.getAttachmentFileService();
        FileItem fi = null;
        String uploadPath = AttachServiceUtil.getUploadUrl(fileName, accNo, transDate);
        try (FileInputStream fileInputStream = new FileInputStream(filePath);){
            String path;
            fi = new FileItem(fileName, uploadPath, (InputStream)fileInputStream);
            fi.setCreateNewFileWhenExists(false);
            String string = path = fs.upload(fi);
            return string;
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u5f02\u5e38\uff1a", (Throwable)e);
            logger.monitorError("upload error\uff1a", (Throwable)e);
            throw new ReceiptException((Throwable)e);
        }
    }

    public static String getUploadUrl(String fileName, String accNo, LocalDate transDate) {
        EBContext context = EBContext.getContext();
        String customID = context.getCustomID();
        String accId = RequestContext.get().getAccountId();
        String monthStr = LocalDateUtil.formatDate((LocalDate)transDate, (String)"yyyyMM");
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        StringBuilder sb = new StringBuilder();
        sb.append(customID).append(File.separator).append(accId).append(File.separator).append(monthStr).append(File.separator).append("receipt").append(File.separator).append("receipt_detail").append(File.separator).append(accNo).append(File.separator).append("attachments").append(File.separator).append(transDateStr).append(File.separator).append(fileName);
        return sb.toString();
    }
}

