/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.arcu.dc.service.api;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.arcu.dc.service.ARCUDCCommConfig;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail {
    private static final String DETAIL_CODE = "B2EACTransQry";
    private static EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);
    private int pageNum = 20;

    public List<DetailInfo> process(BankDetailRequest request) {
        this.setCurrentPage("0");
        this.setLastPage(false);
        ArrayList<DetailInfo> response = new ArrayList<DetailInfo>();
        do {
            EBBankDetailResponse doResponse = this.doBiz(request);
            List result = doResponse.getDetails();
            response.addAll(result);
        } while (!this.isLastPage());
        return response;
    }

    public String pack(BankDetailRequest request) {
        Element root = DetailImpl.getCommonHeader(DETAIL_CODE, Sequence.gen8Sequence(), LocalDateTime.now());
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"AcNo", (String)request.getAcnt().getAccNo());
        String startDate = request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String endDate = request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)startDate);
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)endDate);
        JDomUtils.addChild((Element)body, (String)"CurrentIndex", (String)this.getCurrentPage());
        JDomUtils.addChild((Element)body, (String)"QueryCount", (String)String.valueOf(this.pageNum));
        try {
            return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        this.setLastPage(true);
        int nextPage = Integer.parseInt(this.getCurrentPage()) + this.pageNum;
        this.setCurrentPage(nextPage);
        Element root = JDomUtils.string2Root((String)responseStr, (String)"GBK");
        BankResponse bankResponse = DetailImpl.parserCommonHeader(root);
        if (null == bankResponse.getResponseCode() || !"000000".equals(bankResponse.getResponseCode())) {
            return new EBBankDetailResponse();
        }
        Element body = JDomUtils.getChildElement((Element)root, (String)"Body");
        Element list = JDomUtils.getChildElement((Element)body, (String)"List");
        if (null == list) {
            return new EBBankDetailResponse();
        }
        String totalNum = JDomUtils.getChildText((Element)body, (String)"TotalNum");
        int total = Integer.parseInt(totalNum);
        if (total > nextPage) {
            this.setLastPage(false);
        }
        List mapList = list.getChildren("Map");
        ArrayList<DetailInfo> ret = new ArrayList<DetailInfo>(8);
        for (int i = 0; i < mapList.size(); ++i) {
            Element e = (Element)mapList.get(i);
            String HostJnlNo = JDomUtils.getUnNullChildText((Element)e, (String)"HostJnlNo");
            String Amount = JDomUtils.getUnNullChildText((Element)e, (String)"Amount");
            String PayeeAcNo = JDomUtils.getUnNullChildText((Element)e, (String)"PayeeAcNo");
            String PayerAcNo = JDomUtils.getUnNullChildText((Element)e, (String)"PayerAcNo");
            String dcFlag = JDomUtils.getChildText((Element)e, (String)"DCFlag");
            if ("C".equalsIgnoreCase(dcFlag)) {
                PayeeAcNo = PayerAcNo;
            }
            DetailInfo detailInfo = new DetailInfo();
            detailInfo.setUniqueSeq(HostJnlNo);
            detailInfo.setId(Amount);
            detailInfo.setOppAccNo(PayeeAcNo);
            ret.add(detailInfo);
        }
        return new EBBankDetailResponse(ret);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6307\u5b9a\u65e5\u671f\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_0", (String)"ebg-receipt-banks-arcu-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        ARCUDCCommConfig config = (ARCUDCCommConfig)EBConfigBuilder.getInstance().buildConfig(ARCUDCCommConfig.class, bankLoginId);
        factory.setUri("/bweb/b2econnect.do?userPassword=" + config.getAccessNum() + "&SIGDATA=0");
        log.info("URI:{}", (Object)("/bweb/b2econnect.do?userPassword=" + config.getAccessNum() + "&SIGDATA=0"));
    }

    public static Element getCommonHeader(String transCode, String sequence, LocalDateTime requestDate) {
        Element root = JDomUtils.createRoot((String)"Message");
        Element head = JDomUtils.addChild((Element)root, (String)"Head");
        JDomUtils.addChild((Element)head, (String)"SerialNo", (String)sequence);
        JDomUtils.addChild((Element)head, (String)"ReqTime", (String)requestDate.format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        JDomUtils.addChild((Element)head, (String)"TrsCode", (String)transCode);
        return root;
    }

    public static BankResponse parserCommonHeader(Element root) {
        BankResponse bankResponse = new BankResponse();
        Element head = JDomUtils.getUnNullChildElement((Element)root, (String)"Head");
        String returnCode = JDomUtils.getUnNullChildText((Element)head, (String)"IBSReturnCode");
        String retrunMsg = JDomUtils.getUnNullChildText((Element)head, (String)"IBSReturnMsg");
        bankResponse.setResponseCode(returnCode);
        bankResponse.setResponseMessage(retrunMsg);
        return bankResponse;
    }
}

