/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cmb.opa;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.ebg.egf.common.constant.ConfigInputType;
import kd.ebg.egf.common.constant.PropertiesOptions;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.conf.BankLoginConfigUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.framework.meta.MetaDataConfigType;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;
import kd.ebg.receipt.banks.cmb.opa.BankBusinessConfig;
import kd.ebg.receipt.banks.cmb.opa.constants.CmbCmpConstants;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.BankReceiptDownloadImpl;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.BankReceiptFetchListImpl;
import kd.ebg.receipt.banks.cmb.opa.service.reconciliation.BankReconciliationDownloadImpl;
import kd.ebg.receipt.banks.cmb.opa.service.reconciliation.BankReconciliationFetchListImpl;
import kd.ebg.receipt.business.receipt.query.FileReceiptImpl;
import kd.ebg.receipt.business.receipt.query.FileReconciliationImpl;
import kd.ebg.receipt.common.framework.bank.meta.template.OPAMetaDataTemplate;
import kd.ebg.receipt.common.framework.properties.BankPropertyConfig;

public class CmbOpaMetaDataImpl
extends OPAMetaDataTemplate {
    public static final String aesKey = "aes_key";
    public static final String rsaKey = "rsa_key";
    public static final String LGNNAM = "lgnnam";
    public static final String TESTDATE = "TESTDATE";
    public static final String signType = "sign_type";
    public static final String SIGN_TYPE_SM = "SM";
    public static final String SIGN_TYPE_AES = "AES";
    public static final String IS_UNIQUE = "is_unique";
    public static final String FILE_FORMAT = "file_format";
    public static final String DOWNLOAD_URL = "download_url";
    public static final String DOWNLOAD_PROXY_URL = "download_proxy_url";

    public void metaDataInit() {
        this.setBankName(ResManager.loadKDString((String)"\u62db\u5546\u94f6\u884c", (String)"CmbOpaMetaDataImpl_0", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]));
        this.setBankVersionID("CMB_OPA");
        this.setBankShortName("CMB");
        this.setBankVersionName(ResManager.loadKDString((String)"\u62db\u5546\u94f6\u884c\u5f00\u653e\u5e73\u53f0\u7248", (String)"CmbOpaMetaDataImpl_1", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]));
        this.setDescription(ResManager.loadKDString((String)"\u62db\u5546\u94f6\u884c", (String)"CmbOpaMetaDataImpl_0", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]));
        this.setKeyNames(Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u62db\u5546\u94f6\u884c", (String)"CmbOpaMetaDataImpl_0", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), ResManager.loadKDString((String)"\u62db\u884c", (String)"CmbOpaMetaDataImpl_2", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0])}));
        String cache = "CMB_OPA_concurrentCount";
        int concurrentCount = 0;
        try {
            if (!StringUtils.isEmpty((String)System.getProperty(cache))) {
                concurrentCount = Integer.parseInt(System.getProperty(cache));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setConcurrentCount(concurrentCount);
    }

    public void baseConfigInit() {
        if ("prod".equals(System.getProperty("ebg.server.env"))) {
            this.setHost("cdc.cmbchina.com");
            this.setPort(443);
            this.setExchangeProtocol("HTTPS");
        } else {
            this.setHost("183.62.66.60");
            this.setPort(9080);
            this.setExchangeProtocol("HTTP");
        }
        this.setUri("/cdcserver/api/v2");
        this.setTimeOut(3);
        this.setCharSet("UTF-8");
        this.setSupportReconciliation(true);
    }

    public List<BankLoginConfig> getBankLoginExtraConfig() {
        String exchangeProtocol;
        int port;
        String host;
        if ("prod".equals(System.getProperty("ebg.server.env"))) {
            host = "cdc.cmbchina.com";
            port = 443;
            exchangeProtocol = "HTTPS";
        } else {
            host = "183.62.66.60";
            port = 9080;
            exchangeProtocol = "HTTP";
        }
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getBankLoginConfig((String)"CLOUD_TYPE", (String)ResManager.loadKDString((String)"\u62db\u5546\u4e91\u76f4\u8054\u6a21\u5f0f", (String)"CmbOpaMetaDataImpl_3", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4ee5\u5ba2\u6237\u5728\u94f6\u884c\u5f00\u901a\u7684\u6a21\u5f0f\u4e3a\u51c6\uff0c\u6807\u51c6\u6a21\u5f0f\u4e91\u76f4\u8054\u4ec5\u652f\u6301\u65e0\u524d\u7f6e\u673a\u7248\u672c\n\u5982\u9700\u5207\u6362\u6a21\u5f0f\uff0c\u8bf7\u5230[\u94f6\u884c\u53c2\u6570\u914d\u7f6e]->[\u57fa\u7840\u53c2\u6570]->[\u62db\u5546\u4e91\u76f4\u8054\u6a21\u5f0f]\u4fee\u6539\u3002", (String)"CmbOpaMetaDataImpl_4", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), Arrays.asList(BankBusinessConfig.CLOUD_TYPE_KEY_S, BankBusinessConfig.CLOUD_TYPE_KEY_N), (String)"", (boolean)true, (boolean)true, (boolean)false), BankLoginConfigUtil.getBankLoginConfig((String)"ip", (String)ResManager.loadKDString((String)"\u670d\u52a1\u7f51\u5173\u5730\u5740", (String)"CmbOpaMetaDataImpl_5", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u751f\u4ea7\u73af\u5883\u4e3acdc.cmbchina.com\uff0c\u6d4b\u8bd5\u73af\u5883\u4e3a183.62.66.60\u3002", (String)"CmbOpaMetaDataImpl_6", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), (String)host, (boolean)false, (boolean)false), BankLoginConfigUtil.getBankLoginConfig((String)"exchangePort", (String)ResManager.loadKDString((String)"\u670d\u52a1\u7aef\u53e3", (String)"CmbOpaMetaDataImpl_7", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u751f\u4ea7\u73af\u5883\u4e3a443\uff0c\u6d4b\u8bd5\u73af\u5883\u4e3a9080\u3002", (String)"CmbOpaMetaDataImpl_8", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), (String)String.valueOf(port), (boolean)false, (boolean)false).set2InputType(ConfigInputType.INTEGER.getInputType()).set2MinValueNum(Integer.valueOf(0)).set2MaxValueNum(65535), BankLoginConfigUtil.getBankLoginConfig((String)"exchangeUri", (String)ResManager.loadKDString((String)"\u670d\u52a1uri\u5730\u5740", (String)"CmbOpaMetaDataImpl_9", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u56fa\u5b9a\u4e3a/cdcserver/api/v2", (String)"CmbOpaMetaDataImpl_10", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), (String)"/cdcserver/api/v2", (boolean)false, (boolean)true), BankLoginConfigUtil.getBankLoginConfig((String)"exchangeProtocol", (String)ResManager.loadKDString((String)"\u901a\u8baf\u534f\u8bae", (String)"CmbOpaMetaDataImpl_11", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u751f\u4ea7\u73af\u5883\u9009\u62e9https\uff0c\u6d4b\u8bd5\u73af\u5883\u9009\u62e9http", (String)"CmbOpaMetaDataImpl_12", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), Arrays.asList("HTTPS", "HTTP"), (String)exchangeProtocol, (boolean)false, (boolean)false, (boolean)false), BankLoginConfigUtil.getBankLoginConfig((String)"timeout", (String)ResManager.loadKDString((String)"\u8d85\u65f6\u8bbe\u7f6e(min)", (String)"CmbOpaMetaDataImpl_13", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), (String)"3").set2InputType(ConfigInputType.INTEGER.getInputType()).set2MinValueNum(Integer.valueOf(0)), BankLoginConfigUtil.getBankLoginConfig((String)LGNNAM, (String)ResManager.loadKDString((String)"'\u62db\u5546\u94f6\u884c\u4f01\u4e1a\u94f6\u884c\u76f4\u8054\u7cfb\u7edf'\u7684'\u7528\u6237\u540d'", (String)"CmbOpaMetaDataImpl_14", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4e00\u822c\u4e3aN00\u5f00\u5934", (String)"CmbOpaMetaDataImpl_15", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), (boolean)false, (boolean)false), BankLoginConfigUtil.getBankLoginConfig((String)"charset", (String)ResManager.loadKDString((String)"\u5b57\u7b26\u96c6", (String)"CmbOpaMetaDataImpl_16", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), (String)"UTF-8").set2ReadOnly(), BankLoginConfigUtil.getMlBankLoginConfig((String)"ipVal", (MultiLangEnumBridge)new MultiLangEnumBridge("IP\u5730\u5740", "", "ebg-receipt-banks-cmb-opa"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u7528\u6237ip\u5730\u5740\uff0csaas\u6a21\u5f0f\u4e91\u76f4\u8054\u7528\u6237\u5fc5\u586b\u3001\u6807\u51c6\u6a21\u5f0f\u4e91\u76f4\u8054/\u6709\u524d\u7f6e\u673a\u6a21\u5f0f\u4e91\u76f4\u8054\u975e\u5fc5\u586b\u3002", "", "ebg-receipt-banks-cmb-opa"), (String)"", (boolean)false, (boolean)true).set2MaxLength(40), BankLoginConfigUtil.getMlBankLoginConfig((String)"macVal", (MultiLangEnumBridge)new MultiLangEnumBridge("MAC\u5730\u5740", "", "ebg-receipt-banks-cmb-opa"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u7528\u6237\u6240\u7528\u7535\u8111\u7684MAC\u5730\u5740\uff1b\u683c\u5f0f\u5982\uff1a309C23779B4B\uff0c\u4e0d\u8981\u5e26\u6709\u201c\uff1a\u201d\u201c-\u201d\u5206\u9694\u7b26\uff1b", "", "ebg-receipt-banks-cmb-opa"), (String)"", (boolean)false, (boolean)true).set2MaxLength(20), BankLoginConfigUtil.getMlBankLoginConfig((String)"cpuInfo", (MultiLangEnumBridge)new MultiLangEnumBridge("CPU ID", "", "ebg-receipt-banks-cmb-opa"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u7528\u6237\u6240\u7528\u7535\u8111\u7684CPU\u7f16\u53f7\uff1b\u5982\u65e0\u6cd5\u83b7\u53d6\uff0c\u8bf7\u5411\u94f6\u884c\u7279\u6b8a\u8bf4\u660e\uff0c\u5e76\u586b\u5199CDCK003\u3002", "", "ebg-receipt-banks-cmb-opa"), (String)"", (boolean)false, (boolean)true).set2MaxLength(16), BankLoginConfigUtil.getMlBankLoginConfig((String)"cmpName", (MultiLangEnumBridge)new MultiLangEnumBridge("\u673a\u5668\u540d", "", "ebg-receipt-banks-cmb-opa"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u7528\u6237\u6240\u7528\u7535\u8111\u7684\u673a\u5668\u540d\uff1b\u5982\u65e0\u6cd5\u83b7\u53d6\uff0c\u8bf7\u5411\u94f6\u884c\u7279\u6b8a\u8bf4\u660e\uff0c\u5e76\u586b\u5199CDCK003\u3002", "", "ebg-receipt-banks-cmb-opa"), (String)"", (boolean)false, (boolean)true).set2MaxLength(32), BankLoginConfigUtil.getMlBankLoginConfig((String)"mbId", (MultiLangEnumBridge)new MultiLangEnumBridge("\u4e3b\u677fID", "", "ebg-receipt-banks-cmb-opa"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u7528\u6237\u6240\u7528\u7535\u8111\u7684\u4e3b\u677f\u7f16\u53f7\uff1b\u5982\u65e0\u6cd5\u83b7\u53d6\uff0c\u8bf7\u5411\u94f6\u884c\u7279\u6b8a\u8bf4\u660e\uff0c\u5e76\u586b\u5199CDCK003\u3002", "", "ebg-receipt-banks-cmb-opa"), (String)"", (boolean)false, (boolean)true).set2MaxLength(32), BankLoginConfigUtil.getMlBankLoginConfig((String)"mbMf", (MultiLangEnumBridge)new MultiLangEnumBridge("\u4e3b\u677f\u5382\u5546", "", "ebg-receipt-banks-cmb-opa"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u7528\u6237\u6240\u7528\u7535\u8111\u7684\u4e3b\u677f\u5382\u5546\u4fe1\u606f\uff1b\u5982\u65e0\u6cd5\u83b7\u53d6\uff0c\u8bf7\u5411\u94f6\u884c\u7279\u6b8a\u8bf4\u660e\uff0c\u5e76\u586b\u5199CDCK003\u3002", "", "ebg-receipt-banks-cmb-opa"), (String)"", (boolean)false, (boolean)true).set2MaxLength(24)});
    }

    public List<BankLoginConfig> getBankLoginConfig() {
        List<BankLoginConfig> loginConfigs = super.getBankLoginConfig();
        loginConfigs = loginConfigs.stream().filter(l -> !MetaDataConfigType.PGP_CONFIG.getName().equals(l.getType())).collect(Collectors.toList());
        List configs = this.getUserBankPGPConfig().stream().map(b -> {
            b.setType(MetaDataConfigType.PGP_CONFIG.getName());
            return b;
        }).collect(Collectors.toList());
        loginConfigs.addAll(configs);
        return loginConfigs;
    }

    private List<BankLoginConfig> getUserBankPGPConfig() {
        BankLoginConfig signTypeConfig = BankLoginConfigUtil.getBankLoginConfig((String)signType, (String)ResManager.loadKDString((String)"\u52a0\u89e3\u5bc6\u7b97\u6cd5", (String)"CmbOpaMetaDataImpl_17", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5b58\u91cf\u5ba2\u6237\u53ef\u7ee7\u7eed\u4f7f\u7528AES\uff0c\u65b0\u5ba2\u6237\u4f7f\u7528\u56fd\u5bc6\u3002\u5982\u4e0d\u6e05\u695a\u5f53\u524d\u5c5e\u4e8e\u54ea\u79cd\u7b97\u6cd5\uff0c\u53ef\u54a8\u8be2\u94f6\u884c\u65b9\u3002", (String)"CmbOpaMetaDataImpl_18", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), Arrays.asList(SIGN_TYPE_SM, SIGN_TYPE_AES), (String)SIGN_TYPE_AES, (boolean)false, (boolean)false, (boolean)false);
        BankLoginConfig aes = BankLoginConfigUtil.getBankLoginConfig((String)aesKey, (String)ResManager.loadKDString((String)"AES\u5bc6\u94a5", (String)"CmbOpaMetaDataImpl_19", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), (String)"", (boolean)false, (boolean)false, (String)"upload");
        aes.setDesc(ResManager.loadKDString((String)"\u5ba2\u6237\u81ea\u5df1\u4fdd\u5b58\uff0c\u7528\u6237\u62a5\u6587\u52a0\u5bc6\u3001\u89e3\u5bc6\u4f7f\u7528\uff0c\u8bf7\u59a5\u5584\u4fdd\u7ba1\uff0c\u9632\u6b62\u6cc4\u9732\u3002", (String)"CmbOpaMetaDataImpl_20", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]));
        BankLoginConfig rsa = BankLoginConfigUtil.getBankLoginConfig((String)rsaKey, (String)ResManager.loadKDString((String)"RSA\u79c1\u94a5", (String)"CmbOpaMetaDataImpl_21", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), (String)"", (boolean)false, (boolean)false, (String)"upload");
        aes.setDesc(ResManager.loadKDString((String)"\u5ba2\u6237\u81ea\u5df1\u4fdd\u5b58\uff0c\u5bf9\u8bf7\u6c42\u62a5\u6587\u8fdb\u884c\u7b7e\u540d\u65f6\u4f7f\u7528\uff0c\u8bf7\u59a5\u5584\u4fdd\u7ba1\uff0c\u9632\u6b62\u6cc4\u9732\u3002", (String)"CmbOpaMetaDataImpl_22", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]));
        return Lists.newArrayList((Object[])new BankLoginConfig[]{aes, rsa, signTypeConfig});
    }

    public List<Class<? extends IBankService>> getBizImplClasses() {
        return Lists.newArrayList((Object[])new Class[]{FileReceiptImpl.class, BankReceiptFetchListImpl.class, FileReconciliationImpl.class, BankReceiptDownloadImpl.class, BankReconciliationFetchListImpl.class, BankReconciliationDownloadImpl.class});
    }

    public List<Class<? extends IBankBatchSeqIDCreator>> getBatchSeqIDClasses() {
        return Lists.newArrayList();
    }

    public List<Class<? extends IBankDetailSeqIDCreator>> getDetailSeqIDClasses() {
        return Lists.newArrayList();
    }

    public BankPropertyConfig getPropertyConfig() {
        return new BankBusinessConfig();
    }

    public List<BankLoginConfig> getBankLoginReceiptBaseConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)"is_support_today_receipt", (MultiLangEnumBridge)new MultiLangEnumBridge("\u662f\u5426\u652f\u6301\u5f53\u65e5\u56de\u5355", "CmbOpaMetaDataImpl_23", "ebg-receipt-banks-cmb-opa"), (MultiLangEnumBridge)new MultiLangEnumBridge("1.\u5982\u679c\u652f\u6301\uff0c\u5219\u4f1a\u81ea\u52a8\u521b\u5efa\u5f53\u65e5\u56de\u5355\u3002", "CmbOpaMetaDataImpl_24", "ebg-receipt-banks-cmb-opa"), (List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{PropertiesOptions.YES_NAME, PropertiesOptions.NO_NAME}), (List)Lists.newArrayList((Object[])new String[]{"true", "false"}), (String)"false", (boolean)false, (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)IS_UNIQUE, (MultiLangEnumBridge)new MultiLangEnumBridge("\u56de\u5355\u4e0b\u8f7d\u662f\u5426\u4e3a\u4e13\u7ebf\u8bbf\u95ee\u6a21\u5f0f", "CmbOpaMetaDataImpl_25", "ebg-receipt-banks-cmb-opa"), (List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u56de\u5355\u4e0b\u8f7d\u662f\u5426\u4e3a\u4e13\u7ebf\u8bbf\u95ee\u6a21\u5f0f\uff1a\u5982\u679c\u662f\u4e13\u7ebf\u6a21\u5f0f\u8bf7\u9009\u62e9\u662f\uff1b", "CmbOpaMetaDataImpl_26", "ebg-receipt-banks-cmb-opa"), new MultiLangEnumBridge("1\uff09\u5426\uff0c\u5373\u548c\u62db\u884c\u7ea6\u5b9a\u7684\u56de\u5355\u4e0b\u8f7d\u5730\u5740\u4e3a\u4e92\u8054\u7f51\uff08\u5373\u516c\u7f51\uff09\u6a21\u5f0f\uff1b\u9ed8\u8ba4\u9009\u9879", "CmbOpaMetaDataImpl_27", "ebg-receipt-banks-cmb-opa"), new MultiLangEnumBridge("2\uff09\u662f\uff0c\u5373\u548c\u62db\u884c\u7ea6\u5b9a\u7684\u56de\u5355\u4e0b\u8f7d\u4e3a\u4e13\u7ebf\u6a21\u5f0f\uff1b", "CmbOpaMetaDataImpl_28", "ebg-receipt-banks-cmb-opa")}), (List)Lists.newArrayList((Object[])new String[]{"true", "false"}), (List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{PropertiesOptions.YES_NAME, PropertiesOptions.NO_NAME}), (String)"false", (boolean)false, (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)FILE_FORMAT, (MultiLangEnumBridge)new MultiLangEnumBridge("\u56de\u5355\u6587\u4ef6\u683c\u5f0f", "CmbOpaMetaDataImpl_29", "ebg-receipt-banks-cmb-opa"), (List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u652f\u6301PDF\u548cOFD\u4e24\u79cd\u56de\u5355\u6587\u4ef6\u683c\u5f0f\uff0c\u9ed8\u8ba4\u662fPDF\u683c\u5f0f", "CmbOpaMetaDataImpl_30", "ebg-receipt-banks-cmb-opa")}), (List)Lists.newArrayList((Object[])new String[]{"PDF", "OFD"}), (List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{CmbCmpConstants.PDF_NAME, CmbCmpConstants.OFD_NAME}), (String)"PDF", (boolean)false, (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)DOWNLOAD_URL, (MultiLangEnumBridge)new MultiLangEnumBridge("\u56de\u5355\u4e0b\u8f7d\u7684\u57df\u540d", "CmbOpaMetaDataImpl_31", "ebg-receipt-banks-cmb-opa"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u884c\u8fd4\u56de\u7684\u56de\u5355\u4e0b\u8f7d\u5730\u5740\u4e2d\u7684\u57df\u540d\u5730\u5740\uff0c\u4f8b\u5982\u94f6\u884c\u8fd4\u56de\u7684\u56de\u5355\u4e0b\u8f7d\u94fe\u63a5\u5730\u5740\u4e3ahttps://cmb.com:443/xxxxxx\uff0c\u53ef\u4ee5\u628ahttps://cmb.com:443\u914d\u7f6e\u5230\u53c2\u6570\u4e2d\uff0c\u540e\u7eed\u901a\u8fc7\u56de\u5355\u4e0b\u8f7d\u57df\u540d\u7684\u4ee3\u7406\u670d\u52a1\u66ff\u6362\u8be5\u57df\u540d\u8fdb\u884c\u56de\u5355\u4e0b\u8f7d\u3002", "CmbOpaMetaDataImpl_32", "ebg-receipt-banks-cmb-opa"), (String)"", (boolean)false, (boolean)true), BankLoginConfigUtil.getMlBankLoginConfig((String)DOWNLOAD_PROXY_URL, (MultiLangEnumBridge)new MultiLangEnumBridge("\u56de\u5355\u4e0b\u8f7d\u57df\u540d\u7684\u4ee3\u7406\u670d\u52a1", "CmbOpaMetaDataImpl_33", "ebg-receipt-banks-cmb-opa"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5982\u9700\u914d\u7f6e\uff0c\u9700\u8981\u7528\u6237\u81ea\u884c\u914d\u7f6e\u597d\u4ee3\u7406\u670d\u52a1\uff0c\u5982nginx\uff0c\u7136\u540e\u628a\u4ee3\u7406\u670d\u52a1\u5730\u5740\u914d\u7f6e\u5230\u53c2\u6570\u4e2d\uff0c\u4f8b\u5982https://127.0.0.1:443\u3002\u4f5c\u7528\u662f\u4ee3\u7406\u670d\u52a1\u66ff\u6362\u6389\u56de\u5355\u4e0b\u8f7d\u7684\u57df\u540d\u3002", "CmbOpaMetaDataImpl_34", "ebg-receipt-banks-cmb-opa"), (String)"", (boolean)false, (boolean)true)});
    }

    public boolean isShowOFDSignConfig() {
        return true;
    }
}

