/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cmb.opa.service.reconciliation;

import java.time.LocalDate;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.banks.cmb.opa.service.reconciliation.api.IssueBillOfd;
import kd.ebg.receipt.business.receipt.atom.reconciliation.AbstractBankReconciliationFetchHandleImpl;
import kd.ebg.receipt.business.receipt.atom.reconciliation.IBankReconciliationHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.reconciliation.BankReconciliationRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.reconciliation.BankReconciliationResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.reconciliation.BankReconciliationHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.reconciliation.BankReconciliationHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.services.reconciliation.ReconciliationDownloadListDetailService;
import kd.ebg.receipt.common.framework.utils.CurrencyUtils;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationDetail;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReconciliationFetchListImpl
extends AbstractBankReconciliationFetchHandleImpl
implements IBankReconciliationHandle {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BankReconciliationFetchListImpl.class);
    public ReconciliationDownloadListDetailService reconciliationDownloadListDetailService;

    public void init(BankReconciliationHandleRequest request) {
        this.reconciliationDownloadListDetailService = (ReconciliationDownloadListDetailService)SpringContextUtil.getBean(ReconciliationDownloadListDetailService.class);
    }

    public boolean match(BankReconciliationHandleRequest request) {
        if (request == null) {
            return false;
        }
        if (!RequestContextUtils.isSupportReconciliation((String)EBContext.getContext().getBankLoginID())) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u8be5\u94f6\u884c\u4e0d\u652f\u6301\u5bf9\u8d26\u5355", (String)"", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0]));
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReconciliationHandleResponseEB doBiz(BankReconciliationHandleRequest request) {
        this.init(request);
        LocalDate transDate = request.getTransDate();
        String accNo = request.getAccNo();
        BankAcnt acnt = new BankAcnt();
        BankAcnt mainAcnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
        String currency = mainAcnt.getCurrency();
        String bankCurrency = CurrencyUtils.convert2Bank((String)currency);
        acnt.setAccNo(accNo);
        acnt.setCurrency(bankCurrency);
        ArrayList<ReconciliationDetail> result = new ArrayList<ReconciliationDetail>(16);
        IssueBillOfd issueBillOfd = new IssueBillOfd();
        BankReconciliationRequest bankReceiptRequest = BankReconciliationRequest.builder().accNo(accNo).transDate(transDate).build();
        BankHeader bankHeader = new BankHeader();
        bankHeader.setAcnt(acnt);
        bankReceiptRequest.setHeader(bankHeader);
        BankReconciliationResponseEB iboResp = (BankReconciliationResponseEB)issueBillOfd.doBiz((BankRequest)bankReceiptRequest);
        String issueKey = (String)iboResp.getData();
        logger.info("issueKey{}", (Object)issueKey);
        if (!StringUtils.isEmpty((String)issueKey)) {
            bankReceiptRequest.setRequestStr(issueKey);
            ReconciliationDetail detail = new ReconciliationDetail();
            detail.setFileLink(issueKey);
            detail.setFileName(issueKey + "_reconciliation_ofd.tar.gz");
            result.add(detail);
        }
        return BankReconciliationHandleResponseEB.success(result);
    }

    public boolean isBreak() {
        return true;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

