-- 规则执行方案执行范围
IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 'T_EB_RULECASEEXECRANGE')
CREATE TABLE T_EB_RULECASEEXECRANGE (
	FID				    BIGINT 			NOT NULL DEFAULT 0,
	FNUMBER 		    NVARCHAR(255)   NOT NULL DEFAULT ' ',
	FNAME 			    NVARCHAR(255)   NOT NULL DEFAULT ' ',
	FEXECRANGE		    NCLOB,
	FMODELID		    BIGINT 			NOT NULL DEFAULT 0,
	FBIZMODELID		    BIGINT 			NOT NULL DEFAULT 0,
	FDEFAULTSHOWSTATUS  CHAR(1)         DEFAULT '0' NOT NULL,
	FSCHEDULESTATUS     CHAR(1)         DEFAULT '0' NOT NULL,
	FCREATERFIELD		BIGINT 			NOT NULL DEFAULT 0,
	FMODIFIERFIELD		BIGINT 			NOT NULL DEFAULT 0,
	FCREATEDATEFIELD 	DATETIME        NULL,
	FMODIFYDATEFIELD 	DATETIME        NULL,
	FEXECJSONSHOW		NVARCHAR(255)   NOT NULL DEFAULT ' ',
	FCASESHOWSTR		NVARCHAR(255)   NOT NULL DEFAULT ' '
);
EXEC P_ALTERPK 'PK_EB_RULECASEEXECRANGE', 'T_EB_RULECASEEXECRANGE', 'FID', '1';


-- 规则执行方案执行范围对应执行方案表
IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 'T_EB_RULECASEEXECRANGE_CA')
CREATE TABLE T_EB_RULECASEEXECRANGE_CA (
	FPKID			BIGINT 			NOT NULL DEFAULT 0,
	FID		        BIGINT 			NOT NULL DEFAULT 0,
	FBASEDATAID		BIGINT 			NOT NULL DEFAULT 0
);

EXEC P_ALTERPK 'PK_EB_RULECASEEXECRANGE_CA', 'T_EB_RULECASEEXECRANGE_CA', 'FPKID', '1';

IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IDX_EB_RULECASEEXECRANGE_CA_FK')
CREATE INDEX IDX_EB_RULECASEEXECRANGE_CA_FK ON T_EB_RULECASEEXECRANGE_CA (FID);


-- 规则执行方案执行范围多语言表
IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 'T_EB_RULECASEEXECRANGE_L')
CREATE TABLE T_EB_RULECASEEXECRANGE_L (
	FPKID				NVARCHAR(36) 			NOT NULL DEFAULT ' ',
	FID		            BIGINT 		            NOT NULL DEFAULT 0,
	FLOCALEID			NVARCHAR(10) 			NOT NULL DEFAULT ' ',
	FNAME				NVARCHAR(255) 			NOT NULL DEFAULT ' '
);

EXEC P_ALTERPK 'PK_EB_RULECASEEXECRANGE_L', 'T_EB_RULECASEEXECRANGE_L', 'FPKID', '1';

IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IDX_EB_RULECASEEXECRANGE_L_0')
CREATE INDEX IDX_EB_RULECASEEXECRANGE_L_0 ON T_EB_RULECASEEXECRANGE_L (FID, FLOCALEID);