/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas.report;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.ReportModel;
import kd.epm.eb.business.servicehelper.DimensionPropertyServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.spread.util.GZIPUtils;
import kd.epm.eb.formplugin.analysiscanvas.report.AbstractReportHelper;
import kd.epm.eb.formplugin.utils.TemplateHelper;
import kd.epm.eb.spread.command.lockcontroller.ISpreadLockControl;
import kd.epm.eb.spread.command.lockcontroller.SpreadLockContext;
import kd.epm.eb.spread.command.lockcontroller.lockcell.DataLockCellLockController;
import kd.epm.eb.spread.command.lockcontroller.lockcell.NoLeafCellLockController;
import kd.epm.eb.spread.command.lockcontroller.lockcell.PageViewDimNoLeafController;
import kd.epm.eb.spread.command.lockcontroller.lockcell.RollCellLockController;
import kd.epm.eb.spread.command.rangedefined.ContextMenuItemsEnum;
import kd.epm.eb.spread.command.rangedefined.SheetFrozenInfo;
import kd.epm.eb.spread.command.rangedefined.ToolBarItemsEnum;
import kd.epm.eb.spread.command.style.CellStyleInfo;
import kd.epm.eb.spread.command.stylecontroller.ISpreadStyleControl;
import kd.epm.eb.spread.command.stylecontroller.SpreadStyleControlContext;
import kd.epm.eb.spread.command.stylecontroller.styleset.ColDimCenterController;
import kd.epm.eb.spread.command.stylecontroller.styleset.EnumMetricCellController;
import kd.epm.eb.spread.command.stylecontroller.styleset.SheetMetricDimStyleController;
import kd.epm.eb.spread.command.stylecontroller.styleset.SheetRowColWidthController;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.spreadmanager.EbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.book.EBook;
import kd.epm.eb.spread.template.spreadmanager.book.IEBook;
import kd.epm.eb.spread.template.spreadmanager.hander.ESpanInfo;
import kd.epm.eb.spread.template.spreadmanager.serializer.EbSpreadManagerSerializerUtil;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.StyleCell;
import kd.epm.eb.spread.utils.DimPropertyHelper;
import org.apache.commons.collections.CollectionUtils;

public class DynamicReportHelper
extends AbstractReportHelper {
    private List<Integer> autofitrows;
    private List<Integer> autofircols;
    private List<SpreadStyleControlContext.RowColsWidth> colswidth;
    private List<SpreadStyleControlContext.RowColsWidth> rowsheigth;
    private int cellIndetCol = -1;

    public DynamicReportHelper(CustomItem customItem, ReportModel reportModel, ITemplateModel templateModel, IModelCacheHelper modelCache, IFormView formView) {
        super(customItem, reportModel, templateModel, modelCache, formView);
    }

    protected void beforeResolveStyles() {
        ISheet sheet = this.getSpreadManager().getEbook().getSheet(0);
        if (sheet.getValueAreaRowStart() < 0 || sheet.getValueAreaColStart() < 0) {
            return;
        }
        this.resolveSpreadLock();
        this.rowColDimensionSpecialColor();
        this.setCellStyles();
        Map rowColDimMemsMap = TemplateHelper.getRowColDimMemsMap((ITemplateModel)this.templateModel);
        ArrayList rowColDims = new ArrayList(rowColDimMemsMap.keySet());
        Map propertyMap = DimensionPropertyServiceHelper.getInstance().queryDimensionPropertysByNum(this.templateModel.getModelId(), rowColDims);
        this.setTitleDimName(propertyMap);
    }

    protected void invokeSpreadJson() {
        ISpreadContainer spreadContainer = this.getSpreadContainer();
        IEBook ieBook = this.getSpreadManager().getEbook();
        if (ieBook.getSheet(0).getValueAreaRowStart() > 0) {
            byte[] bb;
            try {
                String spreadjson = ieBook.toJsonWithRealRowCol();
                bb = Base64.getEncoder().encode(GZIPUtils.compress((String)spreadjson));
                spreadjson = null;
            }
            catch (IOException e2) {
                throw new KDBizException(e2.getMessage());
            }
            spreadContainer.rebuildSpread("base64" + new String(bb));
            bb = null;
        }
        if (this.cellIndetCol >= 0) {
            Map indentParents = this.getSpreadManager().getIndentParents();
            this.getSpreadContainer().setOutlineColumn(this.cellIndetCol, Boolean.FALSE, Integer.valueOf(20), indentParents);
        }
        int startcol = this.getSpreadManager().getEbook().getSheet(0).getValueAreaColStart();
        int startrow = this.getSpreadManager().getEbook().getSheet(0).getValueAreaRowStart();
        this.getSpreadContainer().frozenSheet(new SheetFrozenInfo(Integer.valueOf(startrow), null, Integer.valueOf(startcol), null));
        if (this.autofircols != null && this.autofircols.size() > 0) {
            this.getSpreadContainer().setColsAutoFit(this.autofircols);
        }
        if (this.autofitrows != null && this.autofitrows.size() > 0) {
            this.getSpreadContainer().setRowsAutoFit(this.autofitrows);
        }
        if (this.colswidth != null && this.colswidth.size() > 0) {
            this.colswidth.forEach(e -> this.getSpreadContainer().setColumnsWidth(e.getRowcols(), e.getWidth()));
        }
        if (this.rowsheigth != null && this.rowsheigth.size() > 0) {
            this.rowsheigth.forEach(e -> this.getSpreadContainer().setRowsHeight(e.getRowcols(), e.getWidth()));
        }
        this.handleMetricDimRowVisiable();
    }

    private void handleMetricDimRowVisiable() {
        Optional<SpreadStyleControlContext.RowColsWidth> first;
        SpreadStyleControlContext.RowColsWidth rowColsWidth;
        List<Integer> metricColIndex = this.getHideMetricColIndex();
        List<Integer> metricRowIndex = this.getHideMetricRowIndex();
        boolean isHideMetric = this.getTemplateModel().getIsHideMetric();
        boolean metricInRow = Boolean.TRUE.equals(this.getTemplateModel().getAreaRangeEntry().isMetricInRow());
        if (CollectionUtils.isNotEmpty(metricColIndex) && metricInRow) {
            if (!isHideMetric && (rowColsWidth = (SpreadStyleControlContext.RowColsWidth)(first = this.colswidth.stream().filter(x -> x.getRowcols().equals(metricColIndex)).findFirst()).orElse(null)) != null && rowColsWidth.getWidth() == 0) {
                this.getSpreadContainer().setColsAutoFit(metricColIndex);
            }
            this.getSpreadContainer().setColumnsVisible(metricColIndex, !isHideMetric);
        }
        if (CollectionUtils.isNotEmpty(metricRowIndex) && !metricInRow) {
            if (!isHideMetric && (rowColsWidth = (SpreadStyleControlContext.RowColsWidth)(first = this.rowsheigth.stream().filter(x -> x.getRowcols().equals(metricRowIndex)).findFirst()).orElse(null)) != null && rowColsWidth.getWidth() == 0) {
                this.getSpreadContainer().setRowsAutoFit(metricRowIndex);
            }
            this.getSpreadContainer().setRowsVisible(metricRowIndex, !isHideMetric);
        }
    }

    protected List<Integer> getHideMetricColIndex() {
        Integer metricColIndex = this.getSpreadManager().getMetricColIndex();
        if (metricColIndex != null) {
            ArrayList<Integer> indexList = new ArrayList<Integer>(1);
            indexList.add(metricColIndex);
            return indexList;
        }
        return null;
    }

    protected List<Integer> getHideMetricRowIndex() {
        Integer metricRowIndex = this.getSpreadManager().getMetricRowIndex();
        if (metricRowIndex != null) {
            ArrayList<Integer> indexList = new ArrayList<Integer>(1);
            indexList.add(metricRowIndex);
            return indexList;
        }
        return null;
    }

    protected void afterResolveStyles() {
        SpreadStyleControlContext spreadStyleControlContext = this.getSpreadStyleControlContext();
        if (spreadStyleControlContext == null) {
            return;
        }
        if (spreadStyleControlContext.getRowEnumCells().size() > 0) {
            this.getSpreadContainer().setFListCells(spreadStyleControlContext.getRowEnumCells(), true, true);
        }
        if (spreadStyleControlContext.getColEnumCells().size() > 0) {
            this.getSpreadContainer().setFListCells(spreadStyleControlContext.getColEnumCells(), true, true);
        }
    }

    protected void resolveSpreadLock() {
        boolean designMode = Boolean.parseBoolean(this.getView().getPageCache().get("designMode"));
        if (designMode) {
            this.lockAllData();
            return;
        }
        ArrayList<ISpreadLockControl> spreadStyleControls = new ArrayList<ISpreadLockControl>(16);
        this.resolveSpreadLockController(spreadStyleControls);
        SpreadLockContext controlContext = this.getSpreadContext();
        if (controlContext == null || controlContext.getEbSpreadManager() == null) {
            return;
        }
        for (ISpreadLockControl style : spreadStyleControls) {
            style.control(controlContext);
            if (!controlContext.isStopcommand()) continue;
            break;
        }
    }

    protected SpreadLockContext getSpreadContext() {
        return new SpreadLockContext(this.getSpreadManager(), this.getTemplateModel());
    }

    protected void resolveSpreadLockController(List<ISpreadLockControl> spreadLockControls) {
        spreadLockControls.add((ISpreadLockControl)new PageViewDimNoLeafController(this.getView()));
        spreadLockControls.add((ISpreadLockControl)new NoLeafCellLockController());
        spreadLockControls.add((ISpreadLockControl)new RollCellLockController());
        spreadLockControls.add((ISpreadLockControl)new DataLockCellLockController());
    }

    protected void lockAllData() {
        this.getSpreadContext().lockAllData(null, "#FFF8E1");
    }

    protected void rowColDimensionSpecialColor() {
        StyleCell styleCell;
        int col;
        int dimStartrow;
        int row;
        ISheet sheet = this.getSpreadManager().getEbook().getSheet(0);
        CellStyleInfo cellStyleInfo = this.getRowColDimensionAreaColor();
        int maxcol = this.getSpreadManager().getEbook().getSheet(0).getRealMaxCols();
        int maxrow = this.getSpreadManager().getEbook().getSheet(0).getRealMaxRows();
        int startcol = this.getSpreadManager().getEbook().getSheet(0).getValueAreaColStart();
        int startrow = this.getSpreadManager().getEbook().getSheet(0).getValueAreaRowStart();
        int dimStartcol = this.getSpreadManager().getEbook().getSheet(0).getDimColStart();
        for (row = dimStartrow = this.getSpreadManager().getEbook().getSheet(0).getDimRowStart(); row < startrow; ++row) {
            for (col = dimStartcol; col < maxcol; ++col) {
                styleCell = (StyleCell)sheet.getECell(row, col);
                styleCell.setLocked(true);
                styleCell.setBackColor(cellStyleInfo.getBkc());
            }
        }
        for (row = dimStartrow; row < maxrow; ++row) {
            for (col = dimStartcol; col < startcol; ++col) {
                styleCell = (StyleCell)sheet.getECell(row, col);
                styleCell.setLocked(true);
                styleCell.setBackColor(cellStyleInfo.getBkc());
            }
        }
    }

    protected CellStyleInfo getRowColDimensionAreaColor() {
        CellStyleInfo cellStyleInfo = new CellStyleInfo();
        cellStyleInfo.setBkc("#F3F3F5");
        cellStyleInfo.setF("10pt Microsoft YaHei");
        return cellStyleInfo;
    }

    protected void setCellStyles() {
        ArrayList<ISpreadStyleControl> spreadStyleControls = new ArrayList<ISpreadStyleControl>();
        this.resolveSpreadStyleController(spreadStyleControls);
        SpreadStyleControlContext spreadStyleControlContext = this.getSpreadStyleControlContext();
        spreadStyleControls.forEach(stylecontrol -> stylecontrol.control(spreadStyleControlContext));
        this.autofitrows = spreadStyleControlContext.getAutofitrows();
        this.autofircols = spreadStyleControlContext.getAutofitcols();
        this.colswidth = spreadStyleControlContext.getColsWidths();
        this.rowsheigth = spreadStyleControlContext.getRowsheigths();
    }

    protected SpreadStyleControlContext getSpreadStyleControlContext() {
        SpreadStyleControlContext spreadStyleControlContext = new SpreadStyleControlContext(this.getSpreadManager());
        spreadStyleControlContext.setTemplateModel(this.getTemplateModel());
        return spreadStyleControlContext;
    }

    protected void resolveSpreadStyleController(List<ISpreadStyleControl> spreadStyleControls) {
        spreadStyleControls.clear();
        spreadStyleControls.add((ISpreadStyleControl)new SheetMetricDimStyleController());
        spreadStyleControls.add((ISpreadStyleControl)new SheetRowColWidthController());
        spreadStyleControls.add((ISpreadStyleControl)new ColDimCenterController());
        spreadStyleControls.add((ISpreadStyleControl)new EnumMetricCellController());
    }

    protected void setTitleDimName(Map<String, List<PropertyObj>> propertyMap) {
        ISheet sheet = this.getSpreadManager().getEbook().getSheet(0);
        int startcol = this.getSpreadManager().getEbook().getSheet(0).getValueAreaColStart();
        int rows = this.getSpreadManager().getColpartitionDims().size();
        int dimStartcol = this.getSpreadManager().getEbook().getSheet(0).getDimColStart();
        int dimStartrow = this.getSpreadManager().getEbook().getSheet(0).getDimRowStart();
        IModelCacheHelper helper = ModelCacheContext.getOrCreate((Long)this.getTemplateModel().getModelId());
        String dimNum = "";
        for (int col = dimStartcol; col < startcol; ++col) {
            Object typeNumObj;
            StyleCell styleCell = (StyleCell)sheet.getECell(dimStartrow, col);
            Object dimNumber = sheet.getECell(rows + dimStartrow, col).getUserObject("dimnumber");
            if (dimNumber != null) {
                dimNum = dimNumber.toString();
                styleCell.setValue((Object)helper.getDimension(dimNum).getName());
                styleCell.setChangeVal(true);
                styleCell.setUserObject("dimnumber", dimNumber);
                styleCell.setUserObject("number", dimNumber);
                styleCell.setSpanInfo(new ESpanInfo(rows, 1));
                continue;
            }
            String typename = "";
            if (propertyMap != null && propertyMap.containsKey(dimNum) && (typeNumObj = sheet.getECell(rows + dimStartrow, col).getUserObject("typenum")) != null) {
                String typenum = typeNumObj.toString();
                PropertyObj propertyObj = propertyMap.get(dimNum).stream().filter(temProperty -> temProperty.getNumber().equals(typenum)).findFirst().orElse(null);
                if (propertyObj != null) {
                    typename = propertyObj.getName();
                    DimPropertyHelper.setPropertyCellUserObject((ECell)styleCell, (String)dimNum, (String)"", (String)typenum, (String)typename, (String)"");
                }
            }
            styleCell.setValue((Object)typename);
            styleCell.setChangeVal(true);
            styleCell.setSpanInfo(new ESpanInfo(rows, 1));
        }
    }

    public void cacheSpreadManager() {
        this.formView.getPageCache().put("spreadManagerCacheKey" + this.pageCacheKeySuffix, EbSpreadManagerSerializerUtil.toJson((IEbSpreadManager)this.spreadManager));
    }

    protected List<ToolBarItemsEnum> getHideToolBarItems() {
        return null;
    }

    protected List<ContextMenuItemsEnum> getHideContextMenuItems() {
        return super.getHideContextMenuItems();
    }

    public void initSpreadManager(String itemId, ReportModel reportModel, ITemplateModel templateModel, IModelCacheHelper modelCache, Map<String, String> filterDim) {
        this.spreadManager = new EbSpreadManager();
        this.setCacheVar();
        EBook ieBook = new EBook(new String[]{"Sheet1"});
        this.spreadManager.setEbook((IEBook)ieBook);
        ieBook.getSheet(0).setStyleCell(true);
        this.spreadManager.buildReportManager(templateModel);
        this.initHideDim(this.spreadManager, templateModel, modelCache);
        this.initPageDim(reportModel, this.spreadManager, modelCache, filterDim);
        this.initFormulaMap(templateModel, this.spreadManager);
        this.dealCellsIndent(this.spreadManager);
    }

    private void dealCellsIndent(IEbSpreadManager ebSpreadManager) {
        Map indentcells = ebSpreadManager.getIndentcells();
        if (indentcells != null && indentcells.size() > 0) {
            Integer[] col = new Integer[1];
            indentcells.forEach((key, cells) -> {
                int ti = key;
                if (cells != null && cells.size() > 0) {
                    if (col[0] == null) {
                        col[0] = ((ECell)cells.get(0)).getCol();
                    }
                    cells.forEach(cell -> {
                        if (cell != null) {
                            ((StyleCell)cell).setTextIndent(ti);
                        }
                    });
                }
            });
            this.cellIndetCol = col[0];
        }
    }
}

