/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analyze;

import com.google.common.collect.Lists;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.OperationContext;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.param.FuzzySearch;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.ModelCacheServiceHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.ModelDetailPeriodEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.permission.EBPermission;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.TreeNodeUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.excel.BgExcelWriter;
import kd.epm.eb.control.BgControlCallerImpl;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;

public class ExecuteAnalyze
extends AbstractListPlugin
implements TreeNodeClickListener,
RowClickEventListener,
ClickListener,
EBPermission,
HyperLinkClickListener,
BasedataFuzzySearchListener,
BeforeF7SelectListener {
    private static final Pattern com = Pattern.compile("[^0-9]");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00%");
    private static final List<String> dimKeys = Lists.newArrayList((Object[])new String[]{"currency", "period", "year", "version", "entity", "subject"});
    private static final List<String> YEARLISTS = Lists.newArrayList((Object[])new String[]{"Q_YearTotal", "HF_YearTotal", "M_YearTotal", "AllYear"});
    private static final List<String> PERIODLISTS = Lists.newArrayList((Object[])new String[]{"M_HF2", "Q_HF2", "HF_HF2", "M_Q2", "M_Q3", "M_Q4", "Q_Q2", "Q_Q3", "Q_Q4"});
    private static final List<String> DimensionList = Lists.newArrayList((Object[])new String[]{SysDimensionEnum.Currency.getNumber(), SysDimensionEnum.Period.getNumber(), SysDimensionEnum.Year.getNumber(), SysDimensionEnum.Version.getNumber(), SysDimensionEnum.Entity.getNumber()});
    private static final String modelCacheKey = "KEY_MODEL_ID";
    private static final String customDimsInfoCache = "customDimsInfoCache";
    public static final String EB_EXECUTEANALYZEHISTORY = "eb_executeanalyzehistory";
    public static final String EB_COSTTYPE = "eb_costtype";
    public static final String EB_ANALYZEWAY = "eb_analyzeway";
    public static final String EB_RELEVANCEANALYZE = "eb_relevanceanalyze";
    public static final String EB_ANALYZESINGLEF_7 = "eb_analyzesinglef7";
    public static final String TREEENTRYENTITY = "treeentryentity";
    private DynamicInfoCollection customdimInfo = null;
    private static final Log log = LogFactory.getLog(ExecuteAnalyze.class);

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"costtypetext"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        if (evt.getSource() instanceof Control) {
            this.checkPermission(this.getView(), ((Control)evt.getSource()).getKey());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap", "floatmenuap"});
        this.addF7SelectListeners("model", "entity", "year", "period", "version", "currency", "costtypetext", "subject");
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("model");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        treeEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
        if (IDUtils.isNotNull((Long)modelId)) {
            this.getPageCache().put(modelCacheKey, modelId.toString());
            this.getModel().setValue("model", (Object)modelId);
            this.getPageCache().put("yuan", "0");
            this.getPageCache().put("OldpageIndex", "1");
            this.getPageCache().put("initstate", "1");
            this.getPageCache().put("pageRow", "10");
            this.userMemory(modelId);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"costtype"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelap3"});
            this.setDetailValue(true);
            this.refreshEntryentity();
            this.yearAnaylzeData(true);
            this.viewMessage();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ExecuteAnalyze_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void viewMessage() {
        String message = this.getPageCache().get("message");
        if (message != null && !message.isEmpty()) {
            this.getView().showTipNotification(message);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("model".equals(key)) {
            this.setDetailValue(true);
            if (this.getModel().getValue("model") != null) {
                Long model = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
                this.userMemory(model);
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)model);
            } else {
                this.getModel().setValue("costtypetext", null);
                this.clearDimValue();
            }
            this.loadData(true);
        } else if ("costtypetext".equals(key) && this.getPageCache().get("userMemory") == null) {
            this.initDimensions();
        } else if (dimKeys.contains(key) && this.getPageCache().get("userMemory") == null) {
            if ("period".equals(key)) {
                this.setDetailValue(false);
            }
            this.loadData(true);
        } else if ("entity".equals(key) && this.getPageCache().get("userMemory") == null) {
            this.loadData(false);
        } else if ("mon".equals(key) || "que".equals(key) || "hef".equals(key)) {
            this.yearAnaylzeData(false);
        }
    }

    private void initDimensions() {
        this.clearDimValue();
        if (this.getModel().getValue("costtypetext") != null) {
            this.getPageCache().put("initstate", "1");
            this.initDimmensionRangPageCache();
        }
        this.loadData(false);
    }

    private void userMemory(Long model) {
        this.getPageCache().put(modelCacheKey, model.toString());
        QFilter qFilter = new QFilter("model", "=", (Object)IDUtils.toLong((Object)model));
        QFilter userFilter = new QFilter("modifyer", "=", (Object)UserUtils.getUserId());
        String selectFields = "model,costtype,entity,year,version,currency,period,modifyer,application,formid,subject";
        DynamicObject query = BusinessDataServiceHelper.loadSingleFromCache((String)EB_EXECUTEANALYZEHISTORY, (String)selectFields, (QFilter[])new QFilter[]{qFilter, userFilter});
        DynamicObjectCollection objectCollection = this.searchCostTypeValue();
        ArrayList<String> typeIds = new ArrayList<String>(objectCollection.size());
        for (DynamicObject dynamicObject : objectCollection) {
            typeIds.add(dynamicObject.getString("id"));
        }
        if (query != null && this.isVoidJudgment(query)) {
            Long userId = UserUtils.getUserId();
            if (typeIds.contains(query.getString("costtype_id"))) {
                this.getPageCache().put("userMemory", "1");
                Map<String, List<Long>> stringListMap = this.getStringListMap(query.getString("costtype_id"));
                List<Long> accountLongs = this.getAccountLongs(query.getString("costtype_id"));
                this.getModel().setValue("costtypetext", query.get("costtype_id"));
                Long modelId = this.getModelId();
                Set perm = DimMembPermHelper.getReadPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)modelId, (Long)0L, null, (boolean)true);
                long entityId = query.getLong("entity_id");
                if (perm == null || perm.contains(entityId)) {
                    this.setDimensionId(query, stringListMap, "entity", "entity_id");
                }
                this.setDimensionId(query, stringListMap, "year", "year_id");
                this.setDimensionId(query, stringListMap, "period", "period_id");
                Set permMembIds = DimMembPermHelper.getReadPermMembIds((String)SysDimensionEnum.Version.getNumber(), (Long)modelId, (Long)0L, null, (boolean)true);
                long versionId = query.getLong("version_id");
                if (permMembIds == null || permMembIds.contains(versionId)) {
                    this.setDimensionId(query, stringListMap, "version", "version_id");
                }
                this.setDimensionId(query, stringListMap, "currency", "currency_id");
                ArrayList subiects = new ArrayList(16);
                DynamicObjectCollection subject = (DynamicObjectCollection)query.get("subject");
                subject.forEach(su -> {
                    if (su.get("fbasedataid") != null && !((DynamicObject)su.get("fbasedataid")).getString("number").equals(SysDimensionEnum.Account.getNumber())) {
                        subiects.add(su.getLong("fbasedataid_id"));
                    }
                });
                Set readPermMembIds = DimMembPermHelper.getReadPermMembIds((String)SysDimensionEnum.Account.getNumber(), (Long)modelId, (Long)0L, null, (boolean)true);
                ArrayList<Long> account = new ArrayList<Long>(16);
                for (Long subiect : subiects) {
                    if (readPermMembIds != null && !readPermMembIds.contains(subiect)) continue;
                    account.add(subiect);
                }
                ArrayList accounts = new ArrayList(16);
                accountLongs.forEach(e -> {
                    if (account.contains(e)) {
                        accounts.add(e);
                    }
                });
                if (accounts.size() > 0) {
                    this.getModel().setValue("subject", (Object)accounts.toArray());
                } else {
                    DynamicObject costtypetext = (DynamicObject)this.getModel().getValue("costtypetext");
                    this.setAccountF7(costtypetext);
                }
                this.getPageCache().remove("userMemory");
            }
        } else {
            this.setCostTypeValue();
        }
    }

    private void setDimensionId(DynamicObject query, Map<String, List<Long>> stringListMap, String year, String yearId) {
        if (stringListMap.get(year) != null) {
            List<Long> entity = stringListMap.get(year);
            if (entity.contains(query.getLong(yearId))) {
                this.getModel().setValue(year, query.get(yearId));
            } else if (entity.size() > 0) {
                this.getModel().setValue(year, (Object)entity.get(0));
            }
        }
    }

    private boolean isVoidJudgment(DynamicObject query) {
        if (query.get("costtype") == null || query.get("entity") == null || query.get("year") == null || query.get("period") == null || query.get("version") == null || query.get("currency") == null) {
            return false;
        }
        DynamicObject entity = (DynamicObject)query.get("entity");
        if (SysDimensionEnum.Entity.getNumber().equals(entity.get("number"))) {
            return false;
        }
        DynamicObject year = (DynamicObject)query.get("year");
        if (SysDimensionEnum.Year.getNumber().equals(year.get("number")) || "AllYear".equals(year.get("number"))) {
            return false;
        }
        DynamicObject period = (DynamicObject)query.get("period");
        if (SysDimensionEnum.Period.getNumber().equals(period.get("number")) || "HF_YearTotal".equals(period.get("number")) || "Q_YearTotal".equals(period.get("number")) || "M_YearTotal".equals(period.get("number"))) {
            return false;
        }
        DynamicObject version = (DynamicObject)query.get("version");
        if (SysDimensionEnum.Version.getNumber().equals(version.get("number"))) {
            return false;
        }
        DynamicObject currency = (DynamicObject)query.get("currency");
        if (SysDimensionEnum.Currency.getNumber().equals(currency.get("number"))) {
            return false;
        }
        ArrayList cost = new ArrayList(16);
        DynamicObjectCollection objectCollection = this.searchCostTypeValue();
        objectCollection.forEach(e -> cost.add(e.getString("id")));
        return query.get("costtype") == null || cost.contains(((DynamicObject)query.get("costtype")).getString("id"));
    }

    private void setDetailValue(Boolean isEnable) {
        if (isEnable.booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"mon", "que", "hef"});
        }
        this.getModel().setValue("mon", (Object)false);
        this.getModel().setValue("que", (Object)false);
        this.getModel().setValue("hef", (Object)false);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        this.checkPermission(this.getView(), evt.getItemKey());
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "close": {
                this.getView().close();
                break;
            }
            case "refresh": {
                this.getPageCache().put("OldpageIndex", "1");
                this.getPageCache().put("initstate", "1");
                this.getPageCache().put("pageRow", "10");
                this.refreshEntryentity();
                this.yearAnaylzeData(false);
                break;
            }
            case "floatmenuitemap": {
                this.switchHideShowPageDims();
                break;
            }
            case "btn_export": {
                this.exportData();
                break;
            }
        }
        if (key.contains("btn_unit")) {
            this.switchingUnit(key);
        }
    }

    private void exportData() {
        IDataModel model = this.getModel();
        Map<String, DynamicObject> accountMapChache = this.getAccountMapChache();
        if (accountMapChache == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u51fa\u7684\u6709\u6548\u6570\u636e\u3002", (String)"ExecuteAnalyze_38", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject period = (DynamicObject)model.getValue("period");
        DynamicObject modelValue = (DynamicObject)model.getValue("model");
        DynamicObject entity = (DynamicObject)model.getValue("entity");
        DynamicObject year = (DynamicObject)model.getValue("year");
        DynamicObject version = (DynamicObject)model.getValue("version");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        if (period == null || modelValue == null || entity == null || year == null || version == null || currency == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u51fa\u7684\u6709\u6548\u6570\u636e\u3002", (String)"ExecuteAnalyze_38", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
        BgExcelWriter excelWriter = BgExcelWriter.getInstance().readTemplateByClasspath("datacollection/execute_export.xlsx");
        excelWriter.setStarPosition(2, 0);
        excelWriter.createRow(new Object[]{ResManager.loadKDString((String)"\u4f53\u7cfb", (String)"ExecuteAnalyze_39", (String)"epm-eb-formplugin", (Object[])new Object[0]), modelValue.getString("shownumber"), modelValue.getString("name")});
        excelWriter.setStarPosition(3, 0);
        excelWriter.createRow(new Object[]{ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"ExecuteAnalyze_40", (String)"epm-eb-formplugin", (Object[])new Object[0]), entity.getString("number"), entity.getString("name")});
        excelWriter.setStarPosition(4, 0);
        excelWriter.createRow(new Object[]{ResManager.loadKDString((String)"\u8d22\u5e74", (String)"ExecuteAnalyze_41", (String)"epm-eb-formplugin", (Object[])new Object[0]), year.getString("number"), year.getString("name")});
        excelWriter.setStarPosition(5, 0);
        excelWriter.createRow(new Object[]{ResManager.loadKDString((String)"\u671f\u95f4", (String)"ExecuteAnalyze_42", (String)"epm-eb-formplugin", (Object[])new Object[0]), period.getString("number"), period.getString("name")});
        excelWriter.setStarPosition(6, 0);
        excelWriter.createRow(new Object[]{ResManager.loadKDString((String)"\u7248\u672c", (String)"ExecuteAnalyze_43", (String)"epm-eb-formplugin", (Object[])new Object[0]), version.getString("number"), version.getString("name")});
        excelWriter.setStarPosition(7, 0);
        excelWriter.createRow(new Object[]{ResManager.loadKDString((String)"\u5e01\u79cd", (String)"ExecuteAnalyze_44", (String)"epm-eb-formplugin", (Object[])new Object[0]), currency.getString("number"), currency.getString("name")});
        excelWriter.setStarPosition(8, 4);
        excelWriter.createRow(new Object[]{period.getString("name"), "", "", "", "", "", ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1", (String)"ExecuteAnalyze_37", (String)"epm-eb-formplugin", (Object[])new Object[0])});
        excelWriter.setStarPosition(10, 3);
        CellStyle numberCellStyle = excelWriter.getWorkbook().createCellStyle();
        CreationHelper creationHelper = excelWriter.getWorkbook().getCreationHelper();
        numberCellStyle.setDataFormat(creationHelper.createDataFormat().getFormat("#,##0.00"));
        for (DynamicObject row : dataEntity.getDynamicObjectCollection(TREEENTRYENTITY)) {
            DynamicObject dynamicObject = accountMapChache.get(row.getString("id"));
            if (dynamicObject == null) continue;
            DynamicObject fbasedataid = (DynamicObject)dynamicObject.get("fbasedataid");
            String account = fbasedataid.getString("name");
            BigDecimal budget = row.getBigDecimal("budget");
            BigDecimal acturechanges = row.getBigDecimal("acturechanges");
            BigDecimal occupy = row.getBigDecimal("occupy");
            BigDecimal execute = row.getBigDecimal("execute");
            BigDecimal balance = row.getBigDecimal("balance");
            String decimalfield = row.getString("decimalfield");
            BigDecimal budget1 = row.getBigDecimal("budget1");
            BigDecimal acturechanges1 = row.getBigDecimal("acturechanges1");
            BigDecimal occupy1 = row.getBigDecimal("occupy1");
            BigDecimal execute1 = row.getBigDecimal("execute1");
            BigDecimal balance1 = row.getBigDecimal("balance1");
            String decimalfield1 = row.getString("decimalfield1");
            ArrayList<Pair> rows = new ArrayList<Pair>();
            rows.add(Pair.onePair(null, (Object)account));
            rows.add(Pair.onePair((Object)numberCellStyle, (Object)budget));
            rows.add(Pair.onePair((Object)numberCellStyle, (Object)acturechanges));
            rows.add(Pair.onePair((Object)numberCellStyle, (Object)occupy));
            rows.add(Pair.onePair((Object)numberCellStyle, (Object)execute));
            rows.add(Pair.onePair((Object)numberCellStyle, (Object)balance));
            rows.add(Pair.onePair(null, (Object)decimalfield));
            rows.add(Pair.onePair((Object)numberCellStyle, (Object)budget1));
            rows.add(Pair.onePair((Object)numberCellStyle, (Object)acturechanges1));
            rows.add(Pair.onePair((Object)numberCellStyle, (Object)occupy1));
            rows.add(Pair.onePair((Object)numberCellStyle, (Object)execute1));
            rows.add(Pair.onePair((Object)numberCellStyle, (Object)balance1));
            rows.add(Pair.onePair(null, (Object)decimalfield1));
            excelWriter.createRow(rows);
        }
        String fileName = ResManager.loadKDString((String)"\u6267\u884c\u5206\u6790\u6570\u636e\u5bfc\u51fa.xlsx", (String)"ExecuteAnalyze_36", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String url = excelWriter.getDownloadUrl(fileName);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5bfc\u51fa", "ExecuteAnalyze_45", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6267\u884c\u5206\u6790\u6570\u636e\u5bfc\u51fa\u6210\u529f\u3002", "ExecuteAnalyze_46", "epm-eb-formplugin");
        this.writeLog("", "", opName, opDesc, null);
    }

    private void switchingUnit(String key) {
        int newUnitSize = Integer.parseInt(key.substring(8));
        this.changeDataUnitDisplay(newUnitSize);
        if (!(newUnitSize + "").equals(this.getPageCache().get("yuan"))) {
            this.getPageCache().put("yuan", newUnitSize + "");
            if (this.getPageCache().get("OldpageIndex") != null) {
                int oldpageIndex = Integer.parseInt(this.getPageCache().get("OldpageIndex"));
                this.loadData(false);
                if (this.getModel().getEntryEntity(TREEENTRYENTITY).size() != 0) {
                    TreeEntryGrid control = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
                    control.beginInit();
                    control.setPageIndex(oldpageIndex);
                    control.endInit();
                    this.getView().updateView(TREEENTRYENTITY);
                }
            }
        }
    }

    public Long getModelId() {
        Long modelId = 0L;
        DynamicObject model = this.getSelModel();
        if (model != null) {
            modelId = model.getLong("id");
        }
        return modelId;
    }

    protected DynamicObject getSelModel() {
        return (DynamicObject)this.getModel().getValue("model");
    }

    public Long getUserId() {
        return super.getUserId();
    }

    public boolean isCheckModel() {
        return true;
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        long modelId = this.getModelId();
        String propName = arg0.getProperty().getName();
        if (modelId == 0L && !"model".equals(propName)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"ExecuteAnalyze_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ListShowParameter showP = (ListShowParameter)arg0.getFormShowParameter();
        List qs = showP.getListFilterParameter().getQFilters();
        if (!"model".equals(propName)) {
            if ("costtypetext".equals(propName)) {
                DynamicObject model = (DynamicObject)this.getModel().getValue("model");
                if (model != null) {
                    this.openCosttype(model, arg0);
                }
            } else {
                DynamicObject dimObj = NewF7Utils.getDimension((Long)this.getModelId(), (String)this.getCurrentDimNum(propName));
                MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)this.getModelId(), (DynamicObject)dimObj, (String)ListSelectedRow.class.getName());
                if (SysDimensionEnum.Account.getNumber().equals(f7Param.getDimensionNumber())) {
                    f7Param.setMultiSelect(true);
                } else if (!SysDimensionEnum.Entity.getNumber().equals(f7Param.getDimensionNumber()) && !SysDimensionEnum.Period.getNumber().equals(f7Param.getDimensionNumber())) {
                    f7Param.setOnlySelLeaf(true);
                }
                f7Param.addCustomFilter(this.getDimQFilter(propName));
                NewF7Utils.openF7((BeforeF7SelectEvent)arg0, (MemberF7Parameter)f7Param);
            }
        } else {
            this.setModelFilter(arg0);
        }
    }

    private void setModelFilter(BeforeF7SelectEvent arg0) {
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        ArrayList qFilterList = ((BasedataEdit)this.getControl("model")).getQFilters();
        if (qFilterList == null) {
            qFilterList = new ArrayList(16);
        }
        qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
        showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection selectedRowCollection;
        DynamicObject[] dynamicObjects;
        Map resultMap;
        String key = e.getActionId();
        if ("showaccount".equals(key) && (resultMap = (Map)e.getReturnData()) != null && resultMap.size() > 0 && (dynamicObjects = (DynamicObject[])resultMap.get("selectRows")) != null) {
            List collect = Stream.of(dynamicObjects).map(v -> v.getPkValue()).collect(Collectors.toList());
            this.getModel().setValue(key, (Object)collect.toArray());
        }
        if (e.getReturnData() != null && (dimKeys.contains(key) || "entity".equals(key)) && (selectedRowCollection = (ListSelectedRowCollection)e.getReturnData()) != null && selectedRowCollection.size() != 0) {
            if ("subject".equals(key)) {
                ArrayList<Object> accounts = new ArrayList<Object>(16);
                for (ListSelectedRow selectedRow : selectedRowCollection) {
                    accounts.add(selectedRow.getPrimaryKeyValue());
                }
                this.getModel().setValue(key, (Object)accounts.toArray());
            } else {
                ListSelectedRow returnData = selectedRowCollection.get(0);
                this.getModel().setValue(key, returnData.getPrimaryKeyValue());
            }
        }
        if ("schemeCatalog".equals(key)) {
            DynamicObject dynamicObject = (DynamicObject)e.getReturnData();
            if (dynamicObject == null) {
                return;
            }
            this.getModel().setValue("costtypetext", (Object)dynamicObject.getString("id"));
        }
        if ("analyze".equals(key) && (resultMap = (Map)e.getReturnData()) != null) {
            this.openAnalyze(resultMap);
        }
    }

    private void createEntry(Collection<IBudgetBalance> iBudgetBalances, Collection<IBudgetBalance> yeariBudgetBalances, List<Collection<IBudgetBalance>> iBudgetBalanceList) {
        DynamicObjectCollection subject = (DynamicObjectCollection)this.getModel().getValue("subject");
        LinkedList<IBudgetBalance> balanceList = new LinkedList<IBudgetBalance>();
        for (DynamicObject dynamicObject : subject) {
            for (IBudgetBalance iBudgetBalance : iBudgetBalances) {
                if (dynamicObject.get("fbasedataid") == null || !iBudgetBalance.getAccount(true).getNumber().equals(((DynamicObject)dynamicObject.get("fbasedataid")).getString("number"))) continue;
                balanceList.add(iBudgetBalance);
            }
        }
        if (!(iBudgetBalances instanceof ArrayList)) {
            throw new KDBizException("ExecuteAnalyze createEntry()");
        }
        ((ArrayList)iBudgetBalances).sort(new /* Unavailable Anonymous Inner Class!! */);
        Map<String, String> accountName = this.getAccountName(balanceList);
        HashMap<String, IBudgetBalance> yeariBudgetBalancesMap = new HashMap<String, IBudgetBalance>(16);
        for (IBudgetBalance yeariBudgetBalance : yeariBudgetBalances) {
            yeariBudgetBalancesMap.put(yeariBudgetBalance.getAccount(true).getNumber(), yeariBudgetBalance);
        }
        IDataModel model = this.getModel();
        model.deleteEntryData(TREEENTRYENTITY);
        if (balanceList.size() > 0) {
            this.getPageCache().remove("accountNumber");
            this.getPageCache().put("batchstates", "1");
            int weis = 0;
            try {
                weis = Integer.parseInt(this.getPageCache().get("yuan"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            StringBuilder priceStr = new StringBuilder("1");
            for (int i = 0; i < weis; ++i) {
                priceStr.append("0");
            }
            BigDecimal price = new BigDecimal(priceStr.toString());
            HashMap accountNumberMap = new HashMap(balanceList.size());
            Map<Long, DynamicObject> accountParent = this.getAccountParent();
            TreeNode root = this.getTreeNode(accountParent);
            TreeNodeUtils.ListSortByDseq((TreeNode)root);
            Map<String, IBudgetBalance> balanceMap = this.transitionBalanceListToMap(balanceList);
            this.BuildEntryTree(root, balanceMap, price, iBudgetBalanceList, yeariBudgetBalancesMap);
            this.getPageCache().put("accountNumber", SerializationUtils.serializeToBase64(accountNumberMap));
        }
        this.getView().updateView(TREEENTRYENTITY);
        if (this.getPageCache().get("maxValue") == null) {
            this.getPageCache().put("maxValue", "0");
        }
        if ("1".equals(this.getPageCache().get("initstate"))) {
            this.refreshpicture();
        }
        this.getPageCache().remove("batchstates");
    }

    private void BuildEntryTree(TreeNode root, Map<String, IBudgetBalance> balanceMap, BigDecimal price, List<Collection<IBudgetBalance>> iBudgetBalanceList, HashMap<String, IBudgetBalance> yeariBudgetBalancesMap) {
        HashMap<Integer, String> accountNumberMap = new HashMap<Integer, String>(16);
        List children = root.getChildren();
        int count = TreeNodeUtils.getTreeNodesCount((TreeNode)root);
        this.getModel().batchCreateNewEntryRow(TREEENTRYENTITY, count - 1);
        if (children != null && children.size() > 0) {
            this.buildLevel(children, 0, balanceMap, price, accountNumberMap, iBudgetBalanceList, yeariBudgetBalancesMap);
        }
    }

    private int buildLevel(List<TreeNode> children, int row, Map<String, IBudgetBalance> balanceMap, BigDecimal price, Map<Integer, String> accountNumberMap, List<Collection<IBudgetBalance>> iBudgetBalanceList, HashMap<String, IBudgetBalance> yeariBudgetBalancesMap) {
        if (children == null || children.size() == 0) {
            return row;
        }
        BigDecimal maxBudget = null;
        for (TreeNode child : children) {
            DynamicObject rowObject = this.getModel().getEntryRowEntity(TREEENTRYENTITY, row);
            IBudgetBalance balance = balanceMap.get(child.getId());
            if (maxBudget == null) {
                maxBudget = balance.getBudget();
            } else if (balance.getBudget() != null && maxBudget.compareTo(balance.getBudget()) < 0) {
                maxBudget = balance.getBudget();
            }
            accountNumberMap.put(row, balance.getAccount(true).getNumber());
            rowObject.set("id", (Object)balance.getAccount(true).getId());
            rowObject.set("accountname", (Object)balance.getAccount(true).getName());
            rowObject.set("pid", (Object)child.getParentid());
            if (balance.getBudget() != null) {
                rowObject.set("budget", (Object)balance.getBudget().divide(price));
            }
            if (balance.getOccupation() != null) {
                rowObject.set("occupy", (Object)balance.getOccupation().divide(price));
            }
            if (balance.getActualChanges() != null && BigDecimal.ZERO.compareTo(balance.getActualChanges()) != 0) {
                rowObject.set("acturechanges", (Object)balance.getActualChanges().divide(price));
                this.getPageCache().put("acturechanges", "1");
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"acturechanges"});
            }
            if (balance.getExecute() != null) {
                rowObject.set("execute", (Object)balance.getExecute().divide(price));
            }
            if (balance.getBalance() != null) {
                rowObject.set("balance", (Object)balance.getBalance().divide(price));
            }
            if (balance.getBalance() != null && balance.getBudget() != null && BigDecimal.ZERO.compareTo(balance.getBudget()) != 0) {
                String format = balance.getBudget().subtract(balance.getBalance()).divide(balance.getBudget(), 4, 4).toPlainString();
                rowObject.set("decimalfield", (Object)DECIMAL_FORMAT.format(new BigDecimal(format)));
            }
            if (iBudgetBalanceList.size() > 0) {
                this.calculationCumulative(balance, iBudgetBalanceList, price, rowObject);
            } else {
                IBudgetBalance yeariBudgetBalance = yeariBudgetBalancesMap.get(balance.getAccount(true).getNumber());
                String period = ((DynamicObject)this.getModel().getValue("period")).getString("number");
                if ("M_Q1".equals(period) || "Q_Q1".equals(period) || "HF_HF1".equals(period)) {
                    yeariBudgetBalance = balance;
                }
                if (yeariBudgetBalance.getBudget() != null) {
                    rowObject.set("budget1", (Object)yeariBudgetBalance.getBudget().divide(price));
                }
                if (yeariBudgetBalance.getOccupation() != null) {
                    rowObject.set("occupy1", (Object)yeariBudgetBalance.getOccupation().divide(price));
                }
                if (yeariBudgetBalance.getExecute() != null) {
                    rowObject.set("execute1", (Object)yeariBudgetBalance.getExecute().divide(price));
                }
                if (yeariBudgetBalance.getBalance() != null) {
                    rowObject.set("balance1", (Object)yeariBudgetBalance.getBalance().divide(price));
                }
                if (yeariBudgetBalance.getActualChanges() != null && BigDecimal.ZERO.compareTo(yeariBudgetBalance.getActualChanges()) != 0) {
                    rowObject.set("acturechanges1", (Object)yeariBudgetBalance.getActualChanges().divide(price));
                    this.getPageCache().put("acturechanges1", "1");
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"acturechanges1"});
                }
                if (yeariBudgetBalance.getBalance() != null && yeariBudgetBalance.getBudget() != null && BigDecimal.ZERO.compareTo(yeariBudgetBalance.getBudget()) != 0) {
                    String format = yeariBudgetBalance.getBudget().subtract(yeariBudgetBalance.getBalance()).divide(yeariBudgetBalance.getBudget(), 4, 4).toPlainString();
                    rowObject.set("decimalfield1", (Object)DECIMAL_FORMAT.format(new BigDecimal(format)));
                }
            }
            List children1 = child.getChildren();
            if (children1 != null && children1.size() > 0) {
                rowObject.set("isgroupnode", (Object)true);
            }
            row = this.buildLevel(children1, row + 1, balanceMap, price, accountNumberMap, iBudgetBalanceList, yeariBudgetBalancesMap);
        }
        if (maxBudget != null) {
            this.getPageCache().put("maxValue", maxBudget.divide(price).toPlainString());
        }
        return row;
    }

    private Map<String, IBudgetBalance> transitionBalanceListToMap(List<IBudgetBalance> balanceList) {
        HashMap<String, IBudgetBalance> balanceMap = new HashMap<String, IBudgetBalance>(balanceList.size());
        for (IBudgetBalance balance : balanceList) {
            String id = balance.getAccount(true).getId().toString();
            if (!StringUtils.isNotEmpty((String)id)) continue;
            balanceMap.put(id, balance);
        }
        return balanceMap;
    }

    private Map<Long, DynamicObject> getAccountParent() {
        HashMap<Long, DynamicObject> accParent = new HashMap<Long, DynamicObject>(16);
        DynamicObjectCollection subject = (DynamicObjectCollection)this.getModel().getValue("subject");
        for (DynamicObject object : subject) {
            long fbasedataidId = object.getLong("fbasedataid_id");
            accParent.put(fbasedataidId, object);
        }
        return accParent;
    }

    private TreeNode getTreeNode(Map<Long, DynamicObject> accParent) {
        TreeNode root = new TreeNode();
        root.setId("0");
        root.setText("root");
        root.setParentid("0");
        root.setChildren(new ArrayList(16));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Set<Long> longs = accParent.keySet();
        List<TreeNode> treeNodes = this.getTreeNodes(accParent, root, modelCache, longs);
        this.buildTreeNode(treeNodes);
        return root;
    }

    private List<TreeNode> getTreeNodes(Map<Long, DynamicObject> accParent, TreeNode root, IModelCacheHelper modelCache, Set<Long> longs) {
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(16);
        for (Map.Entry<Long, DynamicObject> entry : accParent.entrySet()) {
            Long key = entry.getKey();
            DynamicObject value = entry.getValue();
            TreeNode nodeValue = this.lookupTreeNode(nodeList, value);
            TreeNode treeNode = this.handleValue(root, modelCache, longs, nodeList, key, value, nodeValue);
            TreeNode lifeNode = this.lookupTreeNode(nodeList, key);
            if (lifeNode == null || lifeNode.getId() == null || lifeNode.getChildren() == null) continue;
            List nodeChildren = treeNode.getChildren();
            for (TreeNode nodeChild : nodeChildren) {
                if (!nodeChild.getId().equals(lifeNode.getId())) continue;
                List children1 = nodeChild.getChildren();
                if (children1 == null) {
                    ArrayList nodes = new ArrayList(16);
                    nodes.addAll(lifeNode.getChildren());
                    nodeChild.setChildren(nodes);
                    continue;
                }
                children1.addAll(lifeNode.getChildren());
            }
            this.deleteTreeNodeId(nodeList, lifeNode);
        }
        return nodeList;
    }

    private void buildTreeNode(List<TreeNode> treeNodes) {
        TreeNode addTreeNode = null;
        TreeNode dleTreeNode = null;
        if (treeNodes.size() > 1) {
            for (TreeNode node : treeNodes) {
                List<TreeNode> lifeNode = this.getTreeNodes(treeNodes, node.getId());
                if (lifeNode.size() <= 1) continue;
                for (TreeNode treeNode1 : lifeNode) {
                    String parentid = treeNode1.getParentid();
                    if (!"0".equals(parentid)) {
                        addTreeNode = treeNode1;
                        continue;
                    }
                    dleTreeNode = treeNode1;
                }
                if (addTreeNode == null || dleTreeNode == null) continue;
                List nodeChildren = addTreeNode.getChildren();
                if (nodeChildren == null) {
                    if (dleTreeNode.getChildren() == null) continue;
                    ArrayList nodes = new ArrayList(16);
                    nodes.addAll(dleTreeNode.getChildren());
                    addTreeNode.setChildren(nodes);
                    continue;
                }
                if (dleTreeNode.getChildren() == null) continue;
                nodeChildren.addAll(dleTreeNode.getChildren());
            }
        }
    }

    private void deleteTreeNodeId(List<TreeNode> nodeList, TreeNode lifeNode) {
        nodeList.removeIf(next -> next.getId().equals(lifeNode.getId()));
    }

    private TreeNode handleValue(TreeNode root, IModelCacheHelper modelCache, Set<Long> longs, List<TreeNode> nodeList, Long key, DynamicObject account, TreeNode node) {
        DynamicObject fbasedataid = (DynamicObject)account.get("fbasedataid");
        Long value = fbasedataid.getLong("parent_id");
        if (node == null) {
            TreeNode treeNode = new TreeNode();
            treeNode.setId(String.valueOf(key));
            this.setTreeNodeData(key, fbasedataid, treeNode);
            if (longs.contains(value)) {
                TreeNode treeNode1 = new TreeNode();
                treeNode1.setId(String.valueOf(value));
                treeNode.setParentid(String.valueOf(value));
                treeNode1.setParentid("0");
                this.setTreeNodeParentData(modelCache, value, treeNode1);
                ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(16);
                treeNodes.add(treeNode);
                treeNode1.setChildren(treeNodes);
                nodeList.add(treeNode1);
                return treeNode1;
            }
            Long recursion = this.recursion(longs, modelCache, value);
            if (recursion == 0L) {
                TreeNode treeNode2 = this.lookupTreeNode(nodeList, recursion);
                TreeNode treeNode1 = new TreeNode();
                treeNode1.setId(String.valueOf(key));
                treeNode1.setParentid("0");
                this.setTreeNodeData(key, fbasedataid, treeNode1);
                if (treeNode2 == null) {
                    root.addChild(treeNode1);
                    nodeList.add(root);
                    return root;
                }
                treeNode2.addChild(treeNode1);
                return treeNode2;
            }
            TreeNode treeNode2 = this.lookupTreeNode(nodeList, recursion);
            TreeNode treeNode1 = new TreeNode();
            treeNode1.setId(String.valueOf(key));
            treeNode1.setParentid(String.valueOf(recursion));
            this.setTreeNodeData(key, fbasedataid, treeNode1);
            if (treeNode2 == null) {
                TreeNode node1 = new TreeNode();
                node1.setId(String.valueOf(recursion));
                this.setTreeNodeParentData(modelCache, recursion, node1);
                ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(16);
                treeNodes.add(treeNode1);
                node1.setChildren(treeNodes);
                nodeList.add(node1);
                return node1;
            }
            treeNode2.addChild(treeNode1);
            return treeNode2;
        }
        List nodeChildren = node.getChildren();
        TreeNode lifeNode = new TreeNode();
        lifeNode.setId(String.valueOf(key));
        lifeNode.setParentid(String.valueOf(value));
        this.setTreeNodeData(key, fbasedataid, lifeNode);
        if (nodeChildren == null) {
            ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(16);
            treeNodes.add(lifeNode);
            node.setChildren(treeNodes);
        } else {
            nodeChildren.add(lifeNode);
        }
        return node;
    }

    private void setTreeNodeParentData(IModelCacheHelper modelCache, Long recursion, TreeNode node1) {
        HashMap<String, Object> dataRecursion = new HashMap<String, Object>(16);
        dataRecursion.put("number", modelCache.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), recursion).getNumber());
        dataRecursion.put("id", String.valueOf(recursion));
        dataRecursion.put("level", modelCache.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), recursion).getLevel());
        dataRecursion.put("dseq", modelCache.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), recursion).getSeq());
        node1.setData(dataRecursion);
    }

    private void setTreeNodeData(Long key, DynamicObject fbasedataid, TreeNode treeNode) {
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("number", fbasedataid.getString("number"));
        data.put("id", String.valueOf(key));
        data.put("level", fbasedataid.get("level"));
        data.put("dseq", fbasedataid.get("dseq"));
        treeNode.setData(data);
    }

    private TreeNode lookupTreeNode(List<TreeNode> children, Long key) {
        for (TreeNode child : children) {
            TreeNode treeNode = child.getTreeNode(String.valueOf(key), 20);
            if (treeNode == null) continue;
            return treeNode;
        }
        return null;
    }

    private TreeNode lookupTreeNode(List<TreeNode> children, DynamicObject key) {
        DynamicObject fbasedataid = (DynamicObject)key.get("fbasedataid");
        long parenId = fbasedataid.getLong("parent_id");
        for (TreeNode child : children) {
            TreeNode treeNode = child.getTreeNode(String.valueOf(parenId), 20);
            if (treeNode == null) continue;
            return treeNode;
        }
        return null;
    }

    private List<TreeNode> getTreeNodes(List<TreeNode> children, String key) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(16);
        for (TreeNode child : children) {
            TreeNode treeNode = child.getTreeNode(key, 20);
            if (treeNode == null) continue;
            treeNodes.add(treeNode);
        }
        return treeNodes;
    }

    private Long recursion(Set<Long> memberIds, IModelCacheHelper modelCache, Long value) {
        Member member = modelCache.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), value);
        if (member != null) {
            Long parentId = member.getParentId();
            if (parentId == 0L) {
                return parentId;
            }
            if (memberIds.contains(parentId)) {
                return parentId;
            }
            this.recursion(memberIds, modelCache, parentId);
        }
        return 0L;
    }

    private void calculationCumulative(IBudgetBalance balance, List<Collection<IBudgetBalance>> iBudgetBalanceList, BigDecimal price, DynamicObject rowObject) {
        BigDecimal budget = new BigDecimal(0);
        if (balance.getBudget() != null) {
            budget = balance.getBudget();
        }
        BigDecimal occupy = new BigDecimal(0);
        if (balance.getOccupation() != null) {
            occupy = balance.getOccupation();
        }
        BigDecimal execute = new BigDecimal(0);
        if (balance.getExecute() != null) {
            execute = balance.getExecute();
        }
        BigDecimal balances = new BigDecimal(0);
        if (balance.getBalance() != null) {
            balances = balance.getBalance();
        }
        BigDecimal acturechanges = new BigDecimal(0);
        if (balance.getActualChanges() != null) {
            acturechanges = balance.getActualChanges();
        }
        for (Collection<IBudgetBalance> collection : iBudgetBalanceList) {
            for (IBudgetBalance iBudgetBalance : collection) {
                if (!iBudgetBalance.getAccount(true).getNumber().equals(balance.getAccount(true).getNumber())) continue;
                if (iBudgetBalance.getBudget() != null) {
                    budget = budget.add(iBudgetBalance.getBudget());
                }
                if (iBudgetBalance.getOccupation() != null) {
                    occupy = occupy.add(iBudgetBalance.getOccupation());
                }
                if (iBudgetBalance.getExecute() != null) {
                    execute = execute.add(iBudgetBalance.getExecute());
                }
                if (iBudgetBalance.getBalance() != null) {
                    balances = balances.add(iBudgetBalance.getBalance());
                }
                if (iBudgetBalance.getActualChanges() == null) continue;
                acturechanges = acturechanges.add(iBudgetBalance.getActualChanges());
            }
        }
        BigDecimal divide = budget.divide(price, 2, 4);
        rowObject.set("budget1", (Object)divide);
        BigDecimal divide1 = occupy.divide(price, 2, 4);
        rowObject.set("occupy1", (Object)divide1);
        BigDecimal divide2 = execute.divide(price, 2, 4);
        rowObject.set("execute1", (Object)divide2);
        BigDecimal divide3 = balances.divide(price, 2, 4);
        rowObject.set("balance1", (Object)divide3);
        if (BigDecimal.ZERO.compareTo(acturechanges) != 0) {
            BigDecimal divide4 = acturechanges.divide(price, 2, 4);
            rowObject.set("acturechanges1", (Object)divide4);
            this.getPageCache().put("acturechanges1", "1");
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"acturechanges1"});
        }
        if (!balances.toBigInteger().equals(BigInteger.ZERO) && !budget.toBigInteger().equals(BigInteger.ZERO)) {
            String format = budget.subtract(balances).divide(budget, 4, 4).toPlainString();
            rowObject.set("decimalfield1", (Object)DECIMAL_FORMAT.format(new BigDecimal(format)));
        }
    }

    private void refreshpicture() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(TREEENTRYENTITY);
        this.drawColumn(entryentity);
        this.drawpie(entryentity);
    }

    private void changeDataUnitDisplay(int newUnitSize) {
        String unitName = "";
        switch (newUnitSize) {
            case 0: {
                unitName = "";
                break;
            }
            case 3: {
                unitName = ResManager.loadKDString((String)"\u5343", (String)"ExecuteAnalyze_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case 4: {
                unitName = ResManager.loadKDString((String)"\u4e07", (String)"ExecuteAnalyze_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        this.getPageCache().put("unitName", ResManager.loadResFormat((String)"(%1\u5143)", (String)"ExecuteAnalyze_2", (String)"epm-eb-formplugin", (Object[])new Object[]{unitName}));
        HashMap<String, String> language = new HashMap<String, String>(16);
        HashMap<String, HashMap<String, String>> parm = new HashMap<String, HashMap<String, String>>(16);
        language.put("zh_CN", ResManager.loadResFormat((String)"%1\u5143\u8868", (String)"ExecuteAnalyze_3", (String)"epm-eb-formplugin", (Object[])new Object[]{unitName}));
        parm.put("text", language);
        this.getView().updateControlMetadata("btn_dataunit", parm);
    }

    public void yearAnaylzeData(Boolean isFirst) {
        if (this.allValueNotNull()) {
            this.getView().updateView(TREEENTRYENTITY);
            DynamicObjectCollection subject = (DynamicObjectCollection)this.getModel().getValue("subject");
            ArrayList idList = new ArrayList(16);
            if (subject.size() > 0) {
                subject.forEach(e -> idList.add(e.getLong("fbasedataid_id")));
            }
            ArrayList<Map<String, String>> dimlist = new ArrayList<Map<String, String>>(16);
            long modelid = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
            Map<String, String> accountMap = null;
            ArrayList<String> type = new ArrayList<String>();
            String exitQuarterAndHalf = this.isExitQuarterAndHalf(modelid);
            this.setEnableByPeriod(exitQuarterAndHalf);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"epm_accountmembertree", (String)"id,number,isleaf", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
            ArrayList<IBudgetBalance> allIBudgetBalances = new ArrayList<IBudgetBalance>();
            if (isFirst.booleanValue()) {
                this.setDefaultValue(query, dimlist, accountMap, type);
                this.getBudget(allIBudgetBalances, modelid, dimlist, type);
            } else {
                this.getselectPriod(allIBudgetBalances, modelid, query, dimlist, accountMap, type);
            }
            if (allIBudgetBalances.size() != 0) {
                List<BigDecimal> monBudgetList = new ArrayList<BigDecimal>(16);
                List<BigDecimal> monExecuteList = new ArrayList<BigDecimal>(16);
                String showType = this.getShowType();
                this.getShowTypePeriodBudget(showType, allIBudgetBalances, monBudgetList, monExecuteList);
                String obmonBudgetList = ObjectSerialUtil.toByteSerialized(monBudgetList);
                String obmonExecuteList = ObjectSerialUtil.toByteSerialized(monExecuteList);
                BigDecimal maxValue = this.getMaxValue(monBudgetList, monExecuteList);
                if (maxValue != null) {
                    this.getPageCache().put("yearmaxValue", maxValue.toPlainString());
                }
                monBudgetList = (List)ObjectSerialUtil.deSerializedBytes((String)obmonBudgetList);
                monExecuteList = (List)ObjectSerialUtil.deSerializedBytes((String)obmonExecuteList);
                this.drawyearColumn(monBudgetList, monExecuteList, showType);
            } else {
                this.drawyearColumn(null, null, null);
            }
        } else {
            this.drawyearColumn(null, null, null);
        }
    }

    private void getShowTypePeriodBudget(String showType, Collection<IBudgetBalance> allIBudgetBalances, List<BigDecimal> monBudgetList, List<BigDecimal> monExecuteList) {
        block13: {
            String period;
            int j;
            double weis;
            block18: {
                String period2;
                int j2;
                block17: {
                    String period3;
                    int j3;
                    block16: {
                        String period4;
                        int j4;
                        block15: {
                            block14: {
                                block12: {
                                    weis = Double.parseDouble(this.getPageCache().get("yuan"));
                                    if (!showType.equals(ModelDetailPeriodEnum.ISDETAILTOMONTH.getNumber())) break block12;
                                    for (int j5 = 1; j5 <= 12; ++j5) {
                                        String period5 = "M_M" + String.format("%02d", j5);
                                        this.getSamePeriodBudget(allIBudgetBalances, period5, monBudgetList, monExecuteList, weis);
                                    }
                                    break block13;
                                }
                                if (!showType.equals(ModelDetailPeriodEnum.ISDETAILTOQUARTER.getNumber())) break block14;
                                for (int j6 = 1; j6 <= 4; ++j6) {
                                    String period6 = "Q_Q" + j6;
                                    this.getSamePeriodBudget(allIBudgetBalances, period6, monBudgetList, monExecuteList, weis);
                                }
                                break block13;
                            }
                            if (!showType.equals(ModelDetailPeriodEnum.ISDETAILTOHALFYEAR.getNumber())) break block15;
                            for (int j7 = 1; j7 <= 2; ++j7) {
                                String period7 = "HF_HF" + j7;
                                this.getSamePeriodBudget(allIBudgetBalances, period7, monBudgetList, monExecuteList, weis);
                            }
                            break block13;
                        }
                        if (!showType.equals(ModelDetailPeriodEnum.ISDETAILTOMONTHANDQUARTER.getNumber())) break block16;
                        for (j4 = 1; j4 <= 12; ++j4) {
                            period4 = "M_M" + String.format("%02d", j4);
                            this.getSamePeriodBudget(allIBudgetBalances, period4, monBudgetList, monExecuteList, weis);
                        }
                        for (j4 = 1; j4 <= 4; ++j4) {
                            period4 = "Q_Q" + j4;
                            this.getSamePeriodBudget(allIBudgetBalances, period4, monBudgetList, monExecuteList, weis);
                        }
                        break block13;
                    }
                    if (!showType.equals(ModelDetailPeriodEnum.ISDETAILTOQUARTERANDHALFYEAR.getNumber())) break block17;
                    for (j3 = 1; j3 <= 4; ++j3) {
                        period3 = "Q_Q" + j3;
                        this.getSamePeriodBudget(allIBudgetBalances, period3, monBudgetList, monExecuteList, weis);
                    }
                    for (j3 = 1; j3 <= 2; ++j3) {
                        period3 = "HF_HF" + j3;
                        this.getSamePeriodBudget(allIBudgetBalances, period3, monBudgetList, monExecuteList, weis);
                    }
                    break block13;
                }
                if (!showType.equals(ModelDetailPeriodEnum.ISDETAILTOMONTHANDHALFYEAR.getNumber())) break block18;
                for (j2 = 1; j2 <= 12; ++j2) {
                    period2 = "M_M" + String.format("%02d", j2);
                    this.getSamePeriodBudget(allIBudgetBalances, period2, monBudgetList, monExecuteList, weis);
                }
                for (j2 = 1; j2 <= 2; ++j2) {
                    period2 = "HF_HF" + j2;
                    this.getSamePeriodBudget(allIBudgetBalances, period2, monBudgetList, monExecuteList, weis);
                }
                break block13;
            }
            if (!showType.equals(ModelDetailPeriodEnum.ISDETAILTOMONTHANDHALFYEARANDUARTER.getNumber())) break block13;
            for (j = 1; j <= 12; ++j) {
                period = "M_M" + String.format("%02d", j);
                this.getSamePeriodBudget(allIBudgetBalances, period, monBudgetList, monExecuteList, weis);
            }
            for (j = 1; j <= 4; ++j) {
                period = "Q_Q" + j;
                this.getSamePeriodBudget(allIBudgetBalances, period, monBudgetList, monExecuteList, weis);
            }
            for (j = 1; j <= 2; ++j) {
                period = "HF_HF" + j;
                this.getSamePeriodBudget(allIBudgetBalances, period, monBudgetList, monExecuteList, weis);
            }
        }
    }

    private void getBudget(Collection<IBudgetBalance> allIBudgetBalances, long modelid, List<Map<String, String>> dimlist, Collection<String> type) {
        BgControlCallerImpl bgControlCaller = new BgControlCallerImpl();
        try {
            Collection iBudgetBalances = bgControlCaller.queryBalance(Long.valueOf(modelid), dimlist, type, true);
            allIBudgetBalances.addAll(iBudgetBalances);
        }
        catch (Exception e) {
            this.getPageCache().put("message", e.getMessage());
            log.error("queryBalance:error" + e.getMessage());
        }
    }

    private void getselectPriod(Collection<IBudgetBalance> allIBudgetBalances, long modelid, DynamicObjectCollection query, List<Map<String, String>> dimlist, Map<String, String> accountMap, Collection<String> type) {
        boolean mon = (Boolean)this.getModel().getValue("mon");
        boolean que = (Boolean)this.getModel().getValue("que");
        boolean hef = (Boolean)this.getModel().getValue("hef");
        if (mon && !que && !hef) {
            this.dealMonth(query, accountMap, dimlist, type);
            this.getBudget(allIBudgetBalances, modelid, dimlist, type);
        } else if (!mon && que && !hef) {
            this.dealQuarter(query, accountMap, dimlist, type);
            this.getBudget(allIBudgetBalances, modelid, dimlist, type);
        } else if (!mon && !que && hef) {
            this.dealHalf(query, accountMap, dimlist, type);
            this.getBudget(allIBudgetBalances, modelid, dimlist, type);
        } else if (mon && que && !hef) {
            this.dealMonth(query, accountMap, dimlist, type);
            this.getBudget(allIBudgetBalances, modelid, dimlist, type);
            this.clearData(dimlist, type);
            this.dealQuarter(query, accountMap, dimlist, type);
            this.getBudget(allIBudgetBalances, modelid, dimlist, type);
        } else if (mon && !que && hef) {
            this.dealMonth(query, accountMap, dimlist, type);
            this.getBudget(allIBudgetBalances, modelid, dimlist, type);
            this.clearData(dimlist, type);
            this.dealHalf(query, accountMap, dimlist, type);
            this.getBudget(allIBudgetBalances, modelid, dimlist, type);
        } else if (!mon && que && hef) {
            this.dealQuarter(query, accountMap, dimlist, type);
            this.getBudget(allIBudgetBalances, modelid, dimlist, type);
            this.clearData(dimlist, type);
            this.dealHalf(query, accountMap, dimlist, type);
            this.getBudget(allIBudgetBalances, modelid, dimlist, type);
        } else if (mon && que && hef) {
            this.dealMonth(query, accountMap, dimlist, type);
            this.getBudget(allIBudgetBalances, modelid, dimlist, type);
            this.clearData(dimlist, type);
            this.dealQuarter(query, accountMap, dimlist, type);
            this.getBudget(allIBudgetBalances, modelid, dimlist, type);
            this.clearData(dimlist, type);
            this.dealHalf(query, accountMap, dimlist, type);
            this.getBudget(allIBudgetBalances, modelid, dimlist, type);
        }
    }

    private void clearData(List<Map<String, String>> dimlist, Collection<String> type) {
        dimlist.clear();
        type.clear();
    }

    private String getShowType() {
        boolean mon = (Boolean)this.getModel().getValue("mon");
        boolean que = (Boolean)this.getModel().getValue("que");
        boolean hef = (Boolean)this.getModel().getValue("hef");
        if (mon && !que && !hef) {
            return ModelDetailPeriodEnum.ISDETAILTOMONTH.getNumber();
        }
        if (!mon && que && !hef) {
            return ModelDetailPeriodEnum.ISDETAILTOQUARTER.getNumber();
        }
        if (!mon && !que && hef) {
            return ModelDetailPeriodEnum.ISDETAILTOHALFYEAR.getNumber();
        }
        if (mon && que && !hef) {
            return ModelDetailPeriodEnum.ISDETAILTOMONTHANDQUARTER.getNumber();
        }
        if (mon && !que && hef) {
            return ModelDetailPeriodEnum.ISDETAILTOMONTHANDHALFYEAR.getNumber();
        }
        if (!mon && que && hef) {
            return ModelDetailPeriodEnum.ISDETAILTOQUARTERANDHALFYEAR.getNumber();
        }
        if (mon && que && hef) {
            return ModelDetailPeriodEnum.ISDETAILTOMONTHANDHALFYEARANDUARTER.getNumber();
        }
        return ModelDetailPeriodEnum.ISDETAILTOMONTH.getNumber();
    }

    private void getSamePeriodBudget(Collection<IBudgetBalance> iBudgetBalances, String period, List<BigDecimal> monBudgetList, List<BigDecimal> monExecuteList, double weis) {
        BigDecimal bigDecimalBudget = null;
        BigDecimal bigDecimalExecute = null;
        for (IBudgetBalance iBudgetBalance : iBudgetBalances) {
            if (!iBudgetBalance.getPeriod(true).getNumber().equals(period) || !iBudgetBalance.getAccount(true).isLeaf()) continue;
            if (bigDecimalBudget == null) {
                bigDecimalBudget = iBudgetBalance.getBudget();
            } else if (iBudgetBalance.getBudget() != null) {
                bigDecimalBudget = iBudgetBalance.getBudget().add(bigDecimalBudget);
            }
            if (bigDecimalExecute == null) {
                bigDecimalExecute = iBudgetBalance.getExecute();
                continue;
            }
            if (iBudgetBalance.getExecute() == null) continue;
            bigDecimalExecute = iBudgetBalance.getExecute().add(bigDecimalExecute);
        }
        if (bigDecimalBudget != null) {
            monBudgetList.add(bigDecimalBudget.divide(BigDecimal.valueOf(Math.pow(10.0, weis))));
        } else {
            monBudgetList.add(BigDecimal.ZERO);
        }
        if (bigDecimalExecute != null) {
            monExecuteList.add(bigDecimalExecute.divide(BigDecimal.valueOf(Math.pow(10.0, weis))));
        } else {
            monExecuteList.add(BigDecimal.ZERO);
        }
    }

    private void setEnableByPeriod(String exitQuarterAndHalf) {
        if (ModelDetailPeriodEnum.ISDETAILTOMONTH.getNumber().equals(exitQuarterAndHalf)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"mon"});
        } else if (ModelDetailPeriodEnum.ISDETAILTOQUARTER.getNumber().equals(exitQuarterAndHalf)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"que"});
        } else if (ModelDetailPeriodEnum.ISDETAILTOHALFYEAR.getNumber().equals(exitQuarterAndHalf)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"hef"});
        } else if (ModelDetailPeriodEnum.ISDETAILTOMONTHANDQUARTER.getNumber().equals(exitQuarterAndHalf)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"mon", "que"});
        } else if (ModelDetailPeriodEnum.ISDETAILTOMONTHANDHALFYEAR.getNumber().equals(exitQuarterAndHalf)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"mon", "hef"});
        } else if (ModelDetailPeriodEnum.ISDETAILTOQUARTERANDHALFYEAR.getNumber().equals(exitQuarterAndHalf)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"que", "hef"});
        } else if (ModelDetailPeriodEnum.ISDETAILTOMONTHANDHALFYEARANDUARTER.getNumber().equals(exitQuarterAndHalf)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"que", "hef", "mon"});
        }
    }

    private void setDefaultValue(DynamicObjectCollection query, List<Map<String, String>> dimlist, Map<String, String> accountMap, Collection<String> type) {
        String periodNumber = ((DynamicObject)this.getModel().getValue("period")).getString("number");
        if (periodNumber.startsWith("Q_")) {
            this.getModel().setValue("que", (Object)true);
            this.dealQuarter(query, accountMap, dimlist, type);
        } else if (periodNumber.startsWith("M_")) {
            this.getModel().setValue("mon", (Object)true);
            this.dealMonth(query, accountMap, dimlist, type);
        } else if (periodNumber.startsWith("HF_")) {
            this.getModel().setValue("hef", (Object)true);
            this.dealHalf(query, accountMap, dimlist, type);
        }
    }

    private void dealQuarter(DynamicObjectCollection query, Map<String, String> accountMap, List<Map<String, String>> dimlist, Collection<String> type) {
        type.add(BgControlSettingTypeEnum.QUARTER.getNumber());
        for (int i = 1; i <= 4; ++i) {
            String periodNumber = "Q_Q" + i;
            this.addDimension(query, accountMap, periodNumber, dimlist);
        }
    }

    private void dealMonth(DynamicObjectCollection query, Map<String, String> accountMap, List<Map<String, String>> dimlist, Collection<String> type) {
        type.add(BgControlSettingTypeEnum.MONTH.getNumber());
        for (int i = 1; i <= 12; ++i) {
            String periodNumber = "M_M" + String.format("%02d", i);
            this.addDimension(query, accountMap, periodNumber, dimlist);
        }
    }

    private void dealHalf(DynamicObjectCollection query, Map<String, String> accountMap, List<Map<String, String>> dimlist, Collection<String> type) {
        type.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
        for (int i = 1; i <= 2; ++i) {
            String periodNumber = "HF_HF" + i;
            this.addDimension(query, accountMap, periodNumber, dimlist);
        }
    }

    private void addDimension(DynamicObjectCollection query, Map<String, String> accountMap, String periodNumber, List<Map<String, String>> dimlist) {
        for (DynamicObject dynamicObject : query) {
            accountMap = new HashMap<String, String>(16);
            accountMap.put(SysDimensionEnum.Period.getNumber(), periodNumber);
            accountMap.put(SysDimensionEnum.Account.getNumber(), dynamicObject.getString("number"));
            String entityNumber = ((DynamicObject)this.getModel().getValue("entity")).getString("number");
            accountMap.put(SysDimensionEnum.Entity.getNumber(), entityNumber);
            String currencyNumber = ((DynamicObject)this.getModel().getValue("currency")).getString("number");
            accountMap.put(SysDimensionEnum.Currency.getNumber(), currencyNumber);
            String yearNumber = ((DynamicObject)this.getModel().getValue("year")).getString("number");
            accountMap.put(SysDimensionEnum.Year.getNumber(), yearNumber);
            String versionNumber = ((DynamicObject)this.getModel().getValue("version")).getString("number");
            accountMap.put(SysDimensionEnum.Version.getNumber(), versionNumber);
            dimlist.add(accountMap);
        }
    }

    private String isExitQuarterAndHalf(long modelid) {
        DynamicObject model = QueryServiceHelper.queryOne((String)"epm_model", (String)"isdetailtomonth,isdetailtoqrt,isdetailtohalfyear", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelid)});
        if (model != null) {
            if (model.getBoolean("isdetailtomonth") && !model.getBoolean("isdetailtoqrt") && !model.getBoolean("isdetailtohalfyear")) {
                return ModelDetailPeriodEnum.ISDETAILTOMONTH.getNumber();
            }
            if (!model.getBoolean("isdetailtomonth") && model.getBoolean("isdetailtoqrt") && !model.getBoolean("isdetailtohalfyear")) {
                return ModelDetailPeriodEnum.ISDETAILTOQUARTER.getNumber();
            }
            if (!model.getBoolean("isdetailtomonth") && !model.getBoolean("isdetailtoqrt") && model.getBoolean("isdetailtohalfyear")) {
                return ModelDetailPeriodEnum.ISDETAILTOHALFYEAR.getNumber();
            }
            if (model.getBoolean("isdetailtomonth") && model.getBoolean("isdetailtoqrt") && !model.getBoolean("isdetailtohalfyear")) {
                return ModelDetailPeriodEnum.ISDETAILTOMONTHANDQUARTER.getNumber();
            }
            if (model.getBoolean("isdetailtomonth") && !model.getBoolean("isdetailtoqrt") && model.getBoolean("isdetailtohalfyear")) {
                return ModelDetailPeriodEnum.ISDETAILTOMONTHANDHALFYEAR.getNumber();
            }
            if (!model.getBoolean("isdetailtomonth") && model.getBoolean("isdetailtoqrt") && model.getBoolean("isdetailtohalfyear")) {
                return ModelDetailPeriodEnum.ISDETAILTOQUARTERANDHALFYEAR.getNumber();
            }
            if (model.getBoolean("isdetailtomonth") && model.getBoolean("isdetailtoqrt") && model.getBoolean("isdetailtohalfyear")) {
                return ModelDetailPeriodEnum.ISDETAILTOMONTHANDHALFYEARANDUARTER.getNumber();
            }
            return ModelDetailPeriodEnum.ISDETAILTOMONTH.getNumber();
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"ExecuteAnalyze_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return ModelDetailPeriodEnum.ISDETAILTOMONTH.getNumber();
    }

    private void refreshEntryentity() {
        if (this.allValueNotNull()) {
            this.setEntryPeriod();
            DynamicObjectCollection subject = (DynamicObjectCollection)this.getModel().getValue("subject");
            this.setAccountMapChache(subject);
            BgControlCallerImpl bgControlCaller = new BgControlCallerImpl();
            ArrayList<Map<String, String>> dimlist = new ArrayList<Map<String, String>>(16);
            HashMap<String, String> accountMap = null;
            long modelid = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
            for (DynamicObject dynamicObject : subject) {
                accountMap = new HashMap<String, String>(16);
                DynamicObject basedoc = (DynamicObject)dynamicObject.get("fbasedataid");
                if (basedoc == null) {
                    accountMap.put(SysDimensionEnum.Account.getNumber(), null);
                } else {
                    accountMap.put(SysDimensionEnum.Account.getNumber(), basedoc.getString("number"));
                }
                String entityNumber = ((DynamicObject)this.getModel().getValue("entity")).getString("number");
                accountMap.put(SysDimensionEnum.Entity.getNumber(), entityNumber);
                String currencyNumber = ((DynamicObject)this.getModel().getValue("currency")).getString("number");
                accountMap.put(SysDimensionEnum.Currency.getNumber(), currencyNumber);
                String yearNumber = ((DynamicObject)this.getModel().getValue("year")).getString("number");
                accountMap.put(SysDimensionEnum.Year.getNumber(), yearNumber);
                String periodNumber = ((DynamicObject)this.getModel().getValue("period")).getString("number");
                accountMap.put(SysDimensionEnum.Period.getNumber(), periodNumber);
                String versionNumber = ((DynamicObject)this.getModel().getValue("version")).getString("number");
                accountMap.put(SysDimensionEnum.Version.getNumber(), versionNumber);
                dimlist.add(accountMap);
            }
            Collection<String> type = this.dealSettingType();
            String periodNumber = ((DynamicObject)this.getModel().getValue("period")).getString("number");
            ArrayList<Collection<IBudgetBalance>> iBudgetBalanceList = new ArrayList<Collection<IBudgetBalance>>(16);
            if (PERIODLISTS.contains(periodNumber)) {
                this.getDimensionCoyes(iBudgetBalanceList, dimlist, periodNumber, modelid, type);
            }
            Collection iBudgetBalances = null;
            try {
                iBudgetBalances = bgControlCaller.queryBalance(Long.valueOf(modelid), dimlist, type, true);
                log.info("[ExecuteAnalze][refreshEntryentity][Qfilter]" + ((Object)dimlist).toString());
            }
            catch (Exception e) {
                this.getPageCache().put("message", e.getMessage());
                log.error("queryBalance:error" + e.getMessage());
            }
            if (iBudgetBalances == null) {
                this.getModel().deleteEntryData(TREEENTRYENTITY);
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity(TREEENTRYENTITY);
                this.drawColumn(entryentity);
                this.drawpie(entryentity);
            } else {
                ArrayList<IBudgetBalance> yeariBudgetBalances = new ArrayList<IBudgetBalance>(16);
                ArrayList<IBudgetBalance> moniBudgetBalances = new ArrayList<IBudgetBalance>(16);
                ArrayList<String> list = new ArrayList<String>(16);
                Iterator<String> iterator = type.iterator();
                if (iterator.hasNext()) {
                    list.add(iterator.next());
                }
                for (IBudgetBalance ib : iBudgetBalances) {
                    if (ib.getSetting().getSettingType().getNumber().equals(list.get(0))) {
                        moniBudgetBalances.add(ib);
                        if (list.size() != 1) continue;
                        yeariBudgetBalances.add(ib);
                        continue;
                    }
                    yeariBudgetBalances.add(ib);
                }
                if (iBudgetBalanceList.size() > 0) {
                    this.isIBuggetBalance(iBudgetBalanceList, list);
                }
                this.createEntry(moniBudgetBalances, yeariBudgetBalances, iBudgetBalanceList);
                this.showactualchange();
                this.saveUserSelect();
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"labelap3"});
        } else {
            this.getModel().deleteEntryData(TREEENTRYENTITY);
            this.refreshpicture();
        }
    }

    private void setAccountMapChache(DynamicObjectCollection subject) {
        HashMap<String, DynamicObject> accountMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject dynamicObject : subject) {
            accountMap.put(dynamicObject.getString("fbasedataid_id"), dynamicObject);
        }
        this.getPageCache().put("accountMap", SerializationUtils.serializeToBase64(accountMap));
    }

    private Map<String, DynamicObject> getAccountMapChache() {
        String map = this.getPageCache().get("accountMap");
        if (StringUtils.isNotEmpty((String)map)) {
            return (Map)SerializationUtils.deSerializeFromBase64((String)map);
        }
        return null;
    }

    private void showactualchange() {
        if (this.getPageCache().get("acturechanges") != null) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"acturechanges"});
        }
        if (this.getPageCache().get("acturechanges1") != null) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"acturechanges1"});
        }
    }

    private void isIBuggetBalance(List<Collection<IBudgetBalance>> iBudgetBalances, List<String> list) {
        ArrayList collections = new ArrayList(16);
        ArrayList<IBudgetBalance> moniBudgetBalances = null;
        for (Collection<IBudgetBalance> collection : iBudgetBalances) {
            moniBudgetBalances = new ArrayList<IBudgetBalance>(16);
            for (IBudgetBalance ib : collection) {
                if (!ib.getSetting().getSettingType().getNumber().equals(list.get(0))) continue;
                moniBudgetBalances.add(ib);
            }
            collections.add(moniBudgetBalances);
        }
        iBudgetBalances.clear();
        iBudgetBalances.addAll(collections);
    }

    private List<Collection<IBudgetBalance>> getDimensionCoyes(List<Collection<IBudgetBalance>> iBudgetBalanceList, List<Map<String, String>> dimlist, String periodNumber, long modelid, Collection<String> type) {
        BgControlCallerImpl bgControlCaller = new BgControlCallerImpl();
        Collection iBudgetBalances = null;
        Matcher matcher = com.matcher(periodNumber);
        String trim = matcher.replaceAll("").trim();
        String substring = null;
        if (trim.equals(periodNumber.substring(periodNumber.length() - 2))) {
            substring = periodNumber.substring(0, periodNumber.length() - 2);
        } else if (trim.equals(periodNumber.substring(periodNumber.length() - 1))) {
            substring = periodNumber.substring(0, periodNumber.length() - 1);
        } else {
            return iBudgetBalanceList;
        }
        int month = Integer.parseInt(trim);
        if (month > 1) {
            ArrayList dimlists = new ArrayList(dimlist.size());
            HashMap<String, String> dimMap = null;
            for (Map<String, String> map : dimlist) {
                dimMap = new HashMap<String, String>(16);
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    dimMap.put(entry.getKey(), entry.getValue());
                }
                dimlists.add(dimMap);
            }
            for (int i = 0; i < month - 1; ++i) {
                ArrayList arrayList = new ArrayList(dimlist.size());
                HashMap hashMap = null;
                for (Map map : dimlists) {
                    hashMap = new HashMap(16);
                    for (Map.Entry entry : map.entrySet()) {
                        hashMap.put(entry.getKey(), entry.getValue());
                    }
                    arrayList.add(hashMap);
                }
                for (Map map : arrayList) {
                    map.put(SysDimensionEnum.Period.getNumber(), substring + (i + 1));
                }
                try {
                    iBudgetBalances = bgControlCaller.queryBalance(Long.valueOf(modelid), arrayList, type, true);
                    iBudgetBalanceList.add(iBudgetBalances);
                    continue;
                }
                catch (Exception exception) {
                    this.getView().showTipNotification(exception.getMessage());
                }
            }
        }
        return iBudgetBalanceList;
    }

    private void setEntryPeriod() {
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        grid.setColumnProperty("entryfield", "header", (Object)new LocaleString(period.getString("name")));
    }

    private Collection<String> dealSettingType() {
        ArrayList<String> type = new ArrayList<String>();
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        String periodNumber = period.getString("number");
        if (periodNumber.startsWith("M_Q")) {
            type.add(BgControlSettingTypeEnum.QUARTER.getNumber());
            type.add(BgControlSettingTypeEnum.QUARTER_ADDUP.getNumber());
        } else if (periodNumber.startsWith("Q_Q")) {
            type.add(BgControlSettingTypeEnum.QUARTER.getNumber());
            type.add(BgControlSettingTypeEnum.QUARTER_ADDUP.getNumber());
        } else if (periodNumber.startsWith("M_HF")) {
            type.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
            type.add(BgControlSettingTypeEnum.MONTH_BY_YEAR_CURR_GROSS.getNumber());
        } else if (periodNumber.startsWith("Q_HF")) {
            type.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
            type.add(BgControlSettingTypeEnum.QUARTER_HALFYEAR_ADDUP.getNumber());
        } else if (periodNumber.endsWith("_YearTotal")) {
            type.add(BgControlSettingTypeEnum.YEAR.getNumber());
        } else if (periodNumber.startsWith("HF_")) {
            type.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
            type.add(BgControlSettingTypeEnum.HALFYEAR_ADDUP.getNumber());
        } else {
            type.add(BgControlSettingTypeEnum.MONTH.getNumber());
            type.add(BgControlSettingTypeEnum.MONTH_BY_YEAR_CURR_GROSS.getNumber());
        }
        return type;
    }

    private DynamicObjectCollection searchCostTypeValue() {
        QFilter qFilter1 = new QFilter("typemodifyer", "=", (Object)UserUtils.getUserId()).or(new QFilter("typemodifyer", "=", (Object)0).and(new QFilter("schemetype", "=", (Object)"2").or(new QFilter("schemetype", "=", (Object)"1").and(new QFilter("creater", "=", (Object)UserUtils.getUserId())))));
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        QFilter modelQf = new QFilter("model", "=", (Object)model.getLong("id"));
        List<String> sourceIds = this.getSourceIds(model.getLong("id"));
        QFilter qFilter2 = new QFilter("id", "not in", (Object)IDUtils.toLongs(sourceIds));
        return QueryServiceHelper.query((String)EB_COSTTYPE, (String)"typename,accountrang,id", (QFilter[])new QFilter[]{qFilter1, qFilter2, modelQf});
    }

    private List<String> getSourceIds(Long modelId) {
        String selects = "id,schemetype,sourceid,typemodifyer";
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)EB_COSTTYPE, (String)selects, (QFilter[])new QFilter[]{qFilter});
        ArrayList<String> ids = new ArrayList<String>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (dynamicObject.get("sourceid") == null || dynamicObject.getLong("sourceid") == 0L || dynamicObject.get("typemodifyer") == null || !UserUtils.getUserId().equals(dynamicObject.getLong("typemodifyer"))) continue;
            ids.add(dynamicObject.get("sourceid").toString());
        }
        return ids;
    }

    private void setCostTypeValue() {
        DynamicObjectCollection dcs = this.searchCostTypeValue();
        if (dcs.size() > 0) {
            this.getModel().setValue("costtypetext", (Object)((DynamicObject)dcs.get(0)).getString("id"));
            this.initDimensions();
        } else {
            this.clearDimValue();
            this.getModel().setValue("costtypetext", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u65e0\u5206\u6790\u65b9\u6848\u3002", (String)"ExecuteAnalyze_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private Map<String, String> getAccountName(Collection<IBudgetBalance> iBudgetBalances) {
        HashMap<String, String> accountMap = new HashMap<String, String>(iBudgetBalances.size());
        for (IBudgetBalance iba : iBudgetBalances) {
            kd.epm.eb.common.model.Member member = iba.getAccount(true);
            accountMap.put(member.getNumber(), member.getName());
        }
        return accountMap;
    }

    private void drawColumn(DynamicObjectCollection docs) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        for (int i = 0; i < docs.size(); ++i) {
            if (i >= 10) continue;
            collection.add(docs.get(i));
        }
        DynamicObject[] doc = new DynamicObject[collection.size()];
        for (int i = 0; i < collection.size(); ++i) {
            doc[i] = (DynamicObject)collection.get(i);
        }
        HistogramChart customchart = (HistogramChart)this.getControl("histogramchartap");
        customchart.clearData();
        if (docs.size() == 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"histogramchartap"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"histogramchartap"});
            this.setHandlechartXaxisTick(customchart, doc);
            this.setHandleChartData(customchart, doc);
        }
    }

    private void setHandleChartData(HistogramChart customchart, DynamicObject[] docs) {
        Axis taskNumberAxis = null;
        taskNumberAxis = this.getPageCache().get("unitName") == null ? customchart.createYAxis(ResManager.loadKDString((String)"(\u5143)", (String)"ExecuteAnalyze_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), AxisType.value) : customchart.createYAxis(this.getPageCache().get("unitName"), AxisType.value);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        int[] aa = new int[]{0, 0, 0, 10};
        map.put("padding", aa);
        taskNumberAxis.setPropValue("nameTextStyle", map);
        customchart.setTitlePropValue("x", (Object)"center");
        HashMap<String, Object> map3 = new HashMap<String, Object>(16);
        map3.put("color", "#7F93BC");
        map3.put("fontSize", 20);
        map3.put("fontWeight", "lighter");
        customchart.setTitlePropValue("textStyle", map3);
        BarSeries expireSeries = customchart.createBarSeries(ResManager.loadKDString((String)"\u9884\u7b97\u6570", (String)"ExecuteAnalyze_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        expireSeries.setBarWidth("20px");
        expireSeries.setAnimationDuration(2000);
        Number[] handleTaskData = this.getHandleChartData(docs);
        expireSeries.setData(handleTaskData);
        map = new HashMap(16);
        HashMap<String, HashMap<String, Object>> normap = new HashMap<String, HashMap<String, Object>>(16);
        map.put("color", "new echarts.graphic.LinearGradient(0, 0, 0, 1, [{\"offset\": 0,\"color\": '#6DDBDC'}, {\"offset\": 1, \"color\": '#5CC0DA'}])");
        normap.put("normal", map);
        expireSeries.setPropValue("itemStyle", normap);
        ArrayList<String> list = new ArrayList<String>(16);
        list.add("itemStyle");
        list.add("normal");
        list.add("color");
        expireSeries.addFuncPath(list);
        expireSeries.setLabel((Label)null);
        BarSeries expireSeries2 = customchart.createBarSeries(ResManager.loadKDString((String)"\u5b9e\u9645\u6570", (String)"ExecuteAnalyze_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        expireSeries2.setBarWidth("20px");
        expireSeries2.setAnimationDuration(0);
        Number[] handleTaskData2 = this.getHandleChartData2(docs);
        expireSeries2.setData(handleTaskData2);
        map = new HashMap(16);
        normap = new HashMap(16);
        map.put("color", "new echarts.graphic.LinearGradient(0, 0, 0, 1, [{\"offset\": 0,\"color\": '#7DBFFF'}, {\"offset\": 1, \"color\": '#568DFF'}])");
        normap.put("normal", map);
        expireSeries2.setPropValue("itemStyle", normap);
        list = new ArrayList(16);
        list.add("itemStyle");
        list.add("normal");
        list.add("color");
        expireSeries2.addFuncPath(list);
        expireSeries2.setLabel(null);
        if (this.getPageCache().get("maxValue") != null) {
            String budget = this.getPageCache().get("maxValue");
            String budgetone = budget.startsWith("-") ? budget.substring(1, 2) : budget.substring(0, 1);
            String replace = budget.contains(".") ? budget.substring(0, budget.indexOf(".")) : budget;
            double j = 0.0;
            int serachws = 0;
            int i = 0;
            if ("0".equals(budgetone)) {
                int m = budget.indexOf(".");
                if (m == -1) {
                    j = 0.0;
                } else {
                    int n = 1;
                    int c = 2;
                    serachws = this.serachws(budget, n, c);
                    double gap = 1.0 / Math.pow(10.0, serachws);
                    j = Double.parseDouble(budget) + gap;
                    j = (double)((int)(j / gap)) * gap;
                }
                taskNumberAxis.setMax((Number)j);
                taskNumberAxis.setInterval((Number)(1.0 / Math.pow(10.0, serachws)));
            } else {
                i = Integer.parseInt(budgetone);
                int k = replace.length() - 1;
                j = !"0".equals(this.getPageCache().get("yuan")) ? (double)((int)((double)(i + 1) * Math.pow(10.0, k))) : (double)((int)((double)(i + 1) * Math.pow(10.0, k) / Math.pow(10.0, Double.parseDouble(this.getPageCache().get("yuan")))));
                taskNumberAxis.setMax((Number)j);
                taskNumberAxis.setInterval((Number)(Math.pow(10.0, k) * Math.pow(10.0, Double.parseDouble(this.getPageCache().get("yuan"))) / Math.pow(10.0, Double.parseDouble(this.getPageCache().get("yuan")))));
            }
        } else {
            taskNumberAxis.setMax((Number)0);
            taskNumberAxis.setInterval((Number)0);
        }
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>(16);
        axisTick.put("show", false);
        taskNumberAxis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap(16);
        HashMap<String, String> lineStyle = new HashMap<String, String>(16);
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        taskNumberAxis.setPropValue("splitLine", splitLine);
        this.setLineColor(taskNumberAxis);
        customchart.setShowLegend(true);
        customchart.setLegendAlign(XAlign.right, YAlign.top);
        customchart.setShowTooltip(true);
        customchart.bindData(null);
    }

    private int serachws(String budget, int n, int c) {
        String replace = budget.substring(budget.indexOf(".") + n, budget.indexOf(".") + c);
        if (Integer.parseInt(replace) > 0) {
            return n;
        }
        this.serachws(budget, ++n, ++c);
        return 0;
    }

    private Double[] getHandleChartData(DynamicObject[] docs) {
        Double[] budDouble = new Double[docs.length];
        for (int i = 0; i < docs.length; ++i) {
            budDouble[i] = docs[i].getBigDecimal("budget").doubleValue();
        }
        return budDouble;
    }

    private Double[] getHandleChartData2(DynamicObject[] docs) {
        Double[] budDouble = new Double[docs.length];
        for (int i = 0; i < docs.length; ++i) {
            budDouble[i] = docs[i].getBigDecimal("execute").doubleValue();
        }
        return budDouble;
    }

    private void setLineColor(Axis axix) {
        HashMap axisLineMap = new HashMap(16);
        HashMap<String, String> lineStyleMap = new HashMap<String, String>(16);
        lineStyleMap.put("color", "#999999");
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    private void setHandlechartXaxisTick(HistogramChart customchart, DynamicObject[] docs) {
        String axisName = ResManager.loadKDString((String)"(\u79d1\u76ee)", (String)"ExecuteAnalyze_9", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        Axis xaxis = customchart.createXAxis(axisName, AxisType.category);
        ArrayList<String> xDimensions = new ArrayList<String>(docs.length);
        for (DynamicObject doc : docs) {
            xDimensions.add(doc.getString("accountname"));
        }
        xaxis.setCategorys(xDimensions);
        xaxis.setPosition(Position.bottom);
        xaxis.setPropValue("barCategoryGap", (Object)"0");
        HashMap<String, int[]> map = new HashMap<String, int[]>(docs.length);
        int[] aa = new int[]{0, 0, -30, -48};
        try {
            Font font = new Font("SimSun", 1, 14);
            Rectangle2D rectangle = font.getStringBounds(axisName, new FontRenderContext(null, false, false));
            aa[3] = 0 - (int)rectangle.getWidth();
        }
        catch (Throwable font) {
            // empty catch block
        }
        map.put("padding", aa);
        xaxis.setPropValue("nameTextStyle", map);
        HashMap<String, String> axisLabel = new HashMap<String, String>(docs.length);
        axisLabel.put("interval", "0");
        axisLabel.put("rotate", "45");
        xaxis.setPropValue("axisLabel", axisLabel);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>(docs.length);
        axisTick.put("show", false);
        xaxis.setPropValue("axisTick", axisTick);
        this.setLineColor(xaxis);
    }

    private void drawpie(DynamicObjectCollection entryentity) {
        PieChart pieChart = (PieChart)this.getControl("handlechart");
        pieChart.clearData();
        PieSeries series = pieChart.createPieSeries(ResManager.loadKDString((String)"TOP10\u7d2f\u8ba1\u6267\u884c\u7ed3\u6784\u5206\u6790", (String)"ExecuteAnalyze_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        pieChart.setShowTooltip(true);
        if (entryentity.size() != 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"handlechart"});
            ItemValue[] items = this.getDefaultProfitData(entryentity);
            series.setData(items);
            pieChart.setShowLegend(true);
            pieChart.setLegendVertical(true);
            Label label = new Label();
            label.setFormatter("{b}:{c}({d}%)");
            label.setPosition(Position.insideRight);
            label.setShow(false);
            series.setLabel(label);
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("color", "#7F93BC");
            map.put("fontSize", 20);
            map.put("fontWeight", "lighter");
            pieChart.setTitlePropValue("textStyle", map);
            map = new HashMap(16);
            HashMap<String, Boolean> normalMap = new HashMap<String, Boolean>(16);
            map.put("normal", normalMap);
            normalMap.put("show", Boolean.FALSE);
            series.setPropValue("labelLine", map);
            series.setRadius("110");
            pieChart.setLegendPropValue("right", (Object)"5");
            pieChart.setLegendPropValue("top", (Object)"30");
            pieChart.bindData((BindingContext)null);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"handlechart"});
            pieChart.clearData();
        }
    }

    private ItemValue[] getDefaultProfitData(DynamicObjectCollection entryentity) {
        Map accountNumberMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("accountNumber"));
        ArrayList color = Lists.newArrayList((Object[])new String[]{"#4471A6", "#AA4643", "#89A54E", "#6A5284", "#4198AF", "#DB843D", "#93A9CF", "#D29392", "#B9CD96", "#393E2E"});
        if (entryentity.size() > 10) {
            ItemValue[] items = new ItemValue[10];
            DynamicObjectCollection collection = new DynamicObjectCollection();
            for (int i = 0; i < entryentity.size(); ++i) {
                if (i >= 10) continue;
                collection.add(entryentity.get(i));
            }
            this.getItemValue(collection, accountNumberMap, color, items);
            return items;
        }
        ItemValue[] items = new ItemValue[entryentity.size()];
        this.getItemValue(entryentity, accountNumberMap, color, items);
        return items;
    }

    private void getItemValue(DynamicObjectCollection entryentity, Map<Integer, String> accountNumberMap, List<String> color, ItemValue[] items) {
        HashSet<String> itemSet = new HashSet<String>(16);
        ArrayList<String> itemList = new ArrayList<String>(entryentity.size());
        ArrayList<String> itemRepeatList = new ArrayList<String>(16);
        for (DynamicObject object : entryentity) {
            itemList.add(object.getString("accountname"));
        }
        for (String item : itemList) {
            if (itemSet.contains(item)) {
                itemRepeatList.add(item);
                continue;
            }
            itemSet.add(item);
        }
        for (int i = 0; i < entryentity.size(); ++i) {
            ItemValue item1 = null;
            if (itemRepeatList.contains(((DynamicObject)entryentity.get(i)).getString("accountname"))) {
                String accountNumber = accountNumberMap.get(i);
                item1 = new ItemValue(((DynamicObject)entryentity.get(i)).getString("accountname") + "(" + accountNumber + ")", (Number)((DynamicObject)entryentity.get(i)).getBigDecimal("execute1"), color.get(i));
            } else {
                item1 = new ItemValue(((DynamicObject)entryentity.get(i)).getString("accountname"), (Number)((DynamicObject)entryentity.get(i)).getBigDecimal("execute1"), color.get(i));
            }
            items[i] = item1;
        }
    }

    private void drawyearColumn(List<BigDecimal> monBudgetList, List<BigDecimal> monExecuteList, String showType) {
        HistogramChart customchart = (HistogramChart)this.getControl("histogramchartap1");
        customchart.clearData();
        if (monBudgetList == null && monExecuteList == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"histogramchartap1"});
            customchart.clearData();
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"histogramchartap1"});
            customchart.setShowTitle(true);
            this.setyearHandlechartXaxisTick(customchart, showType);
            this.setyearHandleChartData(customchart, monBudgetList, monExecuteList);
            customchart.setMargin(Position.right, "30px");
            customchart.setMargin(Position.top, "30px");
            customchart.setLegendPropValue("itemWidth", (Object)10);
            customchart.setLegendPropValue("itemHeight", (Object)10);
        }
    }

    private void setyearHandleChartData(HistogramChart customchart, List<BigDecimal> monBudgetList, List<BigDecimal> monExecuteList) {
        Axis taskNumberAxis = null;
        taskNumberAxis = this.getPageCache().get("unitName") == null ? customchart.createYAxis(ResManager.loadKDString((String)"(\u5143)", (String)"ExecuteAnalyze_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), AxisType.value) : customchart.createYAxis(this.getPageCache().get("unitName"), AxisType.value);
        taskNumberAxis.setPropValue("nameGap", (Object)"10");
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        int[] aa = new int[]{0, 0, 5, -5};
        map.put("padding", aa);
        taskNumberAxis.setPropValue("nameTextStyle", map);
        customchart.setTitlePropValue("x", (Object)"center");
        HashMap<String, Object> map3 = new HashMap<String, Object>(16);
        map3.put("color", "#7F93BC");
        map3.put("fontSize", 20);
        map3.put("fontWeight", "lighter");
        customchart.setTitlePropValue("textStyle", map3);
        BarSeries expireSeries = customchart.createBarSeries(ResManager.loadKDString((String)"\u9884\u7b97\u6570", (String)"ExecuteAnalyze_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        expireSeries.setBarWidth("20px");
        expireSeries.setAnimationDuration(2000);
        if (monBudgetList != null) {
            Number[] handleTaskData = this.getyearHandleChartData(monBudgetList);
            expireSeries.setData(handleTaskData);
        }
        map = new HashMap(16);
        HashMap<String, HashMap<String, Object>> normap = new HashMap<String, HashMap<String, Object>>(16);
        map.put("color", "new echarts.graphic.LinearGradient(0, 0, 0, 1, [{\"offset\": 0,\"color\": '#6DDBDC'}, {\"offset\": 1, \"color\": '#5CC0DA'}])");
        normap.put("normal", map);
        expireSeries.setPropValue("itemStyle", normap);
        ArrayList<String> list = new ArrayList<String>(16);
        list.add("itemStyle");
        list.add("normal");
        list.add("color");
        expireSeries.addFuncPath(list);
        expireSeries.setLabel((Label)null);
        BarSeries expireSeries2 = customchart.createBarSeries(ResManager.loadKDString((String)"\u5b9e\u9645\u6570", (String)"ExecuteAnalyze_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        expireSeries2.setBarWidth("20px");
        expireSeries2.setAnimationDuration(0);
        if (monExecuteList != null) {
            Number[] handleTaskData2 = this.getyearHandleChartData2(monExecuteList);
            expireSeries2.setData(handleTaskData2);
        }
        map = new HashMap(16);
        normap = new HashMap(16);
        map.put("color", "new echarts.graphic.LinearGradient(0, 0, 0, 1, [{\"offset\": 0,\"color\": '#7DBFFF'}, {\"offset\": 1, \"color\": '#568DFF'}])");
        normap.put("normal", map);
        expireSeries2.setPropValue("itemStyle", normap);
        list = new ArrayList(16);
        list.add("itemStyle");
        list.add("normal");
        list.add("color");
        expireSeries2.addFuncPath(list);
        expireSeries2.setLabel((Label)null);
        if (this.getPageCache().get("yearmaxValue") != null) {
            String budget = this.getPageCache().get("yearmaxValue");
            String replace = null;
            replace = budget.contains(".") ? budget.substring(0, budget.indexOf(".")) : budget;
            String budgetone = budget.substring(0, 1);
            int j = 0;
            int i = 0;
            if ("0".equals(budgetone)) {
                int m = budget.indexOf(".");
                j = m == -1 ? 0 : 10 / (int)Math.pow(10.0, m);
                taskNumberAxis.setMax((Number)j);
                taskNumberAxis.setInterval((Number)(10.0 / Math.pow(10.0, (double)m + 1.0)));
            } else {
                i = Integer.parseInt(budgetone);
                i = Integer.parseInt(budgetone);
                int k = replace.length() - 1;
                j = !"0".equals(this.getPageCache().get("yuan")) ? (int)((double)(i + 1) * Math.pow(10.0, k)) : (int)((double)(i + 1) * Math.pow(10.0, k) / Math.pow(10.0, Double.parseDouble(this.getPageCache().get("yuan"))));
                taskNumberAxis.setMax((Number)j);
                taskNumberAxis.setInterval((Number)(Math.pow(10.0, k) * Math.pow(10.0, Double.parseDouble(this.getPageCache().get("yuan"))) / Math.pow(10.0, Double.parseDouble(this.getPageCache().get("yuan")))));
            }
        } else {
            taskNumberAxis.setMax((Number)0);
            taskNumberAxis.setInterval((Number)0);
        }
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>(16);
        axisTick.put("show", false);
        taskNumberAxis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap(16);
        HashMap<String, String> lineStyle = new HashMap<String, String>(16);
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        taskNumberAxis.setPropValue("splitLine", splitLine);
        this.setyearLineColor(taskNumberAxis);
        customchart.setShowLegend(true);
        customchart.setLegendAlign(XAlign.right, YAlign.top);
        customchart.setShowTooltip(true);
        customchart.bindData(null);
    }

    private Double[] getyearHandleChartData(List<BigDecimal> monBudgetList) {
        Double[] budDouble = new Double[monBudgetList.size()];
        for (int i = 0; i < monBudgetList.size(); ++i) {
            budDouble[i] = monBudgetList.get(i).doubleValue();
        }
        return budDouble;
    }

    private Double[] getyearHandleChartData2(List<BigDecimal> monExecuteList) {
        Double[] budDouble = new Double[monExecuteList.size()];
        for (int i = 0; i < monExecuteList.size(); ++i) {
            budDouble[i] = monExecuteList.get(i) != null ? Double.valueOf(monExecuteList.get(i).doubleValue()) : Double.valueOf(0.0);
        }
        return budDouble;
    }

    private void setyearLineColor(Axis axix) {
        HashMap axisLineMap = new HashMap(16);
        HashMap<String, String> lineStyleMap = new HashMap<String, String>(16);
        lineStyleMap.put("color", "#999999");
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    private void setyearHandlechartXaxisTick(HistogramChart customchart, String showType) {
        Axis xaxis = customchart.createXAxis(null, AxisType.category);
        ArrayList<String> xDimensions = new ArrayList<String>(16);
        this.setXvalue(showType, xDimensions);
        xaxis.setCategorys(xDimensions);
        xaxis.setPosition(Position.bottom);
        xaxis.setPropValue("nameGap", (Object)"9");
        HashMap<String, int[]> map = new HashMap<String, int[]>(16);
        int[] aa = new int[]{0, 0, -30, -10};
        map.put("padding", aa);
        xaxis.setPropValue("nameTextStyle", map);
        HashMap<String, String> axisLabel = new HashMap<String, String>(16);
        axisLabel.put("interval", "0");
        xaxis.setPropValue("axisLabel", axisLabel);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>(16);
        axisTick.put("show", false);
        xaxis.setPropValue("axisTick", axisTick);
        this.setLineColor(xaxis);
    }

    private void setXvalue(String showType, List<String> xDimensions) {
        block17: {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                block16: {
                                    if (!showType.equals(ModelDetailPeriodEnum.ISDETAILTOMONTH.getNumber())) break block16;
                                    for (int i = 1; i <= 12; ++i) {
                                        xDimensions.add(ResManager.loadResFormat((String)"%1\u6708", (String)"ExecuteAnalyze_12", (String)"epm-eb-formplugin", (Object[])new Object[]{i}));
                                    }
                                    break block17;
                                }
                                if (!showType.equals(ModelDetailPeriodEnum.ISDETAILTOQUARTER.getNumber())) break block18;
                                for (int i = 1; i <= 4; ++i) {
                                    xDimensions.add(ResManager.loadResFormat((String)"%1\u5b63", (String)"ExecuteAnalyze_21", (String)"epm-eb-formplugin", (Object[])new Object[]{i}));
                                }
                                break block17;
                            }
                            if (!showType.equals(ModelDetailPeriodEnum.ISDETAILTOHALFYEAR.getNumber())) break block19;
                            for (int i = 1; i <= 2; ++i) {
                                if (i == 1) {
                                    xDimensions.add(ResManager.loadKDString((String)"\u4e0a\u534a\u5e74", (String)"ExecuteAnalyze_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                                }
                                if (i != 2) continue;
                                xDimensions.add(ResManager.loadKDString((String)"\u4e0b\u534a\u5e74", (String)"ExecuteAnalyze_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            }
                            break block17;
                        }
                        if (!showType.equals(ModelDetailPeriodEnum.ISDETAILTOMONTHANDQUARTER.getNumber())) break block20;
                        for (int i = 1; i <= 16; ++i) {
                            if (i <= 12) {
                                xDimensions.add(ResManager.loadResFormat((String)"%1\u6708", (String)"ExecuteAnalyze_12", (String)"epm-eb-formplugin", (Object[])new Object[]{i}));
                                continue;
                            }
                            xDimensions.add(ResManager.loadResFormat((String)"%1\u5b63\u5ea6", (String)"ExecuteAnalyze_24", (String)"epm-eb-formplugin", (Object[])new Object[]{i - 12}));
                        }
                        break block17;
                    }
                    if (!showType.equals(ModelDetailPeriodEnum.ISDETAILTOMONTHANDHALFYEAR.getNumber())) break block21;
                    for (int i = 1; i <= 14; ++i) {
                        if (i <= 12) {
                            xDimensions.add(ResManager.loadResFormat((String)"%1\u6708", (String)"ExecuteAnalyze_12", (String)"epm-eb-formplugin", (Object[])new Object[]{i}));
                            continue;
                        }
                        if (i == 13) {
                            xDimensions.add(ResManager.loadKDString((String)"\u4e0a\u534a\u5e74", (String)"ExecuteAnalyze_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        }
                        if (i != 14) continue;
                        xDimensions.add(ResManager.loadKDString((String)"\u4e0b\u534a\u5e74", (String)"ExecuteAnalyze_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    break block17;
                }
                if (!showType.equals(ModelDetailPeriodEnum.ISDETAILTOQUARTERANDHALFYEAR.getNumber())) break block22;
                for (int i = 1; i <= 6; ++i) {
                    if (i <= 4) {
                        xDimensions.add(ResManager.loadResFormat((String)"%1\u5b63\u5ea6", (String)"ExecuteAnalyze_24", (String)"epm-eb-formplugin", (Object[])new Object[]{i}));
                        continue;
                    }
                    if (i == 5) {
                        xDimensions.add(ResManager.loadKDString((String)"\u4e0a\u534a\u5e74", (String)"ExecuteAnalyze_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    if (i != 6) continue;
                    xDimensions.add(ResManager.loadKDString((String)"\u4e0b\u534a\u5e74", (String)"ExecuteAnalyze_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                break block17;
            }
            if (!showType.equals(ModelDetailPeriodEnum.ISDETAILTOMONTHANDHALFYEARANDUARTER.getNumber())) break block17;
            for (int i = 1; i <= 18; ++i) {
                if (i <= 12) {
                    xDimensions.add(ResManager.loadResFormat((String)"%1\u6708", (String)"ExecuteAnalyze_12", (String)"epm-eb-formplugin", (Object[])new Object[]{i}));
                    continue;
                }
                if (i <= 16) {
                    xDimensions.add(ResManager.loadResFormat((String)"%1\u5b63\u5ea6", (String)"ExecuteAnalyze_24", (String)"epm-eb-formplugin", (Object[])new Object[]{i - 12}));
                    continue;
                }
                if (i == 17) {
                    xDimensions.add(ResManager.loadKDString((String)"\u4e0a\u534a\u5e74", (String)"ExecuteAnalyze_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                if (i != 18) continue;
                xDimensions.add(ResManager.loadKDString((String)"\u4e0b\u534a\u5e74", (String)"ExecuteAnalyze_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private BigDecimal getMaxValue(List<BigDecimal> monBudgetList, List<BigDecimal> monExecuteList) {
        monBudgetList.removeIf(Objects::isNull);
        monExecuteList.removeIf(Objects::isNull);
        if (monBudgetList.size() > 1) {
            Collections.sort(monBudgetList);
        }
        if (monExecuteList.size() > 1) {
            Collections.sort(monExecuteList);
        }
        int i = 2;
        if (monBudgetList.size() > 0 && monExecuteList.size() > 0) {
            i = monBudgetList.get(monBudgetList.size() - 1).compareTo(monExecuteList.get(monExecuteList.size() - 1));
        }
        if (i == -1) {
            return monExecuteList.get(monExecuteList.size() - 1);
        }
        if (i == 2) {
            if (monBudgetList.size() == 0 && monExecuteList.size() > 0) {
                return monExecuteList.get(monExecuteList.size() - 1);
            }
            if (monBudgetList.size() > 0 && monExecuteList.size() == 0) {
                return monBudgetList.get(monBudgetList.size() - 1);
            }
            return null;
        }
        return monBudgetList.get(monBudgetList.size() - 1);
    }

    public void loadData(Boolean isFirst) {
        this.refreshEntryentity();
        this.yearAnaylzeData(isFirst);
    }

    private void initDimmensionRangPageCache() {
        DynamicObject costtype = (DynamicObject)this.getModel().getValue("costtypetext");
        if (costtype != null && kd.bos.util.StringUtils.isNotEmpty((String)costtype.getString("id"))) {
            QFilter ctIdQf = new QFilter("id", "=", (Object)costtype.getLong("id"));
            String selectFields = "id,entityrang_tag,yearrang_tag,periodrang_tag,versionrang_tag,currencyrang_tag,entitybdf,yearbdf,periodbdf,versionbdf,currencybdf";
            DynamicObjectCollection eb_cosstype = QueryServiceHelper.query((String)EB_COSTTYPE, (String)selectFields, (QFilter[])new QFilter[]{ctIdQf});
            HashMap<String, List<Long>> accountMap = new HashMap<String, List<Long>>(16);
            if (eb_cosstype.size() == 1) {
                DynamicObject dynamicObject = (DynamicObject)eb_cosstype.get(0);
                for (String dimKey : DimensionList) {
                    String string = dynamicObject.getString(dimKey + "rang_tag");
                    this.analysisDimensionRange(string, dimKey, accountMap);
                }
                HashMap<String, List<Long>> dimTree = new HashMap<String, List<Long>>(16);
                for (Map.Entry<String, List<Long>> entry : accountMap.entrySet()) {
                    String key = (String)entry.getKey();
                    if (SysDimensionEnum.Entity.getNumber().equals(key)) {
                        this.getLegitimate(dimTree, entry, SysDimensionEnum.Entity);
                        continue;
                    }
                    if (SysDimensionEnum.Version.getNumber().equals(key)) {
                        this.getLegitimate(dimTree, entry, SysDimensionEnum.Version);
                        continue;
                    }
                    dimTree.put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry entry : dimTree.entrySet()) {
                    if (((List)entry.getValue()).size() <= 0) continue;
                    this.getModel().setValue((String)entry.getKey(), ((List)entry.getValue()).get(0));
                }
            }
            this.setAccountF7(costtype);
        }
    }

    private Map<String, List<Long>> getStringListMap(String costtype) {
        QFilter ctIdQf = new QFilter("id", "=", (Object)IDUtils.toLong((Object)costtype));
        String selectFields = "id,entityrang_tag,yearrang_tag,periodrang_tag,versionrang_tag,currencyrang_tag,entitybdf,yearbdf,periodbdf,versionbdf,currencybdf";
        DynamicObjectCollection eb_cosstype = QueryServiceHelper.query((String)EB_COSTTYPE, (String)selectFields, (QFilter[])new QFilter[]{ctIdQf});
        HashMap<String, List<Long>> accountMap = new HashMap<String, List<Long>>(16);
        HashMap<String, List<Long>> dimTree = new HashMap<String, List<Long>>(16);
        if (eb_cosstype.size() == 1) {
            DynamicObject dynamicObject = (DynamicObject)eb_cosstype.get(0);
            for (String string : DimensionList) {
                String dimJsonString = dynamicObject.getString(string + "rang_tag");
                this.analysisDimensionRange(dimJsonString, string, accountMap);
            }
            for (Map.Entry entry : accountMap.entrySet()) {
                String key = (String)entry.getKey();
                if (SysDimensionEnum.Entity.getNumber().equals(key)) {
                    this.getLegitimate(dimTree, entry, SysDimensionEnum.Entity);
                    continue;
                }
                if (SysDimensionEnum.Version.getNumber().equals(key)) {
                    this.getLegitimate(dimTree, entry, SysDimensionEnum.Version);
                    continue;
                }
                String listEntryKey = (String)entry.getKey();
                String letterDim = this.getLetterDim(listEntryKey);
                dimTree.put(letterDim, (List<Long>)entry.getValue());
            }
        }
        return dimTree;
    }

    private void getLegitimate(Map<String, List<Long>> dimTree, Map.Entry<String, List<Long>> stringListEntry, SysDimensionEnum version) {
        Set readPermMembIds = DimMembPermHelper.getReadPermMembIds((String)version.getNumber(), (Long)this.getModelId(), (Long)0L, null, (boolean)true);
        List<Long> value = stringListEntry.getValue();
        ArrayList<Long> legitimate = new ArrayList<Long>(16);
        for (Long aLong : value) {
            if (readPermMembIds != null && !readPermMembIds.contains(aLong)) continue;
            legitimate.add(aLong);
        }
        if (legitimate.size() > 0) {
            String entryKey = stringListEntry.getKey();
            String letters = this.getLetterDim(entryKey);
            dimTree.put(letters, legitimate);
        }
    }

    private String getLetterDim(String entryKey) {
        String letters = null;
        if ("entity".equalsIgnoreCase(entryKey)) {
            letters = "entity";
        } else if ("account".equalsIgnoreCase(entryKey)) {
            letters = "account";
        } else if ("year".equalsIgnoreCase(entryKey)) {
            letters = "year";
        } else if ("period".equalsIgnoreCase(entryKey)) {
            letters = "period";
        } else if ("version".equalsIgnoreCase(entryKey)) {
            letters = "version";
        } else if ("currency".equalsIgnoreCase(entryKey)) {
            letters = "currency";
        }
        return letters;
    }

    private void setAccountF7(DynamicObject costtype) {
        DynamicObject doc = BusinessDataServiceHelper.loadSingle((Object)costtype.getString("id"), (String)EB_COSTTYPE);
        DynamicObjectCollection dcs = (DynamicObjectCollection)doc.get("accountrang");
        if (dcs.size() > 0) {
            int count = 0;
            ArrayList<Long> countList = new ArrayList<Long>(16);
            for (DynamicObject dc : dcs) {
                if (count < 10 && dc.get("fbasedataid") != null && !((DynamicObject)dc.get("fbasedataid")).getString("number").equals(SysDimensionEnum.Account.getNumber())) {
                    countList.add(dc.getLong("fbasedataid_id"));
                }
                ++count;
            }
            Set readPermMembIds = DimMembPermHelper.getReadPermMembIds((String)SysDimensionEnum.Account.getNumber(), (Long)this.getModelId(), (Long)0L, null, (boolean)true);
            ArrayList<Long> accounts = new ArrayList<Long>(16);
            for (Long aLong : countList) {
                if (readPermMembIds != null && !readPermMembIds.contains(aLong)) continue;
                accounts.add(aLong);
            }
            this.getModel().setValue("subject", (Object)accounts.toArray());
        }
    }

    private List<Long> getAccountLongs(String costtype) {
        DynamicObject doc = BusinessDataServiceHelper.loadSingle((Object)costtype, (String)EB_COSTTYPE);
        DynamicObjectCollection dcs = (DynamicObjectCollection)doc.get("accountrang");
        ArrayList<Long> accounts = new ArrayList<Long>(16);
        if (dcs.size() > 0) {
            int count = 0;
            ArrayList<Long> countList = new ArrayList<Long>(16);
            for (DynamicObject dc : dcs) {
                if (dc.get("fbasedataid") != null && !((DynamicObject)dc.get("fbasedataid")).getString("number").equals(SysDimensionEnum.Account.getNumber())) {
                    countList.add(dc.getLong("fbasedataid_id"));
                }
                ++count;
            }
            Set readPermMembIds = DimMembPermHelper.getReadPermMembIds((String)SysDimensionEnum.Account.getNumber(), (Long)this.getModelId(), (Long)0L, null, (boolean)true);
            for (Long aLong : countList) {
                if (readPermMembIds != null && !readPermMembIds.contains(aLong)) continue;
                accounts.add(aLong);
            }
        }
        return accounts;
    }

    private Map<String, List<Long>> analysisDimensionRange(String dimJsonString, String dimKey, Map<String, List<Long>> accountMap) {
        ArrayList<Long> accountIds = new ArrayList<Long>(16);
        if (!dimJsonString.isEmpty()) {
            List serialize = SerializationUtils.fromJsonStringToList((String)dimJsonString, Map.class);
            IModelCacheHelper model = ModelCacheContext.getOrCreate((Long)this.getModelId());
            for (Map stringMap : serialize) {
                List members = ModelCacheServiceHelper.getMember((Model)model.getModelobj(), (String)dimKey, (String)((String)stringMap.get("number")), (int)Integer.parseInt((String)stringMap.get("scope")));
                for (Member member : members) {
                    if (dimKey.equals(member.getNumber()) || YEARLISTS.contains(member.getNumber())) continue;
                    accountIds.add(member.getId());
                }
                accountMap.put(dimKey, accountIds);
            }
        }
        return accountMap;
    }

    private void clearDimValue() {
        this.getModel().beginInit();
        for (String dimKey : dimKeys) {
            this.getModel().setValue(dimKey, null);
        }
        this.getModel().endInit();
        this.getView().updateView();
    }

    private void saveUserSelect() {
        String model = this.getPageCache().get(modelCacheKey);
        QFilter userFilter = new QFilter("modifyer", "=", (Object)UserUtils.getUserId());
        QFilter appFilter = new QFilter("application", "=", (Object)ApplicationTypeEnum.EB.getAppnum());
        QFilter formFilter = new QFilter("formid", "=", (Object)this.getView().getFormShowParameter().getFormId());
        QFilter modelFilter = new QFilter("model", "=", (Object)IDUtils.toLong((Object)model));
        String selectFields = "model,costtype,entity,year,version,currency,period,modifyer,application,formid,subject";
        DynamicObject userSelectHistory = BusinessDataServiceHelper.loadSingle((String)EB_EXECUTEANALYZEHISTORY, (String)selectFields, (QFilter[])new QFilter[]{userFilter, appFilter, formFilter, modelFilter});
        if (userSelectHistory == null) {
            userSelectHistory = ORM.create().newDynamicObject(EB_EXECUTEANALYZEHISTORY);
            userSelectHistory.set("modifyer", (Object)UserUtils.getUserId());
            userSelectHistory.set("application", (Object)ApplicationTypeEnum.EB.getAppnum());
            userSelectHistory.set("formid", (Object)this.getView().getFormShowParameter().getFormId());
            userSelectHistory.set("model", (Object)model);
        }
        List<String> saveData = Arrays.asList("entity", "year", "version", "currency", "period", "model", "subject");
        for (String saveDatum : saveData) {
            Object value = this.getModel().getValue(saveDatum);
            userSelectHistory.set(saveDatum, value);
        }
        if (this.getModel().getValue("costtypetext") == null) {
            return;
        }
        String costtype = ((DynamicObject)this.getModel().getValue("costtypetext")).getString("id");
        if (kd.bos.util.StringUtils.isEmpty((String)costtype)) {
            userSelectHistory.set("costtype", null);
        } else {
            userSelectHistory.set("costtype", (Object)costtype);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userSelectHistory});
        String opName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"ExecuteAnalyze_16", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String opDescription = ResManager.loadKDString((String)"\u7528\u6237\u9009\u62e9\u5df2\u6210\u529f\u4fdd\u5b58\u3002", (String)"ExecuteAnalyze_17", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)opName, (String)opDescription);
    }

    private String getCostTypeId() {
        return ((DynamicObject)this.getModel().getValue("costtypetext")).getString("id");
    }

    private boolean allValueNotNull() {
        if (this.getModel().getValue("model") == null) {
            return false;
        }
        if (this.getModel().getValue("costtypetext") == null) {
            return false;
        }
        if (!QueryServiceHelper.exists((String)EB_COSTTYPE, (Object)this.getCostTypeId())) {
            return false;
        }
        if (this.getModel().getValue("entity") == null) {
            return false;
        }
        for (String dimKey : dimKeys) {
            if ("subject".equals(dimKey) && ((DynamicObjectCollection)this.getModel().getValue("subject")).size() == 0) {
                return false;
            }
            if (this.getModel().getValue(dimKey) != null) continue;
            return false;
        }
        return true;
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        DynamicObject costtypetext = (DynamicObject)this.getModel().getValue("costtypetext");
        if (costtypetext != null) {
            String fieldName = event.getFieldName();
            int rowIndex = event.getRowIndex();
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(TREEENTRYENTITY, rowIndex);
            if (entryRowEntity != null) {
                BigDecimal big = (BigDecimal)entryRowEntity.get(fieldName);
                if (big.compareTo(new BigDecimal(0)) == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u65e0\u6709\u6548\u6570\u636e\u3002", (String)"ExecuteAnalyze_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getPageCache().put("fieldName", fieldName);
                this.getPageCache().put("rowIndex", String.valueOf(rowIndex));
                this.openAnalyze(null);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u65e0\u6b64\u5206\u6790\u65b9\u6848\u3002", (String)"ExecuteAnalyze_29", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void openAnalyze(Map<String, String> retureMap) {
        IPageCache pageCache = this.getPageCache();
        if (retureMap == null) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setShowTitle(true);
            formShowParameter.setFormId(EB_ANALYZEWAY);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("modelId", (Object)String.valueOf(this.getModelId()));
            Map<String, DynamicObject> dimenMap = this.getStringDynamicObjectMap();
            formShowParameter.setCustomParam("dimenMap", (Object)SerializationUtils.serializeToBase64(dimenMap));
            formShowParameter.setCustomParam("dc", (Object)"1");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "analyze"));
            this.getView().showForm(formShowParameter);
        } else {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setShowTitle(true);
            formShowParameter.setFormId(EB_RELEVANCEANALYZE);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCustomParam("modelId", (Object)String.valueOf(this.getModelId()));
            formShowParameter.setCustomParam("fieldName", (Object)pageCache.get("fieldName"));
            formShowParameter.setCustomParam("retureMap", (Object)SerializationUtils.serializeToBase64(retureMap));
            DynamicObject costtypetext = (DynamicObject)this.getModel().getValue("costtypetext");
            DynamicObject doc = BusinessDataServiceHelper.loadSingle((Object)costtypetext.getString("id"), (String)EB_COSTTYPE);
            DynamicObjectCollection dcs = (DynamicObjectCollection)doc.get("accountrang");
            ArrayList<DynamicObject> accountList = new ArrayList<DynamicObject>(dcs.size());
            for (DynamicObject dynamicObject : dcs) {
                accountList.add((DynamicObject)dynamicObject.get("fbasedataid"));
            }
            formShowParameter.setCustomParam("accountList", (Object)SerializationUtils.serializeToBase64(accountList));
            Map<String, DynamicObject> dimenMap = this.getStringDynamicObjectMap();
            formShowParameter.setCustomParam("dimenMap", (Object)SerializationUtils.serializeToBase64(dimenMap));
            this.getView().showForm(formShowParameter);
        }
    }

    private Map<String, DynamicObject> getStringDynamicObjectMap() {
        String rowIndex = this.getPageCache().get("rowIndex");
        Map<String, DynamicObject> accountMapChache = this.getAccountMapChache();
        HashMap<String, DynamicObject> dimenMap = new HashMap<String, DynamicObject>(16);
        dimenMap.put("entity", (DynamicObject)this.getModel().getValue("entity"));
        dimenMap.put("currency", (DynamicObject)this.getModel().getValue("currency"));
        dimenMap.put("year", (DynamicObject)this.getModel().getValue("year"));
        dimenMap.put("period", (DynamicObject)this.getModel().getValue("period"));
        dimenMap.put("version", (DynamicObject)this.getModel().getValue("version"));
        DynamicObject entryentity = this.getModel().getEntryRowEntity(TREEENTRYENTITY, Integer.parseInt(rowIndex));
        if (accountMapChache != null) {
            dimenMap.put("account", accountMapChache.get(entryentity.getString("id")));
        }
        return dimenMap;
    }

    private void addF7SelectListeners(String ... f7Keys) {
        for (String f7Key : f7Keys) {
            BasedataEdit f7 = (BasedataEdit)this.getControl(f7Key);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private void openCosttype(DynamicObject model, BeforeF7SelectEvent arg0) {
        Long modelId = model.getLong("id");
        OperationContext context = OperationContext.get();
        if ("getLookUpList".equals(context.getOpMethod())) {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(3);
            QFilter qFilter1 = new QFilter("model", "=", (Object)modelId);
            QFilter qFilter = new QFilter("typemodifyer", "=", (Object)UserUtils.getUserId()).or(new QFilter("typemodifyer", "=", (Object)0L).and(new QFilter("schemetype", "=", (Object)"2").or(new QFilter("schemetype", "=", (Object)"1").and(new QFilter("creater", "=", (Object)UserUtils.getUserId())))));
            QFilter qFilter2 = new QFilter("id", "not in", (Object)IDUtils.toLongs(this.getSourceIds(modelId)));
            qFilterList.add(qFilter1);
            ListShowParameter param = (ListShowParameter)arg0.getFormShowParameter();
            param.getListFilterParameter().setFilter(qFilter.and(qFilter1).and(qFilter2));
        } else if ("click".equals(context.getOpMethod()) || "showMore".equals(context.getOpMethod())) {
            arg0.setCancel(true);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(EB_ANALYZESINGLEF_7);
            showParameter.setCustomParam("model", (Object)modelId);
            showParameter.setShowTitle(true);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "schemeCatalog");
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)EB_ANALYZESINGLEF_7);
            formConfig.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5206\u6790\u65b9\u6848\u5217\u8868", (String)"ExecuteAnalyze_34", (String)"epm-eb-formplugin", (Object[])new Object[0])));
            showParameter.setFormConfig(formConfig);
            showParameter.setCloseCallBack(callBack);
            this.getView().showForm(showParameter);
        }
    }

    public String getCurrentDimNumber(String controlKey) {
        return this.getCurrentDimNum(controlKey);
    }

    public List<QFilter> getDimQFilter(String ctrlKey) {
        QFBuilder builder = new QFBuilder();
        DynamicObject costtypeId = (DynamicObject)this.getModel().getValue("costtypetext");
        if (costtypeId != null) {
            QFilter ctIdQf = new QFilter("id", "=", (Object)costtypeId.getLong("id"));
            String selectFields = "id,entityrang_tag,yearrang_tag,periodrang_tag,versionrang_tag,currencyrang_tag,entitybdf,yearbdf,periodbdf,versionbdf,currencybdf";
            DynamicObjectCollection eb_cosstype = QueryServiceHelper.query((String)EB_COSTTYPE, (String)selectFields, (QFilter[])new QFilter[]{ctIdQf});
            DynamicObject dynamicObject = (DynamicObject)eb_cosstype.get(0);
            long modelId = this.getModelId();
            if (modelId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"ExecuteAnalyze_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            LinkedList memberIds = Lists.newLinkedList();
            if (ctrlKey.contains("entity")) {
                String number = SysDimensionEnum.Entity.getNumber();
                this.selectDimens(dynamicObject, memberIds, ctrlKey, number);
                builder.add("id", "in", (Object)memberIds);
            } else if ("period".equals(ctrlKey)) {
                String number = SysDimensionEnum.Period.getNumber();
                this.selectDimens(dynamicObject, memberIds, ctrlKey, number);
                builder.add("id", "in", (Object)memberIds);
                builder.add("number", "not in", YEARLISTS);
            } else if ("version".equals(ctrlKey)) {
                String number = SysDimensionEnum.Version.getNumber();
                this.selectDimens(dynamicObject, memberIds, ctrlKey, number);
                builder.add("id", "in", (Object)memberIds);
            } else if ("year".equals(ctrlKey)) {
                String number = SysDimensionEnum.Year.getNumber();
                this.selectDimens(dynamicObject, memberIds, ctrlKey, number);
                builder.add("id", "in", (Object)memberIds);
            } else if ("currency".equals(ctrlKey)) {
                String number = SysDimensionEnum.Currency.getNumber();
                this.selectDimens(dynamicObject, memberIds, ctrlKey, number);
                builder.add("id", "in", (Object)memberIds);
                builder.add("number", "not in", (Object)number);
            } else if ("subject".equals(ctrlKey)) {
                String number = SysDimensionEnum.Account.getNumber();
                DynamicObject dynamicObject1 = BusinessDataServiceHelper.loadSingleFromCache((String)EB_COSTTYPE, (String)"accountrang", (QFilter[])new QFilter[]{ctIdQf});
                this.selectDimensAccount(dynamicObject1, memberIds);
                builder.add("id", "in", (Object)memberIds);
                builder.add("number", "not in", (Object)number);
            }
        }
        return builder.toList();
    }

    private void selectDimensAccount(DynamicObject dynamicObject, List<Long> accountIds) {
        DynamicObjectCollection accounts = (DynamicObjectCollection)dynamicObject.get("accountrang");
        accounts.forEach(e -> accountIds.add(e.getLong("fbasedataid_id")));
    }

    private void selectDimens(DynamicObject dynamicObject, List<Long> accountIds, String key, String number) {
        String entity = dynamicObject.getString(key + "rang_tag");
        if (!entity.isEmpty()) {
            List serialize = SerializationUtils.fromJsonStringToList((String)entity, Map.class);
            IModelCacheHelper model = ModelCacheContext.getOrCreate((Long)this.getModelId());
            for (Map stringMap : serialize) {
                List members = ModelCacheServiceHelper.getMember((Model)model.getModelobj(), (String)number, (String)((String)stringMap.get("number")), (int)Integer.parseInt((String)stringMap.get("scope")));
                for (Member member : members) {
                    accountIds.add(member.getId());
                }
            }
        }
    }

    private String getCurrentDimNum(String ctrlKey) {
        String dimNum = null;
        if (ctrlKey.contains("custom")) {
            String customDimStr = this.getPageCache().get(customDimsInfoCache);
            DynamicInfoCollection customDims = (DynamicInfoCollection)SerializationUtils.deSerializeFromBase64((String)customDimStr);
            dimNum = (String)customDims.getValOfOnePropByAnotherProp("number", "controlkey", (Object)ctrlKey);
        } else {
            if ("subject".equals(ctrlKey)) {
                dimNum = SysDimensionEnum.Account.getNumber();
            }
            for (SysDimensionEnum dimensionEnum : SysDimensionEnum.values()) {
                if (!ctrlKey.contains(dimensionEnum.getNumber().toLowerCase())) continue;
                dimNum = dimensionEnum.getNumber();
                break;
            }
        }
        return dimNum;
    }

    private void switchHideShowPageDims() {
        if ("false".equals(this.getPageCache().get("isPageDimsVisible"))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"pagedimspanel"});
            this.getPageCache().put("isPageDimsVisible", "true");
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"pagedimspanel"});
            this.getPageCache().put("isPageDimsVisible", "false");
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if ("costtypetext".equals(key)) {
            BasedataEdit b = new BasedataEdit(){

                protected FuzzySearch buildDefLookUpSetting(BasedataEntityType refBDType) {
                    FuzzySearch setting = new FuzzySearch();
                    String number = refBDType.getNumberProperty();
                    String name = refBDType.getNameProperty();
                    if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)number)) {
                        ParameterHelper.addItem((FuzzySearch)setting, (String)number, (String)ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0", (String)"ExecuteAnalyze_31", (String)"epm-eb-formplugin", (Object[])new Object[0]), (float)100.0f);
                    }
                    if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)name)) {
                        ParameterHelper.addItem((FuzzySearch)setting, (String)name, (String)ResManager.loadKDString((String)"\u65b9\u6848\u7c7b\u578b", (String)"ExecuteAnalyze_32", (String)"epm-eb-formplugin", (Object[])new Object[0]), (float)100.0f);
                    }
                    return setting;
                }
            };
            b.setFieldKey(key);
            b.setKey(key);
            b.setDisplayProp("name");
            b.setView(this.getView());
            b.setModel(this.getModel());
            b.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            b.addBasedataFuzzySearchListener((BasedataFuzzySearchListener)this);
            e.setControl((Control)b);
        }
    }

    public void handleData(BasedataFuzzySearchEvent searchEvent) {
        List queryData = searchEvent.getQueryData();
        if (queryData != null && queryData.size() > 0) {
            ArrayList dataList = new ArrayList(16);
            ArrayList<String> numbers = null;
            for (Object queryDatum : queryData) {
                numbers = new ArrayList<String>(16);
                if (queryDatum instanceof ArrayList) {
                    numbers.add(((List)queryDatum).get(0).toString());
                    numbers.add(((List)queryDatum).get(1).toString());
                    numbers.add(((List)queryDatum).get(1).toString());
                } else if (queryDatum instanceof Object[]) {
                    numbers.add(((Object[])queryDatum)[0].toString());
                    numbers.add(((Object[])queryDatum)[1].toString());
                    numbers.add(((Object[])queryDatum)[1].toString());
                }
                dataList.add(numbers);
            }
            queryData.clear();
            queryData.addAll(dataList);
        }
    }
}

